/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLPivot;
import com.alibaba.druid.sql.ast.SQLUnpivot;
import com.alibaba.druid.sql.ast.SQLWindow;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLRealExpr;
import com.alibaba.druid.sql.ast.expr.SQLSizeExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprHint;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLGeneratedTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSampling;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnnestTableSource;
import com.alibaba.druid.sql.ast.statement.SQLValuesQuery;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.druid.sql.parser.DialectFeature;
import com.alibaba.druid.sql.parser.EOFParserException;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class SQLSelectParser
extends SQLParser {
    protected SQLExprParser exprParser;
    protected SQLSelectListCache selectListCache;

    public SQLSelectParser(String sql) {
        super(sql);
    }

    public SQLSelectParser(Lexer lexer) {
        super(lexer);
    }

    public SQLSelectParser(SQLExprParser exprParser) {
        this(exprParser, null);
    }

    public SQLSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser.getLexer(), exprParser.getDbType());
        this.exprParser = exprParser;
        this.selectListCache = selectListCache;
    }

    public SQLSelect select() {
        SQLSelect select = new SQLSelect();
        Lexer.SavePoint mark = null;
        int parenCount = 0;
        while (this.lexer.token == Token.LPAREN) {
            if (mark == null) {
                mark = this.lexer.markOut();
            }
            ++parenCount;
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.WITH) {
            SQLWithSubqueryClause with = this.parseWith();
            select.setWithSubQuery(with);
        } else if (mark != null) {
            this.lexer.reset(mark);
            parenCount = 0;
        }
        SQLSelectQuery query = this.query(select, true);
        select.setQuery(query);
        SQLOrderBy orderBy = this.parseOrderBy();
        if (query instanceof SQLSelectQueryBlock) {
            SQLLimit limit;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            if (queryBlock.getOrderBy() == null) {
                queryBlock.setOrderBy(orderBy);
                if (this.lexer.token == Token.LIMIT) {
                    limit = this.exprParser.parseLimit();
                    queryBlock.setLimit(limit);
                }
            } else {
                select.setOrderBy(orderBy);
                if (this.lexer.token == Token.LIMIT) {
                    limit = this.exprParser.parseLimit();
                    select.setLimit(limit);
                }
            }
            if (orderBy != null) {
                this.parseFetchClause(queryBlock);
            }
        } else {
            select.setOrderBy(orderBy);
        }
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            select.setLimit(limit);
        }
        while (this.lexer.token == Token.HINT) {
            this.exprParser.parseHints(select.getHints());
        }
        for (int i = 0; i < parenCount; ++i) {
            this.accept(Token.RPAREN);
        }
        if (parenCount > 0 && this.lexer.token == Token.UNION) {
            select.setQuery(this.queryRest(select.getQuery(), true));
        }
        return select;
    }

    protected void afterParseFetchClause(SQLSelectQueryBlock queryBlock) {
    }

    protected void afterParseLimitClause(SQLSelectQueryBlock queryBlock) {
    }

    protected SQLUnionQuery createSQLUnionQuery() {
        return new SQLUnionQuery(this.dbType);
    }

    public SQLUnionQuery unionRest(SQLUnionQuery union) {
        if (this.lexer.token == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            union.setOrderBy(orderBy);
            return this.unionRest(union);
        }
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            union.setLimit(limit);
        }
        return union;
    }

    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery) {
        return this.queryRest(selectQuery, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery, boolean acceptUnion) {
        if (!acceptUnion) {
            return selectQuery;
        }
        if (this.lexer.token != Token.UNION) {
            if (this.lexer.token == Token.EXCEPT) {
                SQLLimit limit;
                this.lexer.nextToken();
                SQLUnionQuery union = new SQLUnionQuery();
                union.setLeft(selectQuery);
                if (this.lexer.token == Token.ALL) {
                    this.lexer.nextToken();
                    union.setOperator(SQLUnionOperator.EXCEPT_ALL);
                } else if (this.lexer.token == Token.DISTINCT) {
                    this.lexer.nextToken();
                    union.setOperator(SQLUnionOperator.EXCEPT_DISTINCT);
                } else {
                    union.setOperator(SQLUnionOperator.EXCEPT);
                }
                boolean paren = this.lexer.token == Token.LPAREN;
                SQLSelectQuery right = this.query(union, false);
                union.setRight(right);
                if (paren) return this.queryRest(union, true);
                if (right instanceof SQLSelectQueryBlock) {
                    SQLLimit limit2;
                    SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                    SQLOrderBy orderBy = rightQuery.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightQuery.setOrderBy(null);
                    }
                    if ((limit2 = rightQuery.getLimit()) == null) return this.queryRest(union, true);
                    union.setLimit(limit2);
                    rightQuery.setLimit(null);
                    return this.queryRest(union, true);
                }
                if (!(right instanceof SQLUnionQuery)) return this.queryRest(union, true);
                SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                SQLOrderBy orderBy = rightUnion.getOrderBy();
                if (orderBy != null) {
                    union.setOrderBy(orderBy);
                    rightUnion.setOrderBy(null);
                }
                if ((limit = rightUnion.getLimit()) == null) return this.queryRest(union, true);
                union.setLimit(limit);
                rightUnion.setLimit(null);
                return this.queryRest(union, true);
            }
            if (this.lexer.token == Token.INTERSECT) {
                SQLLimit limit;
                this.lexer.nextToken();
                SQLUnionQuery union = new SQLUnionQuery();
                union.setLeft(selectQuery);
                if (this.lexer.token() == Token.DISTINCT) {
                    this.lexer.nextToken();
                    union.setOperator(SQLUnionOperator.INTERSECT_DISTINCT);
                } else if (this.lexer.token == Token.ALL) {
                    this.lexer.nextToken();
                    union.setOperator(SQLUnionOperator.INTERSECT_ALL);
                } else {
                    union.setOperator(SQLUnionOperator.INTERSECT);
                }
                boolean paren = this.lexer.token == Token.LPAREN;
                SQLSelectQuery right = this.query(union, false);
                union.setRight(right);
                if (paren) return this.queryRest(union, true);
                if (right instanceof SQLSelectQueryBlock) {
                    SQLLimit limit3;
                    SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                    SQLOrderBy orderBy = rightQuery.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightQuery.setOrderBy(null);
                    }
                    if ((limit3 = rightQuery.getLimit()) == null) return this.queryRest(union, true);
                    union.setLimit(limit3);
                    rightQuery.setLimit(null);
                    return this.queryRest(union, true);
                }
                if (!(right instanceof SQLUnionQuery)) return this.queryRest(union, true);
                SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                SQLOrderBy orderBy = rightUnion.getOrderBy();
                if (orderBy != null) {
                    union.setOrderBy(orderBy);
                    rightUnion.setOrderBy(null);
                }
                if ((limit = rightUnion.getLimit()) == null) return this.queryRest(union, true);
                union.setLimit(limit);
                rightUnion.setLimit(null);
                return this.queryRest(union, true);
            }
            if (!acceptUnion) return selectQuery;
            if (this.lexer.token != Token.MINUS) return selectQuery;
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.MINUS);
            if (this.lexer.token == Token.DISTINCT) {
                union.setOperator(SQLUnionOperator.MINUS_DISTINCT);
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.ALL) {
                union.setOperator(SQLUnionOperator.MINUS_ALL);
                this.lexer.nextToken();
            }
            SQLSelectQuery right = this.query(union, false);
            union.setRight(right);
            return this.queryRest(union, true);
        }
        do {
            Lexer.SavePoint uninMark = this.lexer.mark();
            this.lexer.nextToken();
            switch (this.lexer.token) {
                case GROUP: 
                case ORDER: 
                case WHERE: 
                case RPAREN: {
                    this.lexer.reset(uninMark);
                    return selectQuery;
                }
            }
            if (this.lexer.token == Token.SEMI && this.dialectFeatureEnabled(DialectFeature.ParserFeature.QueryRestSemi)) break;
            SQLUnionQuery union = this.createSQLUnionQuery();
            union.setLeft(selectQuery);
            if (this.lexer.token == Token.ALL) {
                union.setOperator(SQLUnionOperator.UNION_ALL);
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.DISTINCT) {
                union.setOperator(SQLUnionOperator.DISTINCT);
                this.lexer.nextToken();
            }
            boolean paren = this.lexer.token == Token.LPAREN;
            SQLSelectQuery right = this.query(paren ? null : union, false);
            union.setRight(right);
            while (this.lexer.isEnabled(SQLParserFeature.EnableMultiUnion) && this.lexer.token == Token.UNION) {
                block44: {
                    Lexer.SavePoint mark = this.lexer.mark();
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.UNION && this.dialectFeatureEnabled(DialectFeature.ParserFeature.TwoConsecutiveUnion)) continue;
                    if (this.lexer.token == Token.ALL) {
                        if (union.getOperator() == SQLUnionOperator.UNION_ALL) {
                            this.lexer.nextToken();
                            break block44;
                        } else {
                            this.lexer.reset(mark);
                            break;
                        }
                    }
                    if (this.lexer.token == Token.DISTINCT) {
                        if (union.getOperator() == SQLUnionOperator.DISTINCT) {
                            this.lexer.nextToken();
                            break block44;
                        } else {
                            this.lexer.reset(mark);
                            break;
                        }
                    }
                    if (union.getOperator() != SQLUnionOperator.UNION) {
                        this.lexer.reset(mark);
                        break;
                    }
                }
                paren = this.lexer.token == Token.LPAREN;
                SQLSelectQuery r = this.query(paren ? null : union, false);
                r.setParenthesized(paren);
                union.addRelation(r);
                right = r;
            }
            if (!paren) {
                SQLLimit limit;
                SQLOrderBy orderBy;
                if (right instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                    orderBy = rightQuery.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightQuery.setOrderBy(null);
                    }
                    if ((limit = rightQuery.getLimit()) != null) {
                        union.setLimit(limit);
                        rightQuery.setLimit(null);
                    }
                } else if (right instanceof SQLUnionQuery) {
                    SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                    orderBy = rightUnion.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightUnion.setOrderBy(null);
                    }
                    if ((limit = rightUnion.getLimit()) != null) {
                        union.setLimit(limit);
                        rightUnion.setLimit(null);
                    }
                }
            }
            union = this.unionRest(union);
            selectQuery = union;
        } while (this.lexer.token() == Token.UNION);
        return this.queryRest(selectQuery, true);
    }

    private void setToLeft(SQLSelectQuery selectQuery, SQLUnionQuery parentUnion, SQLUnionQuery union, SQLSelectQuery right) {
        SQLUnionOperator operator = union.getOperator();
        if (union.getLeft() instanceof SQLUnionQuery) {
            SQLUnionQuery left = (SQLUnionQuery)union.getLeft();
            while (left.getLeft() instanceof SQLUnionQuery) {
                left = (SQLUnionQuery)left.getLeft();
            }
            left.setLeft(new SQLUnionQuery(parentUnion.getLeft(), parentUnion.getOperator(), left.getLeft()));
            parentUnion.setLeft(union.getLeft());
            parentUnion.setRight(union.getRight());
        } else {
            parentUnion.setRight(right);
            union.setLeft(parentUnion.getLeft());
            parentUnion.setLeft(union);
            union.setRight(selectQuery);
            union.setOperator(parentUnion.getOperator());
            parentUnion.setOperator(operator);
        }
    }

    public SQLSelectQuery query() {
        return this.query(null, true);
    }

    public SQLSelectQuery query(SQLObject parent) {
        return this.query(parent, true);
    }

    protected SQLSelectQueryBlock createSelectQueryBlock() {
        return new SQLSelectQueryBlock(this.dbType);
    }

    protected void querySelectListBefore(SQLSelectQueryBlock x) {
    }

    protected void parseTop(SQLSelectQueryBlock x) {
    }

    protected void queryBefore(SQLSelectQueryBlock x) {
    }

    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            select.setParenthesized(true);
            return this.queryRest(select, acceptUnion);
        }
        if (this.lexer.token() == Token.VALUES) {
            return this.valuesQuery(acceptUnion);
        }
        SQLSelectQueryBlock queryBlock = this.createSelectQueryBlock();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        if (this.lexer.token() == Token.TABLE && this.dialectFeatureEnabled(DialectFeature.ParserFeature.QueryTable)) {
            this.lexer.nextToken();
            queryBlock.getSelectList().add(new SQLSelectItem(new SQLAllColumnExpr()));
            queryBlock.setFrom(this.parseTableSource());
            return this.queryRest(queryBlock, acceptUnion);
        }
        this.queryBefore(queryBlock);
        this.accept(Token.SELECT);
        this.querySelectListBefore(queryBlock);
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(queryBlock.getHints());
        }
        this.lexer.nextIf(Token.COMMENT);
        this.parseTop(queryBlock);
        this.parseBeforeSelectList(queryBlock);
        this.parseSelectList(queryBlock);
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLExpr expr = this.expr();
            if (this.lexer.token() != Token.COMMA) {
                queryBlock.setInto(expr);
            }
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        this.qualify(queryBlock);
        this.parseWindow(queryBlock);
        this.parseSortBy(queryBlock);
        this.parseFetchClause(queryBlock);
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            queryBlock.setForUpdate(true);
            if (this.lexer.identifierEquals(FnvHash.Constants.NO_WAIT) || this.lexer.identifierEquals(FnvHash.Constants.NOWAIT)) {
                this.lexer.nextToken();
                queryBlock.setNoWait(true);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.WAIT)) {
                this.lexer.nextToken();
                SQLExpr waitTime = this.exprParser.primary();
                queryBlock.setWaitTime(waitTime);
            }
        }
        return this.queryRest(queryBlock, acceptUnion);
    }

    protected void parseBeforeSelectList(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
    }

    protected SQLSelectQuery valuesQuery(boolean acceptUnion) {
        this.lexer.nextToken();
        SQLValuesQuery valuesQuery = new SQLValuesQuery();
        while (true) {
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                SQLListExpr listExpr = new SQLListExpr();
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
                valuesQuery.addValue(listExpr);
            } else {
                this.exprParser.exprList(valuesQuery.getValues(), valuesQuery);
            }
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return this.queryRest(valuesQuery, acceptUnion);
    }

    protected void withSubquery(SQLSelect select) {
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
            if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals(FnvHash.Constants.RECURSIVE)) {
                this.lexer.nextToken();
                withQueryClause.setRecursive(true);
            }
            while (true) {
                SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
                entry.setParent(withQueryClause);
                String alias = this.lexer.stringVal();
                this.lexer.nextToken();
                entry.setAlias(alias);
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(entry.getColumns());
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.AS);
                this.accept(Token.LPAREN);
                entry.setSubQuery(this.select());
                this.accept(Token.RPAREN);
                withQueryClause.addEntry(entry);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            select.setWithSubQuery(withQueryClause);
        }
    }

    public SQLWithSubqueryClause parseWith() {
        SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            withQueryClause.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.WITH);
        if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals(FnvHash.Constants.RECURSIVE)) {
            this.lexer.nextToken();
            withQueryClause.setRecursive(true);
        }
        while (true) {
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            entry.setParent(withQueryClause);
            String alias = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.nextIf(Token.LPAREN)) {
                this.exprParser.names(entry.getColumns(), entry);
                this.accept(Token.RPAREN);
            }
            entry.setAlias(alias);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(entry.getColumns());
                this.accept(Token.RPAREN);
            }
            this.accept(Token.AS);
            this.accept(Token.LPAREN);
            switch (this.lexer.token) {
                case SELECT: 
                case LPAREN: 
                case WITH: 
                case FROM: 
                case VALUES: {
                    entry.setSubQuery(this.select());
                    break;
                }
            }
            this.accept(Token.RPAREN);
            withQueryClause.addEntry(entry);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withQueryClause;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseWhere(SQLSelectQueryBlock queryBlock) {
        SQLExpr where;
        if (this.lexer.token != Token.WHERE) {
            return;
        }
        this.lexer.nextTokenIdent();
        List<String> beforeComments = null;
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            beforeComments = this.lexer.readAndResetComments();
        }
        if (this.lexer.token == Token.IDENTIFIER) {
            SQLExpr identExpr;
            String ident = this.lexer.stringVal();
            long hash_lower = this.lexer.hashLCase();
            this.lexer.nextTokenEq();
            if (this.lexer.token == Token.LITERAL_CHARS) {
                String literal = this.lexer.stringVal;
                if (hash_lower == FnvHash.Constants.TIMESTAMP) {
                    identExpr = new SQLTimestampExpr(literal);
                    this.lexer.nextToken();
                } else if (hash_lower == FnvHash.Constants.DATE) {
                    identExpr = new SQLDateExpr(literal);
                    this.lexer.nextToken();
                } else if (hash_lower == FnvHash.Constants.REAL) {
                    identExpr = new SQLRealExpr(Float.parseFloat(literal));
                    this.lexer.nextToken();
                } else {
                    identExpr = new SQLIdentifierExpr(ident, hash_lower);
                }
            } else if (this.lexer.identifierEquals("COLLATE")) {
                this.acceptIdentifier("COLLATE");
                String collateValue = this.lexer.stringVal();
                if (this.lexer.token != Token.IDENTIFIER && this.lexer.token != Token.LITERAL_ALIAS && this.lexer.token != Token.LITERAL_CHARS) throw new ParserException("syntax error. " + this.lexer.info());
                identExpr = new SQLIdentifierExpr(ident);
                ((SQLIdentifierExpr)identExpr).setCollate(collateValue);
                this.lexer.nextToken();
            } else {
                identExpr = new SQLIdentifierExpr(ident, hash_lower);
            }
            if (this.lexer.token == Token.DOT) {
                identExpr = this.exprParser.primaryRest(identExpr);
            }
            if (this.lexer.token == Token.EQ) {
                SQLExpr rightExp;
                this.lexer.nextToken();
                try {
                    rightExp = this.exprParser.bitOr();
                }
                catch (EOFParserException e) {
                    throw new ParserException("EOF, " + ident + "=", e);
                }
                where = new SQLBinaryOpExpr(identExpr, SQLBinaryOperator.Equality, rightExp, this.dbType);
                switch (this.lexer.token) {
                    case BETWEEN: 
                    case IS: 
                    case EQ: 
                    case IN: 
                    case CONTAINS: 
                    case BANG_TILDE_STAR: 
                    case TILDE_EQ: 
                    case LT: 
                    case LTEQ: 
                    case LTEQGT: 
                    case GT: 
                    case GTEQ: 
                    case LTGT: 
                    case BANGEQ: 
                    case LIKE: 
                    case NOT: {
                        where = this.exprParser.relationalRest(where);
                        break;
                    }
                }
                where = this.exprParser.andRest(where);
                where = this.exprParser.xorRest(where);
                where = this.exprParser.orRest(where);
            } else {
                identExpr = this.exprParser.primaryRest(identExpr);
                where = this.exprParser.exprRest(identExpr);
            }
        } else {
            while (this.lexer.token == Token.HINT) {
                this.lexer.nextToken();
            }
            where = this.exprParser.expr();
            while (this.lexer.token == Token.HINT) {
                this.lexer.nextToken();
            }
        }
        if (beforeComments != null) {
            where.addBeforeComment(beforeComments);
        }
        if (this.lexer.hasComment() && this.lexer.isKeepComments() && this.lexer.token != Token.INSERT) {
            where.addAfterComment(this.lexer.readAndResetComments());
        }
        queryBlock.setWhere(where);
    }

    protected void parseAfterOrderBy(SQLSelectQueryBlock queryBlock) {
    }

    protected void parseSortBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.parseOrderBy();
            queryBlock.setOrderBy(orderBy);
            this.parseAfterOrderBy(queryBlock);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTE)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem distributeByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addDistributeBy(distributeByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem sortByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addSortBy(sortByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTER)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem clusterByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addClusterBy(clusterByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
    }

    protected void qualify(SQLSelectQueryBlock queryBlock) {
        if (!this.lexer.nextIf(Token.QUALIFY)) {
            return;
        }
        SQLExpr qualify = this.exprParser.expr();
        queryBlock.setQualify(qualify);
    }

    protected void parseWindow(SQLSelectQueryBlock queryBlock) {
        if (!this.lexer.identifierEquals(FnvHash.Constants.WINDOW) && this.lexer.token != Token.WINDOW) {
            return;
        }
        this.lexer.nextToken();
        while (true) {
            SQLName name = this.exprParser.name();
            this.accept(Token.AS);
            SQLOver over = new SQLOver();
            this.exprParser.over(over);
            queryBlock.addWindow(new SQLWindow(name, over));
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseGroupBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.GROUP) {
            SQLExpr having;
            this.lexer.nextTokenBy();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            if (this.lexer.token == Token.HINT) {
                groupBy.setHint(this.exprParser.parseHint());
            }
            if (this.lexer.token == Token.ALL) {
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                if (!this.lexer.identifierEquals(FnvHash.Constants.GROUPING)) {
                    if (!this.dialectFeatureEnabled(DialectFeature.ParserFeature.GroupByAll)) throw new ParserException("group by all syntax error. " + this.lexer.info());
                    this.lexer.reset(mark);
                }
            } else if (this.lexer.token == Token.DISTINCT) {
                this.lexer.nextToken();
                groupBy.setDistinct(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                groupBy.setWithRollUp(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                groupBy.setWithCube(true);
            }
            while (true) {
                List<String> comments = null;
                if (this.lexer.hasComment()) {
                    comments = this.lexer.readAndResetComments();
                }
                SQLExpr item = this.parseGroupByItem();
                if (comments != null) {
                    item.addBeforeComment(comments);
                }
                item.setParent(groupBy);
                groupBy.addItem(item);
                if (this.lexer.token == Token.COMMA) {
                    int line = this.lexer.line;
                    this.lexer.nextToken();
                    if (!this.lexer.hasComment() || !this.lexer.isKeepComments() || this.lexer.getComments().size() != 1 || !this.lexer.getComments().get(0).startsWith("--") || this.lexer.line != line + 1) continue;
                    item.addAfterComment(this.lexer.readAndResetComments());
                    continue;
                }
                if (!this.lexer.identifierEquals(FnvHash.Constants.GROUPING)) break;
            }
            if (groupBy.isWithRollUp() || groupBy.isWithCube()) {
                this.accept(Token.RPAREN);
                groupBy.setParen(true);
                if (this.lexer.token == Token.COMMA && this.dialectFeatureEnabled(DialectFeature.ParserFeature.RewriteGroupByCubeRollupToFunction)) {
                    this.lexer.nextToken();
                    SQLMethodInvokeExpr func = new SQLMethodInvokeExpr(groupBy.isWithCube() ? "CUBE" : "ROLLUP");
                    func.getArguments().addAll(groupBy.getItems());
                    groupBy.getItems().clear();
                    groupBy.setWithCube(false);
                    groupBy.setWithRollUp(false);
                    for (SQLExpr arg : func.getArguments()) {
                        arg.setParent(func);
                    }
                    groupBy.addItem(func);
                    this.exprParser.exprList(groupBy.getItems(), groupBy);
                }
            }
            if (this.lexer.token == Token.HAVING) {
                this.lexer.nextToken();
                having = this.exprParser.expr();
                groupBy.setHaving(having);
            }
            if (this.lexer.token == Token.WITH) {
                this.parseOrderByWith(groupBy, queryBlock);
            }
            if (groupBy.getHaving() == null && this.lexer.token == Token.HAVING) {
                this.lexer.nextToken();
                having = this.exprParser.expr();
                groupBy.setHaving(having);
            }
            queryBlock.setGroupBy(groupBy);
            return;
        } else {
            if (this.lexer.token != Token.HAVING) return;
            this.lexer.nextToken();
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            groupBy.setHaving(this.exprParser.expr());
            if (this.lexer.token == Token.GROUP) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                while (true) {
                    SQLExpr item = this.parseGroupByItem();
                    item.setParent(groupBy);
                    groupBy.addItem(item);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("ROLLUP");
                groupBy.setWithRollUp(true);
            }
            if (this.dialectFeatureEnabled(DialectFeature.ParserFeature.GroupByPostDesc) && this.lexer.token == Token.DESC) {
                this.lexer.nextToken();
            }
            queryBlock.setGroupBy(groupBy);
        }
    }

    protected void parseOrderByWith(SQLSelectGroupByClause groupBy, SQLSelectQueryBlock queryBlock) {
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
            this.lexer.nextToken();
            groupBy.setWithCube(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
            this.lexer.nextToken();
            groupBy.setWithRollUp(true);
        } else {
            this.lexer.reset(mark);
        }
    }

    protected SQLExpr parseGroupByItem() {
        SQLExpr item;
        if (this.lexer.token == Token.LPAREN) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token == Token.RPAREN) {
                this.lexer.nextToken();
                return new SQLListExpr();
            }
            this.lexer.reset(mark);
        }
        if (this.lexer.nextIf(Token.ALL)) {
            return new SQLIdentifierExpr("ALL");
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
            SQLMethodInvokeExpr rollup = new SQLMethodInvokeExpr(this.lexer.stringVal());
            this.lexer.nextToken();
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                while (this.lexer.token != Token.RPAREN) {
                    SQLExpr expr;
                    if (this.lexer.token == Token.LPAREN) {
                        this.accept(Token.LPAREN);
                        SQLListExpr list = new SQLListExpr();
                        if (this.lexer.token == Token.COMMA) {
                            this.lexer.nextToken();
                        }
                        this.exprParser.exprList(list.getItems(), list);
                        this.accept(Token.RPAREN);
                        expr = list;
                    } else {
                        expr = this.exprParser.expr();
                    }
                    rollup.addArgument(expr);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            item = rollup;
        } else {
            item = this.exprParser.expr();
        }
        if (this.dialectFeatureEnabled(DialectFeature.ParserFeature.GroupByItemOrder)) {
            if (this.lexer.token == Token.DESC) {
                this.lexer.nextToken();
                item = new MySqlOrderingExpr(item, SQLOrderingSpecification.DESC);
            } else if (this.lexer.token == Token.ASC) {
                this.lexer.nextToken();
                item = new MySqlOrderingExpr(item, SQLOrderingSpecification.ASC);
            }
        }
        if (this.lexer.token == Token.HINT) {
            SQLCommentHint hint = this.exprParser.parseHint();
            if (item instanceof SQLObjectImpl) {
                ((SQLExprImpl)item).setHint(hint);
            }
        }
        return item;
    }

    protected void parseSelectList(SQLSelectQueryBlock queryBlock) {
        List<SQLSelectItem> selectList = queryBlock.getSelectList();
        do {
            SQLSelectItem selectItem = this.exprParser.parseSelectItem();
            selectList.add(selectItem);
            selectItem.setParent(queryBlock);
            if (this.lexer.hasComment() && this.lexer.isKeepComments() && !this.lexer.getComments().isEmpty() && this.lexer.getComments().get(0).startsWith("--")) {
                selectItem.addAfterComment(this.lexer.readAndResetComments());
            }
            if (this.lexer.token != Token.COMMA) break;
            int line = this.lexer.line;
            this.lexer.nextToken();
            if (this.lexer.hasComment() && this.lexer.isKeepComments() && this.lexer.getComments().size() == 1 && this.lexer.getComments().get(0).startsWith("--") && this.lexer.line == line + 1) {
                selectItem.addAfterComment(this.lexer.readAndResetComments());
            }
            if (this.lexer.token != Token.FROM && this.lexer.token != Token.UNION) continue;
            if (this.parseSelectListFromError()) {
                throw new ParserException("syntax error, expect is not TOKEN:from " + this.lexer.info());
            }
            break;
        } while (this.lexer.token != Token.RPAREN || this.dbType != DbType.bigquery);
    }

    protected boolean parseSelectListFromError() {
        return true;
    }

    public void parseFrom(SQLSelectQueryBlock queryBlock) {
        if (!this.lexer.nextIf(Token.FROM)) {
            return;
        }
        if (this.lexer.hasComment()) {
            queryBlock.setCommentsAfterFrom(this.lexer.readAndResetComments());
        }
        queryBlock.setFrom(this.parseTableSource(true));
    }

    public SQLTableSource parseTableSource() {
        return this.parseTableSource(false);
    }

    public SQLTableSource parseTableSource(boolean forFrom) {
        if (this.lexer.token == Token.LPAREN) {
            SQLTableSource tableSource;
            SQLSelect select;
            this.lexer.nextToken();
            if (this.lexer.token == Token.SELECT || this.lexer.token == Token.WITH || this.lexer.token == Token.SEL) {
                select = this.select();
                SQLSelectQuery selectQuery = select.getQuery();
                selectQuery.setParenthesized(true);
                boolean acceptUnion = !(selectQuery instanceof SQLUnionQuery) && this.dialectFeatureEnabled(DialectFeature.ParserFeature.AcceptUnion);
                SQLSelectQuery query = this.queryRest(selectQuery, acceptUnion);
                if (query instanceof SQLUnionQuery) {
                    tableSource = new SQLUnionQueryTableSource((SQLUnionQuery)query);
                    SQLWithSubqueryClause with = select.getWithSubQuery();
                    if (with != null) {
                        ((SQLUnionQuery)query).setWith(with);
                    }
                } else {
                    tableSource = SQLSubqueryTableSource.fixParenthesized(new SQLSubqueryTableSource(select));
                }
            } else if (this.lexer.token == Token.LPAREN) {
                tableSource = this.parseTableSource();
                while (this.lexer.token == Token.UNION || this.lexer.token == Token.EXCEPT || this.lexer.token == Token.INTERSECT || this.lexer.token == Token.MINUS) {
                    if (tableSource instanceof SQLUnionQueryTableSource) {
                        SQLUnionQueryTableSource unionQueryTableSource = (SQLUnionQueryTableSource)tableSource;
                        SQLUnionQuery union = unionQueryTableSource.getUnion();
                        unionQueryTableSource.setUnion((SQLUnionQuery)this.queryRest(union));
                        continue;
                    }
                    if (tableSource instanceof SQLSubqueryTableSource) {
                        select = ((SQLSubqueryTableSource)tableSource).getSelect();
                        if (select == null) continue;
                        SQLSelectQuery query = select.getQuery();
                        SQLSelectQuery queryRest = this.queryRest(query, true);
                        select.setQuery(queryRest);
                        continue;
                    }
                    break;
                }
            } else {
                tableSource = this.parseTableSource();
            }
            if (this.lexer.token == Token.RPAREN) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.AS) {
                SQLTableSourceImpl values;
                this.lexer.nextToken();
                String alias = this.tableAlias(true);
                tableSource.setAlias(alias);
                if (tableSource instanceof SQLValuesTableSource && ((SQLValuesTableSource)tableSource).getColumns().isEmpty()) {
                    values = (SQLValuesTableSource)tableSource;
                    this.accept(Token.LPAREN);
                    this.exprParser.names(((SQLValuesTableSource)values).getColumns(), values);
                    this.accept(Token.RPAREN);
                } else if (tableSource instanceof SQLSubqueryTableSource) {
                    values = (SQLSubqueryTableSource)tableSource;
                    if (this.lexer.token == Token.LPAREN) {
                        this.lexer.nextToken();
                        this.exprParser.names(((SQLSubqueryTableSource)values).getColumns(), values);
                        this.accept(Token.RPAREN);
                    }
                }
            }
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token() == Token.VALUES) {
            SQLValuesTableSource tableSource = new SQLValuesTableSource();
            this.lexer.computeRowAndColumn(tableSource);
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLListExpr listExpr = new SQLListExpr();
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
                listExpr.setParent(tableSource);
                tableSource.getValues().add(listExpr);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.RPAREN || this.lexer.token == Token.SEMI || this.lexer.token == Token.EOF) {
                return tableSource;
            }
            String alias = this.tableAlias();
            if (alias != null) {
                tableSource.setAlias(alias);
            }
            this.accept(Token.LPAREN);
            this.exprParser.names(tableSource.getColumns(), tableSource);
            this.accept(Token.RPAREN);
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token == Token.SELECT) {
            throw new ParserException("TODO " + this.lexer.info());
        }
        SQLTableSource unnestTableSource = this.parseUnnestTableSource();
        if (unnestTableSource != null) {
            return this.parseTableSourceRest(unnestTableSource);
        }
        SQLTableSource generatedTableSource = this.parseGeneratedTableSource();
        if (generatedTableSource != null) {
            return this.parseTableSourceRest(generatedTableSource);
        }
        SQLExprTableSource tableReference = this.getTableSource();
        this.parseTableSourceQueryTableExpr(tableReference);
        SQLTableSource tableSrc = this.parseTableSourceRest(tableReference);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            tableSrc.addAfterComment(this.lexer.readAndResetComments());
        }
        return tableSrc;
    }

    protected SQLExprTableSource getTableSource() {
        return new SQLExprTableSource();
    }

    protected void parseTableSourceQueryTableExpr(SQLExprTableSource tableReference) {
        SQLExpr expr;
        if (this.lexer.token == Token.LITERAL_ALIAS || this.lexer.identifierEquals(FnvHash.Constants.IDENTIFIED) || this.lexer.token == Token.LITERAL_CHARS) {
            tableReference.setExpr(this.exprParser.name());
            return;
        }
        if (this.lexer.token == Token.HINT) {
            SQLCommentHint hint = this.exprParser.parseHint();
            tableReference.setHint(hint);
        }
        switch (this.lexer.token) {
            case ALL: 
            case SET: {
                expr = this.exprParser.name();
                break;
            }
            default: {
                expr = this.exprParser.expr();
            }
        }
        if (expr instanceof SQLBinaryOpExpr) {
            throw new ParserException("Invalid from clause : " + expr.toString().replace("\n", " "));
        }
        tableReference.setExpr(expr);
    }

    protected SQLTableSource parseUnnestTableSource() {
        if (this.lexer.identifierEquals(FnvHash.Constants.UNNEST)) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.nextIf(Token.LPAREN)) {
                SQLUnnestTableSource unnest = new SQLUnnestTableSource();
                this.exprParser.exprList(unnest.getItems(), unnest);
                this.accept(Token.RPAREN);
                if (this.lexer.nextIf(Token.WITH)) {
                    this.acceptIdentifier("ORDINALITY");
                    unnest.setOrdinality(true);
                }
                String alias = this.tableAlias();
                unnest.setAlias(alias);
                if (this.lexer.nextIf(Token.LPAREN)) {
                    this.exprParser.names(unnest.getColumns(), unnest);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.nextIf(Token.WITH)) {
                    this.acceptIdentifier("OFFSET");
                    this.lexer.nextIf(Token.AS);
                    unnest.setOffset(this.exprParser.expr());
                }
                return unnest;
            }
            this.lexer.reset(mark);
        }
        return null;
    }

    protected SQLTableSource parseGeneratedTableSource() {
        for (String returningFunction : this.getReturningFunctions()) {
            if (!this.lexer.identifierEquals(returningFunction)) continue;
            Lexer.SavePoint mark = this.lexer.mark();
            SQLIdentifierExpr methodName = new SQLIdentifierExpr(returningFunction);
            this.lexer.nextToken();
            if (this.lexer.nextIf(Token.LPAREN)) {
                SQLGeneratedTableSource generated = new SQLGeneratedTableSource();
                generated.setMethodName(methodName);
                this.exprParser.exprList(generated.getItems(), generated);
                this.accept(Token.RPAREN);
                String alias = this.tableAlias();
                generated.setAlias(alias);
                if (this.lexer.nextIf(Token.LPAREN)) {
                    this.exprParser.names(generated.getColumns(), generated);
                    this.accept(Token.RPAREN);
                }
                return generated;
            }
            this.lexer.reset(mark);
        }
        return null;
    }

    protected List<String> getReturningFunctions() {
        return Collections.singletonList("GENERATE_SERIES");
    }

    protected SQLTableSource primaryTableSourceRest(SQLTableSource tableSource) {
        return tableSource;
    }

    public void parseTableSourceSample(SQLTableSource tableSource) {
    }

    public void parseTableSourceSampleHive(SQLTableSource tableSource) {
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLESAMPLE) && tableSource instanceof SQLExprTableSource) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLTableSampling sampling = new SQLTableSampling();
                if (this.lexer.identifierEquals(FnvHash.Constants.BUCKET)) {
                    this.lexer.nextToken();
                    SQLExpr bucket = this.exprParser.primary();
                    sampling.setBucket(bucket);
                    if (this.lexer.token() == Token.OUT) {
                        this.lexer.nextToken();
                        this.accept(Token.OF);
                        SQLExpr outOf = this.exprParser.primary();
                        sampling.setOutOf(outOf);
                    }
                    if (this.lexer.token() == Token.ON) {
                        this.lexer.nextToken();
                        SQLExpr on = this.exprParser.expr();
                        sampling.setOn(on);
                    }
                }
                if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT) {
                    SQLExpr val = this.exprParser.primary();
                    if (this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                        this.lexer.nextToken();
                        sampling.setRows(val);
                    } else {
                        this.acceptIdentifier("PERCENT");
                        sampling.setPercent(val);
                    }
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String strVal = this.lexer.stringVal();
                    char first = strVal.charAt(0);
                    char last = strVal.charAt(strVal.length() - 1);
                    if (last >= 'a' && last <= 'z') {
                        last = (char)(last - 32);
                    }
                    boolean match = false;
                    if (first == '.' || first >= '0' && first <= '9') {
                        switch (last) {
                            case 'B': 
                            case 'G': 
                            case 'K': 
                            case 'M': 
                            case 'P': 
                            case 'T': {
                                match = true;
                                break;
                            }
                        }
                    }
                    SQLSizeExpr size = new SQLSizeExpr(strVal.substring(0, strVal.length() - 2), last);
                    sampling.setByteLength(size);
                    this.lexer.nextToken();
                }
                SQLExprTableSource table = (SQLExprTableSource)tableSource;
                table.setSampling(sampling);
                this.accept(Token.RPAREN);
            } else {
                this.lexer.reset(mark);
            }
        }
    }

    protected void parseJoinHint(SQLJoinTableSource join) {
    }

    public SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        block123: {
            block122: {
                this.parseTableSourceSample(tableSource);
                if (this.lexer.hasComment() && this.lexer.isKeepComments() && !(tableSource instanceof SQLSubqueryTableSource)) {
                    tableSource.addAfterComment(this.lexer.readAndResetComments());
                }
                if (tableSource.getAlias() != null && tableSource.getAlias().length() != 0) break block122;
                Token token = this.lexer.token;
                switch (token) {
                    case LEFT: 
                    case RIGHT: 
                    case FULL: {
                        Lexer.SavePoint mark = this.lexer.mark();
                        String strVal = this.lexer.stringVal();
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.OUTER || this.lexer.token == Token.JOIN || this.lexer.identifierEquals(FnvHash.Constants.ANTI) || this.lexer.identifierEquals(FnvHash.Constants.ARRAY) || this.lexer.identifierEquals(FnvHash.Constants.SEMI)) {
                            this.lexer.reset(mark);
                            break;
                        }
                        tableSource.setAlias(strVal);
                        break;
                    }
                    case OUTER: {
                        break;
                    }
                    default: {
                        long hash;
                        String strVal;
                        if (this.identifierEquals("ARRAY")) {
                            Lexer.SavePoint mark = this.lexer.mark();
                            strVal = this.lexer.stringVal();
                            this.lexer.nextToken();
                            if (this.lexer.token == Token.JOIN) {
                                this.lexer.reset(mark);
                                break;
                            }
                            tableSource.setAlias(strVal);
                            break;
                        }
                        if (this.identifierEquals("PIVOT") || this.identifierEquals("UNPIVOT")) {
                            this.parsePivot(tableSource);
                            break;
                        }
                        if (token != Token.IDENTIFIER || (hash = this.lexer.hashLCase()) != FnvHash.Constants.STRAIGHT_JOIN && hash != FnvHash.Constants.CROSS) {
                            String alias;
                            boolean must = false;
                            if (this.lexer.token == Token.AS) {
                                this.lexer.nextToken();
                                must = true;
                            }
                            if ((alias = this.tableAlias(must)) != null) {
                                if (this.isEnabled(SQLParserFeature.IgnoreNameQuotes) && alias.length() > 1) {
                                    alias = StringUtils.removeNameQuotes(alias);
                                }
                                tableSource.setAlias(alias);
                                if (this.lexer.token == Token.HINT) {
                                    tableSource.addAfterComment("/*" + this.lexer.stringVal + "*/");
                                    this.lexer.nextToken();
                                }
                                if (tableSource instanceof SQLValuesTableSource && ((SQLValuesTableSource)tableSource).getColumns().isEmpty()) {
                                    SQLValuesTableSource values = (SQLValuesTableSource)tableSource;
                                    this.accept(Token.LPAREN);
                                    this.exprParser.names(values.getColumns(), values);
                                    this.accept(Token.RPAREN);
                                } else if (tableSource instanceof SQLSubqueryTableSource) {
                                    SQLSubqueryTableSource subQuery = (SQLSubqueryTableSource)tableSource;
                                    if (this.lexer.token == Token.LPAREN) {
                                        this.lexer.nextToken();
                                        this.exprParser.names(subQuery.getColumns(), subQuery);
                                        this.accept(Token.RPAREN);
                                    }
                                } else if (tableSource instanceof SQLUnionQueryTableSource) {
                                    SQLUnionQueryTableSource union = (SQLUnionQueryTableSource)tableSource;
                                    if (this.lexer.token == Token.LPAREN) {
                                        this.lexer.nextToken();
                                        this.exprParser.names(union.getColumns(), union);
                                        this.accept(Token.RPAREN);
                                    }
                                } else if (this.lexer.token == Token.LPAREN && tableSource instanceof SQLExprTableSource && (((SQLExprTableSource)tableSource).getExpr() instanceof SQLVariantRefExpr || ((SQLExprTableSource)tableSource).getExpr() instanceof SQLIdentifierExpr)) {
                                    this.lexer.nextToken();
                                    SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
                                    this.exprParser.names(exprTableSource.getColumns(), exprTableSource);
                                    this.accept(Token.RPAREN);
                                }
                                if (this.lexer.token == Token.WHERE) {
                                    return tableSource;
                                }
                                return this.parseTableSourceRest(tableSource);
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block123;
            }
            if (this.identifierEquals("PIVOT") || this.identifierEquals("UNPIVOT")) {
                this.parsePivot(tableSource);
            }
        }
        SQLJoinTableSource.JoinType joinType = null;
        boolean natural = this.lexer.identifierEquals(FnvHash.Constants.NATURAL);
        if (natural) {
            this.lexer.nextToken();
        }
        boolean asof = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.ASOF) && this.dialectFeatureEnabled(DialectFeature.ParserFeature.AsofJoin)) {
            this.lexer.nextToken();
            asof = true;
        }
        if (this.lexer.token == Token.OUTER) {
            Lexer.SavePoint mark = this.lexer.mark();
            String str = this.lexer.stringVal();
            this.lexer.nextToken();
            if (tableSource.getAlias() == null && !this.lexer.identifierEquals(FnvHash.Constants.APPLY)) {
                tableSource.setAlias(str);
            } else {
                this.lexer.reset(mark);
            }
        }
        boolean global = false;
        if (this.dialectFeatureEnabled(DialectFeature.ParserFeature.GlobalJoin) && this.lexer.token == Token.GLOBAL) {
            this.lexer.nextToken();
            global = true;
        }
        if (this.identifierEquals("ARRAY")) {
            this.lexer.nextToken();
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.ARRAY_JOIN;
        }
        switch (this.lexer.token) {
            case LEFT: {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.SEMI)) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.LEFT_SEMI_JOIN;
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ANTI)) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.LEFT_ANTI_JOIN;
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ARRAY)) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.LEFT_ARRAY_JOIN;
                } else if (this.lexer.token == Token.OUTER) {
                    this.lexer.nextToken();
                    joinType = natural ? SQLJoinTableSource.JoinType.NATURAL_LEFT_JOIN : SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
                } else {
                    SQLJoinTableSource.JoinType joinType2 = joinType = natural ? SQLJoinTableSource.JoinType.NATURAL_LEFT_JOIN : SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
                }
                if (this.dialectFeatureEnabled(DialectFeature.ParserFeature.JoinAt) && this.lexer.token == Token.IDENTIFIER && this.lexer.stringVal().startsWith("join@")) {
                    this.lexer.stringVal = this.lexer.stringVal().substring(5);
                    break;
                }
                this.accept(Token.JOIN);
                break;
            }
            case RIGHT: {
                this.lexer.nextToken();
                if (this.lexer.token == Token.OUTER) {
                    this.lexer.nextToken();
                }
                this.accept(Token.JOIN);
                joinType = SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN;
                break;
            }
            case FULL: {
                this.lexer.nextToken();
                if (this.lexer.token == Token.OUTER) {
                    this.lexer.nextToken();
                }
                this.accept(Token.JOIN);
                joinType = SQLJoinTableSource.JoinType.FULL_OUTER_JOIN;
                break;
            }
            case INNER: {
                this.lexer.nextToken();
                this.accept(Token.JOIN);
                joinType = SQLJoinTableSource.JoinType.INNER_JOIN;
                break;
            }
            case JOIN: {
                this.lexer.nextIf(Token.JOIN);
                joinType = natural ? SQLJoinTableSource.JoinType.NATURAL_JOIN : SQLJoinTableSource.JoinType.JOIN;
                break;
            }
            case COMMA: {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.COMMA;
                break;
            }
            case OUTER: {
                this.lexer.nextToken();
                if (!this.lexer.identifierEquals(FnvHash.Constants.APPLY)) break;
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.OUTER_APPLY;
                break;
            }
            case CROSS: {
                this.lexer.nextToken();
                this.accept(Token.JOIN);
                joinType = natural ? SQLJoinTableSource.JoinType.NATURAL_CROSS_JOIN : SQLJoinTableSource.JoinType.CROSS_JOIN;
                break;
            }
            case STRAIGHT_JOIN: 
            case IDENTIFIER: {
                long hash = this.lexer.hashLCase;
                if (hash == FnvHash.Constants.STRAIGHT_JOIN) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.STRAIGHT_JOIN;
                    break;
                }
                if (hash == FnvHash.Constants.STRAIGHT) {
                    this.lexer.nextToken();
                    this.accept(Token.JOIN);
                    joinType = SQLJoinTableSource.JoinType.STRAIGHT_JOIN;
                    break;
                }
                if (hash != FnvHash.Constants.CROSS) break;
                this.lexer.nextToken();
                if (this.lexer.token == Token.JOIN) {
                    this.lexer.nextToken();
                    joinType = natural ? SQLJoinTableSource.JoinType.NATURAL_CROSS_JOIN : SQLJoinTableSource.JoinType.CROSS_JOIN;
                    break;
                }
                if (!this.lexer.identifierEquals(FnvHash.Constants.APPLY)) break;
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.CROSS_APPLY;
                break;
            }
        }
        if (joinType != null) {
            SQLExprTableSource exprTableSource;
            SQLExpr expr;
            SQLJoinTableSource join = new SQLJoinTableSource();
            join.setLeft(tableSource);
            join.setJoinType(joinType);
            join.setGlobal(global);
            if (asof) {
                join.setAsof(true);
            }
            boolean isBrace = false;
            if (SQLJoinTableSource.JoinType.COMMA == joinType && this.lexer.token == Token.LBRACE) {
                this.lexer.nextToken();
                this.acceptIdentifier("OJ");
                isBrace = true;
            }
            this.parseJoinHint(join);
            SQLTableSource rightTableSource = null;
            if (this.lexer.token == Token.LPAREN) {
                SQLSelect select;
                this.lexer.nextToken();
                if (this.lexer.token == Token.SELECT || this.lexer.token == Token.WITH && this.dialectFeatureEnabled(DialectFeature.ParserFeature.JoinRightTableWith) || this.lexer.token == Token.FROM && this.dialectFeatureEnabled(DialectFeature.ParserFeature.JoinRightTableFrom)) {
                    select = this.select();
                    rightTableSource = SQLSubqueryTableSource.fixParenthesized(new SQLSubqueryTableSource(select));
                } else {
                    SQLExprTableSource sqlExprTableSource;
                    rightTableSource = this.parseTableSource();
                    if (rightTableSource instanceof SQLExprTableSource && (sqlExprTableSource = (SQLExprTableSource)rightTableSource).getExpr() instanceof SQLQueryExpr) {
                        expr = (SQLQueryExpr)sqlExprTableSource.getExpr();
                        ((SQLExprImpl)expr).setParenthesized(true);
                    }
                }
                if (this.lexer.token == Token.UNION || this.lexer.token == Token.EXCEPT || this.lexer.token == Token.MINUS || this.lexer.token == Token.INTERSECT) {
                    if (rightTableSource instanceof SQLSubqueryTableSource) {
                        select = ((SQLSubqueryTableSource)rightTableSource).getSelect();
                        SQLSelectQuery query = this.queryRest(select.getQuery(), true);
                        select.setQuery(query);
                    } else if (rightTableSource instanceof SQLUnionQueryTableSource) {
                        SQLUnionQueryTableSource unionTableSrc = (SQLUnionQueryTableSource)rightTableSource;
                        unionTableSrc.setUnion((SQLUnionQuery)this.queryRest(unionTableSrc.getUnion()));
                    }
                }
                this.accept(Token.RPAREN);
                if (rightTableSource instanceof SQLValuesTableSource && (this.lexer.token == Token.AS || this.lexer.token == Token.IDENTIFIER) && rightTableSource.getAlias() == null && ((SQLValuesTableSource)rightTableSource).getColumns().isEmpty()) {
                    if (this.lexer.token == Token.AS) {
                        this.lexer.nextToken();
                    }
                    rightTableSource.setAlias(this.tableAlias(true));
                    if (this.lexer.token == Token.LPAREN) {
                        this.lexer.nextToken();
                        this.exprParser.names(((SQLValuesTableSource)rightTableSource).getColumns(), rightTableSource);
                        this.accept(Token.RPAREN);
                    }
                }
            } else {
                if (this.lexer.token == Token.VALUES) {
                    rightTableSource = this.parseValues();
                } else {
                    SQLTableSource unnestTableSource = this.parseUnnestTableSource();
                    if (unnestTableSource != null) {
                        rightTableSource = this.lexer.identifierEquals(FnvHash.Constants.CROSS) || this.lexer.token == Token.CROSS || this.lexer.token == Token.LEFT || this.lexer.token == Token.RIGHT || this.lexer.token == Token.COMMA || this.lexer.token == Token.INNER || this.lexer.token == Token.JOIN || this.lexer.token == Token.FULL ? unnestTableSource : this.parseTableSourceRest(unnestTableSource);
                    }
                }
                if (rightTableSource == null) {
                    boolean aliasToken = this.lexer.token == Token.LITERAL_ALIAS;
                    switch (this.lexer.token) {
                        case ALL: 
                        case LITERAL_CHARS: 
                        case LITERAL_ALIAS: {
                            expr = this.exprParser.name();
                            break;
                        }
                        default: {
                            expr = this.expr();
                        }
                    }
                    if (aliasToken && expr instanceof SQLCharExpr) {
                        expr = new SQLIdentifierExpr(((SQLCharExpr)expr).getText());
                    }
                    exprTableSource = new SQLExprTableSource(expr);
                    if (expr instanceof SQLMethodInvokeExpr && this.lexer.token == Token.AS) {
                        this.lexer.nextToken();
                        String alias = this.tableAlias(true);
                        exprTableSource.setAlias(alias);
                        if (this.lexer.token == Token.LPAREN) {
                            this.lexer.nextToken();
                            this.exprParser.names(exprTableSource.getColumns(), exprTableSource);
                            this.accept(Token.RPAREN);
                        }
                    }
                    rightTableSource = exprTableSource;
                }
                rightTableSource = this.primaryTableSourceRest(rightTableSource);
            }
            if (this.lexer.token == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                Lexer.SavePoint savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    join.setRight(rightTableSource);
                    this.exprParser.exprList(join.getUsing(), join);
                    this.accept(Token.RPAREN);
                } else if (this.lexer.token == Token.IDENTIFIER) {
                    if (SQLJoinTableSource.JoinType.COMMA.equals((Object)joinType)) {
                        this.lexer.reset(savePoint);
                        join.setRight(rightTableSource);
                        return join;
                    }
                    join.setRight(rightTableSource);
                    this.exprParser.exprList(join.getUsing(), join);
                } else {
                    join.setAlias(this.tableAlias());
                }
            } else if (this.lexer.token == Token.STRAIGHT_JOIN || this.lexer.identifierEquals(FnvHash.Constants.STRAIGHT_JOIN)) {
                this.primaryTableSourceRest(rightTableSource);
            } else if (rightTableSource.getAlias() == null && !(rightTableSource instanceof SQLValuesTableSource)) {
                String tableAlias;
                int line = this.lexer.line;
                if (this.lexer.token == Token.AS) {
                    this.lexer.nextToken();
                    if (this.lexer.token != Token.ON) {
                        if (this.dialectFeatureEnabled(DialectFeature.ParserFeature.JoinRightTableAlias) && rightTableSource instanceof SQLExprTableSource) {
                            exprTableSource = (SQLExprTableSource)rightTableSource;
                            exprTableSource.setNeedAsTokenForAlias(true);
                        }
                        tableAlias = this.tableAlias(true);
                    } else {
                        tableAlias = null;
                    }
                } else {
                    tableAlias = this.tableAlias(false);
                }
                if (tableAlias != null) {
                    rightTableSource.setAlias(tableAlias);
                    if (line + 1 == this.lexer.line && this.lexer.hasComment() && this.lexer.getComments().get(0).startsWith("--")) {
                        rightTableSource.addAfterComment(this.lexer.readAndResetComments());
                    }
                    if (this.lexer.token == Token.LPAREN) {
                        List<SQLName> columns;
                        if (rightTableSource instanceof SQLSubqueryTableSource) {
                            this.lexer.nextToken();
                            columns = ((SQLSubqueryTableSource)rightTableSource).getColumns();
                            this.exprParser.names(columns, rightTableSource);
                            this.accept(Token.RPAREN);
                        } else if (rightTableSource instanceof SQLExprTableSource && ((SQLExprTableSource)rightTableSource).getExpr() instanceof SQLMethodInvokeExpr && (columns = ((SQLExprTableSource)rightTableSource).getColumns()).isEmpty()) {
                            this.lexer.nextToken();
                            this.exprParser.names(columns, rightTableSource);
                            this.accept(Token.RPAREN);
                        }
                    }
                }
                rightTableSource = this.primaryTableSourceRest(rightTableSource);
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    SQLExpr hintExpr = this.expr();
                    SQLExprHint hint = new SQLExprHint(hintExpr);
                    hint.setParent(tableSource);
                    rightTableSource.getHints().add(hint);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            join.setRight(rightTableSource);
            if (!natural && !StringUtils.isEmpty(tableSource.getAlias()) && tableSource.aliasHashCode64() == FnvHash.Constants.NATURAL && this.dialectFeatureEnabled(DialectFeature.ParserFeature.PostNaturalJoin)) {
                tableSource.setAlias(null);
                natural = true;
                if (natural && join.getJoinType() == SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN) {
                    join.setJoinType(SQLJoinTableSource.JoinType.NATURAL_LEFT_JOIN);
                }
                if (natural && join.getJoinType() == SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN) {
                    join.setJoinType(SQLJoinTableSource.JoinType.NATURAL_RIGHT_JOIN);
                }
                if (natural && join.getJoinType() == SQLJoinTableSource.JoinType.INNER_JOIN) {
                    join.setJoinType(SQLJoinTableSource.JoinType.NATURAL_INNER_JOIN);
                }
            }
            join.setNatural(natural);
            if (this.lexer.token == Token.ON) {
                this.lexer.nextToken();
                SQLExpr joinOn = this.expr();
                join.setCondition(joinOn);
                while (this.lexer.token == Token.ON && this.dialectFeatureEnabled(DialectFeature.ParserFeature.MultipleJoinOn)) {
                    this.lexer.nextToken();
                    SQLExpr joinOn2 = this.expr();
                    join.addCondition(joinOn2);
                }
                if (this.dialectFeatureEnabled(DialectFeature.ParserFeature.UDJ) && this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                    SQLJoinTableSource.UDJ udj = new SQLJoinTableSource.UDJ();
                    this.lexer.nextToken();
                    udj.setFunction(this.exprParser.name());
                    this.accept(Token.LPAREN);
                    this.exprParser.exprList(udj.getArguments(), udj);
                    this.accept(Token.RPAREN);
                    if (this.lexer.token != Token.AS) {
                        udj.setAlias(this.alias());
                    }
                    this.accept(Token.AS);
                    this.accept(Token.LPAREN);
                    this.exprParser.names(udj.getColumns(), udj);
                    this.accept(Token.RPAREN);
                    if (this.lexer.identifierEquals(FnvHash.Constants.SORT)) {
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        this.exprParser.orderBy(udj.getSortBy(), udj);
                    }
                    if (this.lexer.token == Token.WITH) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("UDFPROPERTIES");
                        this.exprParser.parseAssignItem(udj.getProperties(), (SQLObject)udj);
                    }
                    join.setUdj(udj);
                }
            } else if (this.lexer.token == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                Lexer.SavePoint savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.exprList(join.getUsing(), join);
                    this.accept(Token.RPAREN);
                } else {
                    this.lexer.reset(savePoint);
                }
            }
            SQLTableSource tableSourceReturn = this.parseTableSourceRest(join);
            if (isBrace) {
                this.accept(Token.RBRACE);
            }
            return this.parseTableSourceRest(tableSourceReturn);
        }
        if ((tableSource.aliasHashCode64() == FnvHash.Constants.LATERAL || this.lexer.token == Token.LATERAL) && this.lexer.token() == Token.VIEW) {
            return this.parseLateralView(tableSource);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LATERAL) || this.lexer.token == Token.LATERAL) {
            this.lexer.nextToken();
            return this.parseLateralView(tableSource);
        }
        this.parseAfterTableSourceRest(tableSource);
        return tableSource;
    }

    public void parseAfterTableSourceRest(SQLTableSource tableSource) {
    }

    public SQLExpr expr() {
        return this.exprParser.expr();
    }

    public SQLOrderBy parseOrderBy() {
        return this.exprParser.parseOrderBy();
    }

    public void acceptKeyword(String ident) {
        if (this.lexer.token != Token.IDENTIFIER || !ident.equalsIgnoreCase(this.lexer.stringVal())) {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, expect " + ident + ", actual " + (Object)((Object)this.lexer.token) + ", " + this.lexer.info());
        }
        this.lexer.nextToken();
    }

    public void parseFetchClause(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            queryBlock.setLimit(limit);
            this.afterParseLimitClause(queryBlock);
            this.afterParseFetchClause(queryBlock);
            return;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.OFFSET) || this.lexer.token == Token.OFFSET) {
            this.lexer.nextToken();
            SQLExpr offset = this.exprParser.expr();
            queryBlock.setOffset(offset);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW) || this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token == Token.FETCH) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.FIRST || this.lexer.token == Token.NEXT || this.lexer.identifierEquals(FnvHash.Constants.NEXT)) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("FIRST");
            }
            SQLExpr first = this.exprParser.primary();
            queryBlock.setFirst(first);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW) || this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.ONLY) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("ONLY");
            }
        }
        this.afterParseFetchClause(queryBlock);
    }

    protected void parseHierachical(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.CONNECT || this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                this.lexer.nextToken();
                queryBlock.setPrior(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCYCLE)) {
                queryBlock.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token == Token.PRIOR) {
                    this.lexer.nextToken();
                    queryBlock.setPrior(true);
                }
            }
            queryBlock.setConnectBy(this.exprParser.expr());
        }
        if (this.lexer.token == Token.START || this.lexer.identifierEquals(FnvHash.Constants.START)) {
            this.lexer.nextToken();
            this.accept(Token.WITH);
            queryBlock.setStartWith(this.exprParser.expr());
        }
        if (this.lexer.token == Token.CONNECT || this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                this.lexer.nextToken();
                queryBlock.setPrior(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCYCLE)) {
                queryBlock.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                    this.lexer.nextToken();
                    queryBlock.setPrior(true);
                }
            }
            queryBlock.setConnectBy(this.exprParser.expr());
        }
    }

    protected SQLTableSource parseLateralView(SQLTableSource tableSource) {
        this.accept(Token.VIEW);
        if (tableSource != null && "LATERAL".equalsIgnoreCase(tableSource.getAlias())) {
            tableSource.setAlias(null);
        }
        SQLLateralViewTableSource lateralViewTabSrc = new SQLLateralViewTableSource();
        lateralViewTabSrc.setTableSource(tableSource);
        if (this.lexer.token == Token.OUTER) {
            lateralViewTabSrc.setOuter(true);
            this.lexer.nextToken();
        }
        SQLMethodInvokeExpr udtf = (SQLMethodInvokeExpr)this.exprParser.primary();
        lateralViewTabSrc.setMethod(udtf);
        String alias = null;
        if (this.lexer.token != Token.AS) {
            alias = this.alias();
        }
        if (alias != null) {
            lateralViewTabSrc.setAlias(alias);
        }
        if (this.lexer.token == Token.AS) {
            this.parseLateralViewAs(lateralViewTabSrc);
        }
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            lateralViewTabSrc.setOn(this.exprParser.expr());
        }
        return this.parseTableSourceRest(lateralViewTabSrc);
    }

    public void parseLateralViewAs(SQLLateralViewTableSource lateralViewTabSrc) {
        block4: {
            this.accept(Token.AS);
            Lexer.SavePoint mark = null;
            do {
                SQLName name;
                if (this.lexer.token == Token.NULL) {
                    name = new SQLIdentifierExpr(this.lexer.stringVal());
                    this.lexer.nextToken();
                } else {
                    name = this.exprParser.name();
                    if (name instanceof SQLPropertyExpr) {
                        this.lexer.reset(mark);
                        break block4;
                    }
                }
                name.setParent(lateralViewTabSrc);
                lateralViewTabSrc.getColumns().add(name);
                if (this.lexer.token != Token.COMMA) break block4;
                mark = this.lexer.mark();
                this.lexer.nextToken();
            } while (this.lexer.token != Token.LPAREN);
            this.lexer.reset(mark);
        }
    }

    public SQLValuesTableSource parseValues() {
        SQLValuesTableSource tableSource = new SQLValuesTableSource();
        this.lexer.computeRowAndColumn(tableSource);
        this.accept(Token.VALUES);
        while (true) {
            boolean isSingleValue = true;
            if (this.lexer.token == Token.ROW) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
                isSingleValue = false;
            }
            SQLListExpr listExpr = new SQLListExpr();
            if (isSingleValue) {
                SQLExpr expr = this.expr();
                expr.setParent(listExpr);
                listExpr.getItems().add(expr);
            } else {
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
            }
            listExpr.setParent(tableSource);
            tableSource.getValues().add(listExpr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        String alias = this.tableAlias();
        if (alias != null) {
            tableSource.setAlias(alias);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.names(tableSource.getColumns(), tableSource);
            this.accept(Token.RPAREN);
        }
        return tableSource;
    }

    protected void parsePivotIn(SQLObjectImpl parent, List<SQLSelectItem> items) {
        while (true) {
            String name;
            SQLSelectItem item = new SQLSelectItem();
            SQLExpr expr = this.exprParser.expr();
            if (expr instanceof SQLIdentifierExpr && (name = ((SQLIdentifierExpr)expr).getName()).length() > 1 && SQLUtils.isQuoteChar(name.charAt(0)) && name.charAt(name.length() - 1) == name.charAt(0)) {
                expr = new SQLCharExpr(SQLUtils.removeQuote(name));
            }
            item.setExpr(expr);
            item.setAlias(this.as());
            item.setParent(parent);
            items.add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    protected void parsePivot(SQLTableSource tableSource) {
        if (this.lexer.identifierEquals(FnvHash.Constants.PIVOT)) {
            SQLSelectItem item;
            this.lexer.nextToken();
            SQLPivot pivot = new SQLPivot();
            if (this.lexer.identifierEquals("XML")) {
                this.lexer.nextToken();
                pivot.setXml(true);
            }
            this.accept(Token.LPAREN);
            while (true) {
                item = new SQLSelectItem();
                item.setExpr(this.exprParser.expr());
                item.setAlias(this.as());
                pivot.addItem(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.FOR);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    pivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else {
                pivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            if (this.lexer.token() == Token.SELECT) {
                SQLExpr expr = this.exprParser.expr();
                item = new SQLSelectItem();
                item.setExpr(expr);
                item.setParent(pivot);
                pivot.getPivotIn().add(item);
            } else {
                this.parsePivotIn(pivot, pivot.getPivotIn());
            }
            this.accept(Token.RPAREN);
            this.accept(Token.RPAREN);
            tableSource.setPivot(pivot);
        } else if (this.lexer.identifierEquals("UNPIVOT")) {
            this.lexer.nextToken();
            SQLUnpivot unPivot = new SQLUnpivot();
            if (this.lexer.identifierEquals("INCLUDE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("NULLS");
                unPivot.setNullsIncludeType(SQLUnpivot.NullsIncludeType.INCLUDE_NULLS);
            } else if (this.lexer.identifierEquals("EXCLUDE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("NULLS");
                unPivot.setNullsIncludeType(SQLUnpivot.NullsIncludeType.EXCLUDE_NULLS);
            }
            this.accept(Token.LPAREN);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.exprList(unPivot.getItems(), unPivot);
                this.accept(Token.RPAREN);
            } else {
                unPivot.addItem(this.exprParser.expr());
            }
            this.accept(Token.FOR);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    unPivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else {
                unPivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            if (this.lexer.token() == Token.SELECT) {
                throw new ParserException("TODO. " + this.lexer.info());
            }
            this.parsePivotIn(unPivot, unPivot.getPivotIn());
            this.accept(Token.RPAREN);
            this.accept(Token.RPAREN);
            tableSource.setUnpivot(unPivot);
        }
    }
}

