/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLAliasedExpr
extends SQLObjectImpl
implements SQLReplaceable {
    protected SQLExpr expr;
    protected String alias;

    public SQLAliasedExpr() {
    }

    public SQLAliasedExpr(SQLExpr expr, String alias) {
        this.setExpr(expr);
        this.alias = alias;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this) && this.expr != null) {
            this.expr.accept(v);
        }
        v.endVisit(this);
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.expr == expr) {
            this.setExpr(target);
            return true;
        }
        return false;
    }

    public String computeAlias() {
        String alias = this.getAlias();
        if (alias == null) {
            if (this.expr instanceof SQLIdentifierExpr) {
                alias = ((SQLIdentifierExpr)this.expr).getName();
            } else if (this.expr instanceof SQLPropertyExpr) {
                alias = ((SQLPropertyExpr)this.expr).getName();
            }
        }
        return SQLUtils.normalize(alias);
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.expr == null) {
            return null;
        }
        return this.expr.computeDataType();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAlias2() {
        if (this.alias == null || this.alias.length() == 0) {
            return this.alias;
        }
        char first = this.alias.charAt(0);
        if (first == '\"' || first == '\'') {
            char[] chars = new char[this.alias.length() - 2];
            int len = 0;
            for (int i = 1; i < this.alias.length() - 1; ++i) {
                char ch = this.alias.charAt(i);
                if (ch == '\\') {
                    ch = this.alias.charAt(++i);
                }
                chars[len++] = ch;
            }
            return new String(chars, 0, len);
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public SQLAliasedExpr clone() {
        SQLAliasedExpr x = new SQLAliasedExpr();
        this.cloneTo(x);
        return x;
    }

    protected void cloneTo(SQLAliasedExpr x) {
        super.cloneTo(x);
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        x.setAlias(this.alias);
    }
}

