/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm.internal;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.internal.InetAddressCacheUtilCommons;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InetAddressCacheUtilForOld {
    private static volatile Constructor<?> constructorOfInetAddress$CacheEntry = null;
    private static volatile Field cacheMapFieldOfInetAddress$Cache = null;
    private static volatile Object[] ADDRESS_CACHE_AND_NEGATIVE_CACHE = null;
    private static volatile Field expirationFieldOfInetAddress$CacheEntry = null;
    private static volatile Field addressesFieldOfInetAddress$CacheEntry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInetAddressCache(String host, String[] ips, long expireMillis) throws UnknownHostException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        host = host.toLowerCase();
        long expiration = expireMillis == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + expireMillis;
        Object entry = InetAddressCacheUtilForOld.newCacheEntry(host, ips, expiration);
        Object object = InetAddressCacheUtilForOld.getAddressCacheOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtilForOld.getCache().put(host, entry);
            InetAddressCacheUtilForOld.getNegativeCache().remove(host);
        }
    }

    private static Object newCacheEntry(String host, String[] ips, long expiration) throws UnknownHostException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return InetAddressCacheUtilForOld.getConstructorOfInetAddress$CacheEntry().newInstance(InetAddressCacheUtilCommons.toInetAddressArray(host, ips), expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Constructor<?> getConstructorOfInetAddress$CacheEntry() throws ClassNotFoundException {
        if (constructorOfInetAddress$CacheEntry != null) {
            return constructorOfInetAddress$CacheEntry;
        }
        Class<InetAddressCacheUtilCommons> clazz = InetAddressCacheUtilCommons.class;
        synchronized (InetAddressCacheUtilCommons.class) {
            if (constructorOfInetAddress$CacheEntry != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return constructorOfInetAddress$CacheEntry;
            }
            String className = "java.net.InetAddress$CacheEntry";
            Class<?> clazz2 = Class.forName("java.net.InetAddress$CacheEntry");
            Constructor<?> constructor = clazz2.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            constructorOfInetAddress$CacheEntry = constructor;
            // ** MonitorExit[var0] (shouldn't be in output)
            return constructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        host = host.toLowerCase();
        Object object = InetAddressCacheUtilForOld.getAddressCacheOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtilForOld.getCache().remove(host);
            InetAddressCacheUtilForOld.getNegativeCache().remove(host);
        }
    }

    @GuardedBy(value="getAddressCacheOfInetAddress()")
    private static Map<String, Object> getCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        return InetAddressCacheUtilForOld.getCacheOfInetAddress$Cache0(InetAddressCacheUtilForOld.getAddressCacheOfInetAddress());
    }

    @GuardedBy(value="getAddressCacheOfInetAddress()")
    private static Map<String, Object> getNegativeCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        return InetAddressCacheUtilForOld.getCacheOfInetAddress$Cache0(InetAddressCacheUtilForOld.getNegativeCacheOfInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Object> getCacheOfInetAddress$Cache0(Object inetAddressCache) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        if (cacheMapFieldOfInetAddress$Cache != null) return (Map)cacheMapFieldOfInetAddress$Cache.get(inetAddressCache);
        Class<InetAddressCacheUtilForOld> clazz = InetAddressCacheUtilForOld.class;
        synchronized (InetAddressCacheUtilForOld.class) {
            if (cacheMapFieldOfInetAddress$Cache != null) return (Map)cacheMapFieldOfInetAddress$Cache.get(inetAddressCache);
            Class<?> clazz2 = Class.forName("java.net.InetAddress$Cache");
            Field f = clazz2.getDeclaredField("cache");
            f.setAccessible(true);
            cacheMapFieldOfInetAddress$Cache = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Map)cacheMapFieldOfInetAddress$Cache.get(inetAddressCache);
        }
    }

    private static Object getAddressCacheOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtilForOld.getAddressCacheAndNegativeCacheOfInetAddress0()[0];
    }

    private static Object getNegativeCacheOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtilForOld.getAddressCacheAndNegativeCacheOfInetAddress0()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getAddressCacheAndNegativeCacheOfInetAddress0() throws NoSuchFieldException, IllegalAccessException {
        if (ADDRESS_CACHE_AND_NEGATIVE_CACHE != null) {
            return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
        }
        Class<InetAddressCacheUtilForOld> clazz = InetAddressCacheUtilForOld.class;
        synchronized (InetAddressCacheUtilForOld.class) {
            if (ADDRESS_CACHE_AND_NEGATIVE_CACHE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
            }
            Field cacheField = InetAddress.class.getDeclaredField("addressCache");
            cacheField.setAccessible(true);
            Field negativeCacheField = InetAddress.class.getDeclaredField("negativeCache");
            negativeCacheField.setAccessible(true);
            ADDRESS_CACHE_AND_NEGATIVE_CACHE = new Object[]{cacheField.get(InetAddress.class), negativeCacheField.get(InetAddress.class)};
            // ** MonitorExit[var0] (shouldn't be in output)
            return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DnsCacheEntry getInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Object cacheEntry;
        host = host.toLowerCase();
        Object object = InetAddressCacheUtilForOld.getAddressCacheOfInetAddress();
        synchronized (object) {
            cacheEntry = InetAddressCacheUtilForOld.getCache().get(host);
        }
        if (null == cacheEntry) {
            return null;
        }
        DnsCacheEntry dnsCacheEntry = InetAddressCacheUtilForOld.inetAddress$CacheEntry2DnsCacheEntry(host, cacheEntry);
        if (InetAddressCacheUtilForOld.isDnsCacheEntryExpired(dnsCacheEntry.getHost())) {
            return null;
        }
        return dnsCacheEntry;
    }

    private static boolean isDnsCacheEntryExpired(@Nullable String host) {
        return null == host || "0.0.0.0".equals(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DnsCache listInetAddressCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        HashMap<String, Object> negativeCache;
        HashMap<String, Object> cache;
        Object object = InetAddressCacheUtilForOld.getAddressCacheOfInetAddress();
        synchronized (object) {
            cache = new HashMap<String, Object>(InetAddressCacheUtilForOld.getCache());
            negativeCache = new HashMap<String, Object>(InetAddressCacheUtilForOld.getNegativeCache());
        }
        return new DnsCache(InetAddressCacheUtilForOld.convert(cache), InetAddressCacheUtilForOld.convert(negativeCache));
    }

    private static List<DnsCacheEntry> convert(Map<String, Object> cache) throws IllegalAccessException, ClassNotFoundException, NoSuchFieldException {
        ArrayList<DnsCacheEntry> ret = new ArrayList<DnsCacheEntry>();
        for (Map.Entry<String, Object> entry : cache.entrySet()) {
            String host = entry.getKey();
            if (InetAddressCacheUtilForOld.isDnsCacheEntryExpired(host)) continue;
            ret.add(InetAddressCacheUtilForOld.inetAddress$CacheEntry2DnsCacheEntry(host, entry.getValue()));
        }
        return ret;
    }

    private static DnsCacheEntry inetAddress$CacheEntry2DnsCacheEntry(String host, Object entry) throws IllegalAccessException, ClassNotFoundException, NoSuchFieldException {
        InetAddressCacheUtilForOld.initFieldsOfInetAddress$CacheEntry();
        long expiration = expirationFieldOfInetAddress$CacheEntry.getLong(entry);
        InetAddress[] addresses = (InetAddress[])addressesFieldOfInetAddress$CacheEntry.get(entry);
        String[] ips = InetAddressCacheUtilCommons.getIpFromInetAddress(addresses);
        return new DnsCacheEntry(host, ips, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFieldsOfInetAddress$CacheEntry() throws ClassNotFoundException, NoSuchFieldException {
        if (expirationFieldOfInetAddress$CacheEntry != null && addressesFieldOfInetAddress$CacheEntry != null) {
            return;
        }
        Class<InetAddressCacheUtilForOld> clazz = InetAddressCacheUtilForOld.class;
        synchronized (InetAddressCacheUtilForOld.class) {
            Class<?> cacheEntryClass = Class.forName("java.net.InetAddress$CacheEntry");
            if (expirationFieldOfInetAddress$CacheEntry != null && addressesFieldOfInetAddress$CacheEntry != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Field expirationField = cacheEntryClass.getDeclaredField("expiration");
            expirationField.setAccessible(true);
            expirationFieldOfInetAddress$CacheEntry = expirationField;
            Field addressesField = cacheEntryClass.getDeclaredField("addresses");
            addressesField.setAccessible(true);
            addressesFieldOfInetAddress$CacheEntry = addressesField;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInetAddressCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Object object = InetAddressCacheUtilForOld.getAddressCacheOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtilForOld.getCache().clear();
            InetAddressCacheUtilForOld.getNegativeCache().clear();
        }
    }

    private InetAddressCacheUtilForOld() {
    }
}

