/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.audio.omni.OmniRealtimeCallback;
import com.alibaba.dashscope.audio.omni.OmniRealtimeConfig;
import com.alibaba.dashscope.audio.omni.OmniRealtimeConversation;
import com.alibaba.dashscope.audio.omni.OmniRealtimeModality;
import com.alibaba.dashscope.audio.omni.OmniRealtimeParam;
import com.alibaba.dashscope.audio.omni.OmniRealtimeTranscriptionParam;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.LineUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Qwen3AsrRealtimeUsage {
    private static final Logger log = LoggerFactory.getLogger(Qwen3AsrRealtimeUsage.class);
    private static final int AUDIO_CHUNK_SIZE = 1024;
    private static final int SLEEP_INTERVAL_MS = 30;

    public static void main(String[] args) throws InterruptedException, LineUnavailableException {
        Object param = ((OmniRealtimeParam.OmniRealtimeParamBuilder)((OmniRealtimeParam.OmniRealtimeParamBuilder)OmniRealtimeParam.builder().model("qwen3-asr-flash-realtime")).apikey(System.getenv("DASHSCOPE_API_KEY"))).build();
        OmniRealtimeConversation conversation = null;
        final AtomicReference<Object> conversationRef = new AtomicReference<Object>(null);
        conversation = new OmniRealtimeConversation((OmniRealtimeParam)param, new OmniRealtimeCallback(){

            @Override
            public void onOpen() {
                System.out.println("connection opened");
            }

            @Override
            public void onEvent(JsonObject message) {
                String type;
                switch (type = message.get("type").getAsString()) {
                    case "session.created": {
                        System.out.println("start session: " + message.get("session").getAsJsonObject().get("id").getAsString());
                        break;
                    }
                    case "conversation.item.input_audio_transcription.completed": {
                        System.out.println("question: " + message.get("transcript").getAsString());
                        break;
                    }
                    case "response.audio_transcript.delta": {
                        System.out.println("got llm response delta: " + message.get("delta").getAsString());
                        break;
                    }
                    case "input_audio_buffer.speech_started": {
                        System.out.println("======VAD Speech Start======");
                        break;
                    }
                    case "input_audio_buffer.speech_stopped": {
                        System.out.println("======VAD Speech Stop======");
                        break;
                    }
                    case "response.done": {
                        System.out.println("======RESPONSE DONE======");
                        if (conversationRef.get() == null) break;
                        System.out.println("[Metric] response: " + ((OmniRealtimeConversation)((Object)conversationRef.get())).getResponseId() + ", first text delay: " + ((OmniRealtimeConversation)((Object)conversationRef.get())).getFirstTextDelay() + " ms, first audio delay: " + ((OmniRealtimeConversation)((Object)conversationRef.get())).getFirstAudioDelay() + " ms");
                        break;
                    }
                }
            }

            @Override
            public void onClose(int code, String reason) {
                System.out.println("connection closed code: " + code + ", reason: " + reason);
            }
        });
        conversationRef.set(conversation);
        try {
            conversation.connect();
        }
        catch (NoApiKeyException e) {
            throw new RuntimeException(e);
        }
        OmniRealtimeTranscriptionParam transcriptionParam = new OmniRealtimeTranscriptionParam();
        transcriptionParam.setLanguage("zh");
        transcriptionParam.setInputAudioFormat("pcm");
        transcriptionParam.setInputSampleRate(16000);
        transcriptionParam.setCorpusText("\u8fd9\u662f\u4e00\u6bb5\u8131\u53e3\u79c0\u8868\u6f14");
        Object config = ((OmniRealtimeConfig.OmniRealtimeConfigBuilder)((OmniRealtimeConfig.OmniRealtimeConfigBuilder)OmniRealtimeConfig.builder().modalities(Collections.singletonList(OmniRealtimeModality.TEXT))).transcriptionConfig(transcriptionParam)).build();
        conversation.updateSession((OmniRealtimeConfig)config);
        String filePath = "./path/to/your/audio/16k-16bit-mono-file.pcm";
        File audioFile = new File(filePath);
        if (!audioFile.exists()) {
            log.error("Audio file not found: {}", (Object)filePath);
            return;
        }
        try (FileInputStream audioInputStream = new FileInputStream(audioFile);){
            int bytesRead;
            byte[] audioBuffer = new byte[1024];
            int totalBytesRead = 0;
            log.info("Starting to send audio data from: {}", (Object)filePath);
            while ((bytesRead = audioInputStream.read(audioBuffer)) != -1) {
                totalBytesRead += bytesRead;
                String audioB64 = Base64.getEncoder().encodeToString(audioBuffer);
                conversation.appendAudio(audioB64);
                Thread.sleep(30L);
            }
            log.info("Finished sending audio data. Total bytes sent: {}", (Object)totalBytesRead);
        }
        catch (Exception e) {
            log.error("Error sending audio from file: {}", (Object)filePath, (Object)e);
        }
        conversation.commit();
        conversation.createResponse(null, null);
        conversation.close(1000, "bye");
        System.exit(0);
    }
}

