/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MessageAdapter
extends TypeAdapter<Message> {
    public void write(JsonWriter out, Message value) throws IOException {
        out.beginObject();
        out.name("role");
        out.value(value.getRole());
        out.name("content");
        out.value(value.getContent());
        if (value.getToolCalls() != null) {
            out.name("tool_calls").beginArray();
            for (ToolCallBase toolCall : value.getToolCalls()) {
                out.beginObject();
                String type = toolCall.getType();
                out.name("type");
                out.value(type);
                out.name("id");
                out.value(toolCall.getId());
                out.name("function");
                if (type.equals("function")) {
                    this.writeCallFunction(out, (ToolCallFunction)toolCall);
                }
                out.endObject();
            }
            out.endArray();
        }
        out.endObject();
    }

    private void writeCallFunction(JsonWriter out, ToolCallFunction toolCall) throws IOException {
        out.beginObject();
        ToolCallFunction.CallFunction callFunction = toolCall.getFunction();
        out.name("name");
        out.value(callFunction.getName());
        out.name("arguments");
        out.value(callFunction.getArguments());
        out.endObject();
    }

    private ToolCallFunction convertToCallFunction(LinkedTreeMap<String, Object> toolCall) {
        Object functionCall = ToolCallFunction.builder().build();
        if (toolCall.containsKey((Object)"function")) {
            ToolCallFunction.CallFunction callFunction = (ToolCallFunction)functionCall.new ToolCallFunction.CallFunction();
            LinkedTreeMap fc = (LinkedTreeMap)toolCall.get((Object)"function");
            if (fc.containsKey((Object)"name")) {
                callFunction.setName(fc.get((Object)"name").toString());
            }
            if (fc.containsKey((Object)"arguments")) {
                callFunction.setArguments(fc.get((Object)"arguments").toString());
            }
            ((ToolCallFunction)functionCall).setFunction(callFunction);
        }
        ((ToolCallFunction)functionCall).setType(toolCall.get((Object)"type").toString());
        if (toolCall.containsKey((Object)"id")) {
            ((ToolCallFunction)functionCall).setId(toolCall.get((Object)"id").toString());
        }
        return functionCall;
    }

    public Message read(JsonReader in) throws IOException {
        Map objectMap = (Map)JsonUtils.gson.fromJson(in, Map.class);
        Message msg = new Message();
        if (objectMap.containsKey("role")) {
            msg.setRole((String)objectMap.get("role"));
            objectMap.remove("role");
        }
        if (objectMap.containsKey("content")) {
            msg.setContent((String)objectMap.get("content"));
            objectMap.remove("content");
        }
        if (objectMap.containsKey("tool_calls")) {
            msg.toolCalls = new ArrayList<ToolCallBase>();
            for (LinkedTreeMap toolCall : (List)objectMap.get("tool_calls")) {
                String type = toolCall.get((Object)"type").toString();
                if (!type.equals("function")) continue;
                msg.toolCalls.add(this.convertToCallFunction((LinkedTreeMap<String, Object>)toolCall));
            }
            objectMap.remove("tool_calls");
        }
        return msg;
    }
}

