/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.parser.markdown;

import com.alibaba.cloud.ai.document.DocumentParser;
import com.alibaba.cloud.ai.parser.markdown.config.MarkdownDocumentParserConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.springframework.ai.document.Document;

public class MarkdownDocumentParser
implements DocumentParser {
    private final MarkdownDocumentParserConfig config;
    private final Parser parser;

    public MarkdownDocumentParser() {
        this(MarkdownDocumentParserConfig.defaultConfig());
    }

    public MarkdownDocumentParser(MarkdownDocumentParserConfig config) {
        this.config = config;
        this.parser = Parser.builder().build();
    }

    public List<org.springframework.ai.document.Document> parse(InputStream inputStream) {
        List<org.springframework.ai.document.Document> list;
        block8: {
            InputStream input = inputStream;
            try {
                Node node = this.parser.parseReader((Reader)new InputStreamReader(input));
                DocumentVisitor documentVisitor = new DocumentVisitor(this.config);
                node.accept((Visitor)documentVisitor);
                list = documentVisitor.getDocuments();
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return list;
    }

    static class DocumentVisitor
    extends AbstractVisitor {
        private final List<org.springframework.ai.document.Document> documents = new ArrayList<org.springframework.ai.document.Document>();
        private final List<String> currentParagraphs = new ArrayList<String>();
        private final MarkdownDocumentParserConfig config;
        private Document.Builder currentDocumentBuilder;

        DocumentVisitor(MarkdownDocumentParserConfig config) {
            this.config = config;
        }

        public void visit(Document document) {
            this.currentDocumentBuilder = org.springframework.ai.document.Document.builder();
            super.visit(document);
        }

        public void visit(Heading heading) {
            this.buildAndFlush();
            super.visit(heading);
        }

        public void visit(ThematicBreak thematicBreak) {
            if (this.config.horizontalRuleCreateDocument) {
                this.buildAndFlush();
            }
            super.visit(thematicBreak);
        }

        public void visit(SoftLineBreak softLineBreak) {
            this.translateLineBreakToSpace();
            super.visit(softLineBreak);
        }

        public void visit(HardLineBreak hardLineBreak) {
            this.translateLineBreakToSpace();
            super.visit(hardLineBreak);
        }

        public void visit(ListItem listItem) {
            this.translateLineBreakToSpace();
            super.visit(listItem);
        }

        public void visit(BlockQuote blockQuote) {
            if (!this.config.includeBlockquote) {
                this.buildAndFlush();
            }
            this.translateLineBreakToSpace();
            this.currentDocumentBuilder.metadata("category", (Object)"blockquote");
            super.visit(blockQuote);
        }

        public void visit(Code code) {
            this.currentParagraphs.add(code.getLiteral());
            this.currentDocumentBuilder.metadata("category", (Object)"code_inline");
            super.visit(code);
        }

        public void visit(FencedCodeBlock fencedCodeBlock) {
            if (!this.config.includeCodeBlock) {
                this.buildAndFlush();
            }
            this.translateLineBreakToSpace();
            this.currentParagraphs.add(fencedCodeBlock.getLiteral());
            this.currentDocumentBuilder.metadata("category", (Object)"code_block");
            this.currentDocumentBuilder.metadata("lang", (Object)fencedCodeBlock.getInfo());
            this.buildAndFlush();
            super.visit(fencedCodeBlock);
        }

        public void visit(Text text) {
            Node node = text.getParent();
            if (node instanceof Heading) {
                Heading heading = (Heading)node;
                this.currentDocumentBuilder.metadata("category", (Object)"header_%d".formatted(heading.getLevel())).metadata("title", (Object)text.getLiteral());
            } else {
                this.currentParagraphs.add(text.getLiteral());
            }
            super.visit(text);
        }

        public List<org.springframework.ai.document.Document> getDocuments() {
            this.buildAndFlush();
            return this.documents;
        }

        private void buildAndFlush() {
            if (!this.currentParagraphs.isEmpty()) {
                String content = String.join((CharSequence)"", this.currentParagraphs);
                Document.Builder builder = this.currentDocumentBuilder.text(content);
                this.config.additionalMetadata.forEach((arg_0, arg_1) -> ((Document.Builder)builder).metadata(arg_0, arg_1));
                org.springframework.ai.document.Document document = builder.build();
                this.documents.add(document);
                this.currentParagraphs.clear();
            }
            this.currentDocumentBuilder = org.springframework.ai.document.Document.builder();
        }

        private void translateLineBreakToSpace() {
            if (!this.currentParagraphs.isEmpty()) {
                this.currentParagraphs.add(" ");
            }
        }
    }
}

