/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm;

import com.alibaba.bytekit.asm.InliningAdapter;
import com.alibaba.deps.org.objectweb.asm.Label;
import com.alibaba.deps.org.objectweb.asm.MethodVisitor;
import com.alibaba.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.alibaba.deps.org.objectweb.asm.commons.LocalVariablesSorter;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import java.util.ArrayList;
import java.util.List;

public abstract class MethodCallInliner
extends GeneratorAdapter {
    private final MethodNode toBeInlined;
    private List<CatchBlock> blocks = new ArrayList<CatchBlock>();
    private boolean inlining;
    private boolean afterInlining;

    public MethodCallInliner(int access, String name, String desc, MethodVisitor mv, MethodNode toBeInlined) {
        super(589824, mv, access, name, desc);
        this.toBeInlined = toBeInlined;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.shouldBeInlined(owner, name, desc)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Label end = new Label();
        this.inlining = true;
        this.toBeInlined.instructions.resetLabels();
        this.toBeInlined.accept((MethodVisitor)new InliningAdapter((LocalVariablesSorter)this, this.toBeInlined.access, this.toBeInlined.desc, end));
        this.inlining = false;
        this.afterInlining = true;
        super.visitLabel(end);
    }

    abstract boolean shouldBeInlined(String var1, String var2, String var3);

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (!this.inlining) {
            this.blocks.add(new CatchBlock(start, end, handler, type));
        } else {
            super.visitTryCatchBlock(start, end, handler, type);
        }
    }

    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public class CatchBlock {
        private Label start;
        private Label handler;
        private String type;
        private Label end;

        public CatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

