/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.matcher;

import com.alibaba.bytekit.asm.matcher.ClassMatcher;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SimpleSubclassMatcher
implements ClassMatcher {
    Set<String> classNames = new HashSet<String>();

    public SimpleSubclassMatcher(String ... className) {
        for (String name : className) {
            this.classNames.add(name);
        }
    }

    public SimpleSubclassMatcher(Collection<String> names) {
        this.classNames.addAll(names);
    }

    @Override
    public boolean match(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        loader = ClassLoaderUtils.wrap(loader);
        if (classBeingRedefined != null) {
            return this.match(classBeingRedefined);
        }
        ClassReader reader = new ClassReader(classfileBuffer);
        String clazzName = reader.getClassName();
        String superName = reader.getSuperName();
        if (this.classNames != null && this.classNames.contains(clazzName.replace('/', '.'))) {
            return true;
        }
        if (!superName.equals("java/lang/Object")) {
            if (this.classNames.contains(superName)) {
                return true;
            }
            try {
                Class<?> superClass = loader.loadClass(superName.replace('/', '.'));
                return this.match(superClass);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private boolean match(Class<?> clazz) {
        Class<?> superclass = clazz;
        while (superclass != null && !Object.class.equals(superclass)) {
            if (this.classNames != null && this.classNames.contains(superclass.getName().replace('/', '.'))) {
                return true;
            }
            superclass = superclass.getSuperclass();
        }
        return false;
    }
}

