/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm;

import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.alibaba.deps.org.objectweb.asm.ClassWriter;

public class ClassLoaderAwareClassWriter
extends ClassWriter {
    private ClassLoader classLoader;

    public ClassLoaderAwareClassWriter(int flags, ClassLoader loader) {
        this(null, flags, loader);
    }

    public ClassLoaderAwareClassWriter(ClassReader classReader, int flags, ClassLoader loader) {
        super(classReader, flags);
        this.classLoader = loader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> d;
        Class<?> c;
        if (this.classLoader == null) {
            return super.getCommonSuperClass(type1, type2);
        }
        try {
            c = Class.forName(type1.replace('/', '.'), false, this.classLoader);
            d = Class.forName(type2.replace('/', '.'), false, this.classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return "java/lang/Object";
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }
}

