/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.location;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.bytekit.asm.location.LocationMatcher;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LineNumberNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineLocationMatcher
implements LocationMatcher {
    private List<Integer> targetLines = Collections.emptyList();

    public LineLocationMatcher(int ... targetLines) {
        if (targetLines != null) {
            ArrayList<Integer> result = new ArrayList<Integer>(targetLines.length);
            for (int targetLine : targetLines) {
                result.add(targetLine);
            }
            this.targetLines = result;
        }
    }

    public LineLocationMatcher(List<Integer> targetLines) {
        this.targetLines = targetLines;
    }

    @Override
    public List<Location> match(MethodProcessor methodProcessor) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (AbstractInsnNode insnNode = methodProcessor.getEnterInsnNode(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!(insnNode instanceof LineNumberNode)) continue;
            LineNumberNode lineNumberNode = (LineNumberNode)insnNode;
            if (!this.match(lineNumberNode.line)) continue;
            locations.add(new Location.LineLocation((AbstractInsnNode)lineNumberNode, lineNumberNode.line));
        }
        return locations;
    }

    private boolean match(int line) {
        for (int targetLine : this.targetLines) {
            if (targetLine == -1) {
                return true;
            }
            if (line != targetLine) continue;
            return true;
        }
        return false;
    }
}

