/*
 * Decompiled with CFR 0.152.
 */
package com.tmall.ultraviewpager;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tmall.ultraviewpager.IUltraIndicatorBuilder;
import com.tmall.ultraviewpager.IUltraViewPagerFeature;
import com.tmall.ultraviewpager.R;
import com.tmall.ultraviewpager.TimerHandler;
import com.tmall.ultraviewpager.UltraViewPagerAdapter;
import com.tmall.ultraviewpager.UltraViewPagerIndicator;
import com.tmall.ultraviewpager.UltraViewPagerView;

public class UltraViewPager
extends RelativeLayout
implements IUltraViewPagerFeature {
    private final Point size;
    private final Point maxSize;
    private float ratio = Float.NaN;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private UltraViewPagerView viewPager;
    private UltraViewPagerIndicator pagerIndicator;
    private TimerHandler timer;
    private TimerHandler.TimerHandlerListener mTimerHandlerListener = new TimerHandler.TimerHandlerListener(){

        @Override
        public void callBack() {
            UltraViewPager.this.scrollNextPage();
        }
    };

    public UltraViewPager(Context context) {
        super(context);
        this.size = new Point();
        this.maxSize = new Point();
        this.initView();
    }

    public UltraViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.size = new Point();
        this.maxSize = new Point();
        this.initView();
        this.initView(context, attrs);
    }

    public UltraViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.size = new Point();
        this.maxSize = new Point();
        this.initView();
    }

    private void initView() {
        this.viewPager = new UltraViewPagerView(this.getContext());
        this.addView((View)this.viewPager, new ViewGroup.LayoutParams(-1, -1));
    }

    private void initView(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.UltraViewPager);
        this.setAutoScroll(ta.getInt(R.styleable.UltraViewPager_upv_autoscroll, 0));
        this.setInfiniteLoop(ta.getBoolean(R.styleable.UltraViewPager_upv_infiniteloop, false));
        this.setRatio(ta.getFloat(R.styleable.UltraViewPager_upv_ratio, Float.NaN));
        this.setScrollMode(ScrollMode.getScrollMode(ta.getInt(R.styleable.UltraViewPager_upv_scrollmode, 0)));
        this.disableScrollDirection(ScrollDirection.getScrollDirection(ta.getInt(R.styleable.UltraViewPager_upv_disablescroll, 0)));
        this.setMultiScreen(ta.getFloat(R.styleable.UltraViewPager_upv_multiscreen, 1.0f));
        this.setAutoMeasureHeight(ta.getBoolean(R.styleable.UltraViewPager_upv_automeasure, false));
        this.setItemRatio(ta.getFloat(R.styleable.UltraViewPager_upv_itemratio, Float.NaN));
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!Float.isNaN(this.ratio)) {
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)widthSize / this.ratio)), (int)0x40000000);
        }
        this.size.set(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        if (this.maxWidth >= 0 || this.maxHeight >= 0) {
            this.maxSize.set(this.maxWidth, this.maxHeight);
            this.constrainTo(this.size, this.maxSize);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.size.x, (int)0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.size.y, (int)0x40000000);
        }
        if (this.viewPager.getConstrainLength() > 0) {
            if (this.viewPager.getConstrainLength() == heightMeasureSpec) {
                this.viewPager.measure(widthMeasureSpec, heightMeasureSpec);
                this.setMeasuredDimension(this.size.x, this.size.y);
            } else if (this.viewPager.getScrollMode() == ScrollMode.HORIZONTAL) {
                super.onMeasure(widthMeasureSpec, this.viewPager.getConstrainLength());
            } else {
                super.onMeasure(this.viewPager.getConstrainLength(), heightMeasureSpec);
            }
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startTimer();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopTimer();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.stopTimer();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.startTimer();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.timer != null) {
            int action = ev.getAction();
            if (action == 0) {
                this.stopTimer();
            }
            if (action == 1 || action == 3) {
                this.startTimer();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public IUltraIndicatorBuilder initIndicator() {
        this.disableIndicator();
        this.pagerIndicator = new UltraViewPagerIndicator(this.getContext());
        this.pagerIndicator.setViewPager(this.viewPager);
        this.pagerIndicator.setIndicatorBuildListener(new UltraViewPagerIndicator.UltraViewPagerIndicatorListener(){

            @Override
            public void build() {
                UltraViewPager.this.removeView(UltraViewPager.this.pagerIndicator);
                UltraViewPager.this.addView(UltraViewPager.this.pagerIndicator, new ViewGroup.LayoutParams(-1, -1));
            }
        });
        return this.pagerIndicator;
    }

    @Override
    public IUltraIndicatorBuilder initIndicator(int focusColor, int normalColor, int radiusInPixel, int gravity) {
        return this.initIndicator().setFocusColor(focusColor).setNormalColor(normalColor).setRadius(radiusInPixel).setGravity(gravity);
    }

    @Override
    public IUltraIndicatorBuilder initIndicator(int focusColor, int normalColor, int strokeColor, int strokeWidth, int radiusInPixel, int gravity) {
        return this.initIndicator().setFocusColor(focusColor).setNormalColor(normalColor).setStrokeWidth(strokeWidth).setStrokeColor(strokeColor).setRadius(radiusInPixel).setGravity(gravity);
    }

    @Override
    public IUltraIndicatorBuilder initIndicator(int focusResId, int normalResId, int gravity) {
        return this.initIndicator().setFocusResId(focusResId).setNormalResId(normalResId).setGravity(gravity);
    }

    @Override
    public IUltraIndicatorBuilder initIndicator(Bitmap focusBitmap, Bitmap normalBitmap, int gravity) {
        return this.initIndicator().setFocusIcon(focusBitmap).setNormalIcon(normalBitmap).setGravity(gravity);
    }

    @Override
    public void disableIndicator() {
        if (this.pagerIndicator != null) {
            this.removeView(this.pagerIndicator);
            this.pagerIndicator = null;
        }
    }

    public IUltraIndicatorBuilder getIndicator() {
        return this.pagerIndicator;
    }

    @Override
    public void setAutoScroll(int intervalInMillis) {
        if (0 == intervalInMillis) {
            return;
        }
        if (this.timer != null) {
            this.disableAutoScroll();
        }
        this.timer = new TimerHandler(this.mTimerHandlerListener, intervalInMillis);
        this.startTimer();
    }

    @Override
    public void disableAutoScroll() {
        this.stopTimer();
        this.timer = null;
    }

    @Override
    public void setScrollMode(ScrollMode scrollMode) {
        this.viewPager.setScrollMode(scrollMode);
    }

    @Override
    public void setInfiniteLoop(boolean enableLoop) {
        this.viewPager.setEnableLoop(enableLoop);
    }

    @Override
    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    @Override
    public void setRatio(float ratio) {
        this.ratio = ratio;
        this.viewPager.setRatio(ratio);
    }

    @Override
    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    @Override
    public void disableScrollDirection(ScrollDirection direction) {
    }

    @Override
    public void scrollNextPage() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null && this.viewPager.getAdapter().getCount() > 0) {
            int curr = this.viewPager.getCurrentItemFake();
            int nextPage = 0;
            if (curr < this.viewPager.getAdapter().getCount() - 1) {
                nextPage = curr + 1;
            }
            this.viewPager.setCurrentItemFake(nextPage, true);
        }
    }

    @Override
    public void setMultiScreen(float ratio) {
        if (ratio <= 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("");
        }
        if (ratio <= 1.0f) {
            this.viewPager.setMultiScreen(ratio);
        }
    }

    @Override
    public void setAutoMeasureHeight(boolean status) {
        this.viewPager.setAutoMeasureHeight(status);
    }

    @Override
    public void setItemRatio(double ratio) {
        this.viewPager.setItemRatio(ratio);
    }

    @Override
    public void setItemMargin(int left, int top, int right, int bottom) {
        this.viewPager.setItemMargin(left, top, right, bottom);
    }

    @Override
    public void setScrollMargin(int left, int right) {
        this.viewPager.setPadding(left, 0, right, 0);
    }

    public void setAdapter(PagerAdapter adapter) {
        this.viewPager.setAdapter(adapter);
    }

    public void setOffscreenPageLimit(int limit) {
        this.viewPager.setOffscreenPageLimit(limit);
    }

    public PagerAdapter getAdapter() {
        return this.viewPager.getAdapter() == null ? null : ((UltraViewPagerAdapter)this.viewPager.getAdapter()).getAdapter();
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (this.pagerIndicator == null) {
            this.viewPager.setOnPageChangeListener(listener);
        } else {
            this.pagerIndicator.setPageChangeListener(listener);
        }
    }

    public void setCurrentItem(int item) {
        this.viewPager.setCurrentItem(item);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.viewPager.setCurrentItem(item, smoothScroll);
    }

    public int getCurrentItem() {
        return this.viewPager.getCurrentItem();
    }

    public void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.viewPager.setPageTransformer(reverseDrawingOrder, transformer);
    }

    public ViewPager getViewPager() {
        return this.viewPager;
    }

    private void constrainTo(Point size, Point maxSize) {
        if (maxSize.x >= 0 && size.x > maxSize.x) {
            size.x = maxSize.x;
        }
        if (maxSize.y >= 0 && size.y > maxSize.y) {
            size.y = maxSize.y;
        }
    }

    private void startTimer() {
        if (this.timer == null || !this.timer.isStopped) {
            return;
        }
        this.timer.listener = this.mTimerHandlerListener;
        this.timer.removeCallbacksAndMessages(null);
        this.timer.sendEmptyMessageDelayed(87108, this.timer.interval);
        this.timer.isStopped = false;
    }

    private void stopTimer() {
        if (this.timer == null || this.timer.isStopped) {
            return;
        }
        this.timer.removeCallbacksAndMessages(null);
        this.timer.listener = null;
        this.timer.isStopped = true;
    }

    @Override
    public void setInfiniteRatio(int infiniteRatio) {
        if (this.viewPager.getAdapter() != null && this.viewPager.getAdapter() instanceof UltraViewPagerAdapter) {
            ((UltraViewPagerAdapter)this.viewPager.getAdapter()).setInfiniteRatio(infiniteRatio);
        }
    }

    public static enum ScrollDirection {
        NONE(0),
        BACKWARD(1),
        FORWARD(2);

        int id;

        private ScrollDirection(int id) {
            this.id = id;
        }

        static ScrollDirection getScrollDirection(int id) {
            for (ScrollDirection direction : ScrollDirection.values()) {
                if (direction.id != id) continue;
                return direction;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum ScrollMode {
        HORIZONTAL(0),
        VERTICAL(1);

        int id;

        private ScrollMode(int id) {
            this.id = id;
        }

        static ScrollMode getScrollMode(int id) {
            for (ScrollMode scrollMode : ScrollMode.values()) {
                if (scrollMode.id != id) continue;
                return scrollMode;
            }
            throw new IllegalArgumentException();
        }
    }
}

