/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.support.annotation.NonNull;
import com.alibaba.android.bindingx.core.internal.PhysicsAnimationDriver;
import com.alibaba.android.bindingx.core.internal.Utils;
import java.util.Map;

class SpringAnimationDriver
extends PhysicsAnimationDriver {
    private static final double MAX_DELTA_TIME_SEC = 0.064;
    private long mLastTime;
    private boolean mSpringStarted;
    private double mSpringStiffness;
    private double mSpringDamping;
    private double mSpringMass;
    private double mInitialVelocity;
    private boolean mOvershootClampingEnabled;
    private final PhysicsState mCurrentState = new PhysicsState();
    private double mStartValue;
    private double mEndValue;
    private double mRestSpeedThreshold;
    private double mDisplacementFromRestThreshold;
    private double mTimeAccumulator;

    SpringAnimationDriver() {
    }

    @Override
    void onAnimationStart(@NonNull Map<String, Object> configMap) {
        this.mVelocity = this.mCurrentState.velocity = Utils.getDoubleValue(configMap, "initialVelocity", 0.0);
        this.mSpringStiffness = Utils.getDoubleValue(configMap, "stiffness", 100.0);
        this.mSpringDamping = Utils.getDoubleValue(configMap, "damping", 10.0);
        this.mSpringMass = Utils.getDoubleValue(configMap, "mass", 1.0);
        this.mInitialVelocity = this.mCurrentState.velocity;
        this.mValue = Utils.getDoubleValue(configMap, "fromValue", 0.0);
        this.mEndValue = Utils.getDoubleValue(configMap, "toValue", 1.0);
        this.mRestSpeedThreshold = Utils.getDoubleValue(configMap, "restSpeedThreshold", 0.001);
        this.mDisplacementFromRestThreshold = Utils.getDoubleValue(configMap, "restDisplacementThreshold", 0.001);
        this.mOvershootClampingEnabled = Utils.getBooleanValue(configMap, "overshootClamping", false);
        this.mHasFinished = false;
        this.mTimeAccumulator = 0.0;
        this.mSpringStarted = false;
    }

    @Override
    void runAnimationStep(long frameTimeMillis) {
        if (!this.mSpringStarted) {
            this.mStartValue = this.mCurrentState.position = this.mValue;
            this.mLastTime = frameTimeMillis;
            this.mTimeAccumulator = 0.0;
            this.mSpringStarted = true;
        }
        this.advance((double)(frameTimeMillis - this.mLastTime) / 1000.0);
        this.mLastTime = frameTimeMillis;
        this.mValue = this.mCurrentState.position;
        this.mVelocity = this.mCurrentState.velocity;
        if (this.isAtRest()) {
            this.mHasFinished = true;
        }
    }

    @Override
    boolean isAtRest() {
        return Math.abs(this.mCurrentState.velocity) <= this.mRestSpeedThreshold && (this.getDisplacementDistanceForState(this.mCurrentState) <= this.mDisplacementFromRestThreshold || this.mSpringStiffness == 0.0);
    }

    private double getDisplacementDistanceForState(PhysicsState state) {
        return Math.abs(this.mEndValue - state.position);
    }

    private boolean isOvershooting() {
        return this.mSpringStiffness > 0.0 && (this.mStartValue < this.mEndValue && this.mCurrentState.position > this.mEndValue || this.mStartValue > this.mEndValue && this.mCurrentState.position < this.mEndValue);
    }

    private void advance(double realDeltaTime) {
        double velocity;
        double position;
        if (this.isAtRest()) {
            return;
        }
        double adjustedDeltaTime = realDeltaTime;
        if (realDeltaTime > 0.064) {
            adjustedDeltaTime = 0.064;
        }
        this.mTimeAccumulator += adjustedDeltaTime;
        double c = this.mSpringDamping;
        double m = this.mSpringMass;
        double k = this.mSpringStiffness;
        double v0 = -this.mInitialVelocity;
        double zeta = c / (2.0 * Math.sqrt(k * m));
        double omega0 = Math.sqrt(k / m);
        double omega1 = omega0 * Math.sqrt(1.0 - zeta * zeta);
        double x0 = this.mEndValue - this.mStartValue;
        double t = this.mTimeAccumulator;
        if (zeta < 1.0) {
            double envelope = Math.exp(-zeta * omega0 * t);
            position = this.mEndValue - envelope * ((v0 + zeta * omega0 * x0) / omega1 * Math.sin(omega1 * t) + x0 * Math.cos(omega1 * t));
            velocity = zeta * omega0 * envelope * (Math.sin(omega1 * t) * (v0 + zeta * omega0 * x0) / omega1 + x0 * Math.cos(omega1 * t)) - envelope * (Math.cos(omega1 * t) * (v0 + zeta * omega0 * x0) - omega1 * x0 * Math.sin(omega1 * t));
        } else {
            double envelope = Math.exp(-omega0 * t);
            position = this.mEndValue - envelope * (x0 + (v0 + omega0 * x0) * t);
            velocity = envelope * (v0 * (t * omega0 - 1.0) + t * x0 * (omega0 * omega0));
        }
        this.mCurrentState.position = position;
        this.mCurrentState.velocity = velocity;
        if (this.isAtRest() || this.mOvershootClampingEnabled && this.isOvershooting()) {
            if (this.mSpringStiffness > 0.0) {
                this.mStartValue = this.mEndValue;
                this.mCurrentState.position = this.mEndValue;
            } else {
                this.mStartValue = this.mEndValue = this.mCurrentState.position;
            }
            this.mCurrentState.velocity = 0.0;
        }
    }

    private static class PhysicsState {
        double position;
        double velocity;

        private PhysicsState() {
        }
    }
}

