/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.internal.SensorManagerProxy;
import com.alibaba.android.bindingx.core.internal.SensorManagerProxyImpl;
import com.alibaba.android.bindingx.core.internal.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class OrientationDetector
implements SensorEventListener {
    private HandlerThread mThread;
    private Handler mHandler;
    private final Context mAppContext;
    private float[] mMagneticFieldVector;
    private float[] mTruncatedRotationVector;
    private float[] mDeviceRotationMatrix;
    private double[] mRotationAngles;
    @VisibleForTesting
    SensorManagerProxy mSensorManagerProxy;
    private static OrientationDetector sSingleton;
    private static final Object sSingletonLock;
    private static final Set<Integer> DEVICE_ORIENTATION_SENSORS_A;
    private static final Set<Integer> DEVICE_ORIENTATION_SENSORS_B;
    private static final Set<Integer> DEVICE_ORIENTATION_SENSORS_C;
    private final Set<Integer> mActiveSensors = new HashSet<Integer>();
    private final List<Set<Integer>> mOrientationSensorSets;
    private Set<Integer> mDeviceOrientationSensors;
    private boolean mDeviceOrientationIsActive;
    private boolean mDeviceOrientationIsActiveWithBackupSensors;
    private boolean mOrientationNotAvailable;
    private ArrayList<OnOrientationChangedListener> mListeners = new ArrayList();

    private OrientationDetector(@NonNull Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mOrientationSensorSets = Utils.newArrayList(DEVICE_ORIENTATION_SENSORS_A, DEVICE_ORIENTATION_SENSORS_B, DEVICE_ORIENTATION_SENSORS_C);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OrientationDetector getInstance(Context appContext) {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new OrientationDetector(appContext);
            }
            return sSingleton;
        }
    }

    void addOrientationChangedListener(@NonNull OnOrientationChangedListener listener) {
        if (this.mListeners != null && !this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    boolean removeOrientationChangedListener(@Nullable OnOrientationChangedListener listener) {
        if (this.mListeners != null) {
            if (listener == null) {
                this.mListeners.clear();
                return true;
            }
            return this.mListeners.remove(listener);
        }
        return false;
    }

    private boolean registerOrientationSensorsWithFallback(int rateInMicroseconds) {
        if (this.mOrientationNotAvailable) {
            return false;
        }
        if (this.mDeviceOrientationSensors != null) {
            String type = this.getOrientationSensorTypeUsed();
            LogProxy.d("[OrientationDetector] register sensor:" + type);
            return this.registerSensors(this.mDeviceOrientationSensors, rateInMicroseconds, true);
        }
        this.ensureRotationStructuresAllocated();
        for (Set<Integer> sensors : this.mOrientationSensorSets) {
            this.mDeviceOrientationSensors = sensors;
            if (!this.registerSensors(this.mDeviceOrientationSensors, rateInMicroseconds, true)) continue;
            String type = this.getOrientationSensorTypeUsed();
            LogProxy.d("[OrientationDetector] register sensor:" + type);
            return true;
        }
        this.mOrientationNotAvailable = true;
        this.mDeviceOrientationSensors = null;
        this.mDeviceRotationMatrix = null;
        this.mRotationAngles = null;
        return false;
    }

    private String getOrientationSensorTypeUsed() {
        if (this.mOrientationNotAvailable) {
            return "NOT_AVAILABLE";
        }
        if (this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_A) {
            return "GAME_ROTATION_VECTOR";
        }
        if (this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_B) {
            return "ROTATION_VECTOR";
        }
        if (this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_C) {
            return "ACCELEROMETER_MAGNETIC";
        }
        return "NOT_AVAILABLE";
    }

    public boolean start(int rateInMicroseconds) {
        LogProxy.d("[OrientationDetector] sensor started");
        boolean success = this.registerOrientationSensorsWithFallback(rateInMicroseconds);
        if (success) {
            this.setEventTypeActive(true);
        }
        return success;
    }

    void stop() {
        LogProxy.d("[OrientationDetector] sensor stopped");
        HashSet<Integer> sensorsToDeactivate = new HashSet<Integer>(this.mActiveSensors);
        this.unregisterSensors(sensorsToDeactivate);
        this.setEventTypeActive(false);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        int type = event.sensor.getType();
        float[] values = event.values;
        switch (type) {
            case 1: {
                if (!this.mDeviceOrientationIsActiveWithBackupSensors) break;
                this.getOrientationFromGeomagneticVectors(values, this.mMagneticFieldVector);
                break;
            }
            case 11: {
                if (!this.mDeviceOrientationIsActive || this.mDeviceOrientationSensors != DEVICE_ORIENTATION_SENSORS_B) break;
                this.convertRotationVectorToAngles(values, this.mRotationAngles);
                this.gotOrientation(this.mRotationAngles[0], this.mRotationAngles[1], this.mRotationAngles[2]);
                break;
            }
            case 15: {
                if (!this.mDeviceOrientationIsActive) break;
                this.convertRotationVectorToAngles(values, this.mRotationAngles);
                this.gotOrientation(this.mRotationAngles[0], this.mRotationAngles[1], this.mRotationAngles[2]);
                break;
            }
            case 2: {
                if (!this.mDeviceOrientationIsActiveWithBackupSensors) break;
                if (this.mMagneticFieldVector == null) {
                    this.mMagneticFieldVector = new float[3];
                }
                System.arraycopy(values, 0, this.mMagneticFieldVector, 0, this.mMagneticFieldVector.length);
                break;
            }
            default: {
                LogProxy.e("unexpected sensor type:" + type);
            }
        }
    }

    private static double[] computeDeviceOrientationFromRotationMatrix(float[] matrixR, double[] values) {
        if (matrixR.length != 9) {
            return values;
        }
        if (matrixR[8] > 0.0f) {
            values[0] = Math.atan2(-matrixR[1], matrixR[4]);
            values[1] = Math.asin(matrixR[7]);
            values[2] = Math.atan2(-matrixR[6], matrixR[8]);
        } else if (matrixR[8] < 0.0f) {
            values[0] = Math.atan2(matrixR[1], -matrixR[4]);
            values[1] = -Math.asin(matrixR[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = Math.atan2(matrixR[6], -matrixR[8]);
        } else if (matrixR[6] > 0.0f) {
            values[0] = Math.atan2(-matrixR[1], matrixR[4]);
            values[1] = Math.asin(matrixR[7]);
            values[2] = -1.5707963267948966;
        } else if (matrixR[6] < 0.0f) {
            values[0] = Math.atan2(matrixR[1], -matrixR[4]);
            values[1] = -Math.asin(matrixR[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = -1.5707963267948966;
        } else {
            values[0] = Math.atan2(matrixR[3], matrixR[0]);
            values[1] = matrixR[7] > 0.0f ? 1.5707963267948966 : -1.5707963267948966;
            values[2] = 0.0;
        }
        if (values[0] < 0.0) {
            values[0] = values[0] + Math.PI * 2;
        }
        return values;
    }

    private void convertRotationVectorToAngles(float[] rotationVector, double[] angles) {
        if (rotationVector.length > 4) {
            System.arraycopy(rotationVector, 0, this.mTruncatedRotationVector, 0, 4);
            SensorManager.getRotationMatrixFromVector((float[])this.mDeviceRotationMatrix, (float[])this.mTruncatedRotationVector);
        } else {
            SensorManager.getRotationMatrixFromVector((float[])this.mDeviceRotationMatrix, (float[])rotationVector);
        }
        OrientationDetector.computeDeviceOrientationFromRotationMatrix(this.mDeviceRotationMatrix, angles);
        for (int i = 0; i < 3; ++i) {
            angles[i] = Math.toDegrees(angles[i]);
        }
    }

    private void getOrientationFromGeomagneticVectors(float[] acceleration, float[] magnetic) {
        if (acceleration == null || magnetic == null) {
            return;
        }
        if (!SensorManager.getRotationMatrix((float[])this.mDeviceRotationMatrix, null, (float[])acceleration, (float[])magnetic)) {
            return;
        }
        OrientationDetector.computeDeviceOrientationFromRotationMatrix(this.mDeviceRotationMatrix, this.mRotationAngles);
        this.gotOrientation(Math.toDegrees(this.mRotationAngles[0]), Math.toDegrees(this.mRotationAngles[1]), Math.toDegrees(this.mRotationAngles[2]));
    }

    private SensorManagerProxy getSensorManagerProxy() {
        if (this.mSensorManagerProxy != null) {
            return this.mSensorManagerProxy;
        }
        SensorManager sensorManager = (SensorManager)this.mAppContext.getSystemService("sensor");
        if (sensorManager != null) {
            this.mSensorManagerProxy = new SensorManagerProxyImpl(sensorManager);
        }
        return this.mSensorManagerProxy;
    }

    private void setEventTypeActive(boolean active) {
        this.mDeviceOrientationIsActive = active;
        this.mDeviceOrientationIsActiveWithBackupSensors = active && this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_C;
    }

    private void ensureRotationStructuresAllocated() {
        if (this.mDeviceRotationMatrix == null) {
            this.mDeviceRotationMatrix = new float[9];
        }
        if (this.mRotationAngles == null) {
            this.mRotationAngles = new double[3];
        }
        if (this.mTruncatedRotationVector == null) {
            this.mTruncatedRotationVector = new float[4];
        }
    }

    private boolean registerSensors(Set<Integer> sensorTypes, int rateInMicroseconds, boolean failOnMissingSensor) {
        HashSet<Integer> sensorsToActivate = new HashSet<Integer>(sensorTypes);
        sensorsToActivate.removeAll(this.mActiveSensors);
        if (sensorsToActivate.isEmpty()) {
            return true;
        }
        boolean success = false;
        for (Integer sensorType : sensorsToActivate) {
            boolean result = this.registerForSensorType(sensorType, rateInMicroseconds);
            if (!result && failOnMissingSensor) {
                this.unregisterSensors(sensorsToActivate);
                return false;
            }
            if (!result) continue;
            this.mActiveSensors.add(sensorType);
            success = true;
        }
        return success;
    }

    private void unregisterSensors(Iterable<Integer> sensorTypes) {
        for (Integer sensorType : sensorTypes) {
            if (!this.mActiveSensors.contains(sensorType)) continue;
            this.getSensorManagerProxy().unregisterListener(this, sensorType);
            this.mActiveSensors.remove(sensorType);
        }
    }

    private boolean registerForSensorType(int type, int rateInMicroseconds) {
        SensorManagerProxy sensorManager = this.getSensorManagerProxy();
        if (sensorManager == null) {
            return false;
        }
        return sensorManager.registerListener(this, type, rateInMicroseconds, this.getHandler());
    }

    @VisibleForTesting
    void gotOrientation(double alpha, double beta, double gamma) {
        if (this.mListeners != null) {
            try {
                for (OnOrientationChangedListener listener : this.mListeners) {
                    listener.onOrientationChanged(alpha, beta, gamma);
                }
            }
            catch (Throwable e) {
                LogProxy.e("[OrientationDetector] ", e);
            }
        }
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mThread = new HandlerThread("DeviceOrientation");
            this.mThread.start();
            this.mHandler = new Handler(this.mThread.getLooper());
        }
        return this.mHandler;
    }

    static {
        sSingletonLock = new Object();
        DEVICE_ORIENTATION_SENSORS_A = Utils.newHashSet(15);
        DEVICE_ORIENTATION_SENSORS_B = Utils.newHashSet(11);
        DEVICE_ORIENTATION_SENSORS_C = Utils.newHashSet(1, 2);
    }

    static interface OnOrientationChangedListener {
        public void onOrientationChanged(double var1, double var3, double var5);
    }
}

