/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.animation.ArgbEvaluator;
import android.graphics.Color;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.JSFunctionInterface;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONException;

@Keep
public class JSMath {
    private static ArgbEvaluator sArgbEvaluator = new ArgbEvaluator();

    private JSMath() {
    }

    public static Object sin() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.sin((Double)arguments.get(0));
            }
        };
    }

    public static Object cos() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.cos((Double)arguments.get(0));
            }
        };
    }

    public static Object tan() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.tan((Double)arguments.get(0));
            }
        };
    }

    public static Object asin() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.asin((Double)arguments.get(0));
            }
        };
    }

    public static Object acos() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.acos((Double)arguments.get(0));
            }
        };
    }

    public static Object atan() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.atan((Double)arguments.get(0));
            }
        };
    }

    public static Object atan2() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.atan2((Double)arguments.get(0), (Double)arguments.get(1));
            }
        };
    }

    public static Object pow() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.pow((Double)arguments.get(0), (Double)arguments.get(1));
            }
        };
    }

    public static Object exp() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.exp((Double)arguments.get(0));
            }
        };
    }

    public static Object sqrt() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.sqrt((Double)arguments.get(0));
            }
        };
    }

    public static Object cbrt() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.cbrt((Double)arguments.get(0));
            }
        };
    }

    public static Object log() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.log((Double)arguments.get(0));
            }
        };
    }

    public static Object abs() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.abs((Double)arguments.get(0));
            }
        };
    }

    public static Object sign() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                double v = (Double)arguments.get(0);
                if (v > 0.0) {
                    return 1;
                }
                if (v == 0.0) {
                    return 0;
                }
                if (v < 0.0) {
                    return -1;
                }
                return Double.NaN;
            }
        };
    }

    public static Object ceil() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.ceil((Double)arguments.get(0));
            }
        };
    }

    public static Object floor() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.floor((Double)arguments.get(0));
            }
        };
    }

    public static Object round() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                return Math.round((Double)arguments.get(0));
            }
        };
    }

    public static Object max() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                if (arguments != null && arguments.size() >= 1) {
                    double max = (Double)arguments.get(0);
                    int len = arguments.size();
                    for (int i = 1; i < len; ++i) {
                        double val = (Double)arguments.get(i);
                        if (!(val > max)) continue;
                        max = val;
                    }
                    return max;
                }
                return null;
            }
        };
    }

    public static Object min() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                if (arguments != null && arguments.size() >= 1) {
                    double min = (Double)arguments.get(0);
                    int len = arguments.size();
                    for (int i = 1; i < len; ++i) {
                        double val = (Double)arguments.get(i);
                        if (!(val < min)) continue;
                        min = val;
                    }
                    return min;
                }
                return null;
            }
        };
    }

    public static Object PI() {
        return Math.PI;
    }

    public static Object E() {
        return Math.E;
    }

    public static Object rgb() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                if (arguments == null || arguments.size() < 3) {
                    return null;
                }
                double r = (Double)arguments.get(0);
                double g = (Double)arguments.get(1);
                double b = (Double)arguments.get(2);
                return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
            }
        };
    }

    public static Object rgba() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                if (arguments == null || arguments.size() < 4) {
                    return null;
                }
                double r = (Double)arguments.get(0);
                double g = (Double)arguments.get(1);
                double b = (Double)arguments.get(2);
                double a = (Double)arguments.get(3) * 255.0;
                return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
            }
        };
    }

    public static Object evaluateColor() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                int fromColor = JSMath.parseColor((String)arguments.get(0));
                int toColor = JSMath.parseColor((String)arguments.get(1));
                double fraction = (Double)arguments.get(2);
                fraction = Math.min(1.0, Math.max(0.0, fraction));
                return sArgbEvaluator.evaluate((float)fraction, (Object)fromColor, (Object)toColor);
            }
        };
    }

    private static int parseColor(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            throw new IllegalArgumentException("Unknown color");
        }
        String colorStr = str;
        if (str.startsWith("'") || str.startsWith("\"")) {
            colorStr = colorStr.substring(1, colorStr.length() - 1);
        }
        int color = Color.parseColor((String)colorStr);
        color = Color.argb((int)255, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
        return color;
    }

    public static Object asArray() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                return arguments;
            }
        };
    }

    static void applyXYToScope(Map<String, Object> scope, double x, double y, PlatformManager.IDeviceResolutionTranslator translator) {
        scope.put("x", translator.nativeToWeb(x, new Object[0]));
        scope.put("y", translator.nativeToWeb(y, new Object[0]));
        scope.put("internal_x", x);
        scope.put("internal_y", y);
    }

    static void applySpringValueToScope(Map<String, Object> scope, double position, double velocity) {
        scope.put("p", position);
        scope.put("v", velocity);
    }

    static void applyScaleFactorToScope(Map<String, Object> scope, double scale) {
        scope.put("s", scale);
    }

    static void applyRotationInDegreesToScope(Map<String, Object> scope, double rotation) {
        scope.put("r", rotation);
    }

    static void applyOrientationValuesToScope(Map<String, Object> scope, double alpha, double beta, double gamma, double startAlpha, double startBeta, double startGamma, double x, double y, double z) {
        scope.put("alpha", alpha);
        scope.put("beta", beta);
        scope.put("gamma", gamma);
        scope.put("dalpha", alpha - startAlpha);
        scope.put("dbeta", beta - startBeta);
        scope.put("dgamma", gamma - startGamma);
        scope.put("x", x);
        scope.put("y", y);
        scope.put("z", z);
    }

    static void applyTimingValuesToScope(Map<String, Object> scope, double t) {
        scope.put("t", t);
    }

    static void applyScrollValuesToScope(Map<String, Object> scope, double x, double y, double dx, double dy, double tdx, double tdy, PlatformManager.IDeviceResolutionTranslator translator) {
        scope.put("x", translator.nativeToWeb(x, new Object[0]));
        scope.put("y", translator.nativeToWeb(y, new Object[0]));
        scope.put("dx", translator.nativeToWeb(dx, new Object[0]));
        scope.put("dy", translator.nativeToWeb(dy, new Object[0]));
        scope.put("tdx", translator.nativeToWeb(tdx, new Object[0]));
        scope.put("tdy", translator.nativeToWeb(tdy, new Object[0]));
        scope.put("internal_x", x);
        scope.put("internal_y", y);
    }
}

