/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractEventHandler;
import com.alibaba.android.bindingx.core.internal.JSMath;
import com.alibaba.android.bindingx.core.internal.RotationGestureDetector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BindingXRotationHandler
extends AbstractEventHandler
implements View.OnTouchListener,
RotationGestureDetector.OnRotationGestureListener {
    private RotationGestureDetector mRotationGestureDetector = new RotationGestureDetector(this);
    private double mAbsoluteRotationInDegrees;

    public BindingXRotationHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
    }

    @Override
    protected void onExit(@NonNull Map<String, Object> scope) {
        double rotation = (Double)scope.get("r");
        this.fireEventByState("exit", rotation, new Object[0]);
    }

    @Override
    protected void onUserIntercept(String interceptorName, @NonNull Map<String, Object> scope) {
        double rotation = (Double)scope.get("r");
        this.fireEventByState("interceptor", rotation, Collections.singletonMap("interceptor", interceptorName));
    }

    @Override
    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
        View sourceView = this.mPlatformManager.getViewFinder().findViewBy(sourceRef, instanceId);
        if (sourceView == null) {
            LogProxy.e("[RotationHandler] onCreate failed. sourceView not found:" + sourceRef);
            return false;
        }
        sourceView.setOnTouchListener((View.OnTouchListener)this);
        LogProxy.d("[RotationHandler] onCreate success. {source:" + sourceRef + ",type:" + eventType + "}");
        return true;
    }

    @Override
    public void onStart(@NonNull String sourceRef, @NonNull String eventType) {
    }

    @Override
    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
        View hostView = this.mPlatformManager.getViewFinder().findViewBy(sourceRef, instanceId);
        LogProxy.d("remove touch listener success.[" + sourceRef + "," + eventType + "]");
        if (hostView != null) {
            hostView.setOnTouchListener(null);
            return true;
        }
        return false;
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }

    private void fireEventByState(String state, double rotation, Object ... extension) {
        if (this.mCallback != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("state", state);
            param.put("rotation", rotation);
            param.put("token", this.mToken);
            if (extension != null && extension.length > 0 && extension[0] instanceof Map) {
                param.putAll((Map)extension[0]);
            }
            this.mCallback.callback(param);
            LogProxy.d(">>>>>>>>>>>fire event:(" + state + "," + rotation + ")");
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        return this.mRotationGestureDetector.onTouchEvent(event);
    }

    @Override
    public void onRotation(RotationGestureDetector detector) {
        try {
            double rotation = detector.getRotationInDegrees();
            this.mAbsoluteRotationInDegrees += rotation;
            if (LogProxy.sEnableLog) {
                LogProxy.d(String.format(Locale.getDefault(), "[RotationHandler] current rotation in degrees: %f", this.mAbsoluteRotationInDegrees));
            }
            JSMath.applyRotationInDegreesToScope(this.mScope, this.mAbsoluteRotationInDegrees);
            if (!this.evaluateExitExpression(this.mExitExpressionPair, this.mScope)) {
                this.consumeExpression(this.mExpressionHoldersMap, this.mScope, "rotation");
            }
        }
        catch (Exception e) {
            LogProxy.e("runtime error", e);
        }
    }

    @Override
    public void onRotationBegin(RotationGestureDetector detector) {
        LogProxy.d("[RotationHandler] rotation gesture begin");
        this.fireEventByState("start", 0.0, new Object[0]);
    }

    @Override
    public void onRotationEnd(RotationGestureDetector detector) {
        LogProxy.d("[RotationHandler] rotation gesture end");
        this.fireEventByState("end", this.mAbsoluteRotationInDegrees, new Object[0]);
        this.mAbsoluteRotationInDegrees = 0.0;
    }
}

