/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractEventHandler;
import com.alibaba.android.bindingx.core.internal.JSMath;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BindingXPinchHandler
extends AbstractEventHandler
implements View.OnTouchListener,
ScaleGestureDetector.OnScaleGestureListener {
    private ScaleGestureDetector mScaleGestureDetector;
    private boolean mInProgress;
    private int[] mPointerIds = new int[2];
    private double mAbsoluteScaleFactor = 1.0;

    public BindingXPinchHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
        Handler handler = new Handler(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
        this.mScaleGestureDetector = Build.VERSION.SDK_INT >= 19 ? new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this, handler) : new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
    }

    @Override
    protected void onExit(@NonNull Map<String, Object> scope) {
        double scaleFactor = (Double)scope.get("s");
        this.fireEventByState("exit", scaleFactor, new Object[0]);
    }

    @Override
    protected void onUserIntercept(String interceptorName, @NonNull Map<String, Object> scope) {
        double scaleFactor = (Double)scope.get("s");
        this.fireEventByState("interceptor", scaleFactor, Collections.singletonMap("interceptor", interceptorName));
    }

    @Override
    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
        View sourceView = this.mPlatformManager.getViewFinder().findViewBy(sourceRef, instanceId);
        if (sourceView == null) {
            LogProxy.e("[BindingXPinchHandler] onCreate failed. sourceView not found:" + sourceRef);
            return false;
        }
        sourceView.setOnTouchListener((View.OnTouchListener)this);
        LogProxy.d("[BindingXPinchHandler] onCreate success. {source:" + sourceRef + ",type:" + eventType + "}");
        return true;
    }

    @Override
    public void onStart(@NonNull String sourceRef, @NonNull String eventType) {
    }

    @Override
    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
        View hostView = this.mPlatformManager.getViewFinder().findViewBy(sourceRef, instanceId);
        LogProxy.d("remove touch listener success.[" + sourceRef + "," + eventType + "]");
        if (hostView != null) {
            hostView.setOnTouchListener(null);
            return true;
        }
        return false;
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }

    private void fireEventByState(String state, double scaleFactor, Object ... extension) {
        if (this.mCallback != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("state", state);
            param.put("scale", scaleFactor);
            param.put("token", this.mToken);
            if (extension != null && extension.length > 0 && extension[0] instanceof Map) {
                param.putAll((Map)extension[0]);
            }
            this.mCallback.callback(param);
            LogProxy.d(">>>>>>>>>>>fire event:(" + state + "," + scaleFactor + ")");
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mInProgress = false;
                this.mPointerIds[0] = event.getPointerId(event.getActionIndex());
                this.mPointerIds[1] = -1;
                break;
            }
            case 5: {
                if (this.mInProgress) break;
                this.mPointerIds[1] = event.getPointerId(event.getActionIndex());
                this.mInProgress = true;
                this.pinchStart();
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.pinchEnd();
                break;
            }
            case 6: {
                int pointerId;
                if (!this.mInProgress || (pointerId = event.getPointerId(event.getActionIndex())) != this.mPointerIds[0] && pointerId != this.mPointerIds[1]) break;
                this.pinchEnd();
                break;
            }
        }
        return this.mScaleGestureDetector.onTouchEvent(event);
    }

    private void pinchStart() {
        LogProxy.d("[PinchHandler] pinch gesture begin");
        this.fireEventByState("start", 1.0, new Object[0]);
    }

    private void pinchEnd() {
        if (this.mInProgress) {
            LogProxy.d("[PinchHandler] pinch gesture end");
            this.fireEventByState("end", this.mAbsoluteScaleFactor, new Object[0]);
            this.mInProgress = false;
            this.mPointerIds[0] = -1;
            this.mPointerIds[1] = -1;
            this.mAbsoluteScaleFactor = 1.0;
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float scaleFactor = detector.getScaleFactor();
        if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
            return true;
        }
        this.mAbsoluteScaleFactor *= (double)scaleFactor;
        try {
            if (LogProxy.sEnableLog) {
                LogProxy.d(String.format(Locale.getDefault(), "[PinchHandler] current scale factor: %f", this.mAbsoluteScaleFactor));
            }
            JSMath.applyScaleFactorToScope(this.mScope, this.mAbsoluteScaleFactor);
            if (!this.evaluateExitExpression(this.mExitExpressionPair, this.mScope)) {
                this.consumeExpression(this.mExpressionHoldersMap, this.mScope, "pinch");
            }
        }
        catch (Exception e) {
            LogProxy.e("runtime error", e);
        }
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }
}

