/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractEventHandler;
import com.alibaba.android.bindingx.core.internal.JSMath;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractScrollEventHandler
extends AbstractEventHandler {
    protected int mContentOffsetX;
    protected int mContentOffsetY;
    private boolean isStart = false;

    public AbstractScrollEventHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
    }

    @Override
    @CallSuper
    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        this.clearExpressions();
        this.isStart = false;
        this.fireEventByState("end", this.mContentOffsetX, this.mContentOffsetY, 0.0, 0.0, 0.0, 0.0, new Object[0]);
        return true;
    }

    @Override
    protected void onExit(@NonNull Map<String, Object> scope) {
        double contentOffsetX = (Double)scope.get("internal_x");
        double contentOffsetY = (Double)scope.get("internal_y");
        this.fireEventByState("exit", contentOffsetX, contentOffsetY, 0.0, 0.0, 0.0, 0.0, new Object[0]);
    }

    @Override
    protected void onUserIntercept(String interceptorName, @NonNull Map<String, Object> scope) {
        double contentOffsetX = (Double)scope.get("internal_x");
        double contentOffsetY = (Double)scope.get("internal_y");
        double dx = (Double)scope.get("dx");
        double dy = (Double)scope.get("dy");
        double tdx = (Double)scope.get("tdx");
        double tdy = (Double)scope.get("tdy");
        this.fireEventByState("interceptor", contentOffsetX, contentOffsetY, dx, dy, tdx, tdy, Collections.singletonMap("interceptor", interceptorName));
    }

    @Override
    @CallSuper
    public void onDestroy() {
        super.onDestroy();
        this.isStart = false;
    }

    protected void handleScrollEvent(int contentOffsetX, int contentOffsetY, int dx, int dy, int tdx, int tdy) {
        this.handleScrollEvent(contentOffsetX, contentOffsetY, dx, dy, tdx, tdy, "scroll");
    }

    protected void handleScrollEvent(int contentOffsetX, int contentOffsetY, int dx, int dy, int tdx, int tdy, String eventType) {
        if (LogProxy.sEnableLog) {
            LogProxy.d(String.format(Locale.getDefault(), "[ScrollHandler] scroll changed. (contentOffsetX:%d,contentOffsetY:%d,dx:%d,dy:%d,tdx:%d,tdy:%d)", contentOffsetX, contentOffsetY, dx, dy, tdx, tdy));
        }
        this.mContentOffsetX = contentOffsetX;
        this.mContentOffsetY = contentOffsetY;
        if (!this.isStart) {
            this.isStart = true;
            this.fireEventByState("start", contentOffsetX, contentOffsetY, dx, dy, tdx, tdy, new Object[0]);
        }
        try {
            JSMath.applyScrollValuesToScope(this.mScope, contentOffsetX, contentOffsetY, dx, dy, tdx, tdy, this.mPlatformManager.getResolutionTranslator());
            if (!this.evaluateExitExpression(this.mExitExpressionPair, this.mScope)) {
                this.consumeExpression(this.mExpressionHoldersMap, this.mScope, eventType);
            }
        }
        catch (Exception e) {
            LogProxy.e("runtime error", e);
        }
    }

    protected void fireEventByState(String state, double contentOffsetX, double contentOffsetY, double dx, double dy, double tdx, double tdy, Object ... extension) {
        if (this.mCallback != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("state", state);
            double x = this.mPlatformManager.getResolutionTranslator().nativeToWeb(contentOffsetX, new Object[0]);
            double y = this.mPlatformManager.getResolutionTranslator().nativeToWeb(contentOffsetY, new Object[0]);
            param.put("x", x);
            param.put("y", y);
            double _dx = this.mPlatformManager.getResolutionTranslator().nativeToWeb(dx, new Object[0]);
            double _dy = this.mPlatformManager.getResolutionTranslator().nativeToWeb(dy, new Object[0]);
            param.put("dx", _dx);
            param.put("dy", _dy);
            double _tdx = this.mPlatformManager.getResolutionTranslator().nativeToWeb(tdx, new Object[0]);
            double _tdy = this.mPlatformManager.getResolutionTranslator().nativeToWeb(tdy, new Object[0]);
            param.put("tdx", _tdx);
            param.put("tdy", _tdy);
            param.put("token", this.mToken);
            if (extension != null && extension.length > 0 && extension[0] instanceof Map) {
                param.putAll((Map)extension[0]);
            }
            this.mCallback.callback(param);
            LogProxy.d(">>>>>>>>>>>fire event:(" + state + "," + x + "," + y + "," + _dx + "," + _dy + "," + _tdx + "," + _tdy + ")");
        }
    }
}

