/**
 * Copyright 2018 Alibaba Group
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.android.bindingx.core.internal;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import org.json.JSONObject;

/**
 * Description:
 *
 * This class holds an expression which include origin expression and
 * the transformed expression.
 *
 * Created by rowandjj(chuyi)<br/>
 */

public class ExpressionPair {

    // the original expression
    public final String origin;

    // the expression that has been transformed to abstract syntax tree
    public final String transformed;

    public final JSONObject compiledTransformed;

    public ExpressionPair(String origin,String transformed, JSONObject compiledTransformed) {
        this.origin = origin;
        this.transformed = transformed;
        this.compiledTransformed = compiledTransformed;
    }

    public static ExpressionPair createCompiled(@Nullable String origin,@Nullable JSONObject transformed) {
        return new ExpressionPair(origin, null, transformed);
    }

    public static ExpressionPair create(@Nullable String origin, @Nullable String transformed) {
        return new ExpressionPair(origin,transformed, null);
    }

    public static boolean isValid(@Nullable ExpressionPair pair) {
        return pair != null && ((!TextUtils.isEmpty(pair.transformed) && !"{}".equals(pair.transformed)) || pair.compiledTransformed != null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ExpressionPair that = (ExpressionPair) o;

        if (origin != null ? !origin.equals(that.origin) : that.origin != null) return false;
        return transformed != null ? transformed.equals(that.transformed) : that.transformed == null;

    }

    @Override
    public int hashCode() {
        int result = origin != null ? origin.hashCode() : 0;
        result = 31 * result + (transformed != null ? transformed.hashCode() : 0);
        return result;
    }
}
