/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Utils {
    private Utils() {
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        if (object == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, Utils.fromJson(object.get(key)));
        }
        return map;
    }

    public static List toList(JSONArray array) throws JSONException {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(Utils.fromJson(array.get(i)));
        }
        return list;
    }

    private static Object fromJson(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return Utils.toMap((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return Utils.toList((JSONArray)json);
        }
        return json;
    }

    @Nullable
    public static String getStringValue(@NonNull Map<String, Object> params, @NonNull String key) {
        Object value = params.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    @Nullable
    public static List<Map<String, Object>> getRuntimeProps(@NonNull Map<String, Object> params) {
        Object result = params.get("props");
        if (result == null) {
            return null;
        }
        try {
            return (List)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Map<String, ExpressionPair> getCustomInterceptors(@NonNull Map<String, Object> params) {
        Object value = params.get("interceptors");
        if (value == null || !(value instanceof Map)) {
            return null;
        }
        HashMap<String, ExpressionPair> interceptors = new HashMap<String, ExpressionPair>(8);
        Set set = ((Map)value).entrySet();
        for (Map.Entry entry : set) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!(k instanceof String) || !(v instanceof Map)) continue;
            ExpressionPair pair = null;
            try {
                pair = Utils.getExpressionPair((Map)v, "expression");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pair == null) continue;
            interceptors.put((String)k, pair);
        }
        return interceptors;
    }

    @Nullable
    public static ExpressionPair getExpressionPair(@NonNull Map<String, Object> params, @NonNull String key) {
        Object value = params.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return ExpressionPair.create(null, (String)value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(map);
            }
            catch (Throwable e) {
                LogProxy.e("unexpected json parse error.", e);
            }
            if (jsonObject == null) {
                return ExpressionPair.create(null, null);
            }
            String origin = jsonObject.optString("origin", null);
            Object transformedObj = jsonObject.opt("transformed");
            if (transformedObj == null) {
                return ExpressionPair.create(null, null);
            }
            if (transformedObj instanceof JSONObject) {
                return ExpressionPair.createCompiled(origin, (JSONObject)transformedObj);
            }
            if (transformedObj instanceof String) {
                return ExpressionPair.create(origin, (String)transformedObj);
            }
            return ExpressionPair.create(origin, String.valueOf(value));
        }
        return null;
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public static float normalizeRotation(float rotation) {
        float normalizedRotation = (rotation %= 360.0f) >= 0.0f ? (rotation >= 0.0f && rotation <= 180.0f ? rotation : rotation % 180.0f - 180.0f) : (rotation > -180.0f && rotation < 0.0f ? rotation : 180.0f + rotation % 180.0f);
        return normalizedRotation;
    }

    public static int normalizedPerspectiveValue(@NonNull Context context, int raw) {
        float scale = context.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)(scale * (float)raw * 5.0f);
    }

    @Nullable
    public static Pair<Float, Float> parseTransformOrigin(@Nullable String value, @NonNull View view) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        int firstSpace = value.indexOf(32);
        if (firstSpace != -1) {
            int i;
            for (i = firstSpace; i < value.length() && value.charAt(i) == ' '; ++i) {
            }
            if (i < value.length() && value.charAt(i) != ' ') {
                String x = value.substring(0, firstSpace).trim();
                String y = value.substring(i, value.length()).trim();
                float pivotX = "left".equals(x) ? 0.0f : ("right".equals(x) ? (float)view.getWidth() : ("center".equals(x) ? (float)(view.getWidth() / 2) : (float)(view.getWidth() / 2)));
                float pivotY = "top".equals(y) ? 0.0f : ("bottom".equals(y) ? (float)view.getHeight() : ("center".equals(y) ? (float)(view.getHeight() / 2) : (float)(view.getHeight() / 2)));
                return new Pair((Object)Float.valueOf(pivotX), (Object)Float.valueOf(pivotY));
            }
        }
        return null;
    }

    public static double getDoubleValue(Map<String, Object> map, String key, double defaultValue) {
        if (map == null || TextUtils.isEmpty((CharSequence)key)) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (Throwable e) {
                return defaultValue;
            }
        }
        try {
            return Double.valueOf(value.toString());
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static double getDoubleValue(Map<String, Object> map, String key) {
        return Utils.getDoubleValue(map, key, 0.0);
    }

    public static boolean getBooleanValue(Map<String, Object> map, String key, boolean defaultValue) {
        if (map == null || TextUtils.isEmpty((CharSequence)key)) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            try {
                return Boolean.parseBoolean((String)value);
            }
            catch (Throwable e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanValue(Map<String, Object> map, String key) {
        return Utils.getBooleanValue(map, key, false);
    }

    public static Map<String, Object> getMapValue(Map<String, Object> map, String key) {
        if (map == null || TextUtils.isEmpty((CharSequence)key)) {
            return Collections.emptyMap();
        }
        Object value = map.get(key);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        return Collections.emptyMap();
    }
}

