/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.view.animation.Interpolator;
import com.alibaba.android.bindingx.core.internal.JSFunctionInterface;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.json.JSONException;

@Keep
public class TimingFunctions {
    private static final InnerCache<BezierInterpolatorWrapper> cache = new InnerCache(4);

    private TimingFunctions() {
    }

    public static Object linear() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return c * (t / d) + b;
            }
        };
    }

    public static Object cubicBezier() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                double x1 = (Double)arguments.get(4);
                double y1 = (Double)arguments.get(5);
                double x2 = (Double)arguments.get(6);
                double y2 = (Double)arguments.get(7);
                if ((t = Math.min(t, d)) == d) {
                    return b + c;
                }
                BezierInterpolatorWrapper bezierInterpolator = TimingFunctions.isCacheHit((float)x1, (float)y1, (float)x2, (float)y2);
                if (bezierInterpolator == null) {
                    bezierInterpolator = new BezierInterpolatorWrapper((float)x1, (float)y1, (float)x2, (float)y2);
                    cache.add(bezierInterpolator);
                }
                float input = (float)(t / d);
                return c * (double)bezierInterpolator.getInterpolation(input) + b;
            }
        };
    }

    @Nullable
    private static BezierInterpolatorWrapper isCacheHit(float x1, float y1, float x2, float y2) {
        Deque<BezierInterpolatorWrapper> deque = cache.getAll();
        for (BezierInterpolatorWrapper bezier : deque) {
            if (Float.compare(bezier.x1, x1) != 0 || Float.compare(bezier.x2, x2) != 0 || Float.compare(bezier.y1, y1) != 0 || Float.compare(bezier.y2, y2) != 0) continue;
            return bezier;
        }
        return null;
    }

    public static Object easeInQuad() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return c * (t /= d) * t + b;
            }
        };
    }

    public static Object easeOutQuad() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return -c * (t /= d) * (t - 2.0) + b;
            }
        };
    }

    public static Object easeInOutQuad() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double d;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d2 = (Double)arguments.get(3);
                t = Math.min(t, d2);
                t /= d2 / 2.0;
                if (d < 1.0) {
                    return c / 2.0 * t * t + b;
                }
                return -c / 2.0 * ((t -= 1.0) * (t - 2.0) - 1.0) + b;
            }
        };
    }

    public static Object easeInCubic() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return c * (t /= d) * t * t + b;
            }
        };
    }

    public static Object easeOutCubic() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                t = t / d - 1.0;
                return c * (t * t * t + 1.0) + b;
            }
        };
    }

    public static Object easeInOutCubic() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double d;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d2 = (Double)arguments.get(3);
                t = Math.min(t, d2);
                t /= d2 / 2.0;
                if (d < 1.0) {
                    return c / 2.0 * t * t * t + b;
                }
                return c / 2.0 * ((t -= 2.0) * t * t + 2.0) + b;
            }
        };
    }

    public static Object easeInQuart() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return c * (t /= d) * t * t * t + b;
            }
        };
    }

    public static Object easeOutQuart() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                t = t / d - 1.0;
                return -c * (t * t * t * t - 1.0) + b;
            }
        };
    }

    public static Object easeInOutQuart() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double d;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d2 = (Double)arguments.get(3);
                t = Math.min(t, d2);
                t /= d2 / 2.0;
                if (d < 1.0) {
                    return c / 2.0 * t * t * t * t + b;
                }
                return -c / 2.0 * ((t -= 2.0) * t * t * t - 2.0) + b;
            }
        };
    }

    public static Object easeInQuint() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return c * (t /= d) * t * t * t * t + b;
            }
        };
    }

    public static Object easeOutQuint() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                t = t / d - 1.0;
                return c * (t * t * t * t * t + 1.0) + b;
            }
        };
    }

    public static Object easeInOutQuint() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double d;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d2 = (Double)arguments.get(3);
                t = Math.min(t, d2);
                t /= d2 / 2.0;
                if (d < 1.0) {
                    return c / 2.0 * t * t * t * t * t + b;
                }
                return c / 2.0 * ((t -= 2.0) * t * t * t * t + 2.0) + b;
            }
        };
    }

    public static Object easeInSine() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return -c * Math.cos(t / d * 1.5707963267948966) + c + b;
            }
        };
    }

    public static Object easeOutSine() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return c * Math.sin(t / d * 1.5707963267948966) + b;
            }
        };
    }

    public static Object easeInOutSine() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return -c / 2.0 * (Math.cos(Math.PI * t / d) - 1.0) + b;
            }
        };
    }

    public static Object easeInExpo() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                return (t = Math.min(t, d)) == 0.0 ? b : c * Math.pow(2.0, 10.0 * (t / d - 1.0)) + b;
            }
        };
    }

    public static Object easeOutExpo() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                return (t = Math.min(t, d)) == d ? b + c : c * (-Math.pow(2.0, -10.0 * t / d) + 1.0) + b;
            }
        };
    }

    public static Object easeInOutExpo() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double d;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d2 = (Double)arguments.get(3);
                if ((t = Math.min(t, d2)) == 0.0) {
                    return b;
                }
                if (t == d2) {
                    return b + c;
                }
                t /= d2 / 2.0;
                if (d < 1.0) {
                    return c / 2.0 * Math.pow(2.0, 10.0 * (t - 1.0)) + b;
                }
                return c / 2.0 * (-Math.pow(2.0, -10.0 * (t -= 1.0)) + 2.0) + b;
            }
        };
    }

    public static Object easeInCirc() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return -c * (Math.sqrt(1.0 - (t /= d) * t) - 1.0) + b;
            }
        };
    }

    public static Object easeOutCirc() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                t = t / d - 1.0;
                return c * Math.sqrt(1.0 - t * t) + b;
            }
        };
    }

    public static Object easeInOutCirc() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double d;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d2 = (Double)arguments.get(3);
                t = Math.min(t, d2);
                t /= d2 / 2.0;
                if (d < 1.0) {
                    return -c / 2.0 * (Math.sqrt(1.0 - t * t) - 1.0) + b;
                }
                return c / 2.0 * (Math.sqrt(1.0 - (t -= 2.0) * t) + 1.0) + b;
            }
        };
    }

    public static Object easeInElastic() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double s;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                double a = c;
                if (t == 0.0) {
                    return b;
                }
                if ((t /= d) == 1.0) {
                    return b + c;
                }
                double p = d * 0.3;
                if (a < Math.abs(c)) {
                    a = c;
                    s = p / 4.0;
                } else {
                    s = p / (Math.PI * 2) * Math.asin(c / a);
                }
                return -(a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
            }
        };
    }

    public static Object easeOutElastic() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                double s;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                double a = c;
                if (t == 0.0) {
                    return b;
                }
                if ((t /= d) == 1.0) {
                    return b + c;
                }
                double p = d * 0.3;
                if (a < Math.abs(c)) {
                    a = c;
                    s = p / 4.0;
                } else {
                    s = p / (Math.PI * 2) * Math.asin(c / a);
                }
                return a * Math.pow(2.0, -10.0 * t) * Math.sin((t * d - s) * (Math.PI * 2) / p) + c + b;
            }
        };
    }

    public static Object easeInOutElastic() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) {
                double s;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                double a = c;
                if (t == 0.0) {
                    return b;
                }
                if ((t /= d / 2.0) == 2.0) {
                    return b + c;
                }
                double p = d * 0.44999999999999996;
                if (a < Math.abs(c)) {
                    a = c;
                    s = p / 4.0;
                } else {
                    s = p / (Math.PI * 2) * Math.asin(c / a);
                }
                if (t < 1.0) {
                    return -0.5 * (a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
                }
                return a * Math.pow(2.0, -10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p) * 0.5 + c + b;
            }
        };
    }

    public static Object easeInBack() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                double s = 1.70158;
                return c * (t /= d) * t * ((s + 1.0) * t - s) + b;
            }
        };
    }

    public static Object easeOutBack() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                double s = 1.70158;
                t = t / d - 1.0;
                return c * (t * t * ((s + 1.0) * t + s) + 1.0) + b;
            }
        };
    }

    public static Object easeInOutBack() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double d;
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d2 = (Double)arguments.get(3);
                t = Math.min(t, d2);
                double s = 1.70158;
                t /= d2 / 2.0;
                if (d < 1.0) {
                    return c / 2.0 * (t * t * (((s *= 1.525) + 1.0) * t - s)) + b;
                }
                return c / 2.0 * ((t -= 2.0) * t * (((s *= 1.525) + 1.0) * t + s) + 2.0) + b;
            }
        };
    }

    public static Object easeInBounce() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return TimingFunctions.easeInBounce(t, b, c, d);
            }
        };
    }

    public static Object easeOutBounce() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                t = Math.min(t, d);
                return TimingFunctions.easeOutBounce(t, b, c, d);
            }
        };
    }

    public static Object easeInOutBounce() {
        return new JSFunctionInterface(){

            @Override
            public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
                double t = (Double)arguments.get(0);
                double b = (Double)arguments.get(1);
                double c = (Double)arguments.get(2);
                double d = (Double)arguments.get(3);
                if ((t = Math.min(t, d)) < d / 2.0) {
                    return TimingFunctions.easeInBounce(t * 2.0, 0.0, c, d) * 0.5 + b;
                }
                return TimingFunctions.easeOutBounce(t * 2.0 - d, 0.0, c, d) * 0.5 + c * 0.5 + b;
            }
        };
    }

    private static double easeInBounce(double t, double b, double c, double d) {
        return c - TimingFunctions.easeOutBounce(d - t, 0.0, c, d) + b;
    }

    private static double easeOutBounce(double t, double b, double c, double d) {
        double d2;
        t /= d;
        if (d2 < 0.36363636363636365) {
            return c * (7.5625 * t * t) + b;
        }
        if (t < 0.7272727272727273) {
            return c * (7.5625 * (t -= 0.5454545454545454) * t + 0.75) + b;
        }
        if (t < 0.9090909090909091) {
            return c * (7.5625 * (t -= 0.8181818181818182) * t + 0.9375) + b;
        }
        return c * (7.5625 * (t -= 0.9545454545454546) * t + 0.984375) + b;
    }

    private static class BezierInterpolatorWrapper
    implements Interpolator {
        float x1;
        float y1;
        float x2;
        float y2;
        private Interpolator mInnerInterpolator;

        BezierInterpolatorWrapper(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.mInnerInterpolator = PathInterpolatorCompat.create((float)x1, (float)y1, (float)x2, (float)y2);
        }

        public float getInterpolation(float input) {
            return this.mInnerInterpolator.getInterpolation(input);
        }
    }

    private static class InnerCache<T> {
        private final ArrayDeque<T> deque;

        InnerCache(int size) {
            this.deque = new ArrayDeque(size);
        }

        void add(T t) {
            if (this.deque.size() >= 4) {
                this.deque.removeFirst();
                this.deque.addLast(t);
            } else {
                this.deque.addLast(t);
            }
        }

        Deque<T> getAll() {
            return this.deque;
        }
    }
}

