/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.support.annotation.NonNull;
import android.view.animation.AnimationUtils;
import com.alibaba.android.bindingx.core.internal.AnimationFrame;
import java.util.Map;

abstract class PhysicsAnimationDriver
implements AnimationFrame.Callback {
    private AnimationFrame mAnimationFrame;
    protected OnAnimationUpdateListener mAnimationUpdateListener;
    protected OnAnimationEndListener mAnimationEndListener;
    protected double mValue;
    protected double mVelocity;
    protected boolean mHasFinished;

    PhysicsAnimationDriver() {
    }

    abstract void onAnimationStart(@NonNull Map<String, Object> var1);

    abstract void runAnimationStep(long var1);

    abstract boolean isAtRest();

    void setOnAnimationUpdateListener(OnAnimationUpdateListener listener) {
        this.mAnimationUpdateListener = listener;
    }

    void setOnAnimationEndListener(OnAnimationEndListener listener) {
        this.mAnimationEndListener = listener;
    }

    void start(@NonNull Map<String, Object> configMap) {
        this.onAnimationStart(configMap);
        if (this.mAnimationFrame == null) {
            this.mAnimationFrame = AnimationFrame.newInstance();
        }
        this.mAnimationFrame.requestAnimationFrame(this);
    }

    void cancel() {
        if (this.mAnimationFrame != null) {
            this.mAnimationFrame.clear();
        }
        this.mHasFinished = false;
    }

    boolean hasFinished() {
        return this.mHasFinished;
    }

    double getCurrentValue() {
        return this.mValue;
    }

    double getCurrentVelocity() {
        return this.mVelocity;
    }

    @Override
    public void doFrame() {
        this.runAnimationStep(AnimationUtils.currentAnimationTimeMillis());
        if (this.mAnimationUpdateListener != null) {
            this.mAnimationUpdateListener.onAnimationUpdate(this, this.mValue, this.mVelocity);
        }
        if (this.hasFinished()) {
            if (this.mAnimationEndListener != null) {
                this.mAnimationEndListener.onAnimationEnd(this, this.mValue, this.mVelocity);
            }
            if (this.mAnimationFrame != null) {
                this.mAnimationFrame.clear();
            }
        }
    }

    static interface OnAnimationEndListener {
        public void onAnimationEnd(@NonNull PhysicsAnimationDriver var1, double var2, double var4);
    }

    static interface OnAnimationUpdateListener {
        public void onAnimationUpdate(@NonNull PhysicsAnimationDriver var1, double var2, double var4);
    }
}

