/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractEventHandler;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import com.alibaba.android.bindingx.core.internal.JSMath;
import com.alibaba.android.bindingx.core.internal.PhysicsAnimationDriver;
import com.alibaba.android.bindingx.core.internal.SpringAnimationDriver;
import com.alibaba.android.bindingx.core.internal.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BindingXSpringHandler
extends AbstractEventHandler
implements PhysicsAnimationDriver.OnAnimationUpdateListener,
PhysicsAnimationDriver.OnAnimationEndListener {
    private SpringAnimationDriver mSpringAnimationDriver;

    public BindingXSpringHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
    }

    @Override
    public void onBindExpression(@NonNull String eventType, @Nullable Map<String, Object> globalConfig, @Nullable ExpressionPair exitExpressionPair, @NonNull List<Map<String, Object>> expressionArgs, @Nullable BindingXCore.JavaScriptCallback callback) {
        super.onBindExpression(eventType, globalConfig, exitExpressionPair, expressionArgs, callback);
        double velocity = 0.0;
        double position = 0.0;
        if (this.mSpringAnimationDriver != null) {
            velocity = this.mSpringAnimationDriver.getCurrentVelocity();
            position = this.mSpringAnimationDriver.getCurrentValue();
            this.mSpringAnimationDriver.cancel();
        }
        this.mSpringAnimationDriver = new SpringAnimationDriver();
        this.mSpringAnimationDriver.setOnAnimationUpdateListener(this);
        this.mSpringAnimationDriver.setOnAnimationEndListener(this);
        this.mSpringAnimationDriver.start(this.resolveParams(this.mOriginParams, position, velocity));
        this.fireEventByState("start", this.mSpringAnimationDriver.getCurrentValue(), this.mSpringAnimationDriver.getCurrentVelocity(), new Object[0]);
    }

    private Map<String, Object> resolveParams(Map<String, Object> originalParams, double position, double velocity) {
        if (originalParams == null) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = Utils.getMapValue(originalParams, "eventConfig");
        if (map.get("initialVelocity") == null) {
            if (map.isEmpty()) {
                map = new HashMap<String, Object>();
            }
            map.put("initialVelocity", velocity);
        }
        if (map.get("fromValue") == null) {
            if (map.isEmpty()) {
                map = new HashMap<String, Object>();
            }
            map.put("fromValue", position);
        }
        return map;
    }

    @Override
    protected void onExit(@NonNull Map<String, Object> scope) {
        double p = (Double)scope.get("p");
        double v = (Double)scope.get("v");
        this.fireEventByState("exit", p, v, new Object[0]);
        if (this.mSpringAnimationDriver != null) {
            this.mSpringAnimationDriver.cancel();
        }
    }

    private void fireEventByState(String state, double position, double velocity, Object ... extension) {
        if (this.mCallback != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("state", state);
            param.put("position", position);
            param.put("velocity", velocity);
            param.put("token", this.mToken);
            if (extension != null && extension.length > 0 && extension[0] instanceof Map) {
                param.putAll((Map)extension[0]);
            }
            this.mCallback.callback(param);
            LogProxy.d(">>>>>>>>>>>fire event:(" + state + ",position:" + position + ",velocity:" + velocity + ")");
        }
    }

    @Override
    protected void onUserIntercept(String interceptorName, @NonNull Map<String, Object> scope) {
        if (this.mSpringAnimationDriver != null) {
            this.fireEventByState("interceptor", this.mSpringAnimationDriver.getCurrentValue(), this.mSpringAnimationDriver.getCurrentVelocity(), Collections.singletonMap("interceptor", interceptorName));
        }
    }

    @Override
    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        return true;
    }

    @Override
    public void onStart(@NonNull String sourceRef, @NonNull String eventType) {
    }

    @Override
    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        this.clearExpressions();
        if (this.mSpringAnimationDriver != null) {
            this.fireEventByState("end", this.mSpringAnimationDriver.getCurrentValue(), this.mSpringAnimationDriver.getCurrentVelocity(), new Object[0]);
            this.mSpringAnimationDriver.setOnAnimationEndListener(null);
            this.mSpringAnimationDriver.setOnAnimationUpdateListener(null);
            this.mSpringAnimationDriver.cancel();
        }
        return true;
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }

    @Override
    public void onAnimationUpdate(@NonNull PhysicsAnimationDriver driver, double value, double velocity) {
        if (LogProxy.sEnableLog) {
            LogProxy.v(String.format(Locale.getDefault(), "animation update, [value: %f, velocity: %f]", value, velocity));
        }
        try {
            JSMath.applySpringValueToScope(this.mScope, value, velocity);
            if (!this.evaluateExitExpression(this.mExitExpressionPair, this.mScope)) {
                this.consumeExpression(this.mExpressionHoldersMap, this.mScope, "spring");
            }
        }
        catch (Exception e) {
            LogProxy.e("runtime error", e);
        }
    }

    @Override
    public void onAnimationEnd(@NonNull PhysicsAnimationDriver driver, double value, double velocity) {
        if (LogProxy.sEnableLog) {
            LogProxy.v(String.format(Locale.getDefault(), "animation end, [value: %f, velocity: %f]", value, velocity));
        }
        this.fireEventByState("end", this.mSpringAnimationDriver.getCurrentValue(), this.mSpringAnimationDriver.getCurrentVelocity(), new Object[0]);
    }
}

