/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.Choreographer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

abstract class AnimationFrame {
    AnimationFrame() {
    }

    static AnimationFrame newInstance() {
        AnimationFrame frame = null;
        frame = Build.VERSION.SDK_INT >= 16 ? new ChoreographerAnimationFrameImpl() : new HandlerAnimationFrameImpl();
        return frame;
    }

    abstract void clear();

    abstract void terminate();

    abstract void requestAnimationFrame(@NonNull Callback var1);

    private static class HandlerAnimationFrameImpl
    extends AnimationFrame
    implements Handler.Callback {
        private Handler mInnerHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        private Callback callback;
        private boolean isRunning;
        private static final int MSG_FRAME_CALLBACK = 100;
        private static final long DEFAULT_DELAY_MILLIS = 16L;

        HandlerAnimationFrameImpl() {
        }

        @Override
        void clear() {
            if (this.mInnerHandler != null) {
                this.mInnerHandler.removeCallbacksAndMessages(null);
            }
            this.isRunning = false;
        }

        @Override
        void terminate() {
            this.clear();
            this.mInnerHandler = null;
        }

        @Override
        void requestAnimationFrame(@NonNull Callback callback) {
            this.callback = callback;
            this.isRunning = true;
            if (this.mInnerHandler != null) {
                this.mInnerHandler.sendEmptyMessage(100);
            }
        }

        public boolean handleMessage(Message msg) {
            if (msg != null && msg.what == 100 && this.mInnerHandler != null) {
                if (this.callback != null) {
                    this.callback.doFrame();
                }
                if (this.isRunning) {
                    this.mInnerHandler.sendEmptyMessageDelayed(100, 16L);
                }
                return true;
            }
            return false;
        }
    }

    @TargetApi(value=16)
    private static class ChoreographerAnimationFrameImpl
    extends AnimationFrame
    implements Choreographer.FrameCallback {
        private Choreographer choreographer;
        private Callback callback;
        private boolean isRunning;

        @TargetApi(value=16)
        ChoreographerAnimationFrameImpl() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                final CountDownLatch latch = new CountDownLatch(1);
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        ChoreographerAnimationFrameImpl.this.choreographer = Choreographer.getInstance();
                        latch.countDown();
                    }
                });
                try {
                    boolean result = latch.await(500L, TimeUnit.MILLISECONDS);
                    if (!result) {
                        this.choreographer = Choreographer.getInstance();
                    }
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.choreographer = Choreographer.getInstance();
            }
        }

        @Override
        void clear() {
            if (this.choreographer != null) {
                this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            }
            this.isRunning = false;
        }

        @Override
        void terminate() {
            this.clear();
            this.choreographer = null;
        }

        @Override
        void requestAnimationFrame(@NonNull Callback callback) {
            this.callback = callback;
            this.isRunning = true;
            if (this.choreographer != null) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }

        public void doFrame(long frameTimeNanos) {
            if (this.callback != null) {
                this.callback.doFrame();
            }
            if (this.choreographer != null && this.isRunning) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }
    }

    static interface Callback {
        public void doFrame();
    }
}

