/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import java.util.Map;

public class PlatformManager {
    private IDeviceResolutionTranslator mResolutionTranslator;
    private IViewFinder mViewFinder;
    private IViewUpdater mViewUpdater;
    private IScrollFactory mScrollFactory;

    private PlatformManager() {
    }

    @NonNull
    public IDeviceResolutionTranslator getResolutionTranslator() {
        return this.mResolutionTranslator;
    }

    @NonNull
    public IViewFinder getViewFinder() {
        return this.mViewFinder;
    }

    @NonNull
    public IViewUpdater getViewUpdater() {
        return this.mViewUpdater;
    }

    @Nullable
    public IScrollFactory getScrollFactory() {
        return this.mScrollFactory;
    }

    public static class Builder {
        private IDeviceResolutionTranslator deviceResolutionTranslator;
        private IViewFinder viewFinder;
        private IViewUpdater viewUpdater;
        private IScrollFactory scrollFactory;

        public PlatformManager build() {
            PlatformManager factory = new PlatformManager();
            factory.mViewFinder = this.viewFinder;
            factory.mResolutionTranslator = this.deviceResolutionTranslator;
            factory.mViewUpdater = this.viewUpdater;
            factory.mScrollFactory = this.scrollFactory;
            return factory;
        }

        public Builder withDeviceResolutionTranslator(@NonNull IDeviceResolutionTranslator translator) {
            this.deviceResolutionTranslator = translator;
            return this;
        }

        public Builder withViewFinder(@NonNull IViewFinder finder) {
            this.viewFinder = finder;
            return this;
        }

        public Builder withViewUpdater(@NonNull IViewUpdater viewUpdater) {
            this.viewUpdater = viewUpdater;
            return this;
        }

        public Builder withScrollFactory(@Nullable IScrollFactory scrollFactory) {
            this.scrollFactory = scrollFactory;
            return this;
        }
    }

    public static interface ScrollListener {
        public void onScrolled(float var1, float var2);

        public void onScrollStart();

        public void onScrollEnd(float var1, float var2);
    }

    public static interface IScrollFactory {
        public void addScrollListenerWith(@NonNull String var1, @NonNull ScrollListener var2);

        public void removeScrollListenerWith(@NonNull String var1, @NonNull ScrollListener var2);
    }

    public static interface IViewUpdater {
        public void synchronouslyUpdateViewOnUIThread(@NonNull View var1, @NonNull String var2, @NonNull Object var3, @NonNull IDeviceResolutionTranslator var4, @NonNull Map<String, Object> var5, Object ... var6);
    }

    public static interface IViewFinder {
        @Nullable
        public View findViewBy(String var1, Object ... var2);
    }

    public static interface IDeviceResolutionTranslator {
        public double webToNative(double var1, Object ... var3);

        public double nativeToWeb(double var1, Object ... var3);
    }
}

