/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction;

import com.ql.util.express.CallResult;
import com.ql.util.express.ExecuteTimeout;
import com.ql.util.express.ExpressLoader;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.instruction.IOperateDataCache;
import com.ql.util.express.instruction.opdata.OperateDataArrayItem;
import com.ql.util.express.instruction.opdata.OperateDataAttr;
import com.ql.util.express.instruction.opdata.OperateDataField;
import com.ql.util.express.instruction.opdata.OperateDataKeyValue;
import com.ql.util.express.instruction.opdata.OperateDataLocalVar;

public class OperateDataCacheImpl
implements IOperateDataCache {
    private final OperateData[] dataList;
    private final OperateDataAttr[] attrList;
    private final OperateDataLocalVar[] localVarList;
    private final OperateDataField[] fieldList;
    private final OperateDataArrayItem[] arrayList;
    private final OperateDataKeyValue[] keyValueList;
    private final RunEnvironment[] environmentList;
    private final CallResult[] callResultList;
    private final InstructionSetContext[] contextList;
    private int dataPoint = 0;
    private int attrPoint = 0;
    private int localVarPoint = 0;
    private int fieldPoint = 0;
    private int arrayPoint = 0;
    private int keyValuePoint = 0;
    private int environmentPoint = 0;
    private int callResultPoint = 0;
    private int contextPoint = 0;
    private final int length;

    public OperateDataCacheImpl(int len) {
        this.length = len;
        this.dataList = new OperateData[len];
        this.attrList = new OperateDataAttr[len];
        this.localVarList = new OperateDataLocalVar[len];
        this.fieldList = new OperateDataField[len];
        this.arrayList = new OperateDataArrayItem[len];
        this.keyValueList = new OperateDataKeyValue[len];
        this.callResultList = new CallResult[len];
        this.environmentList = new RunEnvironment[len];
        this.contextList = new InstructionSetContext[len];
        for (int i = 0; i < len; ++i) {
            this.dataList[i] = new OperateData(null, null);
            this.attrList[i] = new OperateDataAttr(null, null);
            this.localVarList[i] = new OperateDataLocalVar(null, null);
            this.fieldList[i] = new OperateDataField((Object)null, null);
            this.arrayList[i] = new OperateDataArrayItem(null, -1);
            this.keyValueList[i] = new OperateDataKeyValue(null, null);
            this.callResultList[i] = new CallResult(null, false);
            this.environmentList[i] = new RunEnvironment(null, null, false, ExecuteTimeout.NO_TIMEOUT);
            this.contextList[i] = new InstructionSetContext(false, null, null, null, false);
        }
    }

    @Override
    public void resetCache() {
        int i;
        for (i = 0; i <= this.dataPoint && i < this.length; ++i) {
            this.dataList[i].clear();
        }
        for (i = 0; i <= this.attrPoint && i < this.length; ++i) {
            this.attrList[i].clearDataAttr();
        }
        for (i = 0; i <= this.localVarPoint && i < this.length; ++i) {
            this.localVarList[i].clearDataLocalVar();
        }
        for (i = 0; i <= this.fieldPoint && i < this.length; ++i) {
            this.fieldList[i].clearDataField();
        }
        for (i = 0; i <= this.arrayPoint && i < this.length; ++i) {
            this.arrayList[i].clearDataArrayItem();
        }
        for (i = 0; i <= this.keyValuePoint && i < this.length; ++i) {
            this.keyValueList[i].clearDataKeyValue();
        }
        for (i = 0; i <= this.callResultPoint && i < this.length; ++i) {
            this.callResultList[i].clear();
        }
        for (i = 0; i <= this.environmentPoint && i < this.length; ++i) {
            this.environmentList[i].clear();
        }
        for (i = 0; i <= this.contextPoint && i < this.length; ++i) {
            this.contextList[i].clear();
        }
        this.dataPoint = 0;
        this.attrPoint = 0;
        this.localVarPoint = 0;
        this.fieldPoint = 0;
        this.arrayPoint = 0;
        this.keyValuePoint = 0;
        this.callResultPoint = 0;
        this.environmentPoint = 0;
        this.contextPoint = 0;
    }

    @Override
    public InstructionSetContext fetchInstructionSetContext(boolean isExpandToParent, ExpressRunner expressRunner, IExpressContext<String, Object> parent, ExpressLoader expressLoader, boolean isSupportDynamicFieldName) {
        InstructionSetContext result;
        if (this.contextPoint < this.length) {
            result = this.contextList[this.contextPoint];
            result.initial(isExpandToParent, expressRunner, parent, expressLoader, isSupportDynamicFieldName);
            ++this.contextPoint;
        } else {
            result = new InstructionSetContext(isExpandToParent, expressRunner, parent, expressLoader, isSupportDynamicFieldName);
        }
        return result;
    }

    @Override
    public RunEnvironment fetRunEnvironment(InstructionSet instructionSet, InstructionSetContext instructionSetContext, boolean isTrace, ExecuteTimeout executeTimeOut) {
        RunEnvironment result;
        if (this.environmentPoint < this.length) {
            result = this.environmentList[this.environmentPoint];
            result.initial(instructionSet, instructionSetContext, isTrace, executeTimeOut);
            ++this.environmentPoint;
        } else {
            result = new RunEnvironment(instructionSet, instructionSetContext, isTrace, executeTimeOut);
        }
        return result;
    }

    @Override
    public CallResult fetchCallResult(Object returnValue, boolean isExit) {
        CallResult result;
        if (this.callResultPoint < this.length) {
            result = this.callResultList[this.callResultPoint];
            result.initial(returnValue, isExit);
            ++this.callResultPoint;
        } else {
            result = new CallResult(returnValue, isExit);
        }
        return result;
    }

    @Override
    public OperateData fetchOperateData(Object obj, Class<?> type) {
        OperateData result;
        if (this.dataPoint < this.length) {
            result = this.dataList[this.dataPoint];
            result.initial(obj, type);
            ++this.dataPoint;
        } else {
            result = new OperateData(obj, type);
        }
        return result;
    }

    @Override
    public OperateDataAttr fetchOperateDataAttr(String name, Class<?> type) {
        OperateDataAttr result;
        if (this.attrPoint < this.length) {
            result = this.attrList[this.attrPoint];
            result.initialDataAttr(name, type);
            ++this.attrPoint;
        } else {
            result = new OperateDataAttr(name, type);
        }
        return result;
    }

    @Override
    public OperateDataLocalVar fetchOperateDataLocalVar(String name, Class<?> type) {
        OperateDataLocalVar result;
        if (this.localVarPoint < this.length) {
            result = this.localVarList[this.localVarPoint];
            result.initialDataLocalVar(name, type);
            ++this.localVarPoint;
        } else {
            result = new OperateDataLocalVar(name, type);
        }
        return result;
    }

    @Override
    public OperateDataField fetchOperateDataField(Object fieldObject, String fieldName) {
        OperateDataField result;
        if (this.fieldPoint < this.length) {
            result = this.fieldList[this.fieldPoint];
            result.initialDataField(fieldObject, fieldName);
            ++this.fieldPoint;
        } else {
            result = new OperateDataField(fieldObject, fieldName);
        }
        return result;
    }

    @Override
    public OperateDataArrayItem fetchOperateDataArrayItem(OperateData operateData, int index) {
        OperateDataArrayItem result;
        if (this.arrayPoint < this.length) {
            result = this.arrayList[this.arrayPoint];
            result.initialDataArrayItem(operateData, index);
            ++this.arrayPoint;
        } else {
            result = new OperateDataArrayItem(operateData, index);
        }
        return result;
    }

    @Override
    public OperateDataKeyValue fetchOperateDataKeyValue(OperateData key, OperateData value) {
        OperateDataKeyValue result;
        if (this.keyValuePoint < this.length) {
            result = this.keyValueList[this.keyValuePoint];
            result.initialDataKeyValue(key, value);
            ++this.keyValuePoint;
        } else {
            result = new OperateDataKeyValue(key, value);
        }
        return result;
    }

    @Override
    public long getFetchCount() {
        return 0L;
    }
}

