/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncBaseIndex;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.responses.SearchSynonymResult;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface AsyncSynonyms<T>
extends AsyncBaseIndex<T> {
    default public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content) {
        return this.saveSynonym(synonymID, content, false, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, @Nonnull RequestOptions requestOptions) {
        return this.saveSynonym(synonymID, content, false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas) {
        return this.saveSynonym(synonymID, content, forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().saveSynonym(this.getName(), synonymID, content, forwardToReplicas, requestOptions);
    }

    default public CompletableFuture<Optional<AbstractSynonym>> getSynonym(@Nonnull String synonymID) {
        return this.getSynonym(synonymID, new RequestOptions());
    }

    default public CompletableFuture<Optional<AbstractSynonym>> getSynonym(@Nonnull String synonymID, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getSynonym(this.getName(), synonymID, requestOptions);
    }

    default public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID) {
        return this.deleteSynonym(synonymID, false);
    }

    default public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID, @Nonnull RequestOptions requestOptions) {
        return this.deleteSynonym(synonymID, false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas) {
        return this.deleteSynonym(synonymID, forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().deleteSynonym(this.getName(), synonymID, forwardToReplicas, requestOptions);
    }

    default public CompletableFuture<AsyncTask> clearSynonyms() {
        return this.clearSynonyms(false);
    }

    default public CompletableFuture<AsyncTask> clearSynonyms(@Nonnull RequestOptions requestOptions) {
        return this.clearSynonyms(false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> clearSynonyms(boolean forwardToReplicas) {
        return this.clearSynonyms(forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> clearSynonyms(boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().clearSynonyms(this.getName(), forwardToReplicas, requestOptions);
    }

    default public CompletableFuture<SearchSynonymResult> searchSynonyms(@Nonnull SynonymQuery query) {
        return this.searchSynonyms(query, new RequestOptions());
    }

    default public CompletableFuture<SearchSynonymResult> searchSynonyms(@Nonnull SynonymQuery query, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().searchSynonyms(this.getName(), query, requestOptions);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms) {
        return this.batchSynonyms(synonyms, forwardToReplicas, replaceExistingSynonyms, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().batchSynonyms(this.getName(), synonyms, forwardToReplicas, replaceExistingSynonyms, requestOptions);
    }

    default public CompletableFuture<AsyncTask> replaceAllSynonyms(@Nonnull List<AbstractSynonym> synonyms) {
        return this.replaceAllSynonyms(synonyms, false, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> replaceAllSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas) {
        return this.replaceAllSynonyms(synonyms, forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> replaceAllSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.batchSynonyms(synonyms, forwardToReplicas, true, requestOptions);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas) {
        return this.batchSynonyms(synonyms, forwardToReplicas, false);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.batchSynonyms(synonyms, forwardToReplicas, false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms) {
        return this.batchSynonyms(synonyms, false, false);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, @Nonnull RequestOptions requestOptions) {
        return this.batchSynonyms(synonyms, false, false, requestOptions);
    }
}

