/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncBaseIndex;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.objects.tasks.async.AsyncTaskIndexing;
import com.algolia.search.objects.tasks.async.AsyncTaskSingleIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public interface AsyncObjects<T>
extends AsyncBaseIndex<T> {
    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull T object) {
        return this.addObject(object, new RequestOptions());
    }

    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull T object, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().addObject(this.getName(), object, requestOptions);
    }

    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull String objectID, @Nonnull T object) {
        return this.addObject(objectID, object, new RequestOptions());
    }

    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().addObject(this.getName(), objectID, object, requestOptions);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> addObjects(@Nonnull List<T> objects) {
        return this.addObjects(objects, new RequestOptions());
    }

    default public CompletableFuture<AsyncTaskSingleIndex> addObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().addObjects(this.getName(), objects, requestOptions);
    }

    default public CompletableFuture<Optional<T>> getObject(@Nonnull String objectID) {
        return this.getObject(objectID, new RequestOptions());
    }

    default public CompletableFuture<Optional<T>> getObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getObject(this.getName(), objectID, this.getKlass(), requestOptions);
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs) {
        return this.getObjects(objectIDs, new RequestOptions());
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getObjects(this.getName(), objectIDs, this.getKlass(), requestOptions);
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) {
        return this.getObjects(objectIDs, attributesToRetrieve, new RequestOptions());
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getObjects(this.getName(), objectIDs, attributesToRetrieve, this.getKlass(), requestOptions);
    }

    default public CompletableFuture<AsyncTask> saveObject(@Nonnull String objectID, @Nonnull T object) {
        return this.saveObject(objectID, object, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> saveObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().saveObject(this.getName(), objectID, object, requestOptions);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> saveObjects(@Nonnull List<T> objects) {
        return this.saveObjects(objects, new RequestOptions());
    }

    default public CompletableFuture<AsyncTaskSingleIndex> saveObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().saveObjects(this.getName(), objects, requestOptions);
    }

    default public void replaceAllObjects(@Nonnull Iterable<T> objects, boolean safe) throws ExecutionException, InterruptedException {
        this.replaceAllObjects(objects, safe, new RequestOptions());
    }

    default public void replaceAllObjects(@Nonnull Iterable<T> objects, boolean safe, @Nonnull RequestOptions requestOptions) throws ExecutionException, InterruptedException {
        String tmpName = this.getName() + "_tmp_" + UUID.randomUUID().toString();
        ArrayList<String> scope = new ArrayList<String>(Arrays.asList("rules", "settings", "synonyms"));
        ArrayList<Object> batchResponses = new ArrayList<Object>();
        AsyncTask copyIndexResponse = this.getApiClient().copyIndex(this.getName(), tmpName, scope, requestOptions).get();
        if (safe) {
            this.getApiClient().waitTask(copyIndexResponse);
        }
        ArrayList<T> records = new ArrayList<T>();
        for (T t : objects) {
            if (records.size() == 1000) {
                AsyncTaskSingleIndex batchResponse = this.getApiClient().saveObjects(tmpName, records, requestOptions).get();
                if (safe) {
                    batchResponses.add(batchResponse);
                }
                records.clear();
            }
            records.add(t);
        }
        if (records.size() > 0) {
            AsyncTaskSingleIndex batchResponse = this.getApiClient().saveObjects(tmpName, records, requestOptions).get();
            batchResponses.add(batchResponse);
        }
        if (safe) {
            for (AsyncTaskSingleIndex asyncTaskSingleIndex : batchResponses) {
                this.getApiClient().waitTask(asyncTaskSingleIndex);
            }
        }
        AsyncTask moveIndexResponse = this.getApiClient().moveIndex(tmpName, this.getName(), requestOptions).get();
        if (safe) {
            this.getApiClient().waitTask(moveIndexResponse);
        }
    }

    default public CompletableFuture<AsyncTask> deleteObject(@Nonnull String objectID) {
        return this.deleteObject(objectID, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> deleteObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().deleteObject(this.getName(), objectID, requestOptions);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> deleteObjects(@Nonnull List<String> objectIDs) {
        return this.deleteObjects(objectIDs, new RequestOptions());
    }

    default public CompletableFuture<AsyncTaskSingleIndex> deleteObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().deleteObjects(this.getName(), objectIDs, requestOptions);
    }
}

