/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncAPIClient;
import com.algolia.search.AsyncUserInsightsClient;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.AlgoliaRequestKind;
import com.algolia.search.http.HttpMethod;
import com.algolia.search.inputs.insights.InsightsEvent;
import com.algolia.search.inputs.insights.InsightsRequest;
import com.algolia.search.inputs.insights.InsightsResult;
import com.algolia.search.objects.InsightsConfig;
import com.algolia.search.objects.RequestOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AsyncInsightsClient {
    private AsyncAPIClient client;
    private InsightsConfig config;
    private String host;

    public AsyncInsightsClient(@Nonnull String applicationId, @Nonnull String apiKey, @Nonnull AsyncAPIClient client) {
        this(applicationId, apiKey, "us", client);
    }

    public AsyncInsightsClient(@Nonnull String applicationId, @Nonnull String apiKey, @Nonnull String region, @Nonnull AsyncAPIClient client) {
        this(new InsightsConfig().setApplicationId(applicationId).setApiKey(apiKey).setRegion(region), client);
    }

    public AsyncInsightsClient(@Nonnull InsightsConfig config, @Nonnull AsyncAPIClient client) {
        this.config = config;
        this.client = client;
        this.host = "insights." + config.getRegion() + ".algolia.io";
    }

    public AsyncUserInsightsClient user(@Nonnull String userToken) {
        return new AsyncUserInsightsClient(userToken, this);
    }

    public CompletableFuture<InsightsResult> sendEvent(@Nonnull InsightsEvent event) {
        List<InsightsEvent> events = Collections.singletonList(event);
        return this.sendEvents(events, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> sendEvent(@Nonnull InsightsEvent event, @Nonnull RequestOptions requestOptions) {
        List<InsightsEvent> events = Collections.singletonList(event);
        return this.sendEvents(events, requestOptions);
    }

    public CompletableFuture<InsightsResult> sendEvents(@Nonnull List<InsightsEvent> events) {
        return this.sendEvents(events, new RequestOptions());
    }

    public CompletableFuture<InsightsResult> sendEvents(@Nonnull List<InsightsEvent> events, @Nonnull RequestOptions requestOptions) {
        InsightsRequest request = new InsightsRequest().setEvents(events);
        return this.client.httpClient.requestInsights(new AlgoliaRequest<InsightsResult>(HttpMethod.POST, AlgoliaRequestKind.INSIGHTS_API, Arrays.asList("1", "events"), requestOptions, InsightsResult.class).setData(request), this.host);
    }
}

