/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncAPIClientConfiguration;
import com.algolia.search.AsyncAnalytics;
import com.algolia.search.AsyncIndex;
import com.algolia.search.Index;
import com.algolia.search.Utils;
import com.algolia.search.exceptions.AlgoliaEncodingException;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.exceptions.AlgoliaIndexNotFoundException;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.AlgoliaRequestKind;
import com.algolia.search.http.AsyncAlgoliaHttpClient;
import com.algolia.search.http.HttpMethod;
import com.algolia.search.inputs.ApiKeys;
import com.algolia.search.inputs.Batch;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.inputs.BatchOperations;
import com.algolia.search.inputs.MultipleGetObjectsRequests;
import com.algolia.search.inputs.MultipleQueriesRequests;
import com.algolia.search.inputs.OperationOnIndex;
import com.algolia.search.inputs.Requests;
import com.algolia.search.inputs.analytics.ABTest;
import com.algolia.search.inputs.batch.BatchAddObjectOperation;
import com.algolia.search.inputs.batch.BatchDeleteObjectOperation;
import com.algolia.search.inputs.batch.BatchPartialUpdateObjectNoCreateOperation;
import com.algolia.search.inputs.batch.BatchPartialUpdateObjectOperation;
import com.algolia.search.inputs.batch.BatchUpdateObjectOperation;
import com.algolia.search.inputs.partial_update.PartialUpdateOperation;
import com.algolia.search.inputs.personalization.StrategyRequest;
import com.algolia.search.inputs.query_rules.Rule;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.ApiKey;
import com.algolia.search.objects.Cluster;
import com.algolia.search.objects.IndexQuery;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Log;
import com.algolia.search.objects.LogType;
import com.algolia.search.objects.MultiQueriesStrategy;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.RuleQuery;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.UserID;
import com.algolia.search.objects.tasks.async.AsyncGenericTask;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.objects.tasks.async.AsyncTaskABTest;
import com.algolia.search.objects.tasks.async.AsyncTaskIndexing;
import com.algolia.search.objects.tasks.async.AsyncTaskSingleIndex;
import com.algolia.search.objects.tasks.async.AsyncTasksMultipleIndex;
import com.algolia.search.responses.ABTests;
import com.algolia.search.responses.AssignUserID;
import com.algolia.search.responses.BrowseResult;
import com.algolia.search.responses.Clusters;
import com.algolia.search.responses.CreateUpdateKey;
import com.algolia.search.responses.DeleteKey;
import com.algolia.search.responses.DeleteUserID;
import com.algolia.search.responses.Indices;
import com.algolia.search.responses.Logs;
import com.algolia.search.responses.MultiQueriesResult;
import com.algolia.search.responses.RestoreApiKey;
import com.algolia.search.responses.Results;
import com.algolia.search.responses.SearchFacetResult;
import com.algolia.search.responses.SearchResult;
import com.algolia.search.responses.SearchRuleResult;
import com.algolia.search.responses.SearchSynonymResult;
import com.algolia.search.responses.SearchUserIDs;
import com.algolia.search.responses.TaskStatus;
import com.algolia.search.responses.TopUserResult;
import com.algolia.search.responses.UserIDs;
import com.algolia.search.responses.personalization.GetStrategyResult;
import com.algolia.search.responses.personalization.SetStrategyResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AsyncAPIClient {
    protected final AsyncAlgoliaHttpClient httpClient;
    protected final AsyncAPIClientConfiguration configuration;
    protected final Executor executor;

    AsyncAPIClient(AsyncAlgoliaHttpClient httpClient, AsyncAPIClientConfiguration configuration) {
        this.httpClient = httpClient;
        this.configuration = configuration;
        this.executor = configuration.getExecutorService();
    }

    public void close() throws AlgoliaException {
        this.httpClient.close();
    }

    public CompletableFuture<List<Index.Attributes>> listIndices() {
        return this.listIndices(new RequestOptions());
    }

    public CompletableFuture<List<Index.Attributes>> listIndices(@Nonnull RequestOptions requestOptions) {
        CompletableFuture<Indices> result = this.httpClient.requestWithRetry(new AlgoliaRequest<Indices>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes"), requestOptions, Indices.class));
        return result.thenApply(Indices::getItems);
    }

    public <T> AsyncIndex<T> initIndex(@Nonnull String name, @Nonnull Class<T> klass) {
        return new AsyncIndex<T>(name, klass, this);
    }

    public AsyncAnalytics initAnalytics() {
        return new AsyncAnalytics(this);
    }

    public AsyncIndex<?> initIndex(@Nonnull String name) {
        return new AsyncIndex<Object>(name, Object.class, this);
    }

    public CompletableFuture<AsyncTask> moveIndex(@Nonnull String srcIndexName, @Nonnull String dstIndexName) {
        return this.moveIndex(srcIndexName, dstIndexName, new RequestOptions());
    }

    public CompletableFuture<AsyncTask> moveIndex(@Nonnull String srcIndexName, @Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", srcIndexName, "operation"), requestOptions, AsyncTask.class).setData(new OperationOnIndex("move", dstIndexName))).thenApply(s -> s.setIndex(srcIndexName));
    }

    public CompletableFuture<AsyncTask> copyIndex(@Nonnull String srcIndexName, @Nonnull String dstIndexName) {
        return this.copyIndex(srcIndexName, dstIndexName, null, new RequestOptions());
    }

    public CompletableFuture<AsyncTask> copyIndex(@Nonnull String srcIndexName, @Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) {
        return this.copyIndex(srcIndexName, dstIndexName, null, requestOptions);
    }

    public CompletableFuture<AsyncTask> copyIndex(@Nonnull String srcIndexName, @Nonnull String dstIndexName, List<String> scope, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", srcIndexName, "operation"), requestOptions, AsyncTask.class).setData(new OperationOnIndex("copy", dstIndexName, scope))).thenApply(s -> s.setIndex(srcIndexName));
    }

    public CompletableFuture<AsyncTask> copyIndex(@Nonnull String srcIndexName, @Nonnull String dstIndexName, @Nonnull List<String> scope) {
        return this.copyIndex(srcIndexName, dstIndexName, scope, new RequestOptions());
    }

    public CompletableFuture<AsyncTask> copySynonyms(@Nonnull String srcIndexName, @Nonnull String dstIndexName) {
        return this.copySynonyms(srcIndexName, dstIndexName, new RequestOptions());
    }

    public CompletableFuture<AsyncTask> copySynonyms(@Nonnull String srcIndexName, @Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) {
        ArrayList<String> scope = new ArrayList<String>(Collections.singletonList("synonyms"));
        return this.copyIndex(srcIndexName, dstIndexName, scope, requestOptions);
    }

    public CompletableFuture<AsyncTask> copyRules(@Nonnull String srcIndexName, @Nonnull String dstIndexName) {
        return this.copyRules(srcIndexName, dstIndexName, new RequestOptions());
    }

    public CompletableFuture<AsyncTask> copyRules(@Nonnull String srcIndexName, @Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) {
        ArrayList<String> scope = new ArrayList<String>(Collections.singletonList("rules"));
        return this.copyIndex(srcIndexName, dstIndexName, scope, requestOptions);
    }

    public CompletableFuture<AsyncTask> copySettings(@Nonnull String srcIndexName, @Nonnull String dstIndexName) {
        return this.copySettings(srcIndexName, dstIndexName, new RequestOptions());
    }

    public CompletableFuture<AsyncTask> copySettings(@Nonnull String srcIndexName, @Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) {
        ArrayList<String> scope = new ArrayList<String>(Collections.singletonList("settings"));
        return this.copyIndex(srcIndexName, dstIndexName, scope, requestOptions);
    }

    public CompletableFuture<List<Log>> getLogs() {
        return this.getLogs(new RequestOptions());
    }

    public CompletableFuture<List<Log>> getLogs(@Nonnull RequestOptions requestOptions) {
        CompletableFuture<Logs> result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "logs"), requestOptions, Logs.class));
        return result.thenApply(Logs::getLogs);
    }

    public CompletableFuture<List<Log>> getLogs(@Nonnull Integer offset, @Nonnull Integer length, @Nonnull LogType logType) {
        return this.getLogs(offset, length, logType, new RequestOptions());
    }

    public CompletableFuture<List<Log>> getLogs(@Nonnull Integer offset, @Nonnull Integer length, @Nonnull LogType logType, @Nonnull RequestOptions requestOptions) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset must be >= 0, was %s", (Object)offset);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length must be >= 0, was %s", (Object)length);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("offset", offset.toString());
        parameters.put("length", length.toString());
        parameters.put("type", logType.getName());
        CompletableFuture<Logs> result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "logs"), requestOptions, Logs.class).setParameters(parameters));
        return result.thenApply(Logs::getLogs);
    }

    @Deprecated
    public CompletableFuture<List<ApiKey>> listKeys() {
        return this.listApiKeys();
    }

    public CompletableFuture<List<ApiKey>> listApiKeys() {
        return this.listApiKeys(new RequestOptions());
    }

    public CompletableFuture<List<ApiKey>> listApiKeys(@Nonnull RequestOptions requestOptions) {
        CompletableFuture<ApiKeys> result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "keys"), requestOptions, ApiKeys.class));
        return result.thenApply(ApiKeys::getKeys);
    }

    @Deprecated
    public CompletableFuture<Optional<ApiKey>> getKey(@Nonnull String key) {
        return this.getApiKey(key);
    }

    public CompletableFuture<Optional<ApiKey>> getApiKey(@Nonnull String key) {
        return this.getApiKey(key, new RequestOptions());
    }

    public CompletableFuture<Optional<ApiKey>> getApiKey(@Nonnull String key, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "keys", key), requestOptions, ApiKey.class)).thenApply(Optional::ofNullable);
    }

    @Deprecated
    public CompletableFuture<DeleteKey> deleteKey(@Nonnull String key) {
        return this.deleteApiKey(key);
    }

    public CompletableFuture<DeleteKey> deleteApiKey(@Nonnull String key) {
        return this.deleteApiKey(key, new RequestOptions());
    }

    public CompletableFuture<DeleteKey> deleteApiKey(@Nonnull String key, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "keys", key), requestOptions, DeleteKey.class));
    }

    public CompletableFuture<RestoreApiKey> restoreApiKey(@Nonnull String key) {
        return this.restoreApiKey(key, new RequestOptions());
    }

    public CompletableFuture<RestoreApiKey> restoreApiKey(@Nonnull String key, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<RestoreApiKey>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "keys", key, "restore"), requestOptions, RestoreApiKey.class));
    }

    @Deprecated
    public CompletableFuture<CreateUpdateKey> addKey(@Nonnull ApiKey key) {
        return this.addApiKey(key);
    }

    public CompletableFuture<CreateUpdateKey> addApiKey(@Nonnull ApiKey key) {
        return this.addApiKey(key, new RequestOptions());
    }

    public CompletableFuture<CreateUpdateKey> addApiKey(@Nonnull ApiKey key, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "keys"), requestOptions, CreateUpdateKey.class).setData(key));
    }

    @Deprecated
    public CompletableFuture<CreateUpdateKey> updateKey(@Nonnull String keyName, @Nonnull ApiKey key) {
        return this.updateApiKey(keyName, key);
    }

    public CompletableFuture<CreateUpdateKey> updateApiKey(@Nonnull String keyName, @Nonnull ApiKey key) {
        return this.updateApiKey(keyName, key, new RequestOptions());
    }

    public CompletableFuture<CreateUpdateKey> updateApiKey(@Nonnull String keyName, @Nonnull ApiKey key, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "keys", keyName), requestOptions, CreateUpdateKey.class).setData(key));
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query) throws AlgoliaException {
        return this.generateSecuredApiKey(privateApiKey, query, null);
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query, String userToken) throws AlgoliaException {
        return Utils.generateSecuredApiKey(privateApiKey, query, userToken);
    }

    public <T> void waitTask(@Nonnull AsyncGenericTask<T> task) {
        this.waitTask(task, 100L, new RequestOptions());
    }

    public <T> void waitTask(@Nonnull AsyncGenericTask<T> task, long timeToWait) {
        this.waitTask(task, timeToWait, new RequestOptions());
    }

    public <T> void waitTask(@Nonnull AsyncGenericTask<T> task, long timeToWait, @Nonnull RequestOptions requestOptions) {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (long)timeToWait);
        while (true) {
            TaskStatus result;
            CompletableFuture<TaskStatus> status = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskStatus>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", task.getIndexName(), "task", task.getTaskIDToWaitFor().toString()), requestOptions, TaskStatus.class));
            try {
                result = status.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                break;
            }
            if (Objects.equals("published", result.getStatus())) {
                return;
            }
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeToWait = (timeToWait *= 2L) > 10000L ? 10000L : timeToWait;
        }
    }

    public CompletableFuture<AsyncTasksMultipleIndex> batch(@Nonnull List<BatchOperation> operations) {
        return this.batch(operations, new RequestOptions());
    }

    public CompletableFuture<AsyncTasksMultipleIndex> batch(@Nonnull List<BatchOperation> operations, @Nonnull RequestOptions requestOptions) {
        boolean atLeastOneHaveIndexNameNull = operations.stream().anyMatch(o -> o.getIndexName() == null);
        if (atLeastOneHaveIndexNameNull) {
            return Utils.completeExceptionally(new AlgoliaException("All batch operations must have an index name set"));
        }
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTasksMultipleIndex>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", "*", "batch"), requestOptions, AsyncTasksMultipleIndex.class).setData(new BatchOperations(operations))).thenApply(AsyncTasksMultipleIndex::computeIndex);
    }

    public CompletableFuture<List<Map<String, String>>> multipleGetObjects(@Nonnull List<MultipleGetObjectsRequests> requests) {
        return this.multipleGetObjects(requests, new RequestOptions());
    }

    public CompletableFuture<List<Map<String, String>>> multipleGetObjects(@Nonnull List<MultipleGetObjectsRequests> requests, @Nonnull RequestOptions requestsOptions) {
        return this.multiGetObjects(requests, requestsOptions);
    }

    public CompletableFuture<MultiQueriesResult> multipleQueries(@Nonnull List<IndexQuery> queries) {
        return this.multipleQueries(queries, MultiQueriesStrategy.NONE);
    }

    public CompletableFuture<MultiQueriesResult> multipleQueries(@Nonnull List<IndexQuery> queries, @Nonnull RequestOptions requestOptions) {
        return this.multipleQueries(queries, MultiQueriesStrategy.NONE, requestOptions);
    }

    public CompletableFuture<MultiQueriesResult> multipleQueries(@Nonnull List<IndexQuery> queries, @Nonnull MultiQueriesStrategy strategy) {
        return this.multipleQueries(queries, strategy, new RequestOptions());
    }

    public CompletableFuture<MultiQueriesResult> multipleQueries(@Nonnull List<IndexQuery> queries, @Nonnull MultiQueriesStrategy strategy, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<MultiQueriesResult>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", "*", "queries"), requestOptions, MultiQueriesResult.class).setData(new MultipleQueriesRequests(queries)).setParameters((Map<String, String>)ImmutableMap.of((Object)"strategy", (Object)strategy.getName())));
    }

    public CompletableFuture<AsyncTask> deleteIndex(@Nonnull String indexName) {
        return this.deleteIndex(indexName, new RequestOptions());
    }

    public CompletableFuture<AsyncTask> deleteIndex(@Nonnull String indexName, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.DELETE, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName), requestOptions, AsyncTask.class)).thenApply(s -> s.setIndex(indexName));
    }

    public <T> CompletableFuture<BrowseResult<T>> browse(String indexName, Query query, String cursor, Class<T> klass, RequestOptions requestOptions) {
        AlgoliaRequest<BrowseResult> algoliaRequest = new AlgoliaRequest<BrowseResult>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", indexName, "browse"), requestOptions, BrowseResult.class, klass).setData(query.setCursor(cursor));
        return this.httpClient.requestWithRetry(algoliaRequest).thenCompose(result -> {
            CompletableFuture<BrowseResult> r = new CompletableFuture<BrowseResult>();
            r.complete((BrowseResult)result);
            return r;
        });
    }

    <T> CompletableFuture<AsyncTaskIndexing> addObject(String indexName, T object, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskIndexing>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName), requestOptions, AsyncTaskIndexing.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<AsyncTaskIndexing> addObject(String indexName, String objectID, T object, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskIndexing>(HttpMethod.PUT, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, AsyncTaskIndexing.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<Optional<T>> getObject(String indexName, String objectID, Class<T> klass, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<T>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, klass)).thenApply(Optional::ofNullable);
    }

    <T> CompletableFuture<AsyncTaskSingleIndex> addObjects(String indexName, List<T> objects, RequestOptions requestOptions) {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchAddObjectOperation::new).collect(Collectors.toList()), requestOptions).thenApply(s -> s.setIndex(indexName));
    }

    private CompletableFuture<AsyncTaskSingleIndex> batchSingleIndex(String indexName, List<BatchOperation> operations, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "batch"), requestOptions, AsyncTaskSingleIndex.class).setData(new Batch(operations))).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<AsyncTask> saveObject(String indexName, String objectID, T object, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.PUT, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, AsyncTask.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<AsyncTaskSingleIndex> saveObjects(String indexName, List<T> objects, RequestOptions requestOptions) {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchUpdateObjectOperation::new).collect(Collectors.toList()), requestOptions).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> deleteObject(String indexName, String objectID, RequestOptions requestOptions) {
        if (objectID.trim().length() == 0) {
            throw new IllegalArgumentException("ObjectID must not be empty");
        }
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.DELETE, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, objectID), requestOptions, AsyncTask.class)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> deleteObjects(String indexName, List<String> objectIDs, RequestOptions requestOptions) {
        return this.batchSingleIndex(indexName, objectIDs.stream().map(BatchDeleteObjectOperation::new).collect(Collectors.toList()), requestOptions).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> clearIndex(String indexName, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "clear"), requestOptions, AsyncTask.class)).thenApply(s -> s.setIndex(indexName));
    }

    <T> CompletableFuture<List<T>> multiGetObjects(List<MultipleGetObjectsRequests> request, RequestOptions requestOptions) {
        Requests requests = new Requests(request.stream().map(o -> new Requests.Request().setIndexName(o.getIndexName()).setObjectID(o.getObjectID())).collect(Collectors.toList()));
        AlgoliaRequest<Results> algoliaRequest = new AlgoliaRequest<Results>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", "*", "objects"), requestOptions, Results.class).setData(requests);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(requests)).thenApply(Results::getResults);
    }

    <T> CompletableFuture<List<T>> getObjects(String indexName, List<String> objectIDs, Class<T> klass, RequestOptions requestOptions) {
        Requests requests = new Requests(objectIDs.stream().map(o -> new Requests.Request().setIndexName(indexName).setObjectID((String)o)).collect(Collectors.toList()));
        AlgoliaRequest<Results> algoliaRequest = new AlgoliaRequest<Results>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", "*", "objects"), requestOptions, Results.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(requests)).thenApply(Results::getResults);
    }

    <T> CompletableFuture<List<T>> getObjects(String indexName, List<String> objectIDs, List<String> attributesToRetrieve, Class<T> klass, RequestOptions requestOptions) {
        String encodedAttributesToRetrieve = String.join((CharSequence)",", attributesToRetrieve);
        Requests requests = new Requests(objectIDs.stream().map(o -> new Requests.Request().setIndexName(indexName).setObjectID((String)o).setAttributesToRetrieve(encodedAttributesToRetrieve)).collect(Collectors.toList()));
        AlgoliaRequest<Results> algoliaRequest = new AlgoliaRequest<Results>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", "*", "objects"), requestOptions, Results.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(requests)).thenApply(Results::getResults);
    }

    CompletableFuture<IndexSettings> getSettings(String indexName, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<IndexSettings>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", indexName, "settings"), requestOptions, IndexSettings.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"getVersion", (Object)"2")));
    }

    CompletableFuture<AsyncTask> setSettings(String indexName, IndexSettings settings, Boolean forwardToReplicas, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.PUT, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "settings"), requestOptions, AsyncTask.class).setData(settings).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<List<ApiKey>> listKeys(String indexName, RequestOptions requestOptions) {
        CompletableFuture<ApiKeys> result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "keys"), requestOptions, ApiKeys.class));
        return result.thenApply(ApiKeys::getKeys);
    }

    CompletableFuture<Optional<ApiKey>> getKey(String indexName, String key, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "keys", key), requestOptions, ApiKey.class)).thenApply(Optional::ofNullable);
    }

    CompletableFuture<DeleteKey> deleteKey(String indexName, String key, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "keys", key), requestOptions, DeleteKey.class));
    }

    CompletableFuture<CreateUpdateKey> addKey(String indexName, ApiKey key, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "keys"), requestOptions, CreateUpdateKey.class).setData(key));
    }

    CompletableFuture<CreateUpdateKey> updateApiKey(String indexName, String keyName, ApiKey key, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "keys", keyName), requestOptions, CreateUpdateKey.class).setData(key));
    }

    <T> CompletableFuture<SearchResult<T>> search(String indexName, Query query, Class<T> klass, RequestOptions requestOptions) {
        AlgoliaRequest<SearchResult> algoliaRequest = new AlgoliaRequest<SearchResult>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", indexName, "query"), requestOptions, SearchResult.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(query)).thenCompose(result -> {
            CompletableFuture<SearchResult> r = new CompletableFuture<SearchResult>();
            if (result == null) {
                r.completeExceptionally(new AlgoliaIndexNotFoundException(indexName + " does not exist"));
            } else {
                r.complete((SearchResult)result);
            }
            return r;
        });
    }

    CompletableFuture<AsyncTaskSingleIndex> batch(String indexName, List<BatchOperation> operations, RequestOptions requestOptions) {
        boolean onSameIndex = operations.stream().allMatch(o -> Objects.equals(null, o.getIndexName()));
        if (!onSameIndex) {
            Utils.completeExceptionally(new AlgoliaException("All operations are not on the same index"));
        }
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "batch"), requestOptions, AsyncTaskSingleIndex.class).setData(new BatchOperations(operations))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> partialUpdateObject(String indexName, PartialUpdateOperation operation, Boolean createIfNotExists, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, operation.getObjectID(), "partial"), requestOptions, AsyncTaskSingleIndex.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"createIfNotExists", (Object)createIfNotExists.toString())).setData(operation.toSerialize())).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> partialUpdateObject(String indexName, String objectID, Object object, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTaskSingleIndex>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, objectID, "partial"), requestOptions, AsyncTaskSingleIndex.class).setData(object)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> saveSynonym(String indexName, String synonymID, AbstractSynonym content, Boolean forwardToReplicas, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.PUT, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())).setData(content)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<Optional<AbstractSynonym>> getSynonym(String indexName, String synonymID, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AbstractSynonym>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), requestOptions, AbstractSynonym.class)).thenApply(Optional::ofNullable);
    }

    CompletableFuture<AsyncTask> deleteSynonym(String indexName, String synonymID, Boolean forwardToReplicas, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.DELETE, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> clearSynonyms(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "synonyms", "clear"), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<SearchSynonymResult> searchSynonyms(String indexName, SynonymQuery query, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchSynonymResult>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "synonyms", "search"), requestOptions, SearchSynonymResult.class).setData(query));
    }

    CompletableFuture<AsyncTask> batchSynonyms(String indexName, List<AbstractSynonym> synonyms, Boolean forwardToReplicas, Boolean replaceExistingSynonyms, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "synonyms", "batch"), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString(), (Object)"replaceExistingSynonyms", (Object)replaceExistingSynonyms.toString())).setData(synonyms)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskSingleIndex> partialUpdateObjects(String indexName, List<Object> objects, boolean createIfNotExists, RequestOptions requestOptions) {
        return this.batch(indexName, objects.stream().map(createIfNotExists ? BatchPartialUpdateObjectOperation::new : BatchPartialUpdateObjectNoCreateOperation::new).collect(Collectors.toList()), requestOptions).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<SearchFacetResult> searchForFacetValues(String indexName, String facetName, String facetQuery, Query query, RequestOptions requestOptions) {
        query = query == null ? new Query() : query;
        query = (Query)query.addCustomParameter("facetQuery", facetQuery);
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchFacetResult>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "indexes", indexName, "facets", facetName, "query"), requestOptions, SearchFacetResult.class).setData(query));
    }

    CompletableFuture<AsyncTask> saveRule(String indexName, String queryRuleID, Rule queryRule, Boolean forwardToReplicas, RequestOptions requestOptions) {
        if (queryRuleID.isEmpty()) {
            CompletableFuture<AsyncTask> f = new CompletableFuture<AsyncTask>();
            f.completeExceptionally(new AlgoliaException("Cannot save rule with empty queryRuleID"));
            return f;
        }
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.PUT, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "rules", queryRuleID), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString())).setData(queryRule)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<Optional<Rule>> getRule(String indexName, String queryRuleID, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<Rule>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "rules", queryRuleID), requestOptions, Rule.class)).thenApply(Optional::ofNullable);
    }

    CompletableFuture<AsyncTask> deleteRule(String indexName, String queryRuleID, Boolean forwardToReplicas, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.DELETE, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "rules", queryRuleID), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> clearRules(String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "rules", "clear"), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString()))).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<SearchRuleResult> searchRules(String indexName, RuleQuery query, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchRuleResult>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "rules", "search"), requestOptions, SearchRuleResult.class).setData(query));
    }

    CompletableFuture<AsyncTask> batchRules(String indexName, List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "rules", "batch"), requestOptions, AsyncTask.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToReplicas", (Object)forwardToReplicas.toString(), (Object)"clearExistingRules", (Object)clearExistingRules.toString())).setData(rules)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTask> deleteBy(String indexName, Query query, RequestOptions requestOptions) {
        query = query == null ? new Query() : query;
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AsyncTask>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "indexes", indexName, "deleteByQuery"), requestOptions, AsyncTask.class).setData(query)).thenApply(s -> s.setIndex(indexName));
    }

    CompletableFuture<AsyncTaskABTest> addABTest(ABTest abtest) {
        return this.httpClient.requestAnalytics(new AlgoliaRequest<AsyncTaskABTest>(HttpMethod.POST, AlgoliaRequestKind.ANALYTICS_API, Arrays.asList("2", "abtests"), new RequestOptions(), AsyncTaskABTest.class).setData(abtest));
    }

    CompletableFuture<AsyncTaskABTest> stopABTest(long id) {
        return this.httpClient.requestAnalytics(new AlgoliaRequest<AsyncTaskABTest>(HttpMethod.POST, AlgoliaRequestKind.ANALYTICS_API, Arrays.asList("2", "abtests", Long.toString(id), "stop"), new RequestOptions(), AsyncTaskABTest.class));
    }

    CompletableFuture<AsyncTaskABTest> deleteABTest(long id) {
        return this.httpClient.requestAnalytics(new AlgoliaRequest<AsyncTaskABTest>(HttpMethod.DELETE, AlgoliaRequestKind.ANALYTICS_API, Arrays.asList("2", "abtests", Long.toString(id)), new RequestOptions(), AsyncTaskABTest.class));
    }

    CompletableFuture<ABTest> getABTest(long id) {
        return this.httpClient.requestAnalytics(new AlgoliaRequest<ABTest>(HttpMethod.GET, AlgoliaRequestKind.ANALYTICS_API, Arrays.asList("2", "abtests", Long.toString(id)), new RequestOptions(), ABTest.class));
    }

    CompletableFuture<ABTests> getABTests(int offset, int limit) {
        return this.httpClient.requestAnalytics(new AlgoliaRequest<ABTests>(HttpMethod.GET, AlgoliaRequestKind.ANALYTICS_API, Arrays.asList("2", "abtests"), new RequestOptions(), ABTests.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"offset", (Object)Integer.toString(offset), (Object)"limit", (Object)Integer.toString(limit))));
    }

    public CompletableFuture<List<Cluster>> listClusters() {
        return this.listClusters(new RequestOptions());
    }

    public CompletableFuture<List<Cluster>> listClusters(@Nonnull RequestOptions requestOptions) {
        CompletableFuture<Clusters> result = this.httpClient.requestWithRetry(new AlgoliaRequest<Clusters>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "clusters"), requestOptions, Clusters.class));
        return result.thenApply(Clusters::getClusters);
    }

    public CompletableFuture<UserIDs> listUserIDs() {
        return this.listUserIDs(0, 20, new RequestOptions());
    }

    public CompletableFuture<UserIDs> listUserIDs(Integer page, Integer hitsPerPage) {
        return this.listUserIDs(page, hitsPerPage, new RequestOptions());
    }

    public CompletableFuture<UserIDs> listUserIDs(@Nonnull Integer page, @Nonnull Integer hitsPerPage, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<UserIDs>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "clusters", "mapping"), requestOptions, UserIDs.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"page", (Object)page.toString(), (Object)"hitsPerPage", (Object)hitsPerPage.toString())));
    }

    public CompletableFuture<Map<String, List<UserID>>> getTopUserID() {
        return this.getTopUserID(new RequestOptions());
    }

    public CompletableFuture<Map<String, List<UserID>>> getTopUserID(RequestOptions requestOptions) {
        CompletableFuture<TopUserResult> result = this.httpClient.requestWithRetry(new AlgoliaRequest<TopUserResult>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "clusters", "mapping", "top"), requestOptions, TopUserResult.class));
        return result.thenApply(TopUserResult::getTopUsers);
    }

    public CompletableFuture<AssignUserID> assignUserID(@Nonnull String userID, @Nonnull String clusterName) {
        return this.assignUserID(userID, clusterName, new RequestOptions());
    }

    public CompletableFuture<AssignUserID> assignUserID(@Nonnull String userID, @Nonnull String clusterName, RequestOptions requestOptions) {
        requestOptions.addExtraHeader("X-Algolia-User-ID", userID);
        return this.httpClient.requestWithRetry(new AlgoliaRequest<AssignUserID>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "clusters", "mapping"), requestOptions, AssignUserID.class).setData(ImmutableMap.of((Object)"cluster", (Object)clusterName)));
    }

    public CompletableFuture<UserID> getUserID(@Nonnull String userID) {
        return this.getUserID(userID, new RequestOptions());
    }

    public CompletableFuture<UserID> getUserID(@Nonnull String userID, RequestOptions requestOptions) {
        String encodedUserID = "";
        try {
            encodedUserID = URLEncoder.encode(userID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            CompletableFuture.supplyAsync(() -> new AlgoliaEncodingException("cannot encode given userID", e));
        }
        return this.httpClient.requestWithRetry(new AlgoliaRequest<UserID>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "clusters", "mapping", encodedUserID), requestOptions, UserID.class));
    }

    public CompletableFuture<DeleteUserID> removeUserID(@Nonnull String userID) {
        return this.removeUserID(userID, new RequestOptions());
    }

    public CompletableFuture<DeleteUserID> removeUserID(@Nonnull String userID, RequestOptions requestOptions) {
        requestOptions.addExtraHeader("X-Algolia-User-ID", userID);
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteUserID>(HttpMethod.DELETE, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "clusters", "mapping"), requestOptions, DeleteUserID.class));
    }

    public CompletableFuture<SearchUserIDs> searchUserIDs(@Nonnull String query, @Nonnull String clusterName) {
        return this.searchUserIDs(query, clusterName, new RequestOptions());
    }

    public CompletableFuture<SearchUserIDs> searchUserIDs(@Nonnull String query, @Nonnull String clusterName, RequestOptions requestOptions) {
        return this.searchUserIDs(query, clusterName, 0, 20, requestOptions);
    }

    public CompletableFuture<SearchUserIDs> searchUserIDs(@Nonnull String query, @Nonnull String clusterName, int page, int hitsPerPage) {
        return this.searchUserIDs(query, clusterName, page, hitsPerPage, new RequestOptions());
    }

    public CompletableFuture<SearchUserIDs> searchUserIDs(@Nonnull String query, @Nonnull String clusterName, int page, int hitsPerPage, RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchUserIDs>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "clusters", "mapping", "search"), requestOptions, SearchUserIDs.class).setData(ImmutableMap.of((Object)"query", (Object)query, (Object)"cluster", (Object)clusterName, (Object)"page", (Object)page, (Object)"hitsPerPage", (Object)hitsPerPage)));
    }

    public CompletableFuture<GetStrategyResult> getPersonalizationStrategy() {
        return this.getPersonalizationStrategy(new RequestOptions());
    }

    public CompletableFuture<GetStrategyResult> getPersonalizationStrategy(@Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<GetStrategyResult>(HttpMethod.GET, AlgoliaRequestKind.SEARCH_API_READ, Arrays.asList("1", "recommendation", "personalization", "strategy"), requestOptions, GetStrategyResult.class));
    }

    public CompletableFuture<SetStrategyResult> setPersonalizationStrategy(@Nonnull StrategyRequest request) {
        return this.setPersonalizationStrategy(request, new RequestOptions());
    }

    public CompletableFuture<SetStrategyResult> setPersonalizationStrategy(@Nonnull StrategyRequest request, @Nonnull RequestOptions requestOptions) {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SetStrategyResult>(HttpMethod.POST, AlgoliaRequestKind.SEARCH_API_WRITE, Arrays.asList("1", "recommendation", "personalization", "strategy"), requestOptions, SetStrategyResult.class).setData(request));
    }
}

