/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatistics;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatus;
import Alachisoft.NCache.Common.Monitoring.ClientNode;
import Alachisoft.NCache.Common.Monitoring.ClientProcessStats;
import Alachisoft.NCache.Common.Monitoring.ConfiguredCacheInfo;
import Alachisoft.NCache.Common.Monitoring.EventViewerEvent;
import Alachisoft.NCache.Common.Monitoring.Node;
import Alachisoft.NCache.Common.Monitoring.ServerNode;
import Alachisoft.NCache.Common.RPCFramework.TargetMethodAttribute;
import Alachisoft.NCache.Common.Util.CPUUsage;
import Alachisoft.NCache.Management.CacheServer;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class MonitorServer {
    private static ArrayList<ServerNode> _runningServerNodes = new ArrayList();
    private static CPUUsage _cpuUsage = null;
    private static Object _sync_lock = new Object();
    private static Object _syncLockCPUUsage = new Object();
    private Node[] _totalServerNodes;
    private String _cacheId;

    @TargetMethodAttribute(privateMethod="InitializeMonitor", privateOverload=1)
    public final void Initialize(String cacheId) {
        this._cacheId = cacheId;
    }

    @TargetMethodAttribute(privateMethod="GetCacheStatistics", privateOverload=1)
    public final CacheNodeStatistics[] GetCacheStatistics() throws GeneralFailureException, OperationFailedException, CacheException {
        return CacheServer.getInstance().GetCacheStatistics(this._cacheId);
    }

    @TargetMethodAttribute(privateMethod="GetClusterNIC", privateOverload=1)
    public final String GetClusterNIC() throws GeneralFailureException, OperationFailedException, CacheException {
        CacheNodeStatistics stats;
        CacheNodeStatistics[] statsList = CacheServer.getInstance().GetCacheStatistics(this._cacheId);
        if (statsList != null && statsList.length > 0 && ((stats = statsList[0]).getStatus() == CacheNodeStatus.Running || stats.getStatus() == CacheNodeStatus.InStateTransfer)) {
            return this.GetNICForIP(stats.getNode().getAddress().getIpAddress().toString());
        }
        return null;
    }

    @TargetMethodAttribute(privateMethod="GetSocketServerNIC", privateOverload=1)
    public final String GetSocketServerNIC() {
        InetAddress ip = null;
        if (CacheServer.getInstance() != null && CacheServer.getInstance().getRenderer() != null) {
            ip = CacheServer.getInstance().getRenderer().getIPAddress();
        }
        return ip != null ? this.GetNICForIP(ip.toString()) : null;
    }

    @TargetMethodAttribute(privateMethod="GetNICForIP", privateOverload=1)
    public final String GetNICForIP(String ip) {
        if (ip == null) {
            return null;
        }
        String nic = null;
        try {
            NetworkInterface.getByInetAddress(InetAddress.getByName(ip));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nic;
    }

    @TargetMethodAttribute(privateMethod="RegisterEventViewerEvents", privateOverload=1)
    public final void RegisterEventViewerEvents(String[] sources) {
        this.UnRegisterEventViewerEvents();
    }

    @TargetMethodAttribute(privateMethod="UnRegisterEventViewerEvents", privateOverload=1)
    public final void UnRegisterEventViewerEvents() {
    }

    @TargetMethodAttribute(privateMethod="GetLatestEvents", privateOverload=1)
    public final EventViewerEvent[] GetLatestEvents() {
        EventViewerEvent[] eventList = new EventViewerEvent[EventLogger.getEventList().length];
        eventList = EventLogger.getEventList();
        EventLogger.clearEvents();
        return eventList != null ? eventList : null;
    }

    @TargetMethodAttribute(privateMethod="GetCacheServers", privateOverload=1)
    public final Node[] GetCacheServers() throws UnknownHostException {
        return CacheServer.getInstance().GetCacheServers(this._cacheId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetUpdatedCacheServers", privateOverload=1)
    public final Node[] GetUpdatedCacheServers() throws UnknownHostException {
        Node[] serverNodes = CacheServer.getInstance().GetCacheServers(this._cacheId);
        Object object = _sync_lock;
        synchronized (object) {
            if (this._totalServerNodes != null && this._totalServerNodes.length != serverNodes.length) {
                this._totalServerNodes = serverNodes;
                return serverNodes;
            }
            if (this._totalServerNodes == null) {
                this._totalServerNodes = serverNodes;
                return serverNodes;
            }
            for (Node server : serverNodes) {
                if (Arrays.asList(this._totalServerNodes).contains(server)) continue;
                this._totalServerNodes = serverNodes;
                return serverNodes;
            }
        }
        return null;
    }

    @TargetMethodAttribute(privateMethod="GetRunningCacheServers", privateOverload=1)
    public final ServerNode[] GetRunningCacheServers() {
        ArrayList<ServerNode> serverNodes = CacheServer.getInstance().GetRunningCacheServers(this._cacheId);
        return serverNodes != null ? serverNodes.toArray(new ServerNode[serverNodes.size()]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetUpdatedRunningCacheServers", privateOverload=1)
    public final ServerNode[] GetUpdatedRunningCacheServers() {
        ArrayList<ServerNode> serverNodes = CacheServer.getInstance().GetRunningCacheServers(this._cacheId);
        ServerNode[] cacheServers = serverNodes != null ? serverNodes.toArray(new ServerNode[serverNodes.size()]) : null;
        Object object = _sync_lock;
        synchronized (object) {
            if (_runningServerNodes.size() != serverNodes.size()) {
                _runningServerNodes = serverNodes;
                return cacheServers;
            }
            for (ServerNode server : serverNodes) {
                if (_runningServerNodes.contains(server)) continue;
                _runningServerNodes = serverNodes;
                return cacheServers;
            }
        }
        return null;
    }

    @TargetMethodAttribute(privateMethod="GetCacheClients", privateOverload=1)
    public final ClientNode[] GetCacheClients() throws UnknownHostException {
        ArrayList<ClientNode> clientNodes = CacheServer.getInstance().GetCacheClients(this._cacheId);
        return clientNodes != null ? clientNodes.toArray(new ClientNode[clientNodes.size()]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetUpdatedCacheClients", privateOverload=1)
    public final ClientNode[] GetUpdatedCacheClients() throws UnknownHostException {
        ArrayList<ClientNode> clientNodes = CacheServer.getInstance().GetCacheClients(this._cacheId);
        ArrayList<ClientNode> returnNodes = new ArrayList<ClientNode>();
        Object object = _sync_lock;
        synchronized (object) {
            HashMap<String, ClientNode> clientNodePerIP = new HashMap<String, ClientNode>();
            for (ClientNode node : clientNodes) {
                if (node.getClientContext() == RtContextValue.NCACHE) {
                    String key = node.getAddress().getIpAddress().toString();
                    if (clientNodePerIP.containsKey(key)) continue;
                    clientNodePerIP.put(key, node);
                    returnNodes.add(node);
                    continue;
                }
                returnNodes.add(node);
            }
        }
        return returnNodes != null ? returnNodes.toArray(new ClientNode[returnNodes.size()]) : null;
    }

    @TargetMethodAttribute(privateMethod="GetClientProcessStats", privateOverload=1)
    public final ClientProcessStats[] GetClientProcessStats() throws UnknownHostException {
        ArrayList<ClientProcessStats> clientProcessStats = CacheServer.getInstance().GetClientProcessStats(this._cacheId);
        return clientProcessStats != null ? clientProcessStats.toArray(new ClientProcessStats[clientProcessStats.size()]) : null;
    }

    @TargetMethodAttribute(privateMethod="GetAllConfiguredCaches", privateOverload=1)
    public final ConfiguredCacheInfo[] GetAllConfiguredCaches() {
        return CacheServer.getInstance().GetAllConfiguredCaches();
    }

    @TargetMethodAttribute(privateMethod="GetCacheConfigurationInfo", privateOverload=1)
    public final ConfiguredCacheInfo GetCacheConfigurationInfo() {
        return CacheServer.getInstance().GetCacheConfigurationInfo(this._cacheId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetPercentageCPUUsage", privateOverload=1)
    public final int GetPercentageCPUUsage() {
        Object object = _syncLockCPUUsage;
        synchronized (object) {
            if (_cpuUsage == null) {
                _cpuUsage = new CPUUsage();
            }
            try {
                return 0;
            }
            catch (Exception exception) {
                return -3;
            }
        }
    }

    @TargetMethodAttribute(privateMethod="GetSnmpPorts", privateOverload=1)
    public final HashMap GetSnmpPort() {
        return CacheServer.getInstance().GetSnmpPorts();
    }
}

