package Alachisoft.NCache.Management.ClientConfiguration.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;

public class SecurityConfiguration implements Cloneable, InternalCompactSerializable {

    private UserCredentials _primaryUser;
    private UserCredentials _secondaryUser;

    @ConfigurationSectionAnnotation(value = "primary")
    public final UserCredentials getPrimaryUser() {
        return _primaryUser;
    }

    @ConfigurationSectionAnnotation(value = "primary")
    public final void setPrimaryUser(UserCredentials value) {
        _primaryUser = value;
    }


    @ConfigurationSectionAnnotation(value = "secondary")
    public final UserCredentials getSecondaryUser() {
        return _secondaryUser;
    }

    @ConfigurationSectionAnnotation(value = "secondary")
    public final void setSecondaryUser(UserCredentials value) {
        _secondaryUser = value;
    }

    //C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#region ICloneable Members
    public final Object clone() {
        SecurityConfiguration configuration = new SecurityConfiguration();
        //Object tempVar = _primaryUser.clone();
        configuration._primaryUser = _primaryUser != null ? (UserCredentials) ((_primaryUser.clone() instanceof UserCredentials) ? _primaryUser.clone() : null) : null;
        //Object tempVar2 = _secondaryUser.clone();
        configuration._secondaryUser = _secondaryUser != null ? (UserCredentials) ((_secondaryUser.clone() instanceof UserCredentials) ? _secondaryUser.clone() : null) : null;

        return configuration;
    }
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion
    //<editor-fold defaultstate="collapsed" desc="ISerailizable">

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        _primaryUser = (UserCredentials) Common.readAs(reader.ReadObject(), UserCredentials.class);
        _secondaryUser = (UserCredentials) Common.readAs(reader.ReadObject(), UserCredentials.class);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject(_primaryUser);
        writer.WriteObject(_secondaryUser);
    }

    //</editor-fold>
}