/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management.ClientConfiguration;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Enum.ClientNodeStatus;
import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.NewDom.NodeIdentity;
import Alachisoft.NCache.Management.ClientConfiguration.CacheServerList;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.NodeConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.SecurityConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.UserCredentials;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class ClientConfigManager {
    public static String ENDSTRING = "\r\n";
    private static ArrayList ipAddresses = new ArrayList(1);
    private static String DIRNAME = "config";
    private static String FILENAME = "client.ncconf";
    private static String c_configDir = DIRNAME;
    private static String c_configFileName = FILENAME;
    private static String bindIp;
    private static String _localCacheGivenId;
    private static HashMap _caches;
    private static ClientConfiguration _configuration;

    public static void AvailableNIC(HashMap nic) {
        if (nic != null) {
            ipAddresses.addAll(nic.keySet());
        }
    }

    public static void LoadConfiguration() throws ManagementException {
        try {
            ClientConfigManager.CombinePath();
            if (!new File(c_configFileName).isFile() || new File(c_configFileName).length() == 0L) {
                ClientConfigManager.SaveConfiguration();
                return;
            }
            _caches.clear();
            try {
                ClientConfigManager.LoadXml();
            }
            catch (Exception parserConfigurationException) {
                throw new ManagementException(parserConfigurationException.getMessage(), (Throwable)parserConfigurationException);
            }
        }
        catch (ManagementException e) {
            c_configFileName = "";
            throw e;
        }
        catch (RuntimeException e) {
            c_configFileName = "";
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getBindIP() {
        return bindIp;
    }

    public static void setBindIP(String value) {
        bindIp = value;
    }

    public static String getLocalCacheId() {
        return _localCacheGivenId;
    }

    public static void setLocalCacheId(String value) {
        _localCacheGivenId = value;
    }

    private static void CombinePath() throws ManagementException {
        c_configDir = AppUtil.getInstallDir();
        if (c_configDir == null || c_configDir.length() == 0) {
            throw new ManagementException("Missing installation folder information");
        }
        if (!new File(c_configDir = new File(c_configDir, DIRNAME).getPath()).isDirectory()) {
            new File(c_configDir).mkdir();
        }
        c_configFileName = new File(c_configDir, FILENAME).getPath();
    }

    private static void LoadXml() throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        int i;
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)c_configFileName)) {
            ClientConfigManager.CombinePath();
        }
        ConfigurationBuilder configBuilder = new ConfigurationBuilder(c_configFileName);
        try {
            configBuilder.RegisterRootConfigurationObject(ClientConfiguration.class);
            configBuilder.ReadConfiguration();
        }
        catch (Exception exception) {
            throw new ManagementException(exception.getMessage(), (Throwable)exception);
        }
        ClientConfiguration clientConfiguration = null;
        Object[] configuration = configBuilder.getConfiguration();
        if (configuration != null && configuration.length > 0 && (i = 0) < configuration.length) {
            clientConfiguration = (ClientConfiguration)(configuration[i] instanceof ClientConfiguration ? configuration[i] : null);
        }
        if ((_configuration = clientConfiguration) == null) {
            _configuration = new ClientConfiguration();
        }
        if (_configuration.getNodeConfiguration() == null) {
            _configuration.setNodeConfiguration(new NodeConfiguration());
        }
        _configuration.setBindIp(ClientConfigManager.getBindIP());
    }

    public static void UpdateCacheConfiguration(String cacheId, ClientConfiguration configuration) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        if (_configuration == null) {
            _configuration = new ClientConfiguration();
        }
        if (_configuration.getCacheConfigurationsMap() == null) {
            _configuration.setCacheConfigurationsMap(new HashMap<String, CacheConfiguration>());
        }
        cacheId = cacheId.toLowerCase();
        Object tempVar = configuration.getNodeConfiguration().clone();
        _configuration.setNodeConfiguration((NodeConfiguration)(tempVar instanceof NodeConfiguration ? tempVar : null));
        CacheConfiguration cacheConfiguration = null;
        cacheConfiguration = configuration.getCacheConfigurationsMap().get(cacheId);
        if (cacheConfiguration != null) {
            cacheConfiguration.setBindIp(configuration.getBindIp());
            Object tempVar2 = cacheConfiguration.clone();
            _configuration.getCacheConfigurationsMap().put(cacheId, (CacheConfiguration)(tempVar2 instanceof CacheConfiguration ? tempVar2 : null));
        }
        ClientConfigManager.SaveConfiguration();
    }

    public static void RemoveCacheServer(String cacheId, String server) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        if (_configuration != null && _configuration.getCacheConfigurationsMap() != null) {
            cacheId = cacheId.toLowerCase();
            if (_configuration.getCacheConfigurationsMap().containsKey(cacheId)) {
                CacheConfiguration cacheConfig = _configuration.getCacheConfigurationsMap().get(cacheId);
                cacheConfig.RemoveServer(server);
            }
        }
        ClientConfigManager.SaveConfiguration();
    }

    public static void RemoveCache(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        if (_configuration != null && _configuration.getCacheConfigurationsMap() != null) {
            cacheId = cacheId.toLowerCase();
            if (_configuration.getCacheConfigurationsMap().containsKey(cacheId)) {
                _configuration.getCacheConfigurationsMap().remove(cacheId);
            }
        }
        ClientConfigManager.SaveConfiguration();
    }

    public static void AddCache(String cacheId, RtContextValue serverRuntimeContext) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        if (_configuration != null) {
            if (_configuration.getCacheConfigurationsMap() == null) {
                _configuration.setCacheConfigurationsMap(new HashMap<String, CacheConfiguration>());
            }
            if (!_configuration.getCacheConfigurationsMap().containsKey(cacheId.toLowerCase())) {
                CacheConfiguration cacheConfiguration = new CacheConfiguration();
                cacheConfiguration.setCacheId(cacheId);
                cacheConfiguration.setServerRuntimeContext(serverRuntimeContext);
                cacheConfiguration.AddLocalServer(_configuration.getBindIp());
                _configuration.getCacheConfigurationsMap().put(cacheId.toLowerCase(), cacheConfiguration);
            }
        }
        ClientConfigManager.SaveConfiguration();
    }

    public static void AddCache(String cacheId, CacheServerConfig config) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        if (_configuration != null) {
            if (_configuration.getCacheConfigurationsMap() == null) {
                _configuration.setCacheConfigurationsMap(new HashMap<String, CacheConfiguration>());
            }
            if (!_configuration.getCacheConfigurationsMap().containsKey(cacheId.toLowerCase())) {
                CacheConfiguration cacheConfiguration = new CacheConfiguration();
                cacheConfiguration.setCacheId(cacheId);
                if (config.getCluster() != null && config.getCluster().getNodes() != null) {
                    if (config.getCluster().getNodes().size() != 1) {
                        String[] serverList = new String[config.getCluster().getNodeIdentities().size()];
                        for (int i = 0; i < serverList.length; ++i) {
                            serverList[i] = ((NodeIdentity)config.getCluster().getNodeIdentities().get(i)).getNodeName();
                        }
                        String[] copyServerList = new String[serverList.length];
                        for (int i = 0; i < serverList.length; ++i) {
                            if (cacheConfiguration.getBindIp().equals(serverList[i])) {
                                copyServerList[0] = serverList[i];
                                cacheConfiguration.AddServer(cacheConfiguration.getBindIp(), 0);
                                continue;
                            }
                            if (DotNetToJavaStringHelper.isNullOrEmpty((String)copyServerList[0])) {
                                copyServerList[i + 1] = serverList[i];
                                cacheConfiguration.AddServer(serverList[i], i + 1);
                                continue;
                            }
                            copyServerList[i] = serverList[i];
                            cacheConfiguration.AddServer(serverList[i], i);
                        }
                    } else {
                        cacheConfiguration.AddServer(((NodeIdentity)config.getCluster().getNodeIdentities().get(0)).getNodeName(), 0);
                    }
                } else {
                    cacheConfiguration.AddLocalServer(_configuration.getBindIp());
                }
                _configuration.getCacheConfigurationsMap().put(cacheId.toLowerCase(), cacheConfiguration);
            }
        }
        ClientConfigManager.SaveConfiguration();
    }

    public static void SaveConfiguration() throws ManagementException {
        if (c_configFileName == null || c_configFileName.equals("")) {
            ClientConfigManager.CombinePath();
        }
        FileWriter fs = null;
        BufferedWriter sw = null;
        try {
            fs = new FileWriter(c_configFileName);
            sw = new BufferedWriter(fs);
            sw.write(ClientConfigManager.ToXml());
            sw.flush();
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ClientConfigManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ClientConfigManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static String ToXml() throws IllegalArgumentException, IllegalAccessException, Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(ENDSTRING + "<!-- Client configuration file is used by client to connect to out-proc caches. " + ENDSTRING + "Light weight client also uses this configuration file to connect to the remote caches. " + ENDSTRING + "This file is automatically generated each time a new cache/cluster is created or " + ENDSTRING + "cache/cluster configuration settings are applied. Additionally security information " + ENDSTRING + "can be provided for each cache in the following format. " + ENDSTRING + "<security>" + ENDSTRING + "\t<primary user-id=\"domain\\pri-user\" password=\"pri-pass\"/>" + ENDSTRING + "\t<secondary user-id=\"domain\\sec-user\" password=\"sec-pass\"/>" + ENDSTRING + "</security>" + ENDSTRING + "-->");
        sb.append(ENDSTRING + "<!-- Client configuration file is used by client to connect to out-proc caches. " + ENDSTRING + "This file is automatically generated each time a new cache/cluster is created or " + ENDSTRING + "cache/cluster configuration settings are applied." + ENDSTRING + "-->");
        sb.append("\n");
        if (_configuration != null) {
            Object[] configuration = new Object[]{_configuration};
            ConfigurationBuilder cfgBuilder = new ConfigurationBuilder(configuration);
            try {
                cfgBuilder.RegisterRootConfigurationObject(ClientConfiguration.class);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage(), exception);
            }
            sb.append(cfgBuilder.GetXmlString());
        } else {
            sb.append("<configuration>\r\n");
            sb.append("\r\n</configuration>");
        }
        return sb.toString();
    }

    public static void UpdateServerNodes(String cacheId, CacheServerList serversPriorityList, RtContextValue serverRuntimeContext) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        if (_configuration != null) {
            if (_configuration.getCacheConfigurationsMap() == null) {
                _configuration.setCacheConfigurationsMap(new HashMap<String, CacheConfiguration>());
            }
            cacheId = cacheId.toLowerCase();
            CacheConfiguration cacheConfiguration = null;
            cacheConfiguration = _configuration.getCacheConfigurationsMap().get(cacheId);
            if (cacheConfiguration == null) {
                cacheConfiguration = new CacheConfiguration();
                cacheConfiguration.setCacheId(cacheId);
                cacheConfiguration.setBindIp(bindIp);
                cacheConfiguration.setServerRuntimeContext(serverRuntimeContext);
                _configuration.getCacheConfigurationsMap().put(cacheId, cacheConfiguration);
            }
            cacheConfiguration.setServersPriorityList(serversPriorityList);
        }
        ClientConfigManager.SaveConfiguration();
    }

    public static void UpdateServerNodes(String cacheId, String[] servers, RefObject<String> xml, String clientCacheId, boolean loadBalance) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        cacheId = cacheId.toLowerCase();
        CacheConfiguration cacheConfiguration = null;
        if (_configuration != null && _configuration.getCacheConfigurationsMap() != null && (cacheConfiguration = _configuration.getCacheConfigurationsMap().get(cacheId)) == null) {
            cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setCacheId(cacheId);
            _configuration.getCacheConfigurationsMap().put(cacheId, cacheConfiguration);
        }
        cacheConfiguration.getServersPriorityList().getServersList().clear();
        for (int i = 0; i < servers.length; ++i) {
            CacheServer server = new CacheServer();
            server.setServerName(servers[i]);
            server.setPriority(i);
            cacheConfiguration.getServersPriorityList().getServersList().put(i, server);
        }
        cacheConfiguration.setClientCacheId(clientCacheId);
        cacheConfiguration.setLoadBalance(loadBalance);
        ClientConfigManager.SaveConfiguration();
        if (xml != null) {
            xml.argvalue = "";
        }
    }

    public static void UpdateUserSecurityCredentials(String cacheId, String[] users, String[] passwords) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        cacheId = cacheId.toLowerCase();
        CacheConfiguration cacheConfiguration = null;
        if (_configuration != null && _configuration.getCacheConfigurationsMap() != null && (cacheConfiguration = _configuration.getCacheConfigurationsMap().get(cacheId)) == null) {
            cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setCacheId(cacheId);
            _configuration.getCacheConfigurationsMap().put(cacheId, cacheConfiguration);
        }
        UserCredentials primary = new UserCredentials();
        primary.setUserId(users[0]);
        primary.setPassword(passwords[0]);
        UserCredentials secondary = new UserCredentials();
        secondary.setUserId(users[1]);
        secondary.setPassword(passwords[1]);
        cacheConfiguration.setSecurityConfiguration(new SecurityConfiguration());
        cacheConfiguration.getSecurityConfiguration().setPrimaryUser(primary);
        cacheConfiguration.getSecurityConfiguration().setSecondaryUser(secondary);
        ClientConfigManager.SaveConfiguration();
    }

    public static void GetUserSecurityCredentials(String cacheId, RefObject<String[]> users, RefObject<String[]> passwords) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        cacheId = cacheId.toLowerCase();
        CacheConfiguration cacheConfiguration = null;
        if (_configuration != null && _configuration.getCacheConfigurationsMap() != null && (cacheConfiguration = _configuration.getCacheConfigurationsMap().get(cacheId)) != null && cacheConfiguration.getSecurityConfiguration() != null) {
            UserCredentials primary = cacheConfiguration.getSecurityConfiguration().getPrimaryUser();
            UserCredentials secondary = cacheConfiguration.getSecurityConfiguration().getSecondaryUser();
            users.argvalue = new String[2];
            ((String[])users.argvalue)[0] = primary.getUserId();
            ((String[])users.argvalue)[1] = secondary.getUserId();
            passwords.argvalue = new String[2];
            ((String[])passwords.argvalue)[0] = primary.getPassword();
            ((String[])passwords.argvalue)[1] = secondary.getPassword();
        }
    }

    public static int GetConfigurationId() throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        int configurationId = 0;
        ClientConfigManager.LoadXml();
        if (_configuration != null && _configuration.getNodeConfiguration() != null) {
            configurationId = _configuration.getNodeConfiguration().getConfigurationId();
        }
        return configurationId;
    }

    public static ClientNodeStatus GetClientNodeStatus(String cacheId, RefObject<String> clientCacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientNodeStatus status = ClientNodeStatus.Unavailable;
        clientCacheId.argvalue = "";
        ClientConfigManager.LoadXml();
        if (_configuration != null && _configuration.getCacheConfigurationsMap() != null) {
            CacheConfiguration config = null;
            config = _configuration.getCacheConfigurationsMap().get(cacheId.toLowerCase());
            if (config != null) {
                if (DotNetToJavaStringHelper.isNullOrEmpty((String)config.getClientCacheId())) {
                    status = ClientNodeStatus.ClientCacheUnavailable;
                } else {
                    status = ClientNodeStatus.ClientCacheDisabled;
                    clientCacheId.argvalue = config.getClientCacheId();
                }
            }
        }
        return status;
    }

    public static ClientConfiguration GetClientConfiguration(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.LoadXml();
        return _configuration;
    }

    static {
        _localCacheGivenId = "";
        _caches = new HashMap();
    }
}

