/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Config.ConfigReader;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.Dom.ConfigConverter;
import Alachisoft.NCache.Config.NewDom.AlertsNotifications;
import Alachisoft.NCache.Config.NewDom.AlertsTypes;
import Alachisoft.NCache.Config.NewDom.AttributeListUnion;
import Alachisoft.NCache.Config.NewDom.BackingSource;
import Alachisoft.NCache.Config.NewDom.BatchConfig;
import Alachisoft.NCache.Config.NewDom.CompactClass;
import Alachisoft.NCache.Config.NewDom.EmailNotifications;
import Alachisoft.NCache.Config.NewDom.GenericArgumentType;
import Alachisoft.NCache.Config.NewDom.NotificationRecipient;
import Alachisoft.NCache.Config.NewDom.Parameter;
import Alachisoft.NCache.Config.NewDom.PortableAttribute;
import Alachisoft.NCache.Config.NewDom.PortableClass;
import Alachisoft.NCache.Config.NewDom.Provider;
import Alachisoft.NCache.Config.NewDom.Readthru;
import Alachisoft.NCache.Config.NewDom.Type;
import Alachisoft.NCache.Config.NewDom.WriteBehind;
import Alachisoft.NCache.Config.NewDom.Writethru;
import Alachisoft.NCache.Config.PropsConfigReader;
import Alachisoft.NCache.Management.CacheConfigManager;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.RefObject;

public class CacheConfig {
    private static final String NET_TYPE = "net";
    private static final String NET_TYPE_WITH_COLON = ":net";
    private static final String JAVA_TYPE = "java";
    private static final String JAVA_TYPE_WITH_COLON = ":java";
    private static String PLATFORM_TYPE = "";
    private String _cacheType = "";
    private String _cacheId = "";
    private String _paritionId = "";
    private boolean _useInProc;
    private String _serverName;
    private boolean _useTcp = true;
    private long _port;
    private String _propertyString = "";
    private HashMap _dataSharingKnownTypes;
    private HashMap _backingSource;
    private HashMap _cmptKnownTypes;
    private int _clusterPort;
    private int _clusterPortRange;
    private boolean _errorLogsEnabled;
    private boolean _detailedLogsEnabled;
    private long _cacheMaxSize;
    private long _cleanInterval;
    private float _evictRatio;
    private boolean _compressionEnabled;
    private boolean _securityEnabled;
    private String _securityDomainController;
    private String _securityPort;
    private HashMap _securityUsers;
    private long _compressionThreshold;
    private ArrayList _servers;
    private int _bridgePort = 0;
    private String _bridgeId = "";
    private ArrayList _bridgeServers = null;
    private boolean _isBridgeTargetCache = false;
    private boolean _bridgeSecurityEnabled = false;
    private String _bridgeUsername;
    private String _bridgePassword;
    private boolean _useHeartBeat = false;
    private HashMap _alertNotifications;

    public CacheConfig() throws UnknownHostException {
        this._port = CacheConfigManager.getTcpPort();
        this._clusterPortRange = 2;
        this.InitializeServerName();
    }

    public CacheConfig(long tcpPort) throws UnknownHostException {
        this._port = tcpPort;
        this.InitializeServerName();
    }

    public static CacheConfig FromDom(CacheServerConfig config) throws ManagementException, UnknownHostException {
        HashMap props = ConfigConverter.ToHashMap((CacheServerConfig)config);
        return CacheConfig.FromProperties(props);
    }

    /*
     * WARNING - void declaration
     */
    public static CacheConfig FromConfiguration(CacheServerConfig configuration) throws UnknownHostException {
        CacheConfig cConfig = null;
        if (configuration != null) {
            HashMap<String, HashMap> settings;
            cConfig = new CacheConfig();
            cConfig._useInProc = configuration.getInProc();
            cConfig.setCacheId(configuration.getName());
            if (configuration.getBridge() != null) {
                void var6_10;
                cConfig._bridgeId = configuration.getBridge().getId();
                cConfig._bridgePort = configuration.getBridge().getPort();
                String[] servers = null;
                servers = configuration.getBridge().getServers().split("[,]");
                ArrayList<String> list = new ArrayList<String>(servers.length);
                String[] stringArray = servers;
                int n = stringArray.length;
                boolean i = false;
                while (var6_10 < n) {
                    String server = stringArray[var6_10];
                    if (!list.contains(server)) {
                        list.add(server);
                    }
                    ++var6_10;
                }
                cConfig._bridgeServers = list;
                cConfig._isBridgeTargetCache = configuration.getBridge().getIsBridgeTargetCache();
            }
            if (configuration.getCompression() != null) {
                cConfig._compressionEnabled = configuration.getCompression().getEnabled();
                cConfig._compressionThreshold = configuration.getCompression().getThreshold();
            }
            if (configuration.getSecurity() != null) {
                cConfig._securityEnabled = configuration.getSecurity().getEnabled();
                cConfig._securityDomainController = configuration.getSecurity().getDomainController();
                cConfig._securityPort = configuration.getSecurity().getPort();
                HashMap<String, Object> users = new HashMap<String, Object>();
                if (configuration.getSecurity().getUsers() != null) {
                    for (int i = 0; i < configuration.getSecurity().getUsers().length; ++i) {
                        users.put(configuration.getSecurity().getUsers()[i].getId(), null);
                    }
                }
                cConfig._securityUsers = users;
            }
            if (configuration.getCluster() != null) {
                if (configuration.getCluster().getChannel() != null) {
                    cConfig._clusterPort = configuration.getCluster().getChannel().getTcpPort();
                    cConfig._clusterPortRange = configuration.getCluster().getChannel().getPortRange();
                }
                cConfig._useHeartBeat = configuration.getCluster().getUseHeartbeat();
                cConfig._servers = CacheConfig.FromHostListToServers(configuration.getCluster().getChannel().getInitialHosts());
                String topology = "";
                String tempVar = configuration.getCluster().getTopology();
                if (tempVar.equals("replicated")) {
                    topology = "replicated-server";
                } else if (tempVar.equals("partitioned")) {
                    topology = "partitioned-server";
                } else if (tempVar.equals("partition-replica")) {
                    topology = "partitioned-replicas-server";
                } else if (tempVar.equals("mirror")) {
                    topology = "mirror-server";
                }
                cConfig._cacheType = topology;
            } else {
                cConfig._cacheType = "local-cache";
            }
            if (configuration.getCleanup() != null) {
                cConfig._cleanInterval = configuration.getCleanup().getInterval() * 1000;
            }
            if (configuration.getEvictionPolicy() != null) {
                cConfig._evictRatio = configuration.getEvictionPolicy().getEvictionRatio().floatValue();
            }
            if (configuration.getStorage() != null) {
                cConfig._cacheMaxSize = configuration.getStorage().getSize() * 0x100000L;
            }
            if (configuration.getLog() != null) {
                cConfig._errorLogsEnabled = configuration.getLog().getTraceErrors();
                cConfig._detailedLogsEnabled = configuration.getLog().getTraceDebug();
            }
            if (configuration.getDataSharing() != null) {
                settings = new HashMap<String, HashMap>();
                for (Type type : configuration.getDataSharing().getTypes()) {
                    settings.put(type.getID(), CacheConfig.GetCompactType(type));
                }
                cConfig._dataSharingKnownTypes = settings;
            }
            if (configuration.getCompactSerialization() != null) {
                settings = new HashMap();
                for (Type type : configuration.getCompactSerialization().getCompactClassListAsArray()) {
                    settings.put(type.getID(), CacheConfig.GetCompactClass((CompactClass)type));
                }
                cConfig._cmptKnownTypes = settings;
            }
            if (configuration.getBackingSource() != null) {
                settings = new HashMap();
                settings.put("backing-source", CacheConfig.GetBackingSource(configuration.getBackingSource()));
                cConfig._backingSource = settings;
            }
            if (configuration.getAlertsNotifications() != null) {
                cConfig._alertNotifications = CacheConfig.GetAlerts(configuration.getAlertsNotifications());
            }
        }
        return cConfig;
    }

    private static HashMap GetCompactClass(CompactClass cls) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("id", cls.getID());
        settings.put("name", cls.getName());
        settings.put("assembly", cls.getAssembly());
        settings.put("portable", cls.getPortable());
        settings.put("type", cls.getType());
        settings.put("generic-id", cls.getGenericId());
        settings.put("is-generic", cls.getIsGeneric());
        settings.put("num-of-args", cls.getNumberOfArgs());
        HashMap<String, HashMap> argTypes = null;
        if (cls.getIsGeneric() && cls.getGenericArgumentTypeList() != null) {
            argTypes = new HashMap<String, HashMap>();
            for (GenericArgumentType gat : cls.getGenericArgumentTypeList()) {
                argTypes.put(gat.getID(), CacheConfig.GetArgumentType(gat));
            }
            settings.put("arg-types", argTypes);
        }
        return settings;
    }

    private static HashMap GetArgumentType(GenericArgumentType gat) {
        HashMap concreteArgTypes = new HashMap(gat.getGenericArgsCompactTypeList().size());
        HashMap<String, Object> concreteArgType = null;
        if (gat.getGenericArgsCompactTypeList() != null) {
            for (CompactClass cls : gat.getGenericArgsCompactTypeList()) {
                concreteArgType = new HashMap<String, Object>();
                concreteArgType.put("id", cls.getID());
                concreteArgType.put("name", cls.getName());
                concreteArgType.put("assembly", cls.getAssembly());
                concreteArgType.put("portable", cls.getPortable());
                concreteArgType.put("type", cls.getType());
                concreteArgType.put("generic-id", cls.getGenericId());
                concreteArgType.put("is-generic", cls.getIsGeneric());
                concreteArgType.put("num-of-args", cls.getNumberOfArgs());
                HashMap<String, HashMap> argTypes = null;
                if (cls.getIsGeneric() && cls.getGenericArgumentTypeList() != null) {
                    argTypes = new HashMap<String, HashMap>();
                    for (GenericArgumentType gat2 : cls.getGenericArgumentTypeList()) {
                        argTypes.put(gat2.getID(), CacheConfig.GetArgumentType(gat2));
                    }
                    concreteArgType.put("arg-types", argTypes);
                }
                concreteArgTypes.put(cls.getID(), concreteArgType);
            }
        }
        return concreteArgTypes;
    }

    private static HashMap GetAlerts(AlertsNotifications alertsNotifications) {
        HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
        if (alertsNotifications.getEMailNotifications() != null) {
            settings.put("email-notification", CacheConfig.GetEmailNotifications(alertsNotifications.getEMailNotifications()));
        }
        if (alertsNotifications.getAlertsTypes() != null) {
            settings.put("alerts-types", CacheConfig.GetAlertsType(alertsNotifications.getAlertsTypes()));
        }
        return settings;
    }

    private static HashMap GetEmailNotifications(EmailNotifications emailNotifications) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("email-notification-enabled", new Boolean(emailNotifications.getEmailNotificationEnabled()).toString());
        settings.put("sender", emailNotifications.getSender());
        settings.put("smtp-server", emailNotifications.getSmtpServer());
        settings.put("smtp-port", new Integer(emailNotifications.getSmtpPort()).toString());
        settings.put("ssl", new Boolean(emailNotifications.getSSL()).toString());
        settings.put("authentication", new Boolean(emailNotifications.getAuthentication()).toString());
        settings.put("sender-login", emailNotifications.getLogin());
        settings.put("sender-password", emailNotifications.getPassword());
        if (emailNotifications.getRecipients() != null) {
            settings.put("recipients", CacheConfig.GetRecipients(emailNotifications.getRecipients()));
        }
        return settings;
    }

    private static HashMap GetRecipients(NotificationRecipient[] recipients) {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (int i = 0; i < recipients.length; ++i) {
            settings.put(recipients[i].getID(), recipients[i].getID());
        }
        return settings;
    }

    private static HashMap GetBackingSource(BackingSource backingSource) {
        HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
        if (backingSource.getReadthru() != null) {
            settings.put("read-thru", CacheConfig.GetReadThru(backingSource.getReadthru()));
        }
        if (backingSource.getWritethru() != null) {
            settings.put("write-thru", CacheConfig.GetWriteThru(backingSource.getWritethru()));
        }
        return settings;
    }

    private static HashMap GetWriteThru(Writethru writethru) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("enabled", new Boolean(writethru.getEnabled()).toString());
        if (writethru.getProviders() != null) {
            settings.put("write-thru-providers", CacheConfig.GetProviders(writethru.getProviders()));
        }
        if (writethru.getWriteBehind() != null) {
            settings.put("write-behind", CacheConfig.GetWriteBehind(writethru.getWriteBehind()));
        }
        return settings;
    }

    private static HashMap GetReadThru(Readthru readthru) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("enabled", new Boolean(readthru.getEnabled()).toString());
        if (readthru.getProviders() != null) {
            settings.put("read-thru-providers", CacheConfig.GetProviders(readthru.getProviders()));
        }
        return settings;
    }

    private static HashMap GetWriteBehind(WriteBehind writeBehind) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (writeBehind != null) {
            settings.put("mode", writeBehind.getMode());
            settings.put("throttling-rate-per-sec", writeBehind.getThrottling());
            settings.put("failed-operations-queue-limit", writeBehind.getRequeueLimit());
            settings.put("failed-operations-eviction-ratio", writeBehind.getEviction());
            if (writeBehind.getBatchConfig() != null) {
                settings.put("batch-mode-config", CacheConfig.GetBatchConfig(writeBehind.getBatchConfig()));
            }
        }
        return settings;
    }

    private static HashMap GetBatchConfig(BatchConfig batchConfig) {
        HashMap<String, String> settings = new HashMap<String, String>();
        if (batchConfig != null) {
            settings.put("batch-interval", batchConfig.getBatchInterval());
            settings.put("operation-delay", batchConfig.getOperationDelay());
        }
        return settings;
    }

    private static HashMap GetProviders(Provider[] providers) {
        HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
        if (providers != null && providers.length > 0) {
            for (int i = 0; i < providers.length; ++i) {
                settings.put(providers[i].getProviderName(), CacheConfig.GetProvider(providers[i]));
            }
        }
        return settings;
    }

    private static HashMap GetProvider(Provider provider) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (provider != null) {
            settings.put("provider-name", provider.getProviderName());
            settings.put("assembly-name", provider.getAssemblyName());
            settings.put("class-name", provider.getClassName());
            settings.put("full-name", provider.getFullProviderName());
            settings.put("default-provider", new Boolean(provider.getIsDefaultProvider()).toString());
            HashMap paramss = CacheConfig.GetParameters(provider.getParameters());
            if (paramss != null) {
                settings.put("parameters", paramss);
            }
        }
        return settings;
    }

    private static HashMap GetParameters(Parameter[] parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; ++i) {
            settings.put(parameters[i].getName(), parameters[i].getParamValue());
        }
        return settings;
    }

    private static HashMap GetAlertsType(AlertsTypes alertTypes) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("cache-stop", new Boolean(alertTypes.getCacheStop()).toString());
        settings.put("cache-start", new Boolean(alertTypes.getCacheStart()).toString());
        settings.put("node-left", new Boolean(alertTypes.getNodeLeft()).toString());
        settings.put("node-joined", new Boolean(alertTypes.getNodeJoined()).toString());
        settings.put("state-transfer-started", new Boolean(alertTypes.getStartTransferStarted()).toString());
        settings.put("state-transfer-stop", new Boolean(alertTypes.getStartTransferStop()).toString());
        settings.put("state-transfer-error", new Boolean(alertTypes.getStartTransferError()).toString());
        settings.put("service-start-error", new Boolean(alertTypes.getServiceStartError()).toString());
        settings.put("cache-size", new Boolean(alertTypes.getCacheSize()).toString());
        settings.put("general-error", new Boolean(alertTypes.getGeneralError()).toString());
        settings.put("licensing-error", new Boolean(alertTypes.getLicensingError()).toString());
        settings.put("configuration-error", new Boolean(alertTypes.getConfigurationError()).toString());
        settings.put("security-error", new Boolean(alertTypes.getSecurityError()).toString());
        settings.put("general-info", new Boolean(alertTypes.getGeneralInfo()).toString());
        settings.put("unhandled-exceptions", new Boolean(alertTypes.getUnHandledException()).toString());
        return settings;
    }

    private static HashMap GetCompactType(Type type) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("id", type.getID());
        settings.put("handle", type.getName());
        settings.put("portable", type.getPortable());
        if (type.getPortableClasses() != null) {
            settings.put("known-classes", CacheConfig.GetCompactPortableClasses(type.getPortableClasses()));
            settings.put("attribute-union-list", CacheConfig.GetCompactAttributeListUnion(type.getAttributeList()));
        }
        return settings;
    }

    private static HashMap GetCompactPortableClasses(PortableClass[] classes) {
        HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
        for (PortableClass clas : classes) {
            settings.put(clas.getName(), CacheConfig.GetCompactPortableClass(clas));
        }
        return settings;
    }

    private static HashMap GetCompactAttributeListUnion(AttributeListUnion attributeList) {
        HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
        if (attributeList != null && attributeList.getPortableAttributes() != null) {
            settings.put("attribute", CacheConfig.GetCompactPortableAttributes(attributeList.getPortableAttributes()));
        }
        return settings;
    }

    private static HashMap GetCompactPortableClass(PortableClass clas) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("name", clas.getName());
        settings.put("handle-ID", clas.getID());
        settings.put("assembly", clas.getAssembly());
        settings.put("type", clas.getType());
        if (clas.getPortableAttributes() != null) {
            settings.put("attribute", CacheConfig.GetCompactPortableAttributes(clas.getPortableAttributes()));
        }
        return settings;
    }

    private static HashMap GetCompactPortableAttributes(PortableAttribute[] attributes) {
        HashMap<CallSite, HashMap> settings = new HashMap<CallSite, HashMap>();
        for (PortableAttribute attrib : attributes) {
            settings.put((CallSite)((Object)(attrib.getName() + ":" + attrib.getType())), CacheConfig.GetCompactPortableAttribute(attrib));
        }
        return settings;
    }

    private static HashMap GetCompactPortableAttribute(PortableAttribute attrib) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("name", attrib.getName());
        settings.put("type", attrib.getType());
        settings.put("order", attrib.getOrder());
        return settings;
    }

    public static CacheConfig FromPropertyString(String props) throws ManagementException, UnknownHostException {
        CacheConfig cConfig = null;
        if (props != null) {
            PropsConfigReader pcr = new PropsConfigReader(props);
            HashMap cacheConfig = pcr.getProperties();
            cConfig = CacheConfig.FromProperties(cacheConfig);
        }
        return cConfig;
    }

    public static ArrayList GetConfigs(ArrayList props) throws ManagementException, UnknownHostException {
        ArrayList<CacheConfig> configList = new ArrayList<CacheConfig>();
        for (HashMap properties : props) {
            CacheConfig config = null;
            config = CacheConfig.FromProperties(properties);
            if (config == null) continue;
            configList.add(config);
        }
        return configList;
    }

    public static ArrayList GetConfigs(ArrayList props, long tcpPort) throws Exception {
        ArrayList<CacheConfig> configList = new ArrayList<CacheConfig>();
        for (HashMap properties : props) {
            CacheConfig config = null;
            config = CacheConfig.FromProperties(properties, tcpPort);
            if (config == null) continue;
            configList.add(config);
        }
        return configList;
    }

    private static Map ReplaceCacheId(Map properties, String oldCacheId, String newCacheId) {
        oldCacheId = oldCacheId.toLowerCase();
        newCacheId = newCacheId.toLowerCase();
        Object tempVar = ((HashMap)properties).clone();
        Map props = (Map)(tempVar instanceof Map ? tempVar : null);
        for (Map.Entry current : properties.entrySet()) {
            if (((String)current.getKey()).toLowerCase().equals(oldCacheId)) {
                if (current.getValue() instanceof Map) {
                    props.remove(oldCacheId);
                    props.put(newCacheId, CacheConfig.ReplaceCacheId(current.getValue() instanceof Map ? current.getValue() : null, oldCacheId, newCacheId));
                    continue;
                }
                props.remove(oldCacheId);
                props.put(newCacheId, current.getValue());
                continue;
            }
            if (current.getValue() instanceof Map) {
                props.put(current.getKey(), CacheConfig.ReplaceCacheId(current.getValue() instanceof Map ? current.getValue() : null, oldCacheId, newCacheId));
                continue;
            }
            if (!((String)current.getValue()).toLowerCase().equals(oldCacheId)) continue;
            props.remove(current.getKey());
            props.put(current.getKey(), newCacheId);
        }
        return props;
    }

    public static CacheConfig GetUpdatedConfig(Map properties, String partId, String joiningNode, RefObject<ArrayList> affectedNodes, RefObject<ArrayList> affectedPartitions, String oldCacheId, String newCacheId) throws ManagementException, UnknownHostException {
        Map cacheProps;
        Object list = "";
        int clusterPort = 0;
        if (affectedNodes.argvalue == null) {
            affectedNodes.argvalue = new ArrayList();
        }
        if ((cacheProps = (Map)((properties = CacheConfig.ReplaceCacheId(properties, oldCacheId, newCacheId)).get("cache") instanceof Map ? properties.get("cache") : null)).containsKey("cache-classes")) {
            Map clusterProps;
            Map topologyProps;
            Map cacheClassesProps = cacheProps.get("cache-classes") instanceof Map ? cacheProps.get("cache-classes") : null;
            String cacheName = String.valueOf(cacheProps.get("name"));
            if (cacheClassesProps.containsKey(cacheName = cacheName.toLowerCase()) && (topologyProps = (Map)(cacheClassesProps.get(cacheName) instanceof Map ? cacheClassesProps.get(cacheName) : null)).containsKey("cluster") && (clusterProps = (Map)(topologyProps.get("cluster") instanceof Map ? topologyProps.get("cluster") : null)).containsKey("channel")) {
                HashMap partitionsProps;
                Map tcppingProps;
                Map tcpProps;
                Map channelProps = clusterProps.get("channel") instanceof Map ? clusterProps.get("channel") : null;
                if (channelProps.containsKey("tcp") && (tcpProps = (Map)(channelProps.get("tcp") instanceof Map ? channelProps.get("tcp") : null)).containsKey("start_port")) {
                    clusterPort = (Integer)tcpProps.get("start_port");
                }
                if (channelProps.containsKey("tcpping") && (tcppingProps = (Map)(channelProps.get("tcpping") instanceof Map ? channelProps.get("tcpping") : null)).containsKey("initial_hosts")) {
                    String[] nodes;
                    list = String.valueOf(tcppingProps.get("initial_hosts")).toLowerCase();
                    for (String node : nodes = ((String)list).split("[,]", -1)) {
                        String[] nodename = node.split("[[]", -1);
                        ((ArrayList)affectedNodes.argvalue).add(nodename[0]);
                    }
                    if (((String)list).indexOf(joiningNode) == -1) {
                        list = (String)list + "," + joiningNode + "[" + clusterPort + "]";
                        tcppingProps.put("initial_hosts", list);
                    }
                }
                if (channelProps.containsKey("partitions") && partId != null && !partId.equals("") && (partitionsProps = (HashMap)(channelProps.get("partitions") instanceof HashMap ? channelProps.get("partitions") : null)) != null) {
                    Object nodesList;
                    if (partitionsProps.containsKey(partId.toLowerCase()) && ((String)(nodesList = String.valueOf(partitionsProps.get(partId.toLowerCase())).toLowerCase())).indexOf(joiningNode) == -1) {
                        nodesList = (String)nodesList + ", " + joiningNode;
                        partitionsProps.put(partId.toLowerCase(), nodesList);
                    }
                    for (String part : partitionsProps.keySet()) {
                        if (((ArrayList)affectedPartitions.argvalue).contains(part)) continue;
                        ((ArrayList)affectedPartitions.argvalue).add(part);
                    }
                }
            }
        }
        return CacheConfig.FromProperties(properties);
    }

    public static CacheConfig GetUpdatedConfig(Map properties, String partId, String newNode, RefObject<ArrayList> affectedNodes, RefObject<ArrayList> affectedPartitions, boolean isJoining) throws ManagementException, UnknownHostException {
        Map cacheProps;
        Object list = "";
        int clusterPort = 0;
        if (affectedNodes.argvalue == null) {
            affectedNodes.argvalue = new ArrayList();
        }
        if ((cacheProps = (Map)(properties.get("cache") instanceof Map ? properties.get("cache") : null)).containsKey("cache-classes")) {
            Map clusterProps;
            Map topologyProps;
            Map cacheClassesProps = cacheProps.get("cache-classes") instanceof Map ? cacheProps.get("cache-classes") : null;
            String cacheName = String.valueOf(cacheProps.get("name"));
            if (cacheClassesProps.containsKey(cacheName = cacheName.toLowerCase()) && (topologyProps = (Map)(cacheClassesProps.get(cacheName) instanceof Map ? cacheClassesProps.get(cacheName) : null)).containsKey("cluster") && (clusterProps = (Map)(topologyProps.get("cluster") instanceof Map ? topologyProps.get("cluster") : null)).containsKey("channel")) {
                HashMap partitionsProps;
                Map tcppingProps;
                Map tcpProps;
                Map channelProps = clusterProps.get("channel") instanceof Map ? clusterProps.get("channel") : null;
                if (channelProps.containsKey("tcp") && (tcpProps = (Map)(channelProps.get("tcp") instanceof Map ? channelProps.get("tcp") : null)).containsKey("start_port")) {
                    clusterPort = (Integer)tcpProps.get("start_port");
                }
                if (channelProps.containsKey("tcpping") && (tcppingProps = (Map)(channelProps.get("tcpping") instanceof Map ? channelProps.get("tcpping") : null)).containsKey("initial_hosts")) {
                    String[] nodename;
                    list = String.valueOf(tcppingProps.get("initial_hosts")).toLowerCase();
                    String[] nodes = ((String)list).split("[,]", -1);
                    if (isJoining) {
                        for (String node : nodes) {
                            nodename = node.split("[[]", -1);
                            ((ArrayList)affectedNodes.argvalue).add(nodename[0]);
                        }
                        if (((String)list).indexOf(newNode) == -1) {
                            list = (String)list + "," + newNode + "[" + clusterPort + "]";
                            tcppingProps.put("initial_hosts", list);
                        }
                    } else {
                        for (String node : nodes) {
                            nodename = node.split("[[]", -1);
                            if (newNode.equals(nodename[0])) continue;
                            ((ArrayList)affectedNodes.argvalue).add(nodename[0]);
                        }
                        list = "";
                        for (String node : (ArrayList)affectedNodes.argvalue) {
                            if (((String)list).length() == 0) {
                                list = node + "[" + clusterPort + "]";
                                continue;
                            }
                            list = (String)list + "," + node + "[" + clusterPort + "]";
                        }
                        tcppingProps.put("initial_hosts", list);
                    }
                }
                if (channelProps.containsKey("partitions") && partId != null && !partId.equals("") && (partitionsProps = (HashMap)(channelProps.get("partitions") instanceof HashMap ? channelProps.get("partitions") : null)) != null) {
                    Object nodesList;
                    if (partitionsProps.containsKey(partId.toLowerCase()) && ((String)(nodesList = String.valueOf(partitionsProps.get(partId.toLowerCase())).toLowerCase())).indexOf(newNode) == -1) {
                        nodesList = (String)nodesList + ", " + newNode;
                        partitionsProps.put(partId.toLowerCase(), nodesList);
                    }
                    for (String part : partitionsProps.keySet()) {
                        if (((ArrayList)affectedPartitions.argvalue).contains(part)) continue;
                        ((ArrayList)affectedPartitions.argvalue).add(part);
                    }
                }
            }
        }
        return CacheConfig.FromProperties(properties);
    }

    public static CacheConfig GetUpdatedConfig2(Map properties, String partId, String joiningNode, RefObject<ArrayList> affectedNodes, RefObject<ArrayList> affectedPartitions) throws ManagementException, UnknownHostException {
        Map clusterProps;
        Map.Entry current;
        Iterator ide;
        if (properties.size() == 1 && (ide = properties.entrySet().iterator()).hasNext() && (current = ide.next()).getValue() instanceof Map) {
            properties = current.getValue() instanceof Map ? current.getValue() : null;
        }
        Object list = "";
        int clusterPort = 0;
        if (affectedNodes.argvalue == null) {
            affectedNodes.argvalue = new ArrayList();
        }
        if (properties.containsKey("cluster") && (clusterProps = (Map)(properties.get("cluster") instanceof Map ? properties.get("cluster") : null)).containsKey("channel")) {
            Map channelProps = clusterProps.get("channel") instanceof Map ? clusterProps.get("channel") : null;
            if (channelProps.containsKey("tcp-port")) {
                clusterPort = (Integer)channelProps.get("tcp-port");
            }
            if (channelProps.containsKey("initial-hosts")) {
                String[] nodes;
                list = String.valueOf(channelProps.get("initial-hosts")).toLowerCase();
                for (String node : nodes = ((String)list).split("[,]", -1)) {
                    String[] nodename = node.split("[[]", -1);
                    ((ArrayList)affectedNodes.argvalue).add(nodename[0]);
                }
                if (((String)list).indexOf(joiningNode) == -1) {
                    list = (String)list + "," + joiningNode + "[" + clusterPort + "]";
                    channelProps.put("initial-hosts", list);
                    channelProps.put("num-initial-hosts", "2");
                }
            }
        }
        return CacheConfig.FromProperties2(properties);
    }

    public static CacheConfig FromProperties(Map properties, long tcpPort) throws Exception {
        boolean logsEnabled;
        Map cacheLogProps;
        CacheConfig data = new CacheConfig(tcpPort);
        if (properties.containsKey("partitionid")) {
            data.setPartitionId(properties.get("partitionid").toString().toLowerCase());
        }
        Map webprops = properties.get("web-cache") instanceof Map ? properties.get("web-cache") : null;
        Map cacheprops = properties.get("cache") instanceof Map ? properties.get("cache") : null;
        if (properties == null) {
            throw new ManagementException("Invalid configuration; missing 'web-cache' element.");
        }
        if (cacheprops.containsKey("cache-classes")) {
            Map cacheClassesProps = cacheprops.get("cache-classes") instanceof Map ? cacheprops.get("cache-classes") : null;
            String cacheName = String.valueOf(cacheprops.get("name"));
            if (cacheClassesProps.containsKey(cacheName = cacheName.toLowerCase())) {
                Map channelProps;
                Map clusterProps;
                Map topologyProps = cacheClassesProps.get(cacheName) instanceof Map ? cacheClassesProps.get(cacheName) : null;
                if (topologyProps.containsKey("cluster") && (clusterProps = (Map)(topologyProps.get("cluster") instanceof Map ? topologyProps.get("cluster") : null)).containsKey("channel") && (channelProps = (Map)(clusterProps.get("channel") instanceof Map ? clusterProps.get("channel") : null)).containsKey("tcp")) {
                    Map tcpProps = channelProps.get("tcp") instanceof Map ? channelProps.get("tcp") : null;
                    if (tcpProps.containsKey("start_port")) {
                        data.setClusterPort((Integer)tcpProps.get("start_port"));
                    }
                    if (tcpProps.containsKey("port_range")) {
                        data.setClusterPortRange((Integer)tcpProps.get("port_range"));
                    } else {
                        data.setClusterPortRange(2);
                    }
                }
                if (topologyProps.containsKey("type")) {
                    data._cacheType = String.valueOf(topologyProps.get("type"));
                }
            }
        }
        if (cacheprops.containsKey("log") && (cacheLogProps = (Map)(cacheprops.get("log") instanceof Map ? cacheprops.get("log") : null)).containsKey("enabled") && (logsEnabled = ((Boolean)cacheLogProps.get("enabled")).booleanValue())) {
            if (cacheLogProps.containsKey("trace-errors")) {
                data.setIsErrorLogsEnabled((Boolean)cacheLogProps.get("trace-errors"));
            }
            if (cacheLogProps.containsKey("trace-debug")) {
                data.setIsDetailedLogsEnabled((Boolean)cacheLogProps.get("trace-debug"));
            }
        }
        data.setCacheId(String.valueOf(webprops.get("cache-id")));
        if (data.getCacheId() == null || data.getCacheId().length() == 0) {
            throw new ManagementException("'cache-id' not specified in configuration.");
        }
        if (webprops.containsKey("channel")) {
            String channel = String.valueOf(webprops.get("channel"));
            if ((channel = channel.toLowerCase()).compareTo("http") == 0) {
                data.setUseTcp(false);
            }
        }
        if (webprops.containsKey("shared")) {
            data.setUseInProc((Boolean)webprops.get("shared") == false);
        }
        if (webprops.containsKey("port")) {
            data.setPort(((Integer)webprops.get("port")).intValue());
        }
        if (webprops.containsKey("server")) {
            data.setServerName(String.valueOf(webprops.get("server")));
        }
        properties.remove("id");
        properties.remove("type");
        data.setPropertyString(ConfigReader.ToPropertiesString((Map)properties));
        if (properties.containsKey("data-sharing")) {
            data.setDataSharingKnownTypes((HashMap)properties.get("data-sharing"));
        }
        if (properties.containsKey("compact-serialization")) {
            data.setCompactKnownTypes((HashMap)properties.get("compact-serialization"));
        }
        return data;
    }

    public static CacheConfig FromProperties(Map properties) throws ManagementException, UnknownHostException {
        CacheConfig data = new CacheConfig();
        if (properties.containsKey("partitionid")) {
            data.setPartitionId(properties.get("partitionid").toString().toLowerCase());
        }
        Map webprops = properties.get("web-cache") instanceof Map ? properties.get("web-cache") : null;
        Map cacheprops = properties.get("cache") instanceof Map ? properties.get("cache") : null;
        if (properties == null) {
            throw new ManagementException("Invalid configuration; missing 'web-cache' element.");
        }
        if (!(cacheprops == null || cacheprops.containsKey("class") && cacheprops.containsKey("name") || !properties.containsKey("id"))) {
            cacheprops.put("name", properties.get("id").toString());
            cacheprops.put("class", properties.get("id").toString());
        }
        try {
            boolean logsEnabled;
            Map cacheLogProps;
            if (cacheprops.containsKey("compression")) {
                Map compressionProps = cacheprops.get("compression") instanceof Map ? cacheprops.get("compression") : null;
                data._compressionEnabled = (Boolean)compressionProps.get("enabled");
                data._compressionThreshold = (Long)compressionProps.get("threshold");
            }
            if (cacheprops.containsKey("security")) {
                Map securityProps = cacheprops.get("security") instanceof Map ? cacheprops.get("security") : null;
                data._securityEnabled = (Boolean)securityProps.get("enabled");
                data._securityDomainController = (String)securityProps.get("domain-controller");
                data._securityPort = (String)securityProps.get("port");
                data._securityUsers = (HashMap)securityProps.get("user");
            }
            if (cacheprops.containsKey("cache-classes")) {
                Map cacheClassesProps = cacheprops.get("cache-classes") instanceof Map ? cacheprops.get("cache-classes") : null;
                String cacheName = String.valueOf(cacheprops.get("name"));
                if (cacheClassesProps.containsKey(cacheName = cacheName.toLowerCase())) {
                    Map scavengingProps;
                    Map clusterProps;
                    Map topologyProps = cacheClassesProps.get(cacheName) instanceof Map ? cacheClassesProps.get(cacheName) : null;
                    if (topologyProps.containsKey("cluster") && (clusterProps = (Map)(topologyProps.get("cluster") instanceof Map ? topologyProps.get("cluster") : null)).containsKey("channel")) {
                        Map tcppingProps;
                        Map channelProps = clusterProps.get("channel") instanceof Map ? clusterProps.get("channel") : null;
                        if (channelProps.containsKey("tcp")) {
                            Map tcpProps = channelProps.get("tcp") instanceof Map ? channelProps.get("tcp") : null;
                            if (tcpProps.containsKey("start_port")) {
                                data.setClusterPort((Integer)tcpProps.get("start_port"));
                            }
                            if (tcpProps.containsKey("use_heart_beat")) {
                                data.setUseHeartBeat((Boolean)tcpProps.get("use_heart_beat"));
                            }
                            if (tcpProps.containsKey("port_range")) {
                                data.setClusterPortRange((Integer)tcpProps.get("port_range"));
                            } else {
                                data.setClusterPortRange(2);
                            }
                        }
                        if (channelProps.containsKey("tcpping") && (tcppingProps = (Map)(channelProps.get("tcpping") instanceof Map ? channelProps.get("tcpping") : null)).containsKey("initial_hosts")) {
                            String hostString = (String)tcppingProps.get("initial_hosts");
                            data._servers = CacheConfig.FromHostListToServers(hostString);
                        }
                    }
                    if (topologyProps.containsKey("type")) {
                        data._cacheType = String.valueOf(topologyProps.get("type"));
                    }
                    if (topologyProps.containsKey("clean-interval")) {
                        data._cleanInterval = (Long)topologyProps.get("clean-interval") * 1000L;
                    }
                    if (topologyProps.containsKey("scavenging-policy") && (scavengingProps = (Map)(topologyProps.get("scavenging-policy") instanceof Map ? topologyProps.get("scavenging-policy") : null)).containsKey("evict-ratio")) {
                        data._evictRatio = ((Float)scavengingProps.get("evict-ratio")).floatValue();
                    }
                    if (topologyProps.containsKey("storage")) {
                        String storageClass;
                        Map storageProviderProps;
                        Map storageProps = topologyProps.get("storage") instanceof Map ? topologyProps.get("storage") : null;
                        if (storageProps.containsKey("class") && (storageProviderProps = (Map)(storageProps.get(storageClass = (String)(storageProps.get("class") instanceof String ? storageProps.get("class") : null)) instanceof Map ? storageProps.get(storageClass) : null)).containsKey("max-size")) {
                            data._cacheMaxSize = (Long)storageProviderProps.get("max-size") * 1024L * 1024L;
                        }
                    } else if (topologyProps.containsKey("internal-cache")) {
                        String storageClass;
                        Map storageProviderProps;
                        Map storageProps;
                        Map scavengingProps2;
                        Map internalProps = topologyProps.get("internal-cache") instanceof Map ? topologyProps.get("internal-cache") : null;
                        if (internalProps.containsKey("clean-interval")) {
                            data._cleanInterval = (Long)internalProps.get("clean-interval") * 1000L;
                        }
                        if (internalProps.containsKey("scavenging-policy") && (scavengingProps2 = (Map)(internalProps.get("scavenging-policy") instanceof Map ? internalProps.get("scavenging-policy") : null)).containsKey("evict-ratio")) {
                            data._evictRatio = ((Float)scavengingProps2.get("evict-ratio")).floatValue();
                        }
                        if (internalProps.containsKey("storage") && (storageProps = (Map)(internalProps.get("storage") instanceof Map ? internalProps.get("storage") : null)).containsKey("class") && (storageProviderProps = (Map)(storageProps.get(storageClass = (String)(storageProps.get("class") instanceof String ? storageProps.get("class") : null)) instanceof Map ? storageProps.get(storageClass) : null)).containsKey("max-size")) {
                            data._cacheMaxSize = (Long)storageProviderProps.get("max-size") * 1024L * 1024L;
                        }
                    }
                }
            }
            if (cacheprops.containsKey("log") && (cacheLogProps = (Map)(cacheprops.get("log") instanceof Map ? cacheprops.get("log") : null)).containsKey("enabled") && (logsEnabled = ((Boolean)cacheLogProps.get("enabled")).booleanValue())) {
                if (cacheLogProps.containsKey("trace-errors")) {
                    data.setIsErrorLogsEnabled((Boolean)cacheLogProps.get("trace-errors"));
                }
                if (cacheLogProps.containsKey("trace-debug")) {
                    data.setIsDetailedLogsEnabled((Boolean)cacheLogProps.get("trace-debug"));
                }
            }
            if (cacheprops.containsKey("bridge")) {
                Map cacheBridgeProps = cacheprops.get("bridge") instanceof Map ? cacheprops.get("bridge") : null;
                if (cacheBridgeProps.containsKey("id")) {
                    data.setBridgeId(String.valueOf(cacheBridgeProps.get("id")));
                }
                if (cacheBridgeProps.containsKey("servers")) {
                    String serversString = String.valueOf(cacheBridgeProps.get("servers"));
                    String[] servers = serversString.split("[,]", -1);
                    ArrayList<String> serversList = new ArrayList<String>();
                    for (String server : servers) {
                        if (serversList.contains(server)) continue;
                        serversList.add(server);
                    }
                    data.setBridgeServers(serversList);
                }
                if (cacheBridgeProps.containsKey("port")) {
                    data.setBridgePort((Integer)cacheBridgeProps.get("port"));
                }
                if (cacheBridgeProps.containsKey("is-target-cache")) {
                    data.setIsBridgeTargetCache((Boolean)cacheBridgeProps.get("is-target-cache"));
                }
            }
        }
        catch (Exception cacheBridgeProps) {
            // empty catch block
        }
        data.setCacheId(String.valueOf(webprops.get("cache-id")));
        if (data.getCacheId() == null || data.getCacheId().length() == 0) {
            throw new ManagementException("'cache-id' not specified in configuration.");
        }
        if (webprops.containsKey("channel")) {
            String channel = String.valueOf(webprops.get("channel"));
            if ((channel = channel.toLowerCase()).compareTo("http") == 0) {
                data.setUseTcp(false);
            }
        }
        if (webprops.containsKey("shared")) {
            data.setUseInProc(!Boolean.parseBoolean(webprops.get("shared").toString()));
        }
        if (webprops.containsKey("port")) {
            data.setPort(((Integer)webprops.get("port")).intValue());
        } else {
            data.setPort(data.getUseTcp() ? (long)CacheConfigManager.getTcpPort() : (long)CacheConfigManager.getHttpPort());
        }
        if (webprops.containsKey("server")) {
            data.setServerName(String.valueOf(webprops.get("server")));
        }
        properties.remove("id");
        properties.remove("type");
        data.setPropertyString(ConfigReader.ToPropertiesString((Map)properties));
        if (properties.containsKey("data-sharing")) {
            data.setDataSharingKnownTypes((HashMap)properties.get("data-sharing"));
        }
        if (properties.containsKey("compact-serialization")) {
            data.setCompactKnownTypes((HashMap)properties.get("compact-serialization"));
        }
        return data;
    }

    private static ArrayList FromHostListToServers(String hostString) {
        ArrayList<String> servers = new ArrayList<String>();
        if (hostString.indexOf(44) != -1) {
            String[] hosts = hostString.split("[,]", -1);
            if (hosts != null) {
                for (int i = 0; i < hosts.length; ++i) {
                    hosts[i] = hosts[i].trim();
                    servers.add(hosts[i].substring(0, hosts[i].indexOf(91)));
                }
            }
        } else {
            servers.add(hostString.trim().substring(0, hostString.indexOf(91)));
        }
        return servers;
    }

    public static CacheConfig FromProperties2(Map properties) throws ManagementException, UnknownHostException {
        CacheConfig data = new CacheConfig();
        try {
            Map clusterProps;
            boolean logsEnabled;
            Map cacheLogProps;
            if (!properties.containsKey("name")) {
                throw new ManagementException("'name' not specified in configuration.");
            }
            data._cacheId = properties.get("name") instanceof String ? properties.get("name") : null;
            if (properties.containsKey("log") && (cacheLogProps = (Map)(properties.get("log") instanceof Map ? properties.get("log") : null)).containsKey("enabled") && (logsEnabled = ((Boolean)cacheLogProps.get("enabled")).booleanValue())) {
                if (cacheLogProps.containsKey("trace-errors")) {
                    data.setIsErrorLogsEnabled((Boolean)cacheLogProps.get("trace-errors"));
                }
                if (cacheLogProps.containsKey("trace-debug")) {
                    data.setIsDetailedLogsEnabled((Boolean)cacheLogProps.get("trace-debug"));
                }
            }
            if (properties.containsKey("cluster") && (clusterProps = (Map)(properties.get("cluster") instanceof Map ? properties.get("cluster") : null)).containsKey("channel")) {
                Map channelProps = clusterProps.get("channel") instanceof Map ? clusterProps.get("channel") : null;
                if (channelProps.containsKey("tcp-port")) {
                    data.setClusterPort((Integer)channelProps.get("tcp-port"));
                }
                data.setClusterPortRange(1);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        data.setUseInProc((Boolean)properties.get("inproc"));
        data.setPropertyString(ConfigReader.ToPropertiesString((Map)properties));
        return data;
    }

    public final int getBridgePort() {
        return this._bridgePort;
    }

    public final void setBridgePort(int value) {
        this._bridgePort = value;
    }

    public final String getBridgeId() {
        return this._bridgeId;
    }

    public final void setBridgeId(String value) {
        this._bridgeId = value;
    }

    public final ArrayList getBridgeServers() {
        return this._bridgeServers;
    }

    public final void setBridgeServers(ArrayList value) {
        this._bridgeServers = value;
    }

    public final boolean getIsBridgeTargetCache() {
        return this._isBridgeTargetCache;
    }

    public final void setIsBridgeTargetCache(boolean value) {
        this._isBridgeTargetCache = value;
    }

    public final boolean getBridgeSecurity() {
        return this._bridgeSecurityEnabled;
    }

    public final void setBridgeSecurity(boolean value) {
        this._bridgeSecurityEnabled = value;
    }

    public final String getBridgeUsername() {
        return this._bridgeUsername;
    }

    public final void setBridgeUsername(String value) {
        this._bridgeUsername = value;
    }

    public final String getBridgePassword() {
        return this._bridgePassword;
    }

    public final void setBridgePassword(String value) {
        this._bridgePassword = value;
    }

    public final ArrayList getServers() {
        return this._servers;
    }

    public final boolean getCompressionEnabled() {
        return this._compressionEnabled;
    }

    public final long getCompressionThreshold() {
        return this._compressionThreshold;
    }

    public final boolean getSecurityEnabled() {
        return this._securityEnabled;
    }

    public final String getSecurityDomainController() {
        return this._securityDomainController;
    }

    public String getSecurityPort() {
        return this._securityPort;
    }

    public final HashMap getSecurityUsers() {
        return this._securityUsers;
    }

    public final HashMap getAlertNotification() {
        return this._alertNotifications;
    }

    public final long getCacheMaxSize() {
        return this._cacheMaxSize;
    }

    public final long getCleanInterval() {
        return this._cleanInterval;
    }

    public final float getEvictRatio() {
        return this._evictRatio;
    }

    public final String getCacheType() {
        return this._cacheType;
    }

    public final void setCacheType(String value) {
        this._cacheType = value;
    }

    public final String getCacheId() {
        return this._cacheId;
    }

    public final void setCacheId(String value) {
        this._cacheId = value;
    }

    public final String getPartitionId() {
        return this._paritionId;
    }

    public final void setPartitionId(String value) {
        this._paritionId = value;
    }

    public final boolean getUseInProc() {
        return this._useInProc;
    }

    public final void setUseInProc(boolean value) {
        this._useInProc = value;
    }

    public final String getServerName() {
        return this._serverName;
    }

    public final void setServerName(String value) {
        this._serverName = value;
    }

    public final boolean getUseTcp() {
        return this._useTcp;
    }

    public final void setUseTcp(boolean value) {
        this._useTcp = value;
    }

    public final long getPort() {
        return this._port;
    }

    public final void setPort(long value) {
        this._port = value;
    }

    public final String getPropertyString() {
        return this._propertyString;
    }

    public final void setPropertyString(String value) {
        this._propertyString = value;
    }

    public final HashMap getDataSharingKnownTypes() {
        return this._dataSharingKnownTypes;
    }

    public final void setDataSharingKnownTypes(HashMap value) {
        this._dataSharingKnownTypes = value;
    }

    public final HashMap getCompactKnownTypes() {
        return this._cmptKnownTypes;
    }

    public final void setCompactKnownTypes(HashMap value) {
        this._cmptKnownTypes = value;
    }

    public final HashMap getBackingSource() {
        return this._backingSource;
    }

    public final void setBackingSource(HashMap value) {
        this._backingSource = value;
    }

    public final boolean getIsUdpCluster() {
        return this.getPropertyString().indexOf("cluster") > 0 && this.getPropertyString().indexOf("udp") > 0;
    }

    public final int getClusterPort() {
        return this._clusterPort;
    }

    public final void setClusterPort(int value) {
        this._clusterPort = value;
    }

    public final int getClusterPortRange() {
        return this._clusterPortRange;
    }

    public final void setClusterPortRange(int value) {
        this._clusterPortRange = value;
    }

    public final boolean getIsErrorLogsEnabled() {
        return this._errorLogsEnabled;
    }

    public final void setIsErrorLogsEnabled(boolean value) {
        this._errorLogsEnabled = value;
    }

    public final boolean getIsDetailedLogsEnabled() {
        return this._detailedLogsEnabled;
    }

    public final void setIsDetailedLogsEnabled(boolean value) {
        this._detailedLogsEnabled = value;
    }

    public final boolean getUseHeartBeat() {
        return this._useHeartBeat;
    }

    public final void setUseHeartBeat(boolean value) {
        this._useHeartBeat = value;
    }

    private void InitializeServerName() throws UnknownHostException {
        this._serverName = InetAddress.getLocalHost().getHostName();
    }
}

