package Alachisoft.NCache.ServiceControl;

import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Management.CacheConfigManager;
import Alachisoft.NCache.Management.CacheServer;
import Alachisoft.NCache.Management.ICacheServer;
import com.alachisoft.ncache.runtime.util.TimeSpan;

import java.io.IOException;
import java.net.UnknownHostException;

/**
 * Represents the NCache remoting objects and allows you to start the service and get and instance of the CacheServer on a node.
 */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
//[CLSCompliant(false)]
public class NCacheService extends ServiceBase {

    /**
     * Constructor
     */
    public NCacheService() throws UnknownHostException {
    }

    /**
     * Overloaded Constructor
     *
     * @param server name of machine where the service is running.
     * @param useTcp use tcp channel for remoting.
     */

    public NCacheService(String server, boolean useTcp) throws UnknownHostException {
        this(server, useTcp ? CacheConfigManager.getTcpPort() : CacheConfigManager.getHttpPort(), useTcp);
    }


    /**
     * Overloaded Constructor
     *
     * @param server name of machine where the service is running.
     * @param port   port used by the remote server.
     * @param useTcp use tcp channel for remoting.
     */
    public NCacheService(String server, long port, boolean useTcp) throws UnknownHostException {
        super(server, port, useTcp);
    }

    /**
     * Returns the instance of Cache manager running on the node, starts the service if not running.
     *
     * @return
     */
    public ICacheServer GetCacheServer(TimeSpan timeout) throws ManagementException, java.lang.Exception {
        ICacheServer cm = null;
        try {
            // Try to connect to cache manager first, saves time if the
            // service is already running.
            cm = ConnectCacheServer();
        } catch (ManagementException socketException) {
            //Basit: Making life easy
//            if (socketException.SocketErrorCode == SocketError.TimedOut)
//            { //Machine is not accesible my be should down or we cannot reach it so no need to start service
//                throw new ManagementException(socketException.getMessage(), socketException);
//            }
            try {
                Start(timeout);
                cm = ConnectCacheServer();

            } catch (ManagementException e) {
                throw e;
            } catch (Exception e) {
                throw new ManagementException(e.getMessage(), e);
            }
        } catch (Exception exception) {
            try {
                Start(timeout);
                cm = ConnectCacheServer();
            } catch (Exception e) {
                throw new ManagementException(e.getMessage(), e);
            }
        }
        return cm;
    }


    /**
     * Returns a running instance of CacheServer; does not start the service. If user specifies in the client application an ip address to server channels to bind to then this
     * method creates the server channel bound to that ip. also the object uri then uses the ip address instead of server name.
     *
     * @return
     */
    public ICacheServer ConnectCacheServer() throws ManagementException, IOException {
        //Muneeb: Not Supported remoting

//        String objectUri = "";
//        String protocol;
//        String ip = "";
//
//        try
//        {
//            if (_channel == null)
//            {
//                _channel = new RemotingChannels();
//
//                //RemotingConfiguration.CustomErrorsMode = CustomErrorsModes.Off;
////C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
////#if VS2005
//                String portName = java.net.InetAddress.getLocalHost().getHostName() + "_" + ManagementFactory.getRuntimeMXBean().getName();
//                _channel.RegisterIPCChannels("NCC", portName);
//
//
//                ip = System.getProperty("NCacheServer.BindToClusterIP");
//                if (ip != null && ip.length() > 0)
//                {
//                    if (_useTcp)
//                    {
//                        _channel.RegisterTcpChannels("NCC", ip, 0);
//                    }
//                    else
//                    {
//                        _channel.RegisterHttpChannels("NCC", ip, 0);
//                    }
//                }
//                else
//                {
//                    if (_useTcp)
//                    {
//                        _channel.RegisterTcpChannels("NCC", 0);
//                    }
//                    else
//                    {
//                        _channel.RegisterHttpChannels("NCC", 0);
//                    }
//                }
////#endif
//            }
//
////C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
////#if VS2005
////C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
////#if !THINCLIENT
////C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//            protocol = "ipc://";
//            objectUri = protocol + _portName + "/" + CacheServer.getObjectUri();
//            protocol = _useTcp ? "tcp://" : "http://";
//
//
//            if (ip != null && ip.length() > 0)
//            {
//                objectUri = protocol + ip + ":" + _port + "/" + CacheHost.getApplicationName() + "/" + CacheServer.getObjectUri();
//
//            }
//            else
//            {
//                objectUri = protocol + _serverName + ":" + _port + "/" + CacheHost.getApplicationName() + "/" + CacheServer.getObjectUri();
//
//            }
//
//
//
//            CacheServer server = (CacheServer) Activator.GetObject(CacheServer.class, objectUri, WellKnownObjectMode.Singleton);
//            int ccount = server.getCaches().size();
//            if (ccount > 0)
//            { // SAL: What this statement means?
//                server = server;
//            }
//            return server;
//        }
//        catch (IOException socketException)
//        {
//            throw socketException;
//        }
//        catch (Exception e)
//        {
//            throw new ManagementException(e.getMessage(), e);
//        }
        return new CacheServer();
    }

    /**
     * Starts the NCache service on target machine.
     */
    protected final void Start(TimeSpan timeout) throws ManagementException {

        //Muneeb: Not Supported remoting
//        try
//        {
////C# TO JAVA CONVERTER NOTE: The following 'using' block is replaced by its Java equivalent:
////			using (ServiceControl sc = new ServiceControl(_serverName, "NCacheSvc"))
//            ServiceControl sc = new ServiceControl(_serverName, "NCacheSvc");
//            try
//            {
//                if (!sc.getIsRunning())
//                {
//                    sc.WaitForStart(timeout);
//                }
//            }
//            finally
//            {
//                sc.dispose();
//            }
//        }
//        catch (Exception e)
//        {
//            throw new ManagementException(e.getMessage(), e);
//        }
    }
}