package Alachisoft.NCache.Management.Statistics;

//  Copyright (c) 2020 Alachisoft
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License

public interface StatisticsCounter {
    /**
     * Returns true if the current user has the rights to read/write to performance counters
     * under the category of object cache.
     */
    String getInstanceName();

    void setInstanceName(String value);

    /**
     * Creates Instancename
     * For outproc instanceName = CacheID
     * For inProc instanceNAme = CacheID +"-" + ProcessID + ":" +port
     *
     * @param port
     * @param inProc
     * @return
     */
    String getInstanceName(String instanceName, int port, boolean inProc);

    /**
     * Returns true if the current user has the rights to read/write to performance counters
     * under the category of object cache.
     */
    boolean getUserHasAccessRights();

    /**
     * Gets or Sets the value indicating whether Performance Stats collection is enabled or not.
     * On initialize Performance Collection is enabled.
     */
    boolean getIsEnabled();

    void setIsEnabled(boolean value);

    ///#region    /                 --- IDisposable ---           /

    /**
     * Performs application-defined tasks associated with freeing, releasing, or
     * resetting unmanaged resources.
     */
    void dispose();

    ///#endregion

    ///#region    /                 --- Initialization ---           /

    /**
     * Initializes the counter instances and category.
     */
    void initializePerfCounters(boolean inproc) throws Exception;

    ///#endregion

    /**
     * Increment the performance counter for Requests Per second by client.
     */
    void incrementClientRequestsPerSecStats(long requests);

    /**
     * Increment the performance counter for Responses received Per second by client.
     */
    void incrementClientResponsesPerSecStats(long responses);

    /**
     * Increment the performance counter for Requests Per second by all the clients.
     */
    void incrementTotalClientRequestsPerSecStats(long requests);

    /**
     * Increment the performance counter for Responses received Per second by all the clients.
     */
    void incrementTotalClientResponsesPerSecStats(long responses);

    /**
     * Increment the performance counter for Cache get operations per second.
     */
    void incrementGetPerSecStats();

    /**
     * Increment the performance counter for Cache get operations per second.
     */
    void incrementByGetPerSecStats(long value);

    /**
     * Increment the performance counter for Cache add operations per second.
     */
    void incrementAddPerSecStats();

    /**
     * Increment the performance counter for Cache add operations per second.
     */
    void incrementByAddPerSecStats(long value);

    /**
     * Increment the performance counter for Cache update operations per second.
     */
    void incrementUpdPerSecStats();

    /**
     * Increment the performance counter for Cache update operations per second.
     */
    void incrementByUpdPerSecStats(long value);

    /**
     * Increment the performance counter for Cache remove operations per second.
     */
    void incrementDelPerSecStats();

    /**
     * Increment the performance counter for Cache remove operations per second.
     */
    void incrementByDelPerSecStats(long value);

    /**
     * Timestamps the start of sampling interval for Cache avg. and max. per mill-second time of
     * event operations.
     * s
     */
    void incrementAvgEventProcessingSample(long value);

    /**
     * Increment the performance counter for Responses received Per second by all the clients.
     */
    void incrementEventsProcessedPerSec();

    /**
     * Increment the performance counter for Responses received Per second by all the clients.
     */
    void incrementEventsTriggeredPerSeconds();

    /**
     * Increments the performance counter for compression/sec.
     */
    void incrementCompressionPerSec();

    /**
     * Increments the performance counter for Average �s/compression.
     *
     * @param value Value to increment by
     */
    void incrementMsecPerCompression(long value);

    /**
     * Increments the performance counter for Average �s/compression.
     *
     * @param value Value to increment by
     */
    void incrementMsecPerDecompression(long value);

    /**
     * Increments the performance counter for Average Compressed Item Size.
     *
     * @param value Value to increment by
     */
    void incrementAvgCompressedItemSize(long value);

    /**
     * Increments the performance counter for Average �s/serialization.
     *
     * @param value Value to increment by
     */
    void incrementMsecPerSerialization(long value);


    /**
     * Increments the performance counter for Average �s/serialization.
     *
     * @param value Value to increment by
     */
    void incrementMsecPerDeserialization(long value);

    /**
     * Increments the performance counter for Average Item Size.
     */
    void incrementAvgItemSize(long itemSize);

    /**
     * Timestamps the start of sampling interval for Cache avg. and max. per mill-second time of
     * fetch operations.
     */
    void msecPerGetBeginSample();

    void incrementMsecPerGetSample(long value);

    void incrementMsecPerGetSample(long value, long baseValue);

    /**
     * Timestample and updates the counter for Cache avg. and max. per mill-second time of
     * fetch operations.
     */
    void msecPerGetEndSample();

    /**
     * Timestamps the start of sampling interval for Cache avg. and max. per mill-second time of
     * add operations.
     */
    void msecPerAddBeginSample();

    void incrementMsecPerAddSample(long value);

    void incrementMsecPerAddSample(long value, long baseValue);

    /**
     * Timestample and updates the counter for Cache avg. and max. per mill-second time of
     * add operations.
     */
    void msecPerAddEndSample();

    void incrementMsecPerDecryptionSample(long value);

    void incrementMsecPerEncryptionSample(long value);

    /**
     * Timestamps the start of sampling interval for Cache avg. and max. per mill-second time of
     * update operations.
     */
    void msecPerUpdBeginSample();

    void incrementMsecPerUpdSample(long value);

    void incrementMsecPerUpdSample(long value, long baseValue);

    /**
     * Timestample and updates the counter for Cache avg. and max. per mill-second time of
     * update operations.
     */
    void msecPerUpdEndSample();

    /**
     * Timestamps the start of sampling interval for Cache avg. and max. per mill-second time of
     * remove operations.
     */
    void msecPerDelBeginSample();

    void incrementMsecPerDelSample(long value);

    void incrementMsecPerDelSample(long value, long baseValue);

    /**
     * Timestample and updates the counter for Cache avg. and max. per mill-second time of
     * remove operations.
     */
    void msecPerDelEndSample();

    //Bulk Counters Incrementors
    void incrementMsecPerAddBulkSample(long value);

    void incrementMsecPerGetBulkSample(long value);

    void incrementMsecPerUpdBulkSample(long value);

    void incrementMsecPerDelBulkSample(long value);


    /**
     * Increment the performance counter for Mirror Queue size by one.
     */
    void incrementRequestQueueSizeStats();

    /**
     * Decrement the performance counter for Mirror Queue size by one.
     */
    void decrementRequestQueueSizeStats();


    ///#region ------------ Poll Counters Methods ---------------

    /**
     * Sets the Raw value of Sync poll request count
     *
     * @param value
     */
    void setPollRequestsCount(long value);

    /**
     * Inrements the Sync Poll request count by 1.
     */
    void incrementPollRequestCount();

    /**
     * Sets the last sync poll resultant updates
     *
     * @param value
     */
    void setPollLastUpdates(long value);

    /**
     * Sets the last sync poll resultant removes.
     *
     * @param value
     */
    void setPollLastRemoves(long value);
    ///#endregion

    void incrementMsecPerMessagePublish(long value);

    void incrementMessageCounter(String counterName,int incrementedValue);

    void incrementMessagePublishedPerSec(int incrementBy);

    void incrementMessageDeliverPerSec(long value);

    void startPublishingCounters(String bindIp);

    void DecrementRequestQueueSizeStats();

    void IncrementEventsTriggeredPerSeconds(long pcEventTriggeredPerSec);

    void IncrementClientRequestsPerSecStats(long requests);

    void IncrementClientResponsesPerSecStats(long value);

    void IncrementTotalClientRequestsPerSecStats(long value);

    void IncrementTotalClientResponsesPerSecStats(long value);

    void IncrementByGetPerSecStats(long value);

    void IncrementByAddPerSecStats(long value);

    void IncrementByUpdPerSecStats(long value);

    void IncrementByDelPerSecStats(long value);

    void IncrementEventsProcessedPerSec(long value);

    void IncrementCompressionPerSec(long value);

    void IncrementMsecPerMessagePublish(long value , long messageCount);

    void IncrementMessageDeliverPerSec(long value);

    void IncrementMessageCounter(String counterName , long value);

    void mSecPerDecryptionBeginSample();



    void mSecPerDecryptionEndSample();

    void incrementEventProcessedPerSec();
}
