/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package Alachisoft.NCache.Management;

import com.alachisoft.ncache.licensing.ExpirationInfo;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;

import java.io.IOException;
import java.util.Date;

/**
 * @author muhammad_sami
 */
public class ServerLicenseInfo implements ICompactSerializable
{
    public LicenseManager.LicenseType _licenseType;
    public String _version;
    public String _editionID;
    public long _evaluationDate;
    public String _registeredName;
    public String _companyName;
    public int _evalPeriod;
    public boolean _isReactivated;
    public boolean _isEval;
    public String _spVersion;
    public boolean _isServerOnly;
    public boolean _isPrepetual;
    public int _graceDays;
    public long _expirationDate;
    public boolean _isExpiring;
    public String _email = "";
    public boolean _isExpired;
    public boolean _expiredFromEvaluation = false;
    public String _installationVesion;
    public boolean _isTrial = false;
    private String _firstName;
    private String _lastName;

    public ServerLicenseInfo()
    {
        load();
    }


    public boolean getIsExpiring()
    {
        try
        {

            return _isExpiring;
        }
        catch (java.lang.Exception e)
        {
            return false;
        }
    }
    public void setIsExpiring(boolean value)
    {
        _isExpiring = value;
    }

    public boolean getISReactivated()
    {

        return _isReactivated;
    }
    public void setISReactivated(boolean value)
    {
        _isReactivated = value;
    }

    public boolean getIsPreEvalLicense()
    {
        return _isEval;
    }
    public void setIsPreEvalLicense(boolean value)
    {
        _isEval = value;
    }

    public boolean getIsServerOnly()
    {
        try
        {

            return _isServerOnly;
        }
        catch (java.lang.Exception e)
        {
            return false;
        }
    }
    public void setIsServerOnly(boolean value)
    {
        _isServerOnly = value;
    }

    public boolean getIsTrialLicense()
    {
        return _isTrial;
    }
    public void setIsTrialLicense(boolean value)
    {
        _isTrial = false;
    }

    public boolean getIsPrepetual()
    {
        try
        {

            return _isPrepetual;
        }
        catch (java.lang.Exception e)
        {
            return false;
        }
    }
    public void setIsPrepetual(boolean value)
    {
        _isPrepetual = value;
    }

    public int getGraceDays()
    {
        try
        {

            return _graceDays;
        }
        catch (java.lang.Exception e)
        {
            return 0;
        }

    }
    public void setGraceDays(int value)
    {
        _graceDays = value;
    }


    public long getExpirationDate()
    {
        try
        {

            return _expirationDate;
        }
        catch (java.lang.Exception e)
        {
            return 0;
        }
    }
    public void setExpirationDate(long value)
    {
        _expirationDate = value;
    }

    public boolean getIsExpired()
    {
        return _isExpired;
    }
    public void setIsExpired(boolean value)
    {
        _isExpired = value;
    }

    public boolean getExpiredFromEvaluation()
    {
        return _expiredFromEvaluation;
    }
    public void setExpiredFromEvaluation(boolean value)
    {
        _expiredFromEvaluation = value;
    }

    public LicenseManager.LicenseType getLicenseType()
    {
        return _licenseType;
    }
    public void setLicenseType(LicenseManager.LicenseType value)
    {
        _licenseType = value;
    }

    public String getVersion()
    {
        return _version;
    }
    public void setVersion(String value)
    {
        _version = value;
    }

    public String getInstallationVersion()
    {
        return _installationVesion;
    }
    public void setInstallationVersion(String value)
    {
        _installationVesion = value;
    }


    public String getSPVersion()
    {
        return _spVersion;
    }
    public void setSPVersion(String value)
    {
        _spVersion = value;
    }

    public String getEditionID()
    {
        return _editionID;
    }
    public void setEditionID(String value)
    {
        _editionID = value;
    }

    public long getEvaluationDate()
    {
        return _evaluationDate;
    }
    public void setEvaluationDate(long value)
    {
        _evaluationDate = value;
    }

    public String getEmail()
    {
        return _email;
    }
    public void setEmail(String value)
    {
        _email = value;
    }

    public String getRegisteredName()
    {
        return _registeredName;
    }
    public void setRegisteredName(String value)
    {
        _registeredName = value;
    }

    public String getCompanyName()
    {
        return _companyName;
    }
    public void setCompanyName(String value)
    {
        _companyName = value;
    }

    public int getEvaluationPeriod()
    {
        return _evalPeriod;
    }
    public void setEvaluationPeriod(int value)
    {
        _evalPeriod = value;
    }
    private String evironmentName;
    public String getEvironmentName()
    {
        return evironmentName;
    }
    public void setEvironmentName(String value)
    {
        evironmentName = value;
    }
    private int clientCpus;
    public int getClientCpus()
    {
        return clientCpus;
    }
    public void setClientCpus(int value)
    {
        clientCpus = value;
    }
    private int clientCpusInUse;
    public int getClientCpusInUse()
    {
        return clientCpusInUse;
    }
    public void setClientCpusInUse(int value)
    {
        clientCpusInUse = value;
    }
    public String getFirstName()
    {
        return _firstName;
    }
    public void setFirstName(String value)
    {
        _firstName = value;
    }
    public String getLastName()
    {
        return _lastName;
    }
    public void setLastName(String value)
    {
        _lastName = value;
    }

    public void load()
    {

        try {
            _licenseType = LicenseManager.LicenseMode(null);
        } catch (Exception e) {
        }
        ExpirationInfo expirationInfo = LicenseManager.getExpirationInfo();
        _expirationDate = new NCDateTime(expirationInfo.getExpirationDate().getTime()).getTicks();
        if (NCDateTime.getUTCNow().compareTo(expirationInfo.getExpirationDate().getTime()) < 0)
        {
            if (TimeSpan.subtract(expirationInfo.getExpirationDate().getTime(),new Date()).getDays() <= 30)
            {
                _isExpiring = true;
            }
            else
            {
                _isExpiring = false;
            }
        }
        else
        {
            int daysAfterExpiration = (TimeSpan.subtract(expirationInfo.getExpirationDate().getTime(), NCDateTime.getUTCNow()).getDays());
            if (daysAfterExpiration > _graceDays)
            {
                _isExpired = false;
            }
            else
            {
                _isExpired = true;
                _isExpiring = false;
            }

        }

        _isServerOnly = expirationInfo.getIsServerOnly();
        _graceDays = expirationInfo.getGracePeriod();
        _isPrepetual = expirationInfo.isPerpetual();
        _isTrial = expirationInfo.getIsTrial();

        _isReactivated = LicenseManager.getReactivate();
        _evalPeriod = LicenseManager.getEvaluationPeriod();

        _companyName = RegUtil.getKey(InfoType.USER,RegKeys.Company);
        setEvironmentName(LicenseManager.getEnvironmentName());
        setClientCpus(LicenseManager.getClientCpus());
        //setClientCpusInUse(Integer.parseInt(RegUtil.getKey(InfoType.USER,RegKeys.ClientCups)));


        _firstName = RegUtil.getKey(InfoType.USER,RegKeys.FirstName);
        _lastName = RegUtil.getKey(InfoType.USER,RegKeys.LastName);
        _registeredName = _firstName + " " + _lastName;
        _email = RegUtil.getKey(InfoType.USER,RegKeys.Email);
        _evaluationDate = new NCDateTime(LicenseManager.getEvaluationDt().getTime()).getTicks();
        _editionID = LicenseManager.ActivationInfo.getEditionID();
        _spVersion = RegUtil.getKey(InfoType.USER,RegKeys.SpVersion);
        _version = LicenseManager.getLicenseInfo().getVersion();

        _expiredFromEvaluation = LicenseManager.getExpiredFromEvaluation();


        try {
            _installationVesion = AppUtil.getVersion();
        } catch (Exception e) {
        }
    }

    public void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        _licenseType = LicenseManager.LicenseType.forValue(reader.readInt());
        Object tempVar = reader.readObject();
        _version = (String)((tempVar instanceof String) ? tempVar : null);
        Object tempVar2 = reader.readObject();
        _editionID = (String)((tempVar2 instanceof String) ? tempVar2 : null);
        _evaluationDate = reader.readLong();
        Object tempVar3 = reader.readObject();
        _registeredName = (String)((tempVar3 instanceof String) ? tempVar3 : null);
        Object tempVar4 = reader.readObject();
        _companyName = (String)((tempVar4 instanceof String) ? tempVar4 : null);

        _isEval = reader.readBoolean();

        _evalPeriod = reader.readInt();
        _isReactivated = reader.readBoolean();
        Object tempVar5 = reader.readObject();
        _spVersion = (String)((tempVar5 instanceof String) ? tempVar5 : null);
        _isServerOnly = reader.readBoolean();
        _isPrepetual = reader.readBoolean();
        _graceDays = reader.readInt();
        _expirationDate = reader.readLong();
        _isExpiring = reader.readBoolean();
        Object tempVar6 = reader.readObject();
        _email = (String)((tempVar6 instanceof String) ? tempVar6 : null);
        _isExpired = reader.readBoolean();
        _expiredFromEvaluation = reader.readBoolean();
        Object tempVar7 = reader.readObject();
        _installationVesion = (String)((tempVar7 instanceof String) ? tempVar7 : null);
        setClientCpus(reader.readInt());
        Object tempVar8 = reader.readObject();
        setEvironmentName((String)((tempVar8 instanceof String) ? tempVar8 : null));
        setClientCpusInUse(reader.readInt());
        _isTrial = reader.readBoolean();
        Object tempVar9 = reader.readObject();
        _firstName = (String)((tempVar9 instanceof String) ? tempVar9 : null);
        Object tempVar10 = reader.readObject();
        _lastName = (String)((tempVar10 instanceof String) ? tempVar10 : null);

    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeInt((int)getLicenseType().ordinal());
        writer.writeObject(getVersion());
        writer.writeObject(getEditionID());
        writer.writeLong(getEvaluationDate());
        writer.writeObject(getRegisteredName());
        writer.writeObject(getCompanyName());

        writer.writeBoolean(getIsPreEvalLicense());

        writer.write(getEvaluationPeriod());
        writer.writeBoolean(getISReactivated());
        writer.writeObject(getSPVersion());
        writer.writeBoolean(getIsServerOnly());
        writer.writeBoolean(getIsPrepetual());
        writer.write(getGraceDays());
        writer.writeLong(getExpirationDate());
        writer.writeBoolean(getIsExpiring());
        writer.writeObject(getEmail());
        writer.writeBoolean(getIsExpired());
        writer.writeBoolean(getExpiredFromEvaluation());
        writer.writeObject(getInstallationVersion());
        writer.write(getClientCpus());
        writer.writeObject(getEvironmentName());
        writer.write(getClientCpusInUse());
        writer.writeBoolean(_isTrial);
        writer.writeObject(_firstName);
        writer.writeObject(_lastName);
    }
}

