package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.AppUtil;

import java.io.File;

/**
 * Summary description for SecurityConfiguration.
 */
public class SecurityConfiguration {

    /**
     * Configuration file folder name
     */
    private static final String DIRNAME = "config";
    /**
     * Configuration file name
     */
    private static final String FILENAME = "security.conf";
    /**
     * Path of the configuration file.
     */
    private static String s_configFileName = "";
    /**
     * Path of the configuration folder.
     */
    private static String s_configDir = "";

    public SecurityConfiguration() {
        //
        // TODO: Add constructor logic here
        //
    }

    public static String getConfigurationPath() {
        String filePath = GetFileLocalPath(FILENAME);
        if (filePath != null) {
            return filePath;
        }

        filePath = GetFileGlobalPath(FILENAME, DIRNAME);
        if (filePath != null) {
            return filePath;
        }

        throw new RuntimeException("Missing security config file ");
    }

    /**
     * search for the specified file in the executing assembly's working folder if the file is found, then a path string is returned back. otherwise it returns null.
     *
     * @param fileName
     * @return
     */
    private static String GetFileLocalPath(String fileName) {
        //Basit: Security not in POC
//        String path = (new java.io.File(Assembly.GetExecutingAssembly().Location)).getParent() + "\\" + fileName;
//        if ((new java.io.File(path)).isFile())
//        {
//            return path;
//        }
        return null;
    }

    /**
     * search for the specified file in NCache install directory. if the file is found then returns the path string from where the file can be loaded. otherwise it returns null.
     *
     * @param fileName
     * @return
     */
    private static String GetFileGlobalPath(String fileName, String directoryName) {
        String ncacheInstallDirectory = AppUtil.getInstallDir();
        String directoryPath = "";
        String filePath = "";
        if (ncacheInstallDirectory == null) {
            return null;
        }

        directoryPath = new File(ncacheInstallDirectory, directoryName).getPath();
        if (!(new java.io.File(directoryPath)).isDirectory()) {
            return null;
        }

        filePath = new File(directoryPath, fileName).getPath();
        if (!(new java.io.File(filePath)).isFile()) {
            return null;
        }
        return filePath;
    }
}