/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package Alachisoft.NCache.Management.RPC;

import Alachisoft.NCache.Common.Communication.ITraceProvider;

/**
 * @author ayesha_sana
 */
public class ConsoleTraceProvider implements ITraceProvider {

    public void TraceCritical(String module, String message) {
        WriteTraceToConsole("Critical", module, message);
    }

    public void TraceError(String module, String errorMessage) {
        WriteTraceToConsole("Error", module, errorMessage);
    }

    public void TraceWarning(String module, String warningMessage) {
        WriteTraceToConsole("Warning", module, warningMessage);
    }

    public void TraceDebug(String module, String debug) {
        WriteTraceToConsole("Debug", module, debug);
    }

    private void WriteTraceToConsole(String traceLevel, String module, String message) {
        String finalStr = "[ConsoleTrace] " + new java.util.Date().toString() + "      [" + traceLevel + "]       [" + module + "]      " + message;
        synchronized (this) {
            //System.out.println(finalStr);
        }

    }
}
