package Alachisoft.NCache.Management;

import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.ServiceControl.NCacheService;
import com.alachisoft.ncache.runtime.util.TimeSpan;

import java.util.Iterator;
import java.util.Map;

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS && !MONO
//#endif
public class NCacheServiceBase {

    /**
     * CacheServer object running on other nodes.      *
     */
    protected ICacheServer _server = null;

    /**
     * Address of the machine.
     */
    protected String _address;
    /**
     * Port
     */
    protected int _port;
    /**
     * IP address
     */
    private String _ipAddress;
    /**
     * User Id used for authentication and authorization
     */
    private String _userId = Security.getUserName();
    /**
     * Password used for authentication and authorization
     */
    private String _password = Security.getPasswd();
    private boolean _useRemoting = false;

    /**
     * Constructor
     *
     * @param address
     */
    public NCacheServiceBase(String address) throws Exception {
        this(address, CacheConfigManager.getTcpPort());
    }

    /**
     * Constructor
     *
     * @param address
     * @param port
     */
    public NCacheServiceBase(String address, int port) throws Exception {
        _address = address;
        _port = port;

        Initialize();
        _ipAddress = _server.GetClusterIP();

    }

    /**
     * initilaise
     */
    protected void Initialize() throws Exception {
        NCacheService ncache = null;

        if (_useRemoting) {
            ncache = new NCacheService(_address, (long) _port, true);
        } else {
            ncache = new NCacheRPCService(_address, _port);
        }

        try {
            _server = ncache.GetCacheServer(new TimeSpan());
        } catch (Exception e) {
            throw e;
        } finally {
            ncache.dispose();
        }
    }

    protected final ICacheServer getCacheServer() {
        return _server;
    }

    public final String getClusterIP() {
        return _ipAddress;
    }

    /**
     * Get the list of running server caches
     *
     * @return
     */
    public java.util.HashMap GetServerCaches() {
        return GetServerCaches(_userId, _password);
    }

    /**
     * Get the list of running server caches
     *
     * @return
     */
    public java.util.HashMap GetServerCaches(String userId, String password) {
        try {
            java.util.HashMap cacheList = new java.util.HashMap();
            java.util.Map coll = null;
            //IDictionary coll = _server.CacheProps;

            //Muneeb: CM-1000	:	Not Supported	-	FEATURE
            //coll = _server.GetCacheProps(EncryptionUtil.Encrypt(userId), EncryptionUtil.Encrypt(password));
            Iterator ie = coll.entrySet().iterator();
            while (ie.hasNext()) {
                Map.Entry current = (Map.Entry) ie.next();

                //if (ie.Value is string)
                //{
                //    string cacheProp = (string)ie.Value;

                //    //                    if (cacheProp.Contains("partitioned-server") ||
                //    //                        cacheProp.Contains("replicated-server") ||
                //    //                        cacheProp.Contains("partitioned-replicas-server"))
                //    if ((cacheProp.IndexOf("partitioned-server") != -1)
                //        || (cacheProp.IndexOf("replicated-server") != -1)
                //        || (cacheProp.IndexOf("partitioned-replicas-server") != -1)
                //        || (cacheProp.IndexOf("mirror-server") != -1))
                //    {
                //        cacheList.Add(ie.Key, cacheProp);
                //    }
                //}
                if (current.getValue() instanceof CacheServerConfig) {
                    CacheServerConfig cacheProp = (CacheServerConfig) current.getValue();
                    if (cacheProp.getCluster() != null) {
                        if ((cacheProp.getCluster().getTopology().equals("partitioned-server")) || (cacheProp.getCluster().getTopology().equals("replicated-server"))
                                || (cacheProp.getCluster().getTopology().equals("partitioned-replicas-server")) || (cacheProp.getCluster().getTopology().equals("mirror-server"))) {
                            cacheList.put(current.getKey(), cacheProp);
                        }
                    }
                } else if (current.getValue() instanceof java.util.HashMap) {
                    cacheList.put(current.getKey(), current.getValue());
                }
            }
            return cacheList;
        } catch (RuntimeException e) {
            throw e;
        }
    }

//    public Cache GetCache(String cacheID, boolean checkSecurity)
//    {
//        try
//        {
//            if (!checkSecurity)
//            {
//                return ((CacheServer)_server).getItem(cacheID);
//            }
//            //Muneeb: CM-1000	:	Not Supported	-	Encryption
//            //return ((CacheServer)_server).GetCacheInstance(cacheID, EncryptionUtil.Encrypt(_userId), EncryptionUtil.Encrypt(_password));
//        }
//        catch (RuntimeException ex)
//        {
//            throw ex;
//        }
////#else
//        return null;
////#endif
//    }

    /**
     * Get table containing Name and type of running caches.
     *
     * @param caches Property map
     * @return
     */
//    public final java.util.Hashtable GetRunningCaches(java.util.Hashtable caches)
//    {
//        java.util.Hashtable runningCaches = new java.util.Hashtable(5);
//        Iterator cachesEnu = caches.entrySet().iterator();
//
//        while (cachesEnu.hasNext())
//        {
//            Map.Entry current = (Map.Entry) cachesEnu.next();
//            Cache cacheInstance = GetCache((String) current.getKey(), true);
//            if (cacheInstance.getIsRunning())
//            {
//                runningCaches.put(cacheInstance.getName(), cacheInstance.getStatistics().getClassName());
//            }
//        }
//
//        return runningCaches;
//    }
}