package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Monitoring.*;
import Alachisoft.NCache.Common.RPCFramework.TargetMethodAttribute;
import Alachisoft.NCache.Common.Util.CPUUsage;
import Alachisoft.NCache.Common.Util.ManagementUtil.MethodName;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;

public class MonitorServer //extends MarshalByRefObject implements IMonitorServer
{

    private static java.util.ArrayList<ServerNode> _runningServerNodes = new java.util.ArrayList<ServerNode>();
    private static CPUUsage _cpuUsage = null;
    //Muneeb: CM-1000	:	Not Supported	-	EventLog
    private static Object _sync_lock = new Object();
    private static Object _syncLockCPUUsage = new Object();
    private Node[] _totalServerNodes;
    private String _cacheId;

    public MonitorServer() {
    }

    @TargetMethodAttribute(privateMethod = MethodName.InitializeMonitor, privateOverload = 1)
    public final void Initialize(String cacheId) {
        _cacheId = cacheId;
    }

    ///#region IMonitorServer Members
    @TargetMethodAttribute(privateMethod = MethodName.GetCacheStatistics, privateOverload = 1)
    public final CacheNodeStatistics[] GetCacheStatistics() throws GeneralFailureException, OperationFailedException, CacheException {
        return CacheServer.getInstance().GetCacheStatistics(_cacheId);
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetClusterNIC, privateOverload = 1)
    public final String GetClusterNIC() throws GeneralFailureException, OperationFailedException, CacheException {
        CacheNodeStatistics[] statsList = CacheServer.getInstance().GetCacheStatistics(_cacheId);
        if (statsList != null && statsList.length > 0) {
            CacheNodeStatistics stats = statsList[0];
            if (stats.getStatus() == CacheNodeStatus.Running || stats.getStatus() == CacheNodeStatus.InStateTransfer) {
                return GetNICForIP(stats.getNode().getAddress().getIpAddress().toString());
            }
        }
        return null;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    @TargetMethodAttribute(privateMethod = MethodName.GetSocketServerNIC, privateOverload = 1)
    public final String GetSocketServerNIC() {
        InetAddress ip = null;
        if (CacheServer.getInstance() != null && CacheServer.getInstance().getRenderer() != null) {
            ip = CacheServer.getInstance().getRenderer().getIPAddress();
        }

        return ip != null ? GetNICForIP(ip.toString()) : null;
    }

    /**
     * @param ip
     * @return
     */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    @TargetMethodAttribute(privateMethod = MethodName.GetNICForIP, privateOverload = 1)
    public final String GetNICForIP(String ip) {
        if (ip == null) {
            return null;
        }
        String nic = null;
        try {

            // Detecting Network Interface Cards with enabled IPs through WMI:
            //
            NetworkInterface.getByInetAddress(InetAddress.getByName(ip));

//            ManagementObjectSearcher searcher = new ManagementObjectSearcher("Select * from Win32_NetworkAdapterConfiguration WHERE IPEnabled=True");
//
//            for (ManagementObject mo : searcher.Get())
//            {
//                Object tempVar = mo.GetPropertyValue("IPAddress");
//                String[] ipAddresses = (String[]) ((tempVar instanceof String[]) ? tempVar : null);
//
//                for (String ipAddress : ipAddresses)
//                {
//                    if ((ipAddress.compareToIgnoreCase(ip) == 0))
//                    {
//                        nic = (String) mo.GetPropertyValue("Description");
//                        break;
//                    }
//                }
//            }
        } catch (Exception e) {
        }
        return nic;
    }

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#region System Event Log

    /**
     * Will register the EntryWritten event so that can return the event log entry from this point onwards
     *
     * @param sources
     */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.RegisterEventViewerEvents)]
    @TargetMethodAttribute(privateMethod = MethodName.RegisterEventViewerEvents, privateOverload = 1)
    public final void RegisterEventViewerEvents(String[] sources) {
        UnRegisterEventViewerEvents();
        //Muneeb: CM-1000	:	Not Supported	-	EventLog
//
    }

    /**
     * Unregister the EntryWritten event
     *
     * @param sources
     */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    @TargetMethodAttribute(privateMethod = MethodName.UnRegisterEventViewerEvents, privateOverload = 1)
    public final void UnRegisterEventViewerEvents() {
        //Not Supported
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetLatestEvents)]
    @TargetMethodAttribute(privateMethod = MethodName.GetLatestEvents, privateOverload = 1)
    public final EventViewerEvent[] GetLatestEvents() //throws CloneNotSupportedException, UnknownHostException
    {
        EventViewerEvent[] eventList = new EventViewerEvent[EventLogger.getEventList().length];
        eventList = EventLogger.getEventList();
        EventLogger.clearEvents();

        return eventList != null ? eventList : null;
    }

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion

    /**
     * Gets the list of configured servers irrespective of their running/stopped status.
     *
     * @param cacheId
     * @return
     * @throws UnknownHostException
     */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheServers)]
    @TargetMethodAttribute(privateMethod = MethodName.GetCacheServers, privateOverload = 1)
    public final Node[] GetCacheServers() throws UnknownHostException {
        return CacheServer.getInstance().GetCacheServers(_cacheId);
    }

//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetUpdatedCacheServers)]

    /**
     * @return @throws UnknownHostException
     */
    @TargetMethodAttribute(privateMethod = MethodName.GetUpdatedCacheServers, privateOverload = 1)
    public final Node[] GetUpdatedCacheServers() throws UnknownHostException {
        Node[] serverNodes = CacheServer.getInstance().GetCacheServers(_cacheId);
        synchronized (_sync_lock) {
            //LATIF: Code not exists :we Initialize totalServerNodes
            if (this._totalServerNodes != null && this._totalServerNodes.length != serverNodes.length) {
                this._totalServerNodes = serverNodes;
                return serverNodes;
            } else if (this._totalServerNodes == null) {
                this._totalServerNodes = serverNodes;
                return serverNodes;
            }
            for (Node server : serverNodes) {
                if (!(Arrays.asList(this._totalServerNodes).contains(server))) {
                    this._totalServerNodes = serverNodes;
                    return serverNodes;
                }
            }
        }
        return null;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetRunningCacheServers)]
    @TargetMethodAttribute(privateMethod = MethodName.GetRunningCacheServers, privateOverload = 1)
    public final ServerNode[] GetRunningCacheServers() {
        ArrayList<ServerNode> serverNodes = CacheServer.getInstance().GetRunningCacheServers(_cacheId);
        return serverNodes != null ? serverNodes.toArray(new ServerNode[serverNodes.size()]) : null;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetUpdatedRunningCacheServers)]
    @TargetMethodAttribute(privateMethod = MethodName.GetUpdatedRunningCacheServers, privateOverload = 1)
    public final ServerNode[] GetUpdatedRunningCacheServers() {
        java.util.ArrayList<ServerNode> serverNodes = CacheServer.getInstance().GetRunningCacheServers(_cacheId);
        ServerNode[] cacheServers = serverNodes != null ? serverNodes.toArray(new ServerNode[serverNodes.size()]) : null;
        synchronized (_sync_lock) {
            if (_runningServerNodes.size() != serverNodes.size()) {
                _runningServerNodes = serverNodes;
                return cacheServers;
            }
            for (ServerNode server : serverNodes) {
                if (!_runningServerNodes.contains(server)) {
                    _runningServerNodes = serverNodes;
                    return cacheServers;
                }
            }
        }
        return null;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheClients)]
    @TargetMethodAttribute(privateMethod = MethodName.GetCacheClients, privateOverload = 1)
    public final ClientNode[] GetCacheClients() throws UnknownHostException {
        ArrayList<ClientNode> clientNodes = CacheServer.getInstance().GetCacheClients(_cacheId);
        return clientNodes != null ? clientNodes.toArray(new ClientNode[clientNodes.size()]) : null;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetUpdatedCacheClients)]
    @TargetMethodAttribute(privateMethod = MethodName.GetUpdatedCacheClients, privateOverload = 1)
    public final ClientNode[] GetUpdatedCacheClients() throws UnknownHostException {
        java.util.ArrayList<ClientNode> clientNodes = CacheServer.getInstance().GetCacheClients(_cacheId);
        java.util.ArrayList<ClientNode> returnNodes = new java.util.ArrayList<ClientNode>();

        synchronized (_sync_lock) {
            java.util.HashMap<String, ClientNode> clientNodePerIP = new java.util.HashMap<String, ClientNode>();

            for (ClientNode node : clientNodes) {
                if (node.getClientContext() == RtContextValue.NCACHE) {
                    String key = node.getAddress().getIpAddress().toString();
                    if (!clientNodePerIP.containsKey(key)) {
                        clientNodePerIP.put(key, node);
                        returnNodes.add(node);
                    }
                } else {
                    returnNodes.add(node);
                }
            }
        }

        return returnNodes != null ? returnNodes.toArray(new ClientNode[returnNodes.size()]) : null;
    }

    //CLIENTSTATS : GetClientProcessStats
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetClientProcessStats)]
    @TargetMethodAttribute(privateMethod = MethodName.GetClientProcessStats, privateOverload = 1)
    public final ClientProcessStats[] GetClientProcessStats() throws UnknownHostException {
        ArrayList<ClientProcessStats> clientProcessStats = CacheServer.getInstance().GetClientProcessStats(_cacheId);
        return clientProcessStats != null ? clientProcessStats.toArray(new ClientProcessStats[clientProcessStats.size()]) : null;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetAllConfiguredCaches)]
    @TargetMethodAttribute(privateMethod = MethodName.GetAllConfiguredCaches, privateOverload = 1)
    public final ConfiguredCacheInfo[] GetAllConfiguredCaches() {
        return CacheServer.getInstance().GetAllConfiguredCaches();
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheConfigurationInfo)]
    @TargetMethodAttribute(privateMethod = MethodName.GetCacheConfigurationInfo, privateOverload = 1)
    public final ConfiguredCacheInfo GetCacheConfigurationInfo() {
        return CacheServer.getInstance().GetCacheConfigurationInfo(_cacheId);
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetPercentageCPUUsage)]
    @TargetMethodAttribute(privateMethod = MethodName.GetPercentageCPUUsage, privateOverload = 1)
    public final int GetPercentageCPUUsage() {
        synchronized (_syncLockCPUUsage) {
            if (_cpuUsage == null) {
                _cpuUsage = new CPUUsage();
            }

            try {
                //CM-1000	:	Not Supported	-	CPUUSAGE
                return 0;//_cpuUsage.GetUsage();
            } catch (Exception exception) {
                return -3;
            }
        }
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetSnmpPorts, privateOverload = 1)
    public final java.util.HashMap GetSnmpPort() {
        return CacheServer.getInstance().GetSnmpPorts();
    }

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion
}