package Alachisoft.NCache.Management.ClientConfiguration.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;

public class UserCredentials implements Cloneable, InternalCompactSerializable {

    private String _userId;
    private String _password;

    @ConfigurationAttributeAnnotation(value = "user-id", appendText = "")
    public final String getUserId() {
        return _userId;
    }

    @ConfigurationAttributeAnnotation(value = "user-id", appendText = "")
    public final void setUserId(String value) {
        _userId = value;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[ConfigurationAttribute("password")]
    @ConfigurationAttributeAnnotation(value = "password", appendText = "")
    public final String getPassword() {
        return _password;
    }

    @ConfigurationAttributeAnnotation(value = "password", appendText = "")
    public final void setPassword(String value) {
        _password = value;
    }

    public final Object clone() {
        UserCredentials credentials = new UserCredentials();
        credentials._userId = _userId;
        credentials._password = _password;

        return credentials;
    }

    //<editor-fold defaultstate="collapsed" desc="ISerailizable">
    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        _userId = (String) Common.readAs(reader.ReadObject(), String.class);
        _password = (String) Common.readAs(reader.ReadObject(), String.class);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject(_userId);
        writer.WriteObject(_password);
    }
    //</editor-fold>
}