package Alachisoft.NCache.Management.ClientConfiguration.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;

public class NodeConfiguration implements Cloneable, InternalCompactSerializable {

    private int _connectionRetries = 5;
    private int _retryInterval = 1;
    private int _requestTimeout = 90;
    private int _connectionTimeout = 5;
    private int _serverPort = 9800;
    private int _configurationId;
    private int _retryConnectionDelay = 0;
    private String _localServerIP;
    private int _jvcServerPort = 9600;
    private int _commandretries = 3;
    private double _commandRetryInterval = 0.1;

    public final int getConfigurationId() {
        return _configurationId;
    }

    public final void setConfigurationId(int value) {
        _configurationId = value;
    }


    @ConfigurationAttributeAnnotation(value = "connection-retries", appendText = "")
    public final int getConnectionRetries() {
        return _connectionRetries;
    }

    @ConfigurationAttributeAnnotation(value = "connection-retries", appendText = "")
    public final void setConnectionRetries(int value) {
        _connectionRetries = value;
    }

    @ConfigurationAttributeAnnotation(value = "retry-connection-delays", appendText = "")
    public final int getRetryConnectionDelay() {
        return _retryConnectionDelay;
    }

    @ConfigurationAttributeAnnotation(value = "retry-connection-delays", appendText = "")
    public final void setRetryConnectionDelay(int value) {
        _retryConnectionDelay = value;
    }

    @ConfigurationAttributeAnnotation(value = "retry-interval", appendText = "")
    public final int getRetryInterval() {
        return _retryInterval;
    }

    @ConfigurationAttributeAnnotation(value = "retry-interval", appendText = "")
    public final void setRetryInterval(int value) {
        _retryInterval = value;
    }

    @ConfigurationAttributeAnnotation(value = "client-request-timeout", appendText = "")
    public final int getRequestTimeout() {
        return _requestTimeout;
    }

    @ConfigurationAttributeAnnotation(value = "client-request-timeout", appendText = "")
    public final void setRequestTimeout(int value) {
        _requestTimeout = value;
    }

    @ConfigurationAttributeAnnotation(value = "connection-timeout", appendText = "")
    public final int getConnectionTimeout() {
        return _connectionTimeout;
    }

    @ConfigurationAttributeAnnotation(value = "connection-timeout", appendText = "")
    public final void setConnectionTimeout(int value) {
        _connectionTimeout = value;
    }


    @ConfigurationAttributeAnnotation(value = "port", appendText = "")
    public final int getServerPort() {
        return _serverPort;
    }

    @ConfigurationAttributeAnnotation(value = "port", appendText = "")
    public final void setServerPort(int value) {
        _serverPort = value;
    }

    //@ConfigurationAttributeAnnotation(value="jvc-port",appendText="")
    public final int getJvcServerPort() {
        return _jvcServerPort;
    }

    //@ConfigurationAttributeAnnotation(value="jvc-port",appendText="")
    public final void setJvcServerPort(int value) {
        _jvcServerPort = value;
    }

    @ConfigurationAttributeAnnotation(value = "local-server-ip", appendText = "")
    public final String getLocalServerIP() {
        return _localServerIP;
    }

    @ConfigurationAttributeAnnotation(value = "local-server-ip", appendText = "")
    public final void setLocalServerIP(String value) {
        _localServerIP = value;
    }

    @ConfigurationAttributeAnnotation(value = "command-retries", appendText = "")
    public int getCommandretries() {
        return _commandretries;
    }

    @ConfigurationAttributeAnnotation(value = "command-retries", appendText = "")
    public void setCommandretries(int _commandretries) {
        this._commandretries = _commandretries;
    }

    @ConfigurationAttributeAnnotation(value = "command-retry-interval", appendText = "")
    public double getCommandRetryInterval() {
        return _commandRetryInterval;
    }

    @ConfigurationAttributeAnnotation(value = "command-retry-interval", appendText = "")
    public void setCommandRetryInterval(double _commandRetryInterval) {
        this._commandRetryInterval = _commandRetryInterval;
    }


    //C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#region ICloneable Members
    public final Object clone() {
        NodeConfiguration config = new NodeConfiguration();
        config._configurationId = _configurationId;
        config._connectionRetries = _connectionRetries;
        config._connectionTimeout = _connectionTimeout;
        config._retryInterval = _retryInterval;
        config._serverPort = _serverPort;
        config._requestTimeout = _requestTimeout;
        config._retryConnectionDelay = _retryConnectionDelay;
        config._jvcServerPort = _jvcServerPort;
        config._commandretries = _commandretries;
        config._commandRetryInterval = _commandRetryInterval;
        return config;
    }

    //C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion
    //<editor-fold defaultstate="collapsed" desc="ISerailizable">
    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        _connectionRetries = reader.ReadInt32();
        _retryInterval = reader.ReadInt32();
        _requestTimeout = reader.ReadInt32();
        _connectionTimeout = reader.ReadInt32();
        _serverPort = reader.ReadInt32();
        _configurationId = reader.ReadInt32();
        _retryConnectionDelay = reader.ReadInt32();
        _jvcServerPort = reader.ReadInt32();
        _commandretries = reader.ReadInt32();
        _commandRetryInterval = reader.ReadDouble();
        _localServerIP = Common.as(reader.ReadObject(), String.class);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(_connectionRetries);
        writer.Write(_retryInterval);
        writer.Write(_requestTimeout);
        writer.Write(_connectionTimeout);
        writer.Write(_serverPort);
        writer.Write(_configurationId);
        writer.Write(_retryConnectionDelay);
        writer.Write(_jvcServerPort);
        writer.Write(_commandretries);
        writer.Write(_commandRetryInterval);
        writer.WriteObject(_localServerIP);
    }
    //</editor-fold>
}