/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package Alachisoft.NCache.Management.ClientConfiguration;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @author Muneeb Shahid
 */
public class CacheServerList implements InternalCompactSerializable {
    private HashMap<Integer, CacheServer> _serversList = new HashMap<Integer, CacheServer>();

    public CacheServerList() {
    }

    public CacheServerList(HashMap<Integer, CacheServer> serversList) {
        this._serversList = serversList;
    }

    public HashMap<Integer, CacheServer> getServersList() {
        return this._serversList;
    }

    public void setServersList(HashMap<Integer, CacheServer> _serversList) {
        this._serversList = _serversList;
    }

    public void setServersList(int key, CacheServer cacheServer) {
        _serversList.put(key, cacheServer);
//        this._serversList = _serversList;
    }

    //<editor-fold defaultstate="collapsed" desc="CompactS">
    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._serversList = new HashMap<Integer, CacheServer>();
        int length = reader.ReadInt32();
        for (int i = 0; i < length; i++) {
            int key = reader.ReadInt32();
            CacheServer value = (CacheServer) Common.readAs(reader.ReadObject(), CacheServer.class);
            _serversList.put(key, value);
        }
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(this._serversList.size());
        Map.Entry current = null;
        Iterator ite = this._serversList.entrySet().iterator();
        while (ite.hasNext()) {
            current = (Entry) ite.next();
            writer.Write(((Integer) current.getKey()).intValue());
            writer.WriteObject(current.getValue());
        }
    }
    //</editor-fold>
}
