package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Common;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;

public class ClientCacheStatus implements InternalCompactSerializable {
    /**
     * Client cache does not exist
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public const byte NOT_REGISTERED = 1;
    public static final byte NOT_REGISTERED = 1;
    /**
     * Client cache is registered
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public const byte REGISTERED = 2;
    public static final byte REGISTERED = 2;
    /**
     * Cache exist but not as client cache
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public const byte NOT_CLIENT_CACHE = 3;
    public static final byte NOT_CLIENT_CACHE = 3;

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: private byte _status;
    private byte _status;
    private String _clusteredCacheId;


    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public byte getStatus()
    public final byte getStatus() {
        return _status;
    }

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public void setStatus(byte value)
    public final void setStatus(byte value) {
        _status = value;
    }

    public final String getClusteredCacheId() {
        return _clusteredCacheId;
    }

    public final void setClusteredCacheId(String value) {
        _clusteredCacheId = value;
    }

    @Override
    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {

        this._status = reader.ReadByte();
        this._clusteredCacheId = Common.as(reader.ReadObject(), String.class);
    }

    @Override
    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(_status);
        writer.WriteObject(this._clusteredCacheId);
    }

}