package Alachisoft.NCache.Management;

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:

import Alachisoft.NCache.Caching.*;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.Statistics.ClusterCacheStatistics;
import Alachisoft.NCache.Caching.Statistics.NodeInfo;
import Alachisoft.NCache.Caching.Util.HotConfig;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.*;
import Alachisoft.NCache.Common.Enum.CacheTopology;
import Alachisoft.NCache.Common.Enum.*;
import Alachisoft.NCache.Common.Event.ILicenseExpiration;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Exceptions.SuspectedException;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.LoggingInfo.LoggingSubsystem;
import Alachisoft.NCache.Common.LoggingInfo.LoggingType;
import Alachisoft.NCache.Common.LoggingInfo.LogsStatus;
import Alachisoft.NCache.Common.Monitoring.ServerNode;
import Alachisoft.NCache.Common.Monitoring.*;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Net.NetworkData;
import Alachisoft.NCache.Common.RPCFramework.TargetMethodAttribute;
import Alachisoft.NCache.Common.Threading.TimeScheduler;
import Alachisoft.NCache.Common.Util.ManagementUtil.MethodName;
import Alachisoft.NCache.Common.Util.ReaderWriterLock;
import Alachisoft.NCache.Config.ConfigReader;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.Dom.Cluster;
import Alachisoft.NCache.Config.Dom.ConfigConverter;
import Alachisoft.NCache.Config.NewDom.*;
import Alachisoft.NCache.Config.PropsConfigReader;
import com.alachisoft.ncache.common.monitoring.*;
import com.alachisoft.ncache.licensing.LicenseInfo;
import com.alachisoft.ncache.licensing.LicenseLogger;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.licensing.LicenseManager.LicenseType;
import Alachisoft.NCache.Management.ClientConfiguration.CacheServerList;
import Alachisoft.NCache.Management.ClientConfiguration.ClientConfigManager;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.*;
import com.alachisoft.ncache.runtime.util.TimeSpan;

import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.*;
import java.net.*;
import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Manages cache start and stop and keeps a named collection of caches
 */
public class CacheServer implements ICacheServer, IDisposable, ILicenseExpiration {

    private static CacheServer s_instance;
    private static Object serviceObject = new Object();
    /**
     * A HashMap that contains a list of all the cache objects created so far.
     */
    private static java.util.HashMap s_caches = new java.util.HashMap();
    private static java.util.HashMap s_partitionedCaches = new java.util.HashMap();
    /**
     * Socket server port
     */
    private static int _socketServerPort;
    private static String _clusterIp;
    private static String _clientserverip;
    private static String _localCacheIp;
    private static Thread _evalWarningTask;
    private static boolean stopEvalWarning = false;
    private static LicenseLogger licenseLogger;

    /**
     * Static constructor
     */
    static {
        try {
            LoadConfiguration();
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !VS2003 && !EXPRESS
            licenseLogger = new LicenseLogger();
            try {
                licenseLogger.Load();
            } catch (java.lang.Exception e) {//Muneeb: CM-1000	:	Not Supported	-	EventHandler
                EventLogger.LogEvent("Failed to load license log. Suspected tampering.", EventType.WARNING);
            }
            licenseLogger.setAutoSave(true);
            licenseLogger.setEnabled(GetLicenseLoggingStatus());
            RegisterCompactTypes();
            try {

                com.alachisoft.ncache.licensing.LicenseManager.setIsService(true);
                com.alachisoft.ncache.licensing.LicenseManager.registerLicenseExpirationCallBack(s_instance);
                //  com.alachisoft.ncache.licensing.LicenseMonitor.VerifyLicenseMonitoring();

                if (LicenseManager.LicenseMode(null) == LicenseManager.LicenseType.InEvaluation) {
                    _evalWarningTask = new Thread(new Runnable() {
                        public long interval = 1000 * 60 * 60 * 12; // 12 hour interval.

                        @Override
                        public void run() {
                            while (!stopEvalWarning) {
                                try {
                                    Thread.sleep(interval);
                                    NotifyEvalLicense(this, null);
                                } catch (InterruptedException interruptedException) {
                                    NotifyEvalLicense(this, null);
                                }
                            }
                        }
                    });
                    _evalWarningTask.setDaemon(true);
                    NotifyEvalLicense(null, null);
                }
            } catch (Exception e2) {
            }
        } catch (Exception e) {
            String msg = String.format("CacheServer failed to load configuration, Error %1$s", e.getMessage());
            EventLogger.LogEvent(msg, EventType.WARNING);
        }
    }

    //private const ulong X86MAXMEMORYSIZE = 1677722L;
    private Exception e2;
    /**
     * Reader writer lock used to synchronize access to internals.
     */
    private ReaderWriterLock _rwLock = new ReaderWriterLock();
    private CacheRenderer _renderer;
    private TimeScheduler _gcScheduler;
    public CacheServer() {
        if (this._gcScheduler == null) {
            this._gcScheduler = new TimeScheduler();
        }
        this._gcScheduler.Start();

        NetworkData.registerIPToMonitor(ServicePropValues.BIND_ToCLUSTER_IP);
        NetworkData.registerIPToMonitor(ServicePropValues.BIND_toClient_IP);
        this.StartGCTask();
    }

    public static String getObjectUri() {
        return CacheServer.class.getName();
    }

    public static String getClientserverIp() {
        return CacheServer._clientserverip;
    }

    public static void setClientserverIp(String value) {
        CacheServer._clientserverip = value;
    }

    /**
     * Gets the singlton instance of CacheServer.
     *
     * @return
     */
    public static CacheServer getInstance() {
        return s_instance;
    }

    public static void setInstance(CacheServer value) {
        s_instance = value;
        com.alachisoft.ncache.licensing.LicenseManager.registerLicenseExpirationCallBack(s_instance);
    }

    private static void NotifyEvalLicense(Object source, EventArgs e) {
        try {
            LicenseManager.LicenseType mode = LicenseManager.LicenseType.Expired;
            try {
                mode = LicenseManager.LicenseMode(null);
            } catch (Exception ex) {
            }
            if (mode == LicenseManager.LicenseType.ActivePerNode || mode == LicenseManager.LicenseType.ActivePerProcessor) {

                if (_evalWarningTask != null) {
                    stopEvalWarning = true;
                    _evalWarningTask = null;
                }
            } else if (mode == LicenseType.InEvaluation) {

                TimeSpan tSpan = TimeSpan.subtract(new java.util.Date(), LicenseManager.getEvaluationDt().getTime());
                double daysRemaining = LicenseManager.getEvaluationPeriod() - (tSpan.getTotalMinutes() / 3600);
                boolean writeEntry = true;

                if (writeEntry) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(Calendar.DAY_OF_MONTH, (int) daysRemaining);
                    java.util.Date dT = cal.getTime();
                    if (daysRemaining <= 10 && daysRemaining > 1) {
                        String msg = String.format("N evaluation of %1$s days expires on %2$s. Please purchase license keys or extend evaluation period by contacting support@alachisoft.com ", LicenseManager.getEvaluationPeriod(), dT.toString());
                        EventLogger.LogEvent("NCache", msg, EventType.WARNING, EventCategories.Warning, EventID.LicensingError);
                    } else if (daysRemaining == 1 || daysRemaining == 0) {
                        String msg = String.format("NCache evaluation of %1$s days expires on %2$s. It cannot be extended any more. Therefore, please purchase NCache license from sales@alachisoft.com and activate before expiration.", LicenseManager.getEvaluationPeriod(), dT.toString());
                        EventLogger.LogEvent("NCache", msg, EventType.WARNING, EventCategories.Warning, EventID.LicensingError);
                    }
                }
            }
        } catch (Exception e2) {
        }
    }

    public static void RegisterCompactTypes() throws NCacheArgumentException {
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.RPCFramework.TargetMethodParameter.class, ((Integer) 165).shortValue());
        //<editor-fold defaultstate="collapsed" desc="[Register Bridge Server Assemblies]">
        //
        //            CompactFormatterServices.RegisterCompactType(typeof(BridgeConfiguration), 166);
        //            CompactFormatterServices.RegisterCompactType(typeof(BridgeLogConfiguration), 167);
        //            CompactFormatterServices.RegisterCompactType(typeof(QueueConfiguration), 168);
        //            CompactFormatterServices.RegisterCompactType(typeof(PerfCounterConfiguration), 169);
        //            CompactFormatterServices.RegisterCompactType(typeof(QueueEvictionConfiguration), 170);
        //            CompactFormatterServices.RegisterCompactType(typeof(BridgeConflictResolver), 171);
        //            CompactFormatterServices.RegisterCompactType(typeof(ProviderAssembly), 172);
        //            CompactFormatterServices.RegisterCompactType(typeof(Parameter), 173);
        //            CompactFormatterServices.RegisterCompactType(typeof(TargetCacheCofiguration), 174);
        //            CompactFormatterServices.RegisterCompactType(typeof(BridgeSecurity), 175);
        //            CompactFormatterServices.RegisterCompactType(typeof(Alachisoft.NCache.Bridging.Configuration.User), 176);
        //
        //</editor-fold>

        //<editor-fold defaultstate="collapsed" desc="[Register Cache Server Assemblies]">
        FormatterServices.getDefault().registerKnownTypes(ProductVersion.class, ((Integer) 302).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheServerConfig.class, ((Integer) 177).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Log.class, ((Integer) 178).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.PerfCounters.class, ((Integer) 179).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Compression.class, ((Integer) 180).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.QueryIndex.class, ((Integer) 181).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Class.class, ((Integer) 182).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.DataSharing.class, ((Integer) 183).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Type.class, ((Integer) 184).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CompactSerialization.class, ((Integer) 185).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CompactClass.class, ((Integer) 186).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.BackingSource.class, ((Integer) 187).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Readthru.class, ((Integer) 188).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Writethru.class, ((Integer) 189).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Provider.class, ((Integer) 190).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CacheLoader.class, ((Integer) 191).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BridgeConflictResolver.class, ((Integer) 171).shortValue());

        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Notifications.class, ((Integer) 192).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.BridgeConfig.class, ((Integer) 193).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Cleanup.class, ((Integer) 194).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Storage.class, ((Integer) 195).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.EvictionPolicy.class, ((Integer) 196).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Cluster.class, ((Integer) 197).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.Dom.Channel.class, ((Integer) 198).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.NodeIdentity.class, ((Integer) 199).shortValue());
        FormatterServices.getDefault().registerKnownTypes(StatusInfo.class, ((Integer) 200).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ReplicationStrategy.class, ((Integer) 201).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Security.class, ((Integer) 202).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.AutoLoadBalancing.class, ((Integer) 203).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ClientNodes.class, ((Integer) 204).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ClientNode.class, ((Integer) 205).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.AlertsNotifications.class, ((Integer) 206).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.EmailNotifications.class, ((Integer) 207).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.AlertsTypes.class, ((Integer) 208).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.NotificationRecipient.class, ((Integer) 209).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.SQLDependencyConfig.class, ((Integer) 210).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Encryption.class, ((Integer) 211).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.TaskConfiguration.class, ((Integer) 369).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheRegisterationInfo.class, ((Integer) 212).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheStatusOnServerContainer.class, ((Integer) 213).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheStatistics.class, ((Integer) 65).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClusterCacheStatistics.class, ((Integer) 66).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NodeInfo.class, ((Integer) 67).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration.class, ((Integer) 214).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientConfiguration.Dom.NodeConfiguration.class, ((Integer) 215).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration.class, ((Integer) 216).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientConfiguration.Dom.SecurityConfiguration.class, ((Integer) 217).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientConfiguration.Dom.UserCredentials.class, ((Integer) 218).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer.class, ((Integer) 219).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.CacheInfo.class, ((Integer) 220).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Class[].class, ((Integer) 249).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ClientNodeStatusWrapper.class, ((Integer) 250).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Attrib.class, ((Integer) 251).shortValue());

        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Type[].class, ((Integer) 252).shortValue());

        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.PortableClass.class, ((Integer) 253).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.PortableClass[].class, ((Integer) 254).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.AttributeListUnion.class, ((Integer) 255).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.PortableAttribute.class, ((Integer) 256).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.PortableAttribute[].class, ((Integer) 257).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.NewCacheRegisterationInfo.class, ((Integer) 541).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientCacheStatus.class, ((Integer) 259).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Enum.RtContextValue.class, ((Integer) 300).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CacheDeployment.class, ((Integer) 264).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class, ((Integer) 393).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Cluster.class, ((Integer) 266).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CacheServerConfigSetting.class, ((Integer) 540).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CacheTopology.class, ((Integer) 268).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Channel.class, ((Integer) 269).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ServerNode.class, ((Integer) 270).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ServersNodes.class, ((Integer) 271).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ServerLicenseInfo.class, ((Integer) 301).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.WriteBehind.class, ((Integer) 276).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.BatchConfig.class, ((Integer) 277).shortValue());
        //FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.class, ((Integer) 265).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.DataStructures.NewHashmap.class, ((Integer) 346).shortValue());
        // For NCache 4.6 compatibility
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ExpirationPolicy.class, ((Integer) 278).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.AbsoluteExpiration.class, ((Integer) 279).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.SlidingExpiration.class, ((Integer) 280).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ClientDeathDetection.class, ((Integer) 355).shortValue());

        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.SynchronizationStrategy.class, ((Integer) 378).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.TagList.class, ((Integer) 371).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.LoaderTag.class, ((Integer) 282).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.LoaderTag[].class, ((Integer) 373).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ClientCacheSettings.class, ((Integer) 372).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ClientActivityNotification.class, ((Integer) 376).shortValue());
        FormatterServices.getDefault().registerKnownTypes(HotConfig.class, ((Integer) 347).shortValue());

        //Lucene Settings
        FormatterServices.getDefault().registerKnownTypes(LuceneDeployment.class, ((Integer) 494).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneDeployment[].class, ((Integer) 495).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneDepType.class, ((Integer) 496).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneDepType[].class, ((Integer) 497).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneSettings.class, ((Integer) 498).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Analyzers.class, ((Integer) 499).shortValue());
        FormatterServices.getDefault().registerKnownTypes(StopWords.class, ((Integer) 500).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Patterns.class, ((Integer) 501).shortValue());

        //Monitoring
        FormatterServices.getDefault().registerKnownTypes(ClientMetaData.class, ((Integer) 611).shortValue());
        FormatterServices.getDefault().registerKnownTypes((CounterDataCollection.class), ((Integer) 604).shortValue());
        FormatterServices.getDefault().registerKnownTypes((CounterMetadata.class), ((Integer) 605).shortValue());
        FormatterServices.getDefault().registerKnownTypes((CounterMetadataCollection.class), ((Integer) 606).shortValue());
        FormatterServices.getDefault().registerKnownTypes((IntervalCounterDataCollection.class), ((Integer) 609).shortValue());
        FormatterServices.getDefault().registerKnownTypes((ClientCustomCounters.class), ((Integer) 514).shortValue());
//        FormatterServices.getDefault().registerKnownTypes(EnumChannelContainer.class, ((Integer) 237).shortValue());

        //FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Caching.CacheLoader.CSNode.class, 237);


        //</editor-fold>

        //<editor-fold defaultstate="collapsed" desc="[Monitor Server Assemblies]">
        FormatterServices.getDefault().registerKnownTypes(CacheNodeStatistics.class, ((Integer) 221).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ServerNode.class, ((Integer) 222).shortValue());

        FormatterServices.getDefault().registerKnownTypes(EventViewerEvent.class, ((Integer) 223).shortValue());

        FormatterServices.getDefault().registerKnownTypes(Node.class, ((Integer) 224).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Net.Address.class, ((Integer) 110).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Monitoring.ClientNode.class, ((Integer) 226).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ConfiguredCacheInfo.class, ((Integer) 227).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientProcessStats.class, ((Integer) 228).shortValue());

        FormatterServices.getDefault().registerKnownTypes(CacheNodeStatistics[].class, ((Integer) 229).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ServerNode[].class, ((Integer) 230).shortValue());
        FormatterServices.getDefault().registerKnownTypes(EventViewerEvent[].class, ((Integer) 231).shortValue());

        FormatterServices.getDefault().registerKnownTypes(Node[].class, ((Integer) 232).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Net.Address[].class, ((Integer) 233).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Monitoring.ClientNode[].class, ((Integer) 234).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ConfiguredCacheInfo[].class, ((Integer) 235).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientProcessStats[].class, ((Integer) 236).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BindedIpMap.class, ((Integer) 237).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NodeInfoMap.class, ((Integer) 238).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheServerList.class, ((Integer) 239).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.User.class, ((Integer) 240).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.User[].class, ((Integer) 241).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.NotificationRecipient[].class, ((Integer) 242).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CompactClass[].class, ((Integer) 243).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Parameter.class, ((Integer) 244).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Parameter[].class, ((Integer) 245).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ProviderAssembly.class, ((Integer) 246).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.ClientNode[].class, ((Integer) 247).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Provider[].class, ((Integer) 248).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.BitSet.class, ((Integer) 621).shortValue());


        //</editor-fold>
    }
//#else

//    /**
//     * Static constructor
//     */
//    static {
//        try {
//            LoadConfiguration();
//        } catch (Exception e) {
//        }
//    }
//#endif

    private static boolean GetLicenseLoggingStatus() {
        String val = ServicePropValues.CacheServer_LicenseLogging;
        if (tangible.DotNetToJavaStringHelper.isNullOrEmpty(val)) {
            return false;
        }

        boolean result = false;
        tangible.RefObject<Boolean> tempRef_result = new tangible.RefObject<Boolean>(result);
        boolean tempVar = Boolean.getBoolean(val) ? result : false;
        result = tempRef_result.argvalue;
        return tempVar;
    }

    /**
     * Gets or sets the socket server port.
     */
    public static int getSocketServerPort() {
        return _socketServerPort;
    }

    public static void setSocketServerPort(int value) {
        _socketServerPort = value;
    }

    /**
     * Load all the config sections from the configuration file.
     */
    private static void LoadConfiguration() throws ConfigurationException, ManagementException {
        CacheInfo cacheInfo = null;
        try {
            CacheServerConfig[] configs = CacheConfigManager.GetConfiguredCaches();
            for (int i = 0; i < configs.length; i++) {
                CacheServerConfig config = configs[i];

                /**
                 * [Ata] Until we completely move to using dom based
                 * configuration we have to convert it to string props
                 */
                String props = GetProps(config);

                cacheInfo = new CacheInfo();
                cacheInfo.setCache(new LeasedCache(props));
                cacheInfo.setCacheProps(config);

                // all but the listed cache types are loaded in s_caches table.
                if (!(cacheInfo.getCache().getStatistics().getClassName().equals("replicated-client")
                        || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-replicas-client")
                        || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-client"))) {
                    String cacheId = config.getName().toLowerCase();

                    if (!s_caches.containsKey(cacheId)) {
                        s_caches.put(cacheId, cacheInfo);
                    } else {
                        cacheInfo = (CacheInfo) ((s_caches.get(cacheId) instanceof CacheInfo) ? s_caches.get(cacheId) : null);
                        cacheInfo.setCacheProps(config);
                    }
                }
            }
        } catch (Exception e) {
//            String msg = String.format("CacheServer failed to load configuration information, Error %1$s", e.getMessage());
//            System.err.println(msg);
//            //Muneeb: CM-1000	:	Not Supported	-	EventLog
//            EventLogger.LogEvent(msg, EventType.WARNING);
        }
    }
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !AZURE

    /**
     * Get string props representation of config
     *
     * @param config
     * @return
     */
    private static String GetProps(CacheServerConfig config) {
        /**
         * [Ata] This is until we change the use of properties in Cache from
         * props stirng or HashMap to Dom
         *
         */
        java.util.HashMap table = ConfigConverter.ToHashMap(config);
        String props = ConfigReader.ToPropertiesString(table);
        return props;
    }

    private static String GetProps(CacheServerConfig[] configs) {
        java.util.HashMap table = ConfigConverter.ToHashMap(configs);
        String props = ConfigReader.ToPropertiesString(table);
        return props;
    }

    private static void SaveConfiguration(Alachisoft.NCache.Config.Dom.CacheServerConfig cacheConfig) throws ManagementException, java.lang.IllegalArgumentException, IllegalAccessException,
            Exception {
        try {
            if (!s_caches.containsKey(cacheConfig.getName()) && !s_caches.containsKey(cacheConfig.getName().toLowerCase())) {
                CacheConfigManager.SaveConfiguration(s_caches, s_partitionedCaches);
            } else {
                throw new Exception("Cache with the same name is already registered on the server.");
            }
        } catch (Exception e) {
            String msg = String.format("Error: %1$s", e.getMessage());
            //AppUtil.LogEvent(msg, EventLogEntryType.Warning);
            throw new Exception(msg);
        }
    }

    /**
     * Save caches to configuration
     */
    private static void SaveConfiguration() throws ManagementException, java.lang.IllegalArgumentException, IllegalAccessException {
        try {
            CacheConfigManager.SaveConfiguration(s_caches, s_partitionedCaches);
        } catch (Exception e) {
            String msg = String.format("CacheServer failed to save configuration information, Error %1$s", e.getMessage() + e.getStackTrace());
            //Muneeb: CM-1000	:	Not Supported	-	EventLog
            EventLogger.LogEvent(msg, EventType.WARNING);
            //System.err.print(msg);
        }
    }
//#endif

    public static void SetWaitOnServiceObject() {
        try {
            synchronized (serviceObject) {
                serviceObject.wait();
            }
        } catch (Exception ex) {
        }
    }

    public static void ReleaseServiceObject() {
        try {
            synchronized (serviceObject) {
                serviceObject.notifyAll();
            }
        } catch (Exception ex) {
        }
    }

    public static void callStaticBlock() {

    }

    public static void disposedStaticCall() {
        if (_evalWarningTask != null) {
            try {
                stopEvalWarning = true;
                _evalWarningTask.interrupt();
            } catch (Exception e) {
            }
        }
        if (com.alachisoft.ncache.licensing.LicenseMonitor.getInstance() != null) {
            com.alachisoft.ncache.licensing.LicenseMonitor.getInstance().dispose();
        }


    }

    @Override
    public void onLicenseExpiration() {
        try {
            StopAllCaches(CacheStopReason.Expired);
        } catch (Exception ex) {
            Logger.getLogger(CacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public final String getClusterIP() {
        return _clusterIp;
    }

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#region    /                 --- IDisposable ---           /

    public final void setClusterIP(String value) {
        _clusterIp = value;
    }

    public final String getLocalCacheIP() {
        return _localCacheIp;
    }

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion

    public final void setLocalCacheIP(String value) {
        _localCacheIp = value;
    }

    /**
     * Finalizer for this object.
     */
    protected void finalize() throws Throwable {

//#if !VS2003 && !EXPRESS
        //licenseLogger.Save();
//#endif
        dispose(false);
    }

    /**
     * Obtains a lifetime service object to control the lifetime policy for this
     * instance.
     *
     * @return An object of type ILease used to control the lifetime policy for
     * this instance.
     */
    public Object InitializeLifetimeService() {
        // This lease never expires
        return null;
    }

    /**
     * @param cacheName
     * @param assemblyFileName
     * @param assemblyFileName Name of the file (assembly)
     * @param buffer
     */
    @TargetMethodAttribute(privateMethod = "CopyAssemblies", privateOverload = 1)
    @Override
    public final void CopyAssemblies(String cacheName, String assemblyFileName, byte[] buffer) {
        //************************** Old Code Before Merging **********************/
        //if (AppUtil.InstallDir != null)
        //{
        //    System.IO.Directory.CreateDirectory(AppUtil.DeployedAssemblyDir);

        //    //string[] folderNames = name.Split(new char[] { '$' });
        //    //string folderLevel1 = System.IO.Path.Combine(deployedAssembliesFolder, folderNames[0]);
        //    //System.IO.Directory.CreateDirectory(folderLevel1.Trim());

        //    string folderLevel2 = System.IO.Path.Combine(AppUtil.DeployedAssemblyDir, cacheName);
        //    System.IO.Directory.CreateDirectory(folderLevel2.Trim());


        //    FileStream fs = new FileStream(folderLevel2 + "\\" + name, FileMode.Create, FileAccess.Write);
        //    fs.Write(buffer, 0, buffer.Length);
        //    fs.Flush();
        //    fs.Close();
        //}
        //***************************************************************************/

        //********************** Newly merged code **********************************/
        if (AppUtil.getInstallDir() != null) {
            //Muneeb :  NR-1020	:	StreamWriter to changed to Writer/OutputStream/FileOutputStream
            FileOutputStream fs = null;
            try {
                String path = DirectoryUtil.getDeployedAssemblyFolder();
                (new java.io.File(path)).mkdir();
                String currentCacheFolderPath = Common.combinePath(path, cacheName.toLowerCase());
                (new java.io.File(currentCacheFolderPath.trim())).mkdir();
                fs = new FileOutputStream(Common.combinePath(currentCacheFolderPath, assemblyFileName));
                fs.write(buffer, 0, buffer.length);
                fs.flush();
            } catch (Exception e) {
            } finally {
                if (fs != null) {
                    fs = null;
                }
            }
        }
        //****************************************************************************/
    }
//#endif

    /**
     * @param bridgeName
     * @param assemblyFileName
     * @param buffer
     */
    @TargetMethodAttribute(privateMethod = "CopyBridgeAssemblies", privateOverload = 1)
    @Override
    public final void CopyBridgeAssemblies(String bridgeName, String assemblyFileName, byte[] buffer) {
        //Muneeb: CM-1000	:	Not Supported	-	FEATURE
        //CM-1001 :	Function Body Commented
//        if (AppUtil.getInstallDir() != null)
//        {
//            FileStream fs = null;
//            try
//            {
//                String bridgeRootFolder = AppUtil.DeployedAssemblyDir + AppUtil.BridgeDir;
//                (new java.io.File(bridgeRootFolder.trim())).mkdir();
//                String currentBridgeFolderPath = System.IO.Path.Combine(bridgeRootFolder, bridgeName);
//                (new java.io.File(currentBridgeFolderPath.trim())).mkdir();
//                fs = new FileStream(currentBridgeFolderPath + "\\" + assemblyFileName, FileMode.Create, FileAccess.Write);
//                fs.Write(buffer, 0, buffer.length);
//                fs.Flush();
//            }
//            catch (Exception e)
//            {
//            }
//            finally
//            {
//                if (fs != null)
//                {
//                    fs.Close();
//                    fs = null;
//                }
//            }
//        }
    }

    /**
     * @param cacheName
     * @param fileName
     * @return
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public byte[] GetAssembly(string cacheName, string fileName)
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetAssembly, 1)]
    @TargetMethodAttribute(privateMethod = "GetAssembly", privateOverload = 1)
    public final byte[] GetAssembly(String cacheName, String fileName) throws java.io.IOException {
        byte[] asmData = null;
        if (AppUtil.getInstallDir() != null) {
            InputStream fs = null;
            try {
                String path = AppUtil.DeployedAssemblyDir + cacheName.toLowerCase() + "\\" + fileName;
                fs = new FileInputStream(path);
                asmData = new byte[fs.available()];
                fs.read(asmData, 0, asmData.length);

//                asmData = new byte[fs.getLength()];
//                fs.Read(asmData, 0, asmData.length);
//                fs.Flush();
            } catch (Exception e) {
                return asmData;
            } finally {
                if (fs != null) {
                    fs.close();
                    fs = null;
                }
            }
        }
        return asmData;
    }

//#endif

    /**
     * Add garbage collection task to time sheduler
     */
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !VS2003 && (!EXPRESS ||(EXPRESS && PROFESSIONAL))
    private void StartGCTask() {
        boolean enabled = true;
        tangible.RefObject<Boolean> tempRef_enabled = new tangible.RefObject<Boolean>(enabled);
        tempRef_enabled.argvalue = Boolean.getBoolean(ServicePropValues.CacheServer_EnableForcedGC);
        enabled = tempRef_enabled.argvalue;

        /**
         * Only if CLR is loaded with Server GC, and user asked for forced GC
         */
        if (enabled /*
         * && System.Runtime.GCSettings.IsServerGC
         */) {
            int threshold = 0;
            tangible.RefObject<Integer> tempRef_threshold = new tangible.RefObject<Integer>(threshold);
            boolean tempVar = Boolean.getBoolean(ServicePropValues.CacheServer_ForcedGCThreshold);
            threshold = tempRef_threshold.argvalue;
            //Basit: needs review
            if (tempVar) {
//                this._gcScheduler.AddTask(new GarbageCollectionTask(threshold));
                this._gcScheduler.AddTask(new TimeScheduler.Task() {
                    @Override
                    public boolean IsCancelled() {
                        return false;
                    }

                    @Override
                    public long GetNextInterval() {
                        return 1000 * 60 * 60 * 12; // 12 hour interval.
                    }

                    @Override
                    public void Run() {
                        // System.gc();
                    }
                });
            }
        }
    }

    /**
     * Performs application-defined tasks associated with freeing, releasing, or
     * resetting unmanaged resources.
     *
     * @param disposing
     */
    private void dispose(boolean disposing) {
        _rwLock.AcquireWriterLock();
        try {
            for (Iterator it = s_caches.values().iterator(); it.hasNext(); ) {
                CacheInfo cacheInfo = (CacheInfo) it.next();
                try {
                    if (cacheInfo != null && cacheInfo.getCache() != null) {
                        cacheInfo.getCache().StopInstance(false);
                    }
                } catch (Exception e) {
                }
            }
            for (Iterator it = s_partitionedCaches.values().iterator(); it.hasNext(); ) {
                java.util.HashMap partitionedTable = (java.util.HashMap) it.next();
                for (Iterator its = partitionedTable.values().iterator(); it.hasNext(); ) {
                    CacheInfo cacheInfo = (CacheInfo) its.next();
                    try {
                        if (cacheInfo != null && cacheInfo.getCache() != null) {
                            cacheInfo.getCache().StopInstance(false);
                        }
                    } catch (Exception e2) {
                    }
                }
            }
            if (_evalWarningTask != null) {
                try {
//                    _evalWarningTask.Stop();
//                    _evalWarningTask.Close();
//                    _evalWarningTask.dispose();
                    stopEvalWarning = true;
                    _evalWarningTask.interrupt();
                } catch (Exception e) {
                }
            }
            if (this._gcScheduler != null) {
                synchronized (this._gcScheduler) {
                    if (this._gcScheduler != null) {
                        try {
                            this._gcScheduler.Stop();
                            this._gcScheduler.dispose();
                        } catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }
            if (com.alachisoft.ncache.licensing.LicenseMonitor.getInstance() != null) {
                com.alachisoft.ncache.licensing.LicenseMonitor.getInstance().dispose();
            }

        } finally {
            _rwLock.ReleaseWriterLock();
        }
        if (disposing) {
            System.gc();
            //Muneeb: Suppress Finalize not in Java
            //GC.SuppressFinalize(this);
        }
    }

    /**
     * Performs application-defined tasks associated with freeing, releasing, or
     * resetting unmanaged resources.
     */
    public final void dispose() {
        dispose(true);
    }

    /**
     * Clear cache
     *
     * @param cacheId
     * @throws OperationFailedException
     */
    @TargetMethodAttribute(privateMethod = MethodName.ClearCache, privateOverload = 1)
    @Override
    public final void ClearCache(String cacheId) throws OperationFailedException {
        ClearCacheContent(cacheId);
    }

    public final LicenseLogger getLicenseLogger() {
        return licenseLogger;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetLicenseLogger, 1)]
    @TargetMethodAttribute(privateMethod = "GetLicenseLogger", privateOverload = 1)
    public final LicenseLogger GetLicenseLogger() {
        return licenseLogger;
    }
//#endif

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetLicenses, 1)]
    @TargetMethodAttribute(privateMethod = MethodName.GetLicenses, privateOverload = 1)
    @Override
    public final LicenseInfo[] GetLicenses() {
        return licenseLogger.getLicenses();
    }

    public final String getLicenseKey() {
        //Muneeb: CM-1000	:	Not Supported	-	Regsitery
//        return RegHelper.GetLicenseKey(0);
        return new String();
    }
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if!AZURE
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public Cache GetCacheInstance(string cacheId, byte[] userId, byte[] password)
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheInstance, 2)]

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetLicenseKey, 1)]
    @TargetMethodAttribute(privateMethod = "GetLicenseKey", privateOverload = 1)
    public final String GetLicenseKey() {
        //Muneeb: CM-1000	:	Not Supported	-	EventHandler
//        return RegHelper.GetLicenseKey(0);
        return new String();
    }

    /**
     * finds and returns a cache object, that was previously created.
     *
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in
     *                               Visual Basic).
     */
    public final Cache getItem(String cacheId) {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }
        _rwLock.AcquireReaderLock();
        try {
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                CacheInfo cacheInfo = (CacheInfo) s_caches.get(cacheId.toLowerCase());

                if (cacheInfo != null) {
                    return cacheInfo.getCache();
                }
            } else if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
                java.util.HashMap partitionedTable = (java.util.HashMap) ((s_partitionedCaches.get(cacheId.toLowerCase()) instanceof java.util.HashMap) ? s_partitionedCaches.get(cacheId.toLowerCase()) : null);
                Iterator ide = partitionedTable.entrySet().iterator();
                LeasedCache stoppedCache = null;
                while (ide.hasNext()) {
                    Map.Entry current = (Map.Entry) ide.next();
                    CacheInfo cacheInfo = (CacheInfo) ((current.getValue() instanceof CacheInfo) ? current.getValue() : null);

                    if (cacheInfo != null) {
                        LeasedCache cache = cacheInfo.getCache();
                        if (cache.getIsRunning()) {
                            return cacheInfo.getCache();
                        }

                        if (stoppedCache == null) {
                            stoppedCache = cacheInfo.getCache();
                        }
                    }
                }
                return stoppedCache;
            }
            return null;
        } finally {
            _rwLock.ReleaseReaderLock();
        }
    }
//#endif



    @TargetMethodAttribute(privateMethod = MethodName.GetTayzGridServer, privateOverload = 1)
    public final boolean IsTayzGridServer() {
        return true;
    }




    /**
     * Get a list of running caches (local + clustered)
     *
     * @param userId   user id
     * @param password password
     * @return list of running caches
     */
    @TargetMethodAttribute(privateMethod = "GetRunningCaches", privateOverload = 2)
    public final java.util.ArrayList GetRunningCaches(String userId, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException,
            InterruptedException, SecurityException {
        return GetRunningCaches(EncryptionUtil.Encrypt(userId), EncryptionUtil.Encrypt(password));
    }

    /**
     * Returns a list of running caches
     *
     * @param userId   user id
     * @param password password
     * @return list of running caches
     */
    @TargetMethodAttribute(privateMethod = "GetRunningCaches", privateOverload = 3)
    private java.util.ArrayList GetRunningCaches(byte[] userId, byte[] password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException,
            SecurityException {
        java.util.ArrayList runningCache = new java.util.ArrayList(5);
        java.util.Map coll = GetCacheProps(userId, password);
        for (Iterator it = coll.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            if (entry.getValue() instanceof CacheServerConfig) {
                CacheServerConfig config = (CacheServerConfig) entry.getValue();
                if (config.getCacheType().equals("local-cache") || config.getCacheType().equals("clustered-cache")) {
                    Cache instance = GetCacheInstance((String) entry.getKey(), userId, password);
                    if (instance != null && instance.getIsRunning()) {
                        runningCache.add(entry.getKey());
                    }
                }
            }
            if (entry.getValue() instanceof String) {
                if (((String) entry.getValue()).indexOf("local-cache", 0) != -1 || ((String) entry.getValue()).indexOf("clustered-cache", 0) != -1) {

                    Cache instance = GetCacheInstance((String) entry.getKey(), userId, password);
                    if (instance != null && instance.getIsRunning()) {
                        runningCache.add(entry.getKey());
                    }
                }

            }
        }
        return runningCache;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheInstance, 1)]
    @TargetMethodAttribute(privateMethod = "GetCacheInstance", privateOverload = 1)
    public final Cache GetCacheInstance(String cacheId, String partitionId) {
        if (partitionId == null || partitionId.equals("")) {
            return this.getItem(cacheId);
        } else {
            if (cacheId == null) {
                throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
            }

            _rwLock.AcquireReaderLock();
            try {
                java.util.HashMap partitionTable = (java.util.HashMap) ((s_partitionedCaches.get(cacheId.toLowerCase()) instanceof java.util.HashMap) ? s_partitionedCaches.get(cacheId.toLowerCase()) : null);
                if (partitionTable != null) {
                    CacheInfo cacheInfo = (CacheInfo) partitionTable.get(partitionId.toLowerCase());
                    if (cacheInfo != null) {
                        return cacheInfo.getCache();
                    }
                    return null;
                }
            } finally {
                _rwLock.ReleaseReaderLock();
            }
        }
        return null;
    }

    @TargetMethodAttribute(privateMethod = "GetCacheInstance", privateOverload = 2)
    public final Cache GetCacheInstance(String cacheId, byte[] userId, byte[] password) {
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS
        //Security
        //if (!(ApiSecurityProvider.ApiSecurity.Authorize(Decrypt(userId), Decrypt(password), cacheId)))
        //    throw new SecurityException("You do not have permissions to perform this operation");

        //Security: New Code
        //if (this[cacheId] != null && this[cacheId].CacheSecurityProvider != null)
        //{
        //    bool isAuthorized;
        //    isAuthorized = this[cacheId].CacheSecurityProvider.Authorize(Decrypt(userId), Decrypt(password), cacheId);

        //    if (!isAuthorized)
        //    {
        //        throw new SecurityException("You do not have permissions to perform this operation");
        //    }
        //}

//#endif
        return this.getItem(cacheId);
    }

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public Cache GetCacheInstance(string cacheId, string partitionId, byte[] userId, byte[] password)
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheInstance, 3)]
    @TargetMethodAttribute(privateMethod = "GetCacheInstance", privateOverload = 3)
    public final Cache GetCacheInstance(String cacheId, String partitionId, byte[] userId, byte[] password) throws SecurityException {
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS
        //Security
        //if (!(ApiSecurityProvider.ApiSecurity.Authorize(Decrypt(userId), Decrypt(password), cacheId)))
        //    throw new SecurityException("You do not have permissions to perform this operation");
//#endif
        Cache returnCache = null;
        if (partitionId == null || partitionId.equals("")) {
            returnCache = this.getItem(cacheId);
        } else {
            if (cacheId == null) {
                throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
            }

            _rwLock.AcquireReaderLock();
            try {
                java.util.HashMap partitionTable = (java.util.HashMap) ((s_partitionedCaches.get(cacheId.toLowerCase()) instanceof java.util.HashMap) ? s_partitionedCaches.get(cacheId.toLowerCase()) : null);
                if (partitionTable != null) {
                    CacheInfo cacheInfo = (CacheInfo) partitionTable.get(partitionId.toLowerCase());
                    if (cacheInfo != null) {
                        returnCache = cacheInfo.getCache();
                    }
                }
            } finally {
                _rwLock.ReleaseReaderLock();
            }
        }

        return returnCache;
    }

    /**
     * Gets the cache instance ignoring the backup/replica id. For e.g. if we
     * have two instances of the same cache por_test (master node id) and
     * por_test_bk_node_node1 a replica of the same cache. Now we try to first
     * connect the master id and if it is not available or running then we try
     * to connect to its backup although its id is different. UserId and
     * password are in encryped form.
     *
     * @param cacheId  Id of the cache
     * @param userId   Encrypted user id
     * @param password Encrypted password
     * @return Cache Instance
     * @throws IllegalArgumentException
     * @throws SecurityException
     */
    @TargetMethodAttribute(privateMethod = "GetCacheInstanceIgnoreReplica", privateOverload = 1)
    public final Cache GetCacheInstanceIgnoreReplica(String cacheId, byte[] userId, byte[] password) throws IllegalArgumentException, SecurityException {
        return GetCacheInstanceIgnoreReplica(cacheId, Decrypt(userId), Decrypt(password));
    }

    /**
     * Gets the cache instance ignoring the backup/replica id. For e.g. if we
     * have two instances of the same cache por_test (master node id) and
     * por_test_bk_node_node1 a replica of the same cache. Now we try to first
     * connect the master id and if it is not available or running then we try
     * to connect to its backup although its id is different.
     *
     * @param cacheId  Id of the cache
     * @param userId   user id
     * @param password password
     * @return Cache Instance
     * @throws IllegalArgumentException
     * @throws SecurityException
     */
    @TargetMethodAttribute(privateMethod = "GetCacheInstanceIgnoreReplica", privateOverload = 2)
    public final Cache GetCacheInstanceIgnoreReplica(String cacheId, String userId, String password) throws IllegalArgumentException, SecurityException {

        if (userId != null && userId.equals("")) {
            userId = null;
        }
        if (password != null && password.equals("")) {
            password = null;
        }
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS
        //Security
        //if (!(ApiSecurityProvider.ApiSecurity.Authorize(userId, password, cacheId)))
        //    throw new SecurityException("You do not have permissions to perform this operation");
//#endif
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }
        cacheId = cacheId.toLowerCase();

        // _rwLock.AcquireReaderLock();
        Boolean isLockAcquired = false;
        if (!_rwLock.IsWriterLockHeld()) {
            _rwLock.AcquireReaderLock();
            isLockAcquired = true;
        }
        Cache cache = null;
        try {
            if (s_caches.containsKey(cacheId)) {
                CacheInfo cacheInfo = (CacheInfo) s_caches.get(cacheId);

                if (cacheInfo != null) {
                    cache = cacheInfo.getCache();
                }

                if (cache != null && cache.getIsRunning()) {
                    return cache;
                }
            } else if (s_partitionedCaches.containsKey(cacheId)) {
                java.util.HashMap partitionedTable = (java.util.HashMap) ((s_partitionedCaches.get(cacheId) instanceof java.util.HashMap) ? s_partitionedCaches.get(cacheId) : null);
                if (partitionedTable != null) {
                    Iterator ide = partitionedTable.entrySet().iterator();
                    while (ide.hasNext()) {
                        Map.Entry current = (Map.Entry) ide.next();

                        CacheInfo cacheInfo = (CacheInfo) ((current.getValue() instanceof CacheInfo) ? current.getValue() : null);

                        if (cacheInfo != null) {
                            cache = cacheInfo.getCache();
                        }

                        if (cache != null && cache.getIsRunning()) {
                            return cache;
                        }
                    }
                }
            }
        } finally {
            if (isLockAcquired) {
                _rwLock.ReleaseReaderLock();
            }


        }
        return cache;
    }

    /**
     * @param userId
     * @param password
     * @return
     * @throws SecurityException
     */
    @TargetMethodAttribute(privateMethod = MethodName.GetCacheProps, privateOverload = 1)
    @Override
    public final java.util.Map GetCacheProps(byte[] userId, byte[] password) throws SecurityException {

        return getCacheProps();
    }

    /**
     * CacheProps are in new format now. Instead of saving the props string, it
     * now saves CacheServerConfig instance:
     * <p>
     * |local-cache-id | CacheServerConfig instance
     * |partitioned-replica-cache-id | IDictionary | replica-id |
     * CacheServerConfig instance
     *
     * @return A collection of the cache info registered with the server.
     */
    public final java.util.Map getCacheProps() {
        java.util.Map cacheProps = new java.util.HashMap();
        _rwLock.AcquireReaderLock();
        try {
            Iterator en = s_caches.entrySet().iterator();
            while (en.hasNext()) {
                Map.Entry current = (Map.Entry) en.next();
                CacheInfo cacheInfo = (CacheInfo) current.getValue();
                cacheProps.put(cacheInfo.getCache().getName(), cacheInfo.getCacheProps());
            }

            Iterator ide = s_partitionedCaches.entrySet().iterator();
            while (ide.hasNext()) {
                Map.Entry current = (Map.Entry) ide.next();
                String cacheName = (String) ((current.getKey() instanceof String) ? current.getKey() : null);
                java.util.HashMap tbl = new java.util.HashMap();
                java.util.HashMap partitionedTable = (java.util.HashMap) ((current.getValue() instanceof java.util.HashMap) ? current.getValue() : null);
                cacheProps.put(cacheName, tbl);
                Iterator ie = partitionedTable.entrySet().iterator();
                while (ie.hasNext()) {
                    Map.Entry subCurrent = (Map.Entry) ie.next();
                    CacheInfo cacheInfo = (CacheInfo) Common.readAs(subCurrent.getValue(), CacheInfo.class);
                    tbl.put(subCurrent.getKey(), cacheInfo.getCacheProps());
                }
            }
            return cacheProps;
        } finally {
            _rwLock.ReleaseReaderLock();
        }
    }
//
//    /**
//     * Adds Server Node
//     *
//     * @param cacheId
//     * @param config
//     * @param partId
//     * @param overwrite
//     * @param userId
//     * @param password
//     * @param hotApply
//     * @param isLocalNode
//     * @return
//     * @throws SecurityException
//     * @throws Exception
//     * @throws ManagementException
//     * @throws ConfigurationException
//     * @throws UnknownHostException
//     * @throws IllegalAccessException
//     */
//    @TargetMethodAttribute(privateMethod = MethodName.RegisterCache, privateOverload = 5)
//    @Override
//    public final boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.Dom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply, boolean isLocalNode) throws
//            ManagementException, ConfigurationException, UnknownHostException, Exception, IllegalAccessException, SecurityException {
//        if (cacheId == null) {
//            throw new IllegalArgumentException("cacheId");
//        }
//
//        if ((!NodeSecurityProvider.getNodeSecurity().Authorize(Decrypt(userId), Decrypt(password), null))) {
//            if (!VerifySystemAdministrator(Decrypt(userId), Decrypt(password))) {
//                throw new SecurityException("You do not have permissions to perform this operation");
//            }
//        }
//        //Taimoor:We load configuration before applying the new changes to preserve some old values in the config.
//        //LoadConfiguration();
//
//        cacheId = cacheId.toLowerCase();
//        CacheInfo cacheInfo = null;
//
//        _rwLock.AcquireWriterLock();
//        try {
//
//            if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
//                throw new ManagementException("A cache with same cacheId already exists");
//            }
//
//            if (s_caches.containsKey(cacheId.toLowerCase())) {
//                if (!overwrite) {
//                    //_rwLock.ReleaseWriterLock();
//                    return false;
//                }
//                cacheInfo = (CacheInfo) s_caches.get(cacheId.toLowerCase());
//                //(WARNING)Taimoor: This code is here to save the old value of connection-retries
//                //in the cluster configuration to avoid override by NCManager.
//                //This code should be removed after these options appears on UI.
//                //props = GetChangedConfigForTemp(cacheId.ToLower(), cacheInfo.CacheProps, props);
//                ///#if !EXPRESS
//                //                    ClientConfigManager.UpdateCacheConfig(cacheId.ToLower(), new HashMap());
//                ///#endif
//            } else {
//                /**
//                 * [Ata] This is until we change the use of properties in Cache
//                 * from props stirng or HashMap to Dom
//                 *
//                 */
//                String props = GetProps(config);
//
//                ClientConfigManager.setLocalCacheId(this.getLocalCacheIP());
//                ClientConfigManager.AddCache(cacheId, config.getRuntimeContext());
//
//                cacheInfo = new CacheInfo();
//                cacheInfo.setCache(new LeasedCache(props));
//
//                s_caches.put(cacheId.toLowerCase(), cacheInfo);
//            }
//            cacheInfo.setCacheProps(config);
//
//            if (hotApply && cacheInfo != null && cacheInfo.getCache() != null && cacheInfo.getCache().getIsRunning()) {
//                CacheConfig cc = CacheConfig.FromConfiguration(config);
//
//                Alachisoft.NCache.Caching.Util.HotConfig hotConfig = new Alachisoft.NCache.Caching.Util.HotConfig();
//                hotConfig.setIsErrorLogsEnabled(cc.getIsErrorLogsEnabled());
//                hotConfig.setIsDetailedLogsEnabled(cc.getIsDetailedLogsEnabled());
//                hotConfig.setCacheMaxSize(cc.getCacheMaxSize());
//                hotConfig.setCleanInterval(cc.getCleanInterval());
//                hotConfig.setEvictRatio(cc.getEvictRatio());
//                hotConfig.setSecurityEnabled(cc.getSecurityEnabled());
//                hotConfig.setSecurityDomainController(cc.getSecurityDomainController());
//                hotConfig.setSecurityPort(cc.getSecurityPort());
//                hotConfig.setSecurityUsers(cc.getSecurityUsers());
//                hotConfig.setAlertNotifier(cc.getAlertNotification());
//                hotConfig.setCompressionEnabled(cc.getCompressionEnabled());
//                hotConfig.setCompressionThreshold(cc.getCompressionThreshold());
//                hotConfig.setIsBridgeTargetCache(cc.getIsBridgeTargetCache());
//
//                cacheInfo.getCache().ApplyHotConfiguration(hotConfig);
//            }
//            SaveConfiguration();
//        } catch (Exception e) {
//            throw e;
//        } finally {
//            _rwLock.ReleaseWriterLock();
//        }
//
//        return true;
//    }

//    @TargetMethodAttribute(privateMethod = MethodName.RegisterCache, privateOverload = 6)
//    @Override
//    public final boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply, boolean isLocalNode) throws
//            ManagementException, ConfigurationException, UnknownHostException, Exception, IllegalAccessException, SecurityException {
//
//        Alachisoft.NCache.Config.Dom.CacheServerConfig oldDom = Alachisoft.NCache.Config.NewDom.DomHelper.convertToOldDom(config);
//        return RegisterCache(cacheId, oldDom, partId, overwrite, userId, password, hotApply, isLocalNode);
//    }

    @TargetMethodAttribute(privateMethod = MethodName.GetCacheConfiguration, privateOverload = 1)
    public final CacheServerConfig GetCacheConfiguration(String cacheId) {
        CacheInfo cacheInfo = GetCacheInfo(cacheId);
        CacheServerConfig config = null;

        if (cacheInfo != null) {
            config = cacheInfo.getCacheProps();
        }

        return config;
    }

    /**
     * @param cacheId
     * @return
     */
    @TargetMethodAttribute(privateMethod = MethodName.GetNewConfiguration, privateOverload = 1)
    @Override
    public final Alachisoft.NCache.Config.NewDom.CacheServerConfig GetNewConfiguration(String cacheId) throws Exception {
        CacheInfo cacheInfo = GetCacheInfo(cacheId);
        CacheServerConfig config = null;

        if (cacheInfo != null) {
            config = cacheInfo.getCacheProps();
            return Alachisoft.NCache.Config.NewDom.DomHelper.convertToNewDom(config);
        }

        return null;

    }

    @TargetMethodAttribute(privateMethod = MethodName.GetCacheInfo, privateOverload = 1)
    public final CacheInfo GetCacheInfo(String cacheId) {
        CacheInfo cacheInfo = null;

        if (s_caches.containsKey(cacheId.toLowerCase())) {
            cacheInfo = (CacheInfo) ((s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo) ? s_caches.get(cacheId.toLowerCase()) : null);
        } else if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
            java.util.HashMap partitionedTable = (java.util.HashMap) ((s_partitionedCaches.get(cacheId.toLowerCase()) instanceof java.util.HashMap) ? s_partitionedCaches.get(cacheId.toLowerCase()) : null);
            if (partitionedTable != null) {
                for (Iterator it = partitionedTable.entrySet().iterator(); it.hasNext(); ) {
                    Map.Entry de = (Map.Entry) it.next();
                    cacheInfo = (CacheInfo) ((de.getValue() instanceof CacheInfo) ? de.getValue() : null);
                    if (cacheInfo != null) {
                        break;
                    }
                }
            }
        }

        return cacheInfo;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetHostName, privateOverload = 1)
    @Override
    public final String GetHostName() throws UnknownHostException {
        String localhost = java.net.InetAddress.getLocalHost().getHostName();
        return localhost;
    }

    /**
     * @param cacheId
     * @param partId
     * @param newNode
     * @param isJoining
     * @return
     * @throws ManagementException
     * @throws Exception
     */
    @TargetMethodAttribute(privateMethod = "GetUpdatedCacheConfiguration", privateOverload = 1)
    @Override
    public final CacheRegisterationInfo GetUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, Exception {
        CacheServerConfig config = null;
        java.util.ArrayList affectedNodes = new java.util.ArrayList();
        java.util.ArrayList affectedPartitions = new java.util.ArrayList();
        try {
            tangible.RefObject<java.util.ArrayList> tempRef_affectedNodes = new tangible.RefObject<java.util.ArrayList>(affectedNodes);
            config = CacheConfigManager.GetUpdatedCacheConfig(cacheId, partId, newNode, tempRef_affectedNodes, isJoining);
            affectedNodes = tempRef_affectedNodes.argvalue;
        } catch (Exception ex) {
            throw ex;
        }

        //muds:
        //update the config

        return new CacheRegisterationInfo(config, affectedNodes, affectedPartitions);
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetNewUpdatedCacheConfiguration, privateOverload = 1)
    @Override
    public NewCacheRegisterationInfo GetNewUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, Exception {

        Alachisoft.NCache.Management.CacheRegisterationInfo oldCacheInfo = GetUpdatedCacheConfiguration(cacheId, partId, newNode, isJoining);

        Alachisoft.NCache.Config.NewDom.CacheServerConfig newDom = Alachisoft.NCache.Config.NewDom.DomHelper.convertToNewDom(oldCacheInfo.getUpdatedCacheConfig());
        Alachisoft.NCache.Management.NewCacheRegisterationInfo newCacheInfo = new NewCacheRegisterationInfo(newDom, oldCacheInfo.getAffectedNodes(), oldCacheInfo.getAffectedPartitions());

        return newCacheInfo;

    }

    /**
     * Gets or sets the cache renderer.
     */
    public final CacheRenderer getRenderer() {
        return _renderer;
    }

    public final void setRenderer(CacheRenderer value) {
        _renderer = value;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheRenderer,1)]
    @TargetMethodAttribute(privateMethod = "GetCacheRenderer", privateOverload = 1)
    public final CacheRenderer GetCacheRenderer() {
        return _renderer;

    }

    /**
     * Register cache
     *
     * @param cacheId
     * @param props
     * @param overwrite
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in
     *                               Visual Basic).
     */
    @TargetMethodAttribute(privateMethod = MethodName.RegisterCache, privateOverload = 1)
    @Override
    public final boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.Dom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws
            ConfigurationException, UnknownHostException, ManagementException, java.lang.Exception, SecurityException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }


        //Taimoor:We load configuration before applying the new changes to preserve some old values in the config.
        //LoadConfiguration();

        cacheId = cacheId.toLowerCase();
        CacheInfo cacheInfo = null;

        _rwLock.AcquireWriterLock();
        try {

            if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
                throw new ManagementException("A cache with same cacheId already exists");
            }


            if (s_caches.containsKey(cacheId.toLowerCase())) {
                if (!overwrite) {
                    //_rwLock.ReleaseWriterLock();
                    return false;
                }
                cacheInfo = (CacheInfo) s_caches.get(cacheId.toLowerCase());
                //(WARNING)Taimoor: This code is here to save the old value of connection-retries
                //in the cluster configuration to avoid override by NCManager.
                //This code should be removed after these options appears on UI.
                //props = GetChangedConfigForTemp(cacheId.ToLower(), cacheInfo.CacheProps, props);
                ///#if !EXPRESS
                //                    ClientConfigManager.UpdateCacheConfig(cacheId.ToLower(), new HashMap());
                ///#endif
            } else {
                /**
                 * [Ata] This is until we change the use of properties in Cache
                 * from props stirng or HashMap to Dom
                 *
                 */
                String props = GetProps(config);

                ClientConfigManager.setLocalCacheId(this.getLocalCacheIP());
                ClientConfigManager.AddCache(cacheId, config.getRuntimeContext());

                cacheInfo = new CacheInfo();
                cacheInfo.setCache(new LeasedCache(props));

                s_caches.put(cacheId.toLowerCase(), cacheInfo);
            }
            cacheInfo.setCacheProps(config);

            if (hotApply && cacheInfo != null && cacheInfo.getCache() != null && cacheInfo.getCache().getIsRunning()) {
                CacheConfig cc = CacheConfig.FromConfiguration(config);

                Alachisoft.NCache.Caching.Util.HotConfig hotConfig = new Alachisoft.NCache.Caching.Util.HotConfig();
                hotConfig.set_isErrorLogsEnabled(cc.getIsErrorLogsEnabled());
                hotConfig.set_isDetailedLogsEnabled(cc.getIsDetailedLogsEnabled());
                hotConfig.set_cacheMaxSize(cc.getCacheMaxSize());
                hotConfig.set_cleanInterval(cc.getCleanInterval());
                hotConfig.set_evictRatio(cc.getEvictRatio());
                //TODO update Hotapply
//                if(hotConfig.is_expirationEnabled()= cc.)
//                hotConfig.setSecurityEnabled(cc.getSecurityEnabled());
//                hotConfig.setSecurityDomainController(cc.getSecurityDomainController());
//                hotConfig.setSecurityPort(cc.getSecurityPort());
//                hotConfig.setSecurityUsers(cc.getSecurityUsers());
//                hotConfig.setAlertNotifier(cc.getAlertNotification());
//
//                hotConfig.setCompressionEnabled(cc.getCompressionEnabled());
//                hotConfig.setCompressionThreshold(cc.getCompressionThreshold());
//                hotConfig.setIsBridgeTargetCache(cc.getIsBridgeTargetCache());
//                hotConfig.setBackingSource(cc.getBackingSource());
//                hotConfig.setCompactSerialization(cc.getCompactKnownTypes());
                cacheInfo.getCache().ApplyHotConfiguration(hotConfig);
            }
            SaveConfiguration();
        } catch (Exception e) {
            throw e;
        } finally {
            _rwLock.ReleaseWriterLock();
        }

        return true;
    }

    @TargetMethodAttribute(privateMethod = MethodName.RegisterCache, privateOverload = 2)
    @Override
    public final boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws
            ConfigurationException, UnknownHostException, ManagementException, java.lang.Exception, SecurityException {

        Alachisoft.NCache.Config.Dom.CacheServerConfig oldDom = Alachisoft.NCache.Config.NewDom.DomHelper.convertToOldDom(config);
        return RegisterCache(cacheId, oldDom, partId, overwrite, userId, password, hotApply);
    }

    private String GetChangedConfigForTemp(String cacheId, String oldProps, String updatedProps) {
        if (oldProps != null) {
            PropsConfigReader pcr = new PropsConfigReader(oldProps);
            java.util.Map cacheConfig = pcr.getProperties();
            if (cacheConfig != null) {
                java.util.HashMap configTable = new java.util.HashMap();
                cacheConfig.put("id", cacheId);
                configTable.put("configuration", cacheConfig);
                CacheServerConfig[] configDomList = ConfigConverter.ToDom(configTable);
                if (configDomList != null && configDomList.length > 0) {
                    Object tempVar = configDomList[0];
                    CacheServerConfig oldConfig = (CacheServerConfig) ((tempVar instanceof CacheServerConfig) ? tempVar : null);
                    if (oldConfig != null) {
                        if (oldConfig.getCluster() != null && oldConfig.getCluster().getChannel() != null && oldConfig.getCluster().getChannel() != null) {
                            int retries = oldConfig.getCluster().getChannel().getConnectionRetries();
                            int retryInterval = oldConfig.getCluster().getChannel().getConnectionRetryInterval();
                            int indexOfTcpConfig = updatedProps.toLowerCase().indexOf("tcp(");
                            if (indexOfTcpConfig > -1) {
                                String str = "connection_retries=" + retries + ";connection_retry_interval=" + retryInterval + ";";

                                updatedProps = new StringBuffer(updatedProps).insert(indexOfTcpConfig + 4, str).toString();
                                //Muneeb: IN-1014	:	Changed String.Insert() to StringBuffer().insert().ToString()
                                //updatedProps = updatedProps.insert(indexOfTcpConfig + 4, str);
                            }
                        }
                    }
                }

            }
        }
        return updatedProps;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetNodeInfo, privateOverload = 1)
    public final NodeInfoMap GetNodeInfo() {
        java.util.HashMap nodeInfo = new java.util.HashMap();
        nodeInfo.put(Channel.Cluster, getClusterIP());
        nodeInfo.put(Channel.SocketServer, ClientConfigManager.getBindIP());
        return new NodeInfoMap(nodeInfo);
    }

    @TargetMethodAttribute(privateMethod = MethodName.CanApplyHotConfig, privateOverload = 1)
    public final String CanApplyHotConfiguration(String cacheId, CacheServerConfig config) {
        Exception e = CanApplyHotConfig(cacheId, config);

        if (e != null) {
            return e.getMessage();
        }
        return null;
    }

    public final Exception CanApplyHotConfig(String cacheId, CacheServerConfig config) {
        CacheInfo cacheInfo = null;
        cacheId = cacheId.toLowerCase();
        java.util.HashMap result = new java.util.HashMap();

        Alachisoft.NCache.Caching.Util.HotConfig hotConfig = new Alachisoft.NCache.Caching.Util.HotConfig();

        // TODO update HOTAPPLY
//        hotConfig.setIsErrorLogsEnabled(config.getLog().getTraceErrors());
//        hotConfig.setIsDetailedLogsEnabled(config.getLog().getTraceNotices());
//        hotConfig.setCacheMaxSize(config.getStorage().getSize() * 1024 * 1024); //from MBs to bytes
//        hotConfig.setCleanInterval(config.getCleanup().getInterval());
//        hotConfig.setEvictRatio(config.getEvictionPolicy().getEvictionRatio().floatValue());
//
//        hotConfig.setCompressionEnabled(config.getCompression().getEnabled());
//        hotConfig.setCompressionThreshold(config.getCompression().getThreshold());
//Muneeb: Not Supported	-	Bridge
//        if (config.getBridge() != null)
//        {
//            hotConfig.setIsBridgeTargetCache(config.getBridge().getIsBridgeTargetCache());
//            //hotConfig = config.Bridge.Status;
//        }

        if (s_caches.containsKey(cacheId)) {
            cacheInfo = (CacheInfo) s_caches.get(cacheId);
            return cacheInfo.getCache().CanApplyHotConfig(hotConfig);
        }

        return null;
    }

    /**
     * returns the collection of cache objects.
     */
    public final java.util.Collection getCaches() {
        java.util.ArrayList caches = new java.util.ArrayList();
        _rwLock.AcquireReaderLock();
        try {
            Iterator en = s_caches.entrySet().iterator();
            while (en.hasNext()) {
                Map.Entry current = (Map.Entry) en.next();
                CacheInfo cacheInfo = (CacheInfo) current.getValue();
                {
                    caches.add(cacheInfo.getCache());
                }
            }
            return caches;
        } finally {
            _rwLock.ReleaseReaderLock();
        }
    }

    public final java.util.Map getPartitionedReplicaCaches() {
        java.util.HashMap caches = new java.util.HashMap();
        java.util.HashMap tmp = null;
        _rwLock.AcquireReaderLock();
        try {
            Iterator en = s_partitionedCaches.entrySet().iterator();
            while (en.hasNext()) {
                Map.Entry current = (Map.Entry) en.next();
                String cacheId = (String) ((current.getKey() instanceof String) ? current.getKey() : null);

                if (!caches.containsKey(cacheId.toLowerCase())) {
                    tmp = new java.util.HashMap();
                    caches.put(cacheId.toLowerCase(), tmp);
                }

                java.util.HashMap partitionedCaches = (java.util.HashMap) ((current.getValue() instanceof java.util.HashMap) ? current.getValue() : null);
                if (partitionedCaches != null) {
                    for (Iterator it = partitionedCaches.entrySet().iterator(); it.hasNext(); ) {
                        Map.Entry de = (Map.Entry) it.next();
                        String partId = (String) ((de.getKey() instanceof String) ? de.getKey() : null);
                        CacheInfo cacheInfo = (CacheInfo) de.getValue();
                        if (tmp != null) {
                            tmp.put(partId, cacheInfo.getCache());
                        }
                    }
                }
            }
            return caches;
        } finally {
            _rwLock.ReleaseReaderLock();
        }
    }

    @TargetMethodAttribute(privateMethod = MethodName.RemoveCacheServerFromClientConfig, privateOverload = 1)
    public final void RemoveCacheServerFromClientConfig(String cacheId, String serverName) throws ManagementException, ParserConfigurationException, SAXException, IOException,
            InstantiationException, IllegalAccessException {
        ClientConfigManager.RemoveCacheServer(cacheId, serverName);
    }

    @TargetMethodAttribute(privateMethod = MethodName.RemoveCacheFromClientConfig, privateOverload = 1)
    public final void RemoveCacheFromClientConfig(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException,
            IllegalAccessException {
        ClientConfigManager.RemoveCache(cacheId);
    }

    @TargetMethodAttribute(privateMethod = MethodName.UpdateClientServersList, privateOverload = 1)
    public final void UpdateClientServersList(String cacheId, CacheServerList serversPriorityList, String serverRuntimeContext) throws ManagementException, ParserConfigurationException, SAXException,
            IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateServerNodes(cacheId, serversPriorityList, serverRuntimeContext.equals("1") ? RtContextValue.JVCACHE : RtContextValue.NCACHE);
    }

    @TargetMethodAttribute(privateMethod = MethodName.UpdateClientServersList, privateOverload = 2)
    public final void UpdateClientServersList(String cacheId, String[] servers, tangible.RefObject<String> xml, String clientCacheId, boolean loadBalance) throws
            ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateServerNodes(cacheId, servers, xml, clientCacheId, loadBalance);
    }

    @TargetMethodAttribute(privateMethod = MethodName.UpdateSecurity, privateOverload = 1)
    public final void UpdateSecurity(boolean enabled, java.util.HashMap newSecurityMap, String ldap, String ldapPort) {
        SecurityConfigManager.UpdateSecurity(enabled, newSecurityMap, ldap, ldapPort);
    }

    @TargetMethodAttribute(privateMethod = MethodName.UpdateUserSecurityCredentials, privateOverload = 1)
    public final void UpdateUserSecurityCredentials(String cacheId, String[] users, String[] passwords) throws ManagementException, ParserConfigurationException, SAXException,
            IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateUserSecurityCredentials(cacheId, users, passwords);
    }

    public final void GetUserSecurityCredentials(String cacheId, tangible.RefObject<String[]> users, tangible.RefObject<String[]> passwords) throws ManagementException,
            ParserConfigurationException,
            SAXException, IOException,
            InstantiationException,
            IllegalAccessException {
        ClientConfigManager.GetUserSecurityCredentials(cacheId, users, passwords);
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetUserSecurityCredentials, privateOverload = 1)
    public final Object[] GetUserSecurityCredentials(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException,
            IllegalAccessException {
        Object[] credenials = new Object[2];
        String[] users = null;
        String[] password = null;

        tangible.RefObject<String[]> tempRef_users = new tangible.RefObject<String[]>(users);
        tangible.RefObject<String[]> tempRef_password = new tangible.RefObject<String[]>(password);
        GetUserSecurityCredentials(cacheId, tempRef_users, tempRef_password);
        users = tempRef_users.argvalue;
        password = tempRef_password.argvalue;

        credenials[0] = users;
        credenials[1] = password;

        return credenials;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetClientConfiguration, privateOverload = 1)
    public final ClientConfiguration GetClientConfiguration(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException,
            InstantiationException, IllegalAccessException {
        return ClientConfigManager.GetClientConfiguration(cacheId);
    }

    @TargetMethodAttribute(privateMethod = MethodName.UpdateClientConfiguration, privateOverload = 1)
    public final void UpdateClientConfiguration(String cacheId, ClientConfiguration configuration) throws ManagementException, ParserConfigurationException, SAXException,
            IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateCacheConfiguration(cacheId, configuration);
    }
//

    @TargetMethodAttribute(privateMethod = MethodName.GetBindIP, privateOverload = 1)
    public final String GetBindIP() {
        return ClientConfigManager.getBindIP();
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetClientConfigId, privateOverload = 1)
    public final int GetClientConfigId() throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        return ClientConfigManager.GetConfigurationId();
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetClientNodeStatus, privateOverload = 1)
    public final ClientNodeStatusWrapper GetClientNodeStatus(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException,
            InstantiationException, IllegalAccessException {
        String clientCacheId = "";

        tangible.RefObject<String> tempRef_clientCacheId = new tangible.RefObject<String>(clientCacheId);

        ClientNodeStatus status = ClientConfigManager.GetClientNodeStatus(cacheId, tempRef_clientCacheId);

        clientCacheId = tempRef_clientCacheId.argvalue;

        if (status == ClientNodeStatus.ClientCacheUnavailable) {
            StatusInfo statusInfo = GetCacheStatus(clientCacheId, null);
            if (statusInfo.getIsRunning()) {
                status = ClientNodeStatus.ClientCacheDisabled;
            }
        } else if (status == ClientNodeStatus.ClientCacheDisabled) {
            StatusInfo statusInfo = GetCacheStatus(clientCacheId, null);

            if (statusInfo.getIsRunning()) {
                status = ClientNodeStatus.ClientCacheEnabled;
            } else if (statusInfo.getIsUnavailable()) {
                status = ClientNodeStatus.ClientCacheUnavailable;
            }
        }
        ClientNodeStatusWrapper nodeStatus = new ClientNodeStatusWrapper();
        nodeStatus.value = status;
        return nodeStatus;
    }

    /**
     * Enable logging for specified subsystem
     *
     * @param subsystem Subsystem for which logging will be enabled
     * @param type      Type of logging to enable
     */
    @TargetMethodAttribute(privateMethod = MethodName.EnableLogging, privateOverload = 1)
    public final void EnableLogging(LoggingSubsystem subsystem, LoggingType type) throws Exception {
        try {
            this._renderer.SetLoggingStatus(subsystem, type, LogsStatus.Enable);
            EventLogger.LogEvent("NCache", subsystem.toString() + " logging enabled successfully", EventType.INFORMATION, EventCategories.Information, EventID.LoggingEnabled);
        } catch (Exception exc) {
            EventLogger.LogEvent("NCache", exc.toString(), EventType.ERROR, EventCategories.Error, EventID.GeneralError);
            throw exc;
        }
    }

    private boolean VerifySystemAdministrator(String userName, String password) {
        return true;

    }

    @TargetMethodAttribute(privateMethod = MethodName.VerifyWindowsUser, privateOverload = 1)
    public final boolean VerifyWindowsUser(String nodeName, String userName, String password) {
        throw new UnsupportedOperationException("Security not supported yet.");
        //Alachisoft.NCache.Common.Util.SecurityUtil.VerifyWindowsUserForRole(nodeName, userName, password, WindowsBuiltInRole.Administrator);

    }

    @TargetMethodAttribute(privateMethod = MethodName.VerfyAdministrator, privateOverload = 1)
    public final boolean VerfyAdministrator(String userName, String password) {
        throw new UnsupportedOperationException("Security not supported yet.");
//        WindowsIdentity identity = WindowsIdentity.GetCurrent();
//        WindowsPrincipal principal = new WindowsPrincipal(identity);
//        return principal.IsInRole(WindowsBuiltInRole.Administrator);

    }

    @TargetMethodAttribute(privateMethod = MethodName.VerifyNodeAdministrator, privateOverload = 1)
    public final boolean VerifyNodeAdministrator(String userName, String password) {

        return false;
    }

    /**
     * Disbale logging
     *
     * @param subsystem Subsystem for which logging will be disabled
     * @param type      Type of logging to disable
     */
    @TargetMethodAttribute(privateMethod = MethodName.DisableLogging, privateOverload = 1)
    public final void DisableLogging(LoggingInfo.LoggingSubsystem subsystem, LoggingType type) throws Exception {
        try {
            this._renderer.SetLoggingStatus(subsystem, type, LogsStatus.Disable);
            EventLogger.LogEvent("NCache", subsystem.toString() + " logging disabled successfully", EventType.INFORMATION, EventCategories.Information, EventID.LoggingDisabled);
        } catch (Exception exc) {
            EventLogger.LogEvent("NCache", exc.toString(), EventType.ERROR, EventCategories.Error, EventID.GeneralError);
            throw exc;
        }
    }
    /*
     private CacheServerList UpdateServerPriorityList(CacheServerList serverList)
     {
     Hashmap<int,Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer)
     int i = 0;
     }
     * */

    @TargetMethodAttribute(privateMethod = MethodName.SynchronizeClientConfig, privateOverload = 1)
    public final void SynchronizeClientConfig() throws UnknownHostException, ManagementException {
        String bindIP = ServicePropValues.BIND_toClient_IP;
        InetAddress ipAddr = null;

        if (bindIP != null && !bindIP.equals("")) {
            try {
                String[] str = bindIP.split("\\.");
                byte[] bite = new byte[4];
                bite[0] = new Integer(str[0]).byteValue();
                bite[1] = new Integer(str[1]).byteValue();
                bite[2] = new Integer(str[2]).byteValue();
                bite[3] = new Integer(str[3]).byteValue();
                InetAddress.getByAddress(bite);
            } catch (Exception e) {
                bindIP = java.net.InetAddress.getLocalHost().getHostName().toLowerCase();
            }
        } else {
            bindIP = java.net.InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        _clientserverip = bindIP;
        ClientConfigManager.setBindIP(bindIP);
        ClientConfigManager.AvailableNIC(DetectNICs());

        try {
            ClientConfigManager.LoadConfiguration();
        } catch (Exception parserConfigurationException) {
            throw new ManagementException(parserConfigurationException.getMessage());
        }

    }

    /**
     * Update TCP cache settings that includes updated list of TCP members
     *
     * @param cacheId
     * @param props
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in
     *                               Visual Basic).
     */
    //[TargetMethod(ManagementUtil.MethodName.ApplyCacheConfiguration, 1)]
    @TargetMethodAttribute(privateMethod = MethodName.ApplyCacheConfiguration, privateOverload = 1)
    public final boolean ApplyCacheConfiguration(String cacheId, CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws ManagementException,
            java.lang.IllegalArgumentException,
            IllegalAccessException,
            SecurityException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }

//        if (!(NodeSecurityProvider.getNodeSecurity().Authorize(Decrypt(userId), Decrypt(password), null))) {
//            if (!VerifySystemAdministrator(Decrypt(userId), Decrypt(password))) {
//                throw new SecurityException("You do not have permissions to perform this operation");
//            }
//        }
        cacheId = cacheId.toLowerCase();
        if (s_caches.containsKey(cacheId)) {
            _rwLock.AcquireWriterLock();
            try {
                CacheInfo cacheInfo = (CacheInfo) s_caches.get(cacheId.toLowerCase());
                if (cacheInfo != null) {
                    ///#if !EXPRESS
                    //                        ClientConfigManager.UpdateCacheConfig(cacheId.ToLower(), new HashMap());
                    ///#endif
                    cacheInfo.setCacheProps(props);
                    SaveConfiguration();
                }
            } finally {
                _rwLock.ReleaseWriterLock();
            }
            return true;
        }

        return false;
    }

    //[TargetMethod(ManagementUtil.MethodName.ApplyCacheConfiguration, 1)]
    @TargetMethodAttribute(privateMethod = MethodName.ApplyCacheConfiguration, privateOverload = 2)
    @Override
    public final boolean ApplyCacheConfiguration(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws ManagementException,
            java.lang.IllegalArgumentException,
            IllegalAccessException,
            SecurityException, Exception {
        Alachisoft.NCache.Config.Dom.CacheServerConfig oldDom = Alachisoft.NCache.Config.NewDom.DomHelper.convertToOldDom(props);
        return ApplyCacheConfiguration(cacheId, oldDom, userId, password, hotApply);


    }

    private boolean RemoveDeployedAssemblies(String cacheId) {
        String path = AppUtil.getInstallDir();
        if (path != null) {
            String deployedAssembliesFolder = new File(AppUtil.DeployedAssemblyDir, cacheId.toLowerCase()).getPath();
            try {
                (new java.io.File(deployedAssembliesFolder)).delete();
            } catch (Exception e) {
                return false;
            }
        }

        return true;
    }

    /**
     * Un-register cache
     *
     * @param cacheId
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in
     *                               Visual Basic).
     */
    @TargetMethodAttribute(privateMethod = MethodName.UnregisterCache, privateOverload = 1)
    public final void UnregisterCache(String cacheId, String partId, byte[] userId, byte[] password, Boolean isGracefulShutdown, Boolean removeServerOnly) throws ManagementException, ParserConfigurationException, SAXException,
            IOException, InstantiationException, IllegalAccessException, Exception,
            SecurityException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:

        cacheId = cacheId.toLowerCase();
        _rwLock.AcquireWriterLock();
        try {
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                //ClientConfigManager.RemoveCache(cacheId.toLowerCase());
                RemoveClientCacheConfiguration(cacheId.toLowerCase(), removeServerOnly);
                StopCache(cacheId, userId, password, isGracefulShutdown);

                CacheInfo cacheInfo = (CacheInfo) s_caches.get(cacheId.toLowerCase());
                LeasedCache cache = null;

                if (cacheInfo != null) {
                    cache = cacheInfo.getCache();
                }

                if (cache != null) {
                    cache.dispose();
                }


                s_caches.remove(cacheId);

                RemoveDeployedAssemblies(cacheId); //Asad no need to check return values; if remove then fine else not need to break the process

            } else if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
                RemoveClientCacheConfiguration(cacheId.toLowerCase(), removeServerOnly);
                StopCache(cacheId, userId, password, isGracefulShutdown);

                java.util.HashMap partitionedTable = (java.util.HashMap) ((s_partitionedCaches.get(cacheId.toLowerCase()) instanceof java.util.HashMap) ? s_partitionedCaches.get(cacheId.toLowerCase()) : null);
                if (partitionedTable != null) {
                    Iterator ide = partitionedTable.entrySet().iterator();
                    while (ide.hasNext()) {
                        Map.Entry current = (Map.Entry) ide.next();
                        CacheInfo cacheInfo = (CacheInfo) ((current.getValue() instanceof CacheInfo) ? current.getValue() : null);
                        LeasedCache cache = null;

                        if (cacheInfo != null) {
                            cache = cacheInfo.getCache();
                        }

                        if (cache != null) {
                            cache.dispose();
                        }
                    }
                    s_partitionedCaches.remove(cacheId);
                }
            }

            SaveConfiguration();
        } finally {
            _rwLock.ReleaseWriterLock();
        }
    }

    private void RemoveClientCacheConfiguration(String cacheId, Boolean removeServerOnly) throws ManagementException, ParserConfigurationException, SAXException,
            IOException, InstantiationException, IllegalAccessException, Exception,
            SecurityException {
        if (!removeServerOnly) {
            ClientConfigManager.RemoveCache(cacheId.toLowerCase());
        } else {
            Boolean serverListChanged = false;
            Boolean serverExistsAsClient = false;
            String serverIP = GetBindIP();
            Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration clientConfiguration = ClientConfigManager.GetClientConfiguration(cacheId);
            Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration[] cacheConfigurations = clientConfiguration.getCacheConfigurations();
            for (Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration cc : cacheConfigurations) {
                if (cc.getCacheId() == cacheId) {
                    java.util.List<Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> servers = new java.util.ArrayList<Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer>();
                    if (servers.size() == 1 && servers.get(0).getServerName() == serverIP) {
                        ClientConfigManager.RemoveCache(cacheId.toLowerCase());
                        break;
                    } else {
                        CacheServerConfig serverConfig = GetCacheConfiguration(cacheId);
                        if (serverConfig != null && serverConfig.getClientNodes() != null && serverConfig.getClientNodes().getNodesList().size() > 0) {
                            for (Alachisoft.NCache.Config.NewDom.ClientNode clientNode : serverConfig.getClientNodes().getNodesList()) {
                                if (clientNode.getName() == serverIP) {
                                    serverExistsAsClient = true;
                                    break;
                                }
                            }
                            if (serverExistsAsClient == true) {
                                if (cc.RemoveServer(serverIP)) {
                                    serverListChanged = true;
                                    //HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> serversList = new HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer>();
                                    CacheServerList serversList = new CacheServerList();
                                    serversList.setServersList(UpdateServerPriorityList(cc.getServersPriorityList().getServersList()));
                                    cc.setServersPriorityList(serversList);
                                    clientConfiguration.getCacheConfigurationsMap().put(cacheId, cc);
                                    ClientConfigManager.UpdateCacheConfiguration(cacheId, clientConfiguration);
                                    break;
                                }
                            } else {
                                ClientConfigManager.RemoveCache(cacheId.toLowerCase());
                            }
                        }
                    }
                }
            }
            if (!serverListChanged) {
                ClientConfigManager.RemoveCache(cacheId.toLowerCase());
            }
        }
    }

    private java.util.HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> UpdateServerPriorityList(java.util.HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> dictionary) {
        java.util.HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> newDictionary = new HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer>();
        Integer i = 0;
        for (Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer vals : dictionary.values()) {
            newDictionary.put(i++, vals);
        }

        return newDictionary;
    }

    @TargetMethodAttribute(privateMethod = MethodName.ReloadSrvcConfig, privateOverload = 1)
    public final void ReloadSrvcConfig() {
        ServiceConfiguration.Load();
        ServicePropValues.initialize();
    }

    @TargetMethodAttribute(privateMethod = MethodName.StartCache, privateOverload = 1)
    @Override
    public final void StartCache(String cacheId) throws Exception {
        StartCache(cacheId, null, null, null);
    }

    @TargetMethodAttribute(privateMethod = MethodName.StartCache, privateOverload = 2)
    public final void StartCache(String cacheId, String partitionId) throws Exception {
        StartCache(cacheId, partitionId, null, null);
    }

    @TargetMethodAttribute(privateMethod = MethodName.StartCache, privateOverload = 3)
    public final void StartCache(String cacheId, byte[] userId, byte[] password) throws Exception {
        StartCache(cacheId, null, null, null, null, null, null, null, userId, password, false);
    }

    @TargetMethodAttribute(privateMethod = MethodName.StartCache, privateOverload = 4)
    public final void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws SecurityException, Exception {
        StartCache(cacheId, partitionId, null, null, null, null, null, null, userId, password, twoPhaseInitialization);
    }

    @TargetMethodAttribute(privateMethod = MethodName.StartCachePhase2, privateOverload = 1)
    public final void StartCachePhase2(String cacheId) {
        _rwLock.AcquireWriterLock();
        try {
            Cache tempVar = GetCacheInstance(cacheId, null);
            LeasedCache cache = (LeasedCache) ((tempVar instanceof LeasedCache) ? tempVar : null);
            if (cache != null) {
                cache.StartInstancePhase2();
            }
        } finally {
            _rwLock.ReleaseWriterLock();
        }
    }

    //private void RaiseEvent(string cacheId, int eventId, string source, string message)
    //{
    //    try
    //    {
    //        if (s_caches.containsKey(cacheId.ToLower()))
    //        {
    //            CacheInfo cacheInfo = (CacheInfo)s_caches[cacheId.ToLower()];
    //            cacheInfo.Cache.EmailAlertProgagator.RaiseAlert(eventId, source, message);
    //        }
    //    }
    //    catch (Exception) { }
    //}
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: private void StopCacheInstance(ArrayList caches, ArrayList cacheInfos, byte[] userId, byte[] password)

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public void StartCache(string cacheId, string partitionId, byte[] userId, byte[] password)
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.StartCache, 5)]
    @TargetMethodAttribute(privateMethod = "StartCache", privateOverload = 5)
    public final void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password) throws Exception {
        StartCache(cacheId, partitionId, null, null, null, null, null, null, userId, password, false);
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.StartCache, 6)]
    @TargetMethodAttribute(privateMethod = "StartCache", privateOverload = 6)
    public final void StartCache(String cacheId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate) throws
            Exception, SecurityException {
        StartCache(cacheId, null, itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate, null, null, false);
    }

    /**
     * Start a cache and provide call backs
     *
     * @param cahcheID
     * @param propertyString
     * @param itemAdded
     * @param itemRemoved
     * @param itemUpdated
     * @param cacheCleared
     * @return
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in
     *                               Visual Basic).
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public void StartCache(string cacheId, string partitionId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedCallback itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate, byte[] userId, byte[] password, bool twoPhaseInitialization)
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.StartCache, 7)]
    @TargetMethodAttribute(privateMethod = "StartCache", privateOverload = 7)
    public final void StartCache(String cacheId, String partitionId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws
            Exception, SecurityException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null.\nParameter name: cacheId");
        }

        //muds:
        //first of all check if this is an authorized user.



        CacheInfo cacheInfo = null;
        java.util.ArrayList caches = null;
        LeasedCache cache = null;
        java.util.ArrayList cacheInfos = null;

        _rwLock.AcquireWriterLock();
        try { ///For a finally {...}
            try {
                LoadConfiguration();
            } catch (Exception e) {
                String msg = String.format("CacheServer failed to load configuration, Error %1$s", e.getMessage());
                //Muneeb: CM-1000	:	Not Supported	-	EVENTLOG
                EventLogger.LogEvent(msg, EventType.WARNING);
            }

            if (s_caches.containsKey(cacheId.toLowerCase())) {
                cacheInfo = (CacheInfo) s_caches.get(cacheId.toLowerCase());

                if (cacheInfo != null) {
                    cache = cacheInfo.getCache();
                }

                if (cache != null) {
                    if (caches == null) {
                        caches = new java.util.ArrayList();
                    }

                    if (cacheInfos == null) {
                        cacheInfos = new java.util.ArrayList();
                    }

                    caches.add(cache);
                    cacheInfos.add(cacheInfo);
                }
            } else if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
                java.util.HashMap partitionTable = (java.util.HashMap) ((s_partitionedCaches.get(cacheId.toLowerCase()) instanceof java.util.HashMap) ? s_partitionedCaches.get(cacheId.toLowerCase()) : null);
                if (partitionTable != null) {
                    Iterator ide = partitionTable.entrySet().iterator();
                    while (ide.hasNext()) {
                        Map.Entry current = (Map.Entry) ide.next();
                        cacheInfo = (CacheInfo) current.getValue();

                        if (cacheInfo != null) {
                            cache = cacheInfo.getCache();
                        }

                        if (cache != null) {
                            if (caches == null) {
                                caches = new java.util.ArrayList();
                            }

                            if (cacheInfos == null) {
                                cacheInfos = new java.util.ArrayList();
                            }

                            caches.add(cache);
                            cacheInfos.add(cacheInfo);
                        }
                    }
                }
            }

            try {
                StartCacheInstance(caches, cacheInfos, itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate, userId, password, twoPhaseInitialization);
                //CM-1000	:	Not Supported	-	Eventlog
                EventLogger.LogEvent("NCache", "\"" + cacheId + "\"" + " started successfully.", EventType.INFORMATION, EventCategories.Information, EventID.CacheStart);
            } catch (Exception e) {
                //CM-1000	:	Not Supported	-	Eventlog
                EventLogger.LogEvent("NCache", "\"" + cacheId + "\" can not be started.\n" + e.toString(), EventType.ERROR, EventCategories.Error, EventID.CacheStartError);
                throw e;
            }
        } finally {
            _rwLock.ReleaseWriterLock();
        }
    }

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: private void StartCacheInstance(ArrayList caches, ArrayList cacheInfos, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedCallback itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate, byte[] userId, byte[] password, bool twoPhaseInitialization)
    private void StartCacheInstance(java.util.ArrayList caches, java.util.ArrayList cacheInfos, final ItemAddedCallback itemAdded, final ItemRemovedCallback itemRemoved, final ItemUpdatedListener itemUpdated, final CacheClearedCallback cacheCleared, final CustomRemoveCallback customRemove, final CustomUpdateCallback customUpdate, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws
            ManagementException, Exception {
        if (caches != null && caches.size() > 0) {
            for (int i = 0; i < caches.size(); i++) {
                LeasedCache cache = (LeasedCache) ((caches.get(i) instanceof LeasedCache) ? caches.get(i) : null);
                CacheInfo cacheInfo = (CacheInfo) ((cacheInfos.get(i) instanceof CacheInfo) ? cacheInfos.get(i) : null);
                if (itemAdded != null) {
                    cache.addItemAddedListner(new NEventStart() {
                        @Override
                        public Object hanleEvent(Object... obj) throws SocketException, Exception {
                            itemAdded.invoke(obj[0], (EventContext) obj[1]);
                            return null;
                        }
                    }, null);
//                    cache.addItemAddedListner(new NEventStart()
//                    {
//                        @Override
//                        public void hanleEvent(Object... obj) throws SocketException, Exception
//                        {
//                            itemAdded.invoke(obj[0]);
//                        }
//                    }, null);
                }
                if (itemRemoved != null) {
                    cache.addItemRemovedListner(new NEventStart() {
                        @Override
                        public Object hanleEvent(Object... obj) throws SocketException, Exception {
                            itemRemoved.invoke(obj[0], obj[1], (ItemRemoveReason) obj[2], (BitSet) obj[3], (EventContext) obj[4]);
                            return null;
                        }
                    }, null);//ItemRemoved += itemRemoved;
//                    cache.addItemRemovedListner(new NEventStart()
//                    {
//                        @Override
//                        public void hanleEvent(Object... obj) throws SocketException, Exception
//                        {
//                            itemRemoved.invoke(obj[0], obj[1], (CacheItemRemovedReason) obj[2], (BitSet) obj[3]);
//                        }
//                    }, null);//ItemRemoved += itemRemoved;
                }
                if (itemUpdated != null) {
                    cache.addItemAddedListner(new NEventStart() {
                        @Override
                        public Object hanleEvent(Object... obj) throws SocketException, Exception {
                            itemUpdated.invoke(obj[0], (EventContext) obj[1]);
                            return null;
                        }
                    }, null);
//                    cache.addItemAddedListner(new NEventStart()
//                    {
//                        @Override
//                        public void hanleEvent(Object... obj) throws SocketException, Exception
//                        {
//                            itemUpdated.invoke(obj[0]);
//                        }
//                    }, null);
                }
                if (cacheCleared != null) {
                    cache.addCacheClearedListner(new NEventStart() {
                        @Override
                        public Object hanleEvent(Object... obj) throws SocketException, Exception {
                            cacheCleared.invoke((EventContext) obj[0]);
                            return null;
                        }
                    }, null);


//                    cache.addCacheClearedListner(new NEventStart()
//                    {
//                        @Override
//                        public void hanleEvent(Object... obj) throws SocketException, Exception
//                        {
//                            cacheCleared.invoke();
//                        }
//                    }, null);
                }
                if (customRemove != null) {
                    cache.addCustomRemoveNotifListner(new NEventStart() {
                        @Override
                        public Object hanleEvent(Object... obj) throws SocketException, Exception {
                            customRemove.invoke(obj[0], obj[1], (ItemRemoveReason) obj[2], (BitSet) obj[3], (EventContext) obj[4]);
                            return null;
                        }
                    }, null);
                }
                if (customUpdate != null) {
                    cache.addCustomUpdateNotifListner(new NEventStart() {
                        @Override
                        public Object hanleEvent(Object... obj) throws SocketException, Exception {
                            customUpdate.invoke(_evalWarningTask, _evalWarningTask, (EventContext) obj[2]);
                            return null;
                        }
                    }, null);
                }

                if (!cache.getIsRunning()) {
                    cacheInfo.SyncConfiguration();
                    cache.StartInstance(_renderer, Decrypt(userId), Decrypt(password), twoPhaseInitialization);
                    if (com.alachisoft.ncache.licensing.LicenseManager.isEntCacheServer()) {
                        if (Alachisoft.NCache.Caching.Cache.OnCacheStarted != null) {
                            Alachisoft.NCache.Caching.Cache.OnCacheStarted.invoke(cache.getName());
                        }
                    }
                }
            }
        } else {
            throw new ManagementException("Specified cacheId is not registered");
        }
    }

    @TargetMethodAttribute(privateMethod = MethodName.StopCache, privateOverload = 1)
    public final void StopCache(String cacheId, byte[] userId, byte[] password, Boolean isGracefulShutdown) throws Exception, SecurityException {
        StopCache(cacheId, null, userId, password, isGracefulShutdown);
    }

    /**
     * Stop a cache
     *
     * @param cacheId
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in
     *                               Visual Basic).
     */
    @TargetMethodAttribute(privateMethod = MethodName.StopCache, privateOverload = 2)
    public final void StopCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean isGraceFulShutDown) throws Exception, SecurityException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }

        //muds:
        //first of all check if this user is allowed to stop the cache.


        java.util.ArrayList cacheInfos = null;
        java.util.ArrayList caches = null;
        CacheInfo cacheInfo = null;
        LeasedCache cache = null;

        _rwLock.AcquireWriterLock();
        try { ///For a finally {...}

            cacheInfo = GetCacheInfo(cacheId.toLowerCase());
            if (cacheInfo != null) {
                cache = cacheInfo.getCache();
            }
            if (cache != null) {
                if (caches == null) {
                    caches = new java.util.ArrayList();
                }

                if (cacheInfos == null) {
                    cacheInfos = new java.util.ArrayList();
                }

                caches.add(cache);
                cacheInfos.add(cacheInfo);
            }

            try {
                StopCacheInstance(caches, cacheInfos, CacheStopReason.Stoped, userId, password, isGraceFulShutDown);
                //RaiseEvent(cacheId, EventID.CacheStop, "NCache", "\"" + cacheId + "\"" + " stopped successfully.");
                //CM-1000	:	Not Supported	-	LogEvent
                EventLogger.LogEvent("NCache", "\"" + cacheId + "\"" + " stopped successfully.", EventType.INFORMATION, EventCategories.Information, EventID.CacheStop);

            } catch (Exception e) {
                //CM-1000	:	Not Supported	-	LogEvent
                EventLogger.LogEvent("NCache", "\"" + cacheId + "\" can not be stopped.\n" + e.toString(), EventType.ERROR, EventCategories.Error, EventID.CacheStopError);
                throw e;
            }
        } finally {
            _rwLock.ReleaseWriterLock();
        }
    }

    //[TargetMethod(ManagementUtil.MethodName.GetShutdownTimeout, 1)]
    @TargetMethodAttribute(privateMethod = MethodName.GetShutdownTimeout, privateOverload = 1)
    public int GetShutdownTimeout() {
        int shutdownTimeout = 180;
        int blockTimeout = 3;

        tangible.RefObject<Integer> tempRef_shutdownTimeout = new tangible.RefObject<Integer>(shutdownTimeout);
        tangible.RefObject<Integer> tempRef_blockTimeout = new tangible.RefObject<Integer>(blockTimeout);
        String expMsg = GracefulTimeout.GetGracefulShutDownTimeout(tempRef_shutdownTimeout, tempRef_blockTimeout);
        shutdownTimeout = tempRef_shutdownTimeout.argvalue;
        blockTimeout = tempRef_blockTimeout.argvalue;
        if (expMsg != null) {
            EventLogger.LogEvent("NCache", expMsg, EventType.WARNING, EventCategories.Warning, EventID.GeneralInformation);
        }


        return shutdownTimeout;
    }

    private void StopAllCaches(CacheStopReason reason) throws Exception {
        ArrayList caches = new ArrayList();
        ArrayList cacheInfos = new ArrayList();

        for (Iterator it = s_caches.values().iterator(); it.hasNext(); ) {
            CacheInfo cacheInfo = (CacheInfo) it.next();
            if (cacheInfo != null) {
                caches.add(cacheInfo.getCache());
                cacheInfos.add(cacheInfo);
            }
        }
        StopCacheInstance(caches, cacheInfos, reason, null, null, false);
    }

    private void StopCacheInstance(java.util.ArrayList caches, java.util.ArrayList cacheInfos, CacheStopReason reason, byte[] userId, byte[] password, Boolean isGracefulShutdown) throws Exception //#else
    {
        if (caches != null && caches.size() > 0) {
            for (int i = 0; i < caches.size(); i++) {
                LeasedCache cache = (LeasedCache) ((caches.get(i) instanceof LeasedCache) ? caches.get(i) : null);
                CacheInfo cacheInfo = (CacheInfo) ((cacheInfos.get(i) instanceof CacheInfo) ? cacheInfos.get(i) : null);

                if (cache.getIsRunning()) {
                    if (!cache.VerifyNodeShutdownInProgress(isGracefulShutdown)) {
                        throw new ManagementException("Graceful shutdown is already in progress...");
                    }

                    if (reason == CacheStopReason.Expired)
                        EventLogger.LogEvent("NCache license has expired on this machine. Stopping cache...", EventType.ERROR);
                    cache.StopInstance(isGracefulShutdown);

                    //cache.StopInstance();
                    cacheInfo.SyncConfiguration();

                    //instrumentation Code
                    if (com.alachisoft.ncache.licensing.LicenseManager.isEntCacheServer()) {
                        if (Alachisoft.NCache.Caching.Cache.OnCacheStopped != null) {
                            Alachisoft.NCache.Caching.Cache.OnCacheStopped.invoke(cache.getName());
                        }
                    }
//#endif
                }
            }
        } else {
            throw new ManagementException("Specified cacheId is not registered");
        }

    }

    /**
     * Detect and return all the available NICs on this machine
     *
     * @return
     */
    @TargetMethodAttribute(privateMethod = MethodName.DetectNICs, privateOverload = 1)
    @Override
    public final java.util.HashMap DetectNICs() {
        java.util.HashMap connectedNICs = new java.util.HashMap();

        try {
            // Detecting Network Interface Cards with enabled IPs through WMI:
            //
//            ManagementObjectSearcher searcher = new ManagementObjectSearcher("Select * from Win32_NetworkAdapterConfiguration WHERE IPEnabled=True");

            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface net = enumeration.nextElement();
                List<InterfaceAddress> list = net.getInterfaceAddresses();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    InterfaceAddress interf = (InterfaceAddress) it.next();
                    if (interf.getAddress() instanceof Inet6Address) {
                        continue;
                    }
                    connectedNICs.put(interf.getAddress().getHostAddress(), net.getDisplayName());
                }
            }

//            for (ManagementObject mo : searcher.Get())
//            {
//                Object tempVar = mo.GetPropertyValue("IPAddress");
//                String[] ipAddresses = (String[]) ((tempVar instanceof String[]) ? tempVar : null);
//
//                for (String ipAddress : ipAddresses)
//                {
//                    if (!connectedNICs.containsKey(ipAddress))
//                    {
//                        connectedNICs.put(ipAddress, mo.GetPropertyValue("Description"));
//                    }
//                }
//            }


            return connectedNICs;
        } catch (Exception e) {
        }

        return connectedNICs;
    }

    @TargetMethodAttribute(privateMethod = MethodName.BindToIP, privateOverload = 1)
    public final void BindToIP(BindedIpMap bindedIpMap) throws java.lang.Exception {
        HashMap bindTable = bindedIpMap.getMap();
        if (bindTable.size() == 0) {

            return;
        }
        String path = getServiceFilePath();
        if ((new java.io.File(path)).isFile()) {


//            String xPath = "/configuration/appSettings/add";
//            //Muneeb: NR-1016	:	XMLDocument changed.
//            //File fXmlFile = new File(xPath);
//            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
//            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
//            Document document = dBuilder.parse(path);
//            document.getDocumentElement().normalize();
            String[] elementKeys = {
                    "CacheServer.BindToClusterIP",
                    "CacheServer.BindToClientServerIP"
            };
            String[] elementValues = {
                    bindTable.containsKey(Channel.Cluster) ? (String) bindTable.get(Channel.Cluster) : "",
                    bindTable.containsKey(Channel.SocketServer) ? (String) bindTable.get(Channel.SocketServer) : ""
            };
            Properties loadProp = new Properties();
            loadProp.load(new FileInputStream(path));

            Properties alterProps = loadProp;

            String key = "";
            for (int i = 0; i < elementKeys.length; i++) {
                Enumeration enumProps = loadProp.propertyNames();
                while (enumProps.hasMoreElements()) {
                    key = (String) enumProps.nextElement();
                    if (key.equals(elementKeys[i].toString())) {
                        alterProps.setProperty(key, elementValues[i]);
                    }
                }


            }
            File file = new File(path);
            FileOutputStream fileOut = new FileOutputStream(file);
            alterProps.store(fileOut, "NCache Service Properties");
            fileOut.close();


//            for (int i = 0; i < elementKeys.length; i++)
//            {
//                properties.setProperty(elementKeys[i], elementValues[i]);
//
//                //if (elementValues[i] != string.Empty)
//                //this.ChangeAttribute(document, xPath, elementKeys[i], elementValues[i]);
//            }
//            //Muneeb: nothing written so no need to save document.Save(path);
        }

    }

    /**
     * Changes the value of 'Value' attribute in app.config. If the attribute
     * does not exists, it creates a new one
     *
     * @param document document object
     * @param path     path of 'Key' attribute
     * @param key      key name
     * @param newValue new value of 'Value' attribute
     */
    private void ChangeAttribute(Document document, String path, String key, String newValue) throws ParserConfigurationException, SAXException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
        //Basit: Under Management
//        String format = "{0}[@key='{1}']";
//        String xPath = String.format(format, path, key);
//        //Muneeb: NR-1016	:	XMLDocument changed.
//        File fXmlFile = new File(xPath);
//        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
//        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
//        document = dBuilder.parse(fXmlFile);
//        document.getDocumentElement().normalize();
//
//        Node node = (Node) document.getElementsByTagName(xPath);
//        if (node == null)
//        {
//            //create a new node
//            node = document.CreateNode(Node.ELEMENT_NODE, "add", "");
//            //set its attributes
//            ((Element) node).setAttribute("key", key);
//            if (newValue.equals("") && getClusterIP() != null)
//            {
//                ((Element) node).setAttribute("value", getClusterIP());
//            }
//            else
//            {
//                ((Element) node).setAttribute("value", newValue);
//            }
//            //append it at the end of appSettings element
//            NodeList list = document.getElementsByTagName("appSettings");
//            list.item(0).appendChild(node);
//        }
//        else
//        {
        //SP2
//            if (newValue == string.Empty && ClusterIP != null && key == "NCacheServer.BindToClusterIP")
//                {
//                    node.Attributes["value"].Value = ClusterIP;
//                }
//                else if (newValue == string.Empty && _clientserverip != null && key == "NCacheServer.BindToClientServerIP")
//                {
//                    node.Attributes["value"].Value = _clientserverip;
//                }
//            else
//            {
//                node.Attributes["value"].Value = newValue;
//            }
//        }
    }

    /**
     * @return @throws Exception
     */
    @Override
    @TargetMethodAttribute(privateMethod = MethodName.BindedIp, privateOverload = 1)
    public final BindedIpMap BindedIp() throws Exception {
        HashMap bindedIps = new java.util.HashMap(2);
        bindedIps.put(Channel.Cluster, ServicePropValues.BIND_ToCLUSTER_IP);
        bindedIps.put(Channel.SocketServer, ServicePropValues.BIND_toClient_IP);
        return new BindedIpMap(bindedIps);
    }

    /**
     * Return service config file path
     */
    private String getServiceFilePath() throws Exception {

        //String path = new File(".").getAbsolutePath() + ".config";
        //Muneeb:  changed getAbsolutePath to getCanonicalPath as getAbsolutePath
        //         doesnt remove the unneccssary "." or ".."
//        String path = new File(".").getCanonicalPath() + "/server.properties";
        String path = ServicePropValues.INSTALLDIR_DIR + "/config/server.properties";
        if ((new java.io.File(path)).isFile()) {
            return path;
        }

        //else, get the path of config file from Windows Registry:
        path = AppUtil.getInstallDir();
        if (path == null || path.equals("")) {
            throw new Exception("Missing installation folder information");
        }
        return (path + "/bin/service/server.properties");
    }

    /**
     * Gets the Max port number, among all the ports of registered caches on
     * this machine
     *
     * @return Max cluster port
     */
    @TargetMethodAttribute(privateMethod = MethodName.GetMaxPort, privateOverload = 1)
    public final int GetMaxPort() throws UnknownHostException {
        java.util.Map regCaches = getCacheProps();
        Iterator ie = regCaches.entrySet().iterator();

        CacheConfig cfg = null;
        int maxPort = 0, loop = 1;

        while (ie.hasNext()) {
            Map.Entry current = (Map.Entry) ie.next();
            if (current.getValue() instanceof CacheServerConfig) {
                cfg = CacheConfig.FromConfiguration((CacheServerConfig) ((current.getValue() instanceof CacheServerConfig) ? current.getValue() : null));
            } else if (current.getValue() instanceof java.util.HashMap) {
                Iterator ide = ((java.util.HashMap) current.getValue()).entrySet().iterator();
                while (ide.hasNext()) {
                    Map.Entry subcurrent = (Map.Entry) ide.next();
                    cfg = CacheConfig.FromConfiguration((CacheServerConfig) ((current.getValue() instanceof CacheServerConfig) ? current.getValue() : null));
                    break;
                }
            }

            if (cfg.getClusterPort() != 0) {
                if (loop == 1) {
                    maxPort = cfg.getClusterPort() + cfg.getClusterPortRange() - 1;
                    loop++;
                } else if (maxPort < (cfg.getClusterPort() + cfg.getClusterPortRange())) {
                    maxPort = cfg.getClusterPort() + cfg.getClusterPortRange() - 1;
                }
            }
        }

        return maxPort;
    }

    /**
     * Checks if the current cache is a Cluster cache or not, used in NCache
     * UnReg cache tool as now UnReg is only applicable to cluster caches only
     *
     * @param cacheId
     * @return true if Cluster Cache
     */
    @TargetMethodAttribute(privateMethod = MethodName.IsClusteredCache, privateOverload = 1)
    @Override
    public final CacheStatusOnServerContainer IsClusteredCache(String cacheId) {
        CacheStatusOnServer result = CacheStatusOnServer.Unregistered;
        CacheStatusOnServerContainer status = new CacheStatusOnServerContainer();

        if (cacheId != null && !cacheId.equals("")) {
            cacheId = cacheId.toLowerCase();
            if (s_caches.containsKey(cacheId)) {
                CacheInfo cacheInfo = (CacheInfo) ((s_caches.get(cacheId) instanceof CacheInfo) ? s_caches.get(cacheId) : null);

                if (cacheInfo.getCache().getStatistics().getClassName().equals("replicated-server")
                        || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-server")
                        || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-replicas-server")) {
                    result = CacheStatusOnServer.ClusteredCache;
                } else if (cacheInfo.getCache().getStatistics().getClassName().equals("mirror-server")) {
                    result = CacheStatusOnServer.MirrorCache;
                } else {
                    result = CacheStatusOnServer.LocalCache;
                }
            }
            status.cacheStatus = result;
            return status;
        }
        throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
    }

    /**
     * Checks whether the specified port is available (non-conflicting) or not
     *
     * @param port Cluster port
     * @return 'true' if the port is available, otherwise 'flase'
     * @throws UnknownHostException
     */
    @TargetMethodAttribute(privateMethod = MethodName.PortIsAvailable, privateOverload = 1)
    @Override
    public final boolean PortIsAvailable(int port) throws UnknownHostException {
        java.util.Map regCaches = getCacheProps();
        Iterator ie = regCaches.entrySet().iterator();

        CacheConfig cfg;
        boolean isAvailable = true;

        while (ie.hasNext()) {
            Map.Entry current = (Map.Entry) ie.next();
            if (current.getValue() instanceof CacheServerConfig) {
                cfg = CacheConfig.FromConfiguration((CacheServerConfig) ((current.getValue() instanceof CacheServerConfig) ? current.getValue() : null));
                if (cfg.getClusterPort() != 0) {
                    for (int i = 0; i < cfg.getClusterPortRange(); i++) {
                        if (port == cfg.getClusterPort() + i) {
                            isAvailable = false;
                        }
                    }
                }
            } else if (current.getValue() instanceof java.util.HashMap) {
                java.util.HashMap partitionedTable = (java.util.HashMap) ((current.getValue() instanceof java.util.HashMap) ? current.getValue() : null);
                Iterator ide = partitionedTable.entrySet().iterator();
                while (ide.hasNext()) {
                    cfg = CacheConfig.FromConfiguration((CacheServerConfig) ((current.getValue() instanceof CacheServerConfig) ? current.getValue() : null));
                    if (cfg.getClusterPort() != 0) {
                        for (int i = 0; i < cfg.getClusterPortRange(); i++) {
                            if (port == cfg.getClusterPort() + i) {
                                isAvailable = false;
                            }
                        }
                    }
                    break;
                }
            }

        }

        return isAvailable;
    }

    /**
     * Checks whether the newly added node arise port conflict or not
     *
     * @param port Cluster port
     * @param id
     * @return 'true' if the node is allowed, otherwise 'flase'
     */
    @TargetMethodAttribute(privateMethod = MethodName.NodeIsAllowed, privateOverload = 1)
    @Override
    public final boolean NodeIsAllowed(int port, String id) throws UnknownHostException {
        java.util.Map regCaches = getCacheProps();
        Iterator ie = regCaches.entrySet().iterator();

        CacheConfig cfg = null;
        boolean isAllowed = true;

        while (ie.hasNext()) {
            Map.Entry current = (Map.Entry) ie.next();
            if (current.getValue() instanceof CacheServerConfig) {
                cfg = CacheConfig.FromConfiguration((CacheServerConfig) ((current.getValue() instanceof CacheServerConfig) ? current.getValue() : null));
            } else if (current.getValue() instanceof java.util.HashMap) {
                for (Iterator it = ((java.util.HashMap) current.getValue()).entrySet().iterator(); it.hasNext(); ) {
                    Map.Entry de = (Map.Entry) it.next();
                    cfg = CacheConfig.FromConfiguration((CacheServerConfig) ((current.getValue() instanceof CacheServerConfig) ? current.getValue() : null));
                    break;
                }
            }
            if (cfg != null) {
                if (cfg.getClusterPort() == port && !cfg.getCacheId().equals(id)) {
                    isAllowed = false;
                }
            }
        }

        return isAllowed;
    }
//#endif

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: internal string Decrypt(byte[] cypherText)
    public final String Decrypt(byte[] cypherText) {

        //Latif	:	 Temp Custom Encryption Supported	-
        return EncryptionUtil.Decrypt(cypherText);

    }

    /**
     * Gets the status of NCache on this node.
     *
     * @param partitionId
     * @return The ServerStatus.
     */
    @TargetMethodAttribute(privateMethod = MethodName.GetCacheStatus, privateOverload = 1)
    @Override
    public final StatusInfo GetCacheStatus(String cacheId, String partitionId) {
        StatusInfo status = new StatusInfo();
        CacheInfo cacheInfo = this.GetCacheInfo(cacheId);

        if (cacheInfo != null && cacheInfo.getCacheProps() != null) {
            status.setConfigID(cacheInfo.getCacheProps().getConfigID());
        }

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS || (EXPRESS && PROFESSIONAL)
        LicenseManager.LicenseType lic;
        try {
            lic = LicenseManager.LicenseMode(null);
        } catch (Exception ex) {
            lic = LicenseManager.LicenseType.Expired;
        }

        if (lic == LicenseType.Expired) {
            status.Status = CacheStatus.Expired;
        } else //#endif
        {
            if (cacheInfo != null) {
                LeasedCache cache = cacheInfo.getCache();
                if (cache != null) {
                    status.Status = cache.getIsRunning() ? CacheStatus.Running : CacheStatus.Registered;
                    if (com.alachisoft.ncache.licensing.LicenseManager.isEntCacheServer() || com.alachisoft.ncache.licensing.LicenseManager.isProCacheServer()) {
                        status.setIsCoordinator(cache.getIsCoordinator());
                    }

//#endif
                }
            }
        }

        return status;
    }

    private String GetConfigID(String cacheId) {
        try {
            CacheServerConfig config = GetCacheConfiguration(cacheId);
            if (config != null) {
                return config.getConfigID();
            }
            return "";
        } catch (java.lang.Exception e) {
            return "";
        }
    }

    /**
     * Starts monitoring the client activity.
     *
     * @throws java.lang.Exception
     */
    @TargetMethodAttribute(privateMethod = MethodName.StartMonitoringActivity, privateOverload = 1)
    @Override
    public final void StartMonitoringActivity() throws java.lang.Exception {
        try {
            ServerMonitor.StartMonitoring();
            //Muneeb: CM-1000	:	Not Supported	-	EventLog
            EventLogger.LogEvent("Activity monitoring is started", EventType.INFORMATION);

        } catch (Exception e) {
            //Muneeb: CM-1000	:	Not Supported	-	EventLog
            EventLogger.LogEvent("An error occured while starting activity monitoring " + e.toString(), EventType.ERROR);
            throw e;
        }
    }

    /**
     * Stops monitoring client activity.
     *
     * @throws java.lang.Exception
     */
    @TargetMethodAttribute(privateMethod = MethodName.StopMonitoringActivity, privateOverload = 1)
    public final void StopMonitoringActivity() throws java.lang.Exception {
        try {
            ServerMonitor.StopMonitoring();
            //Muneeb: CM-1000	:	Not Supported	-	EventLog
            EventLogger.LogEvent("Activity monitoring is stopped", EventType.INFORMATION);
        } catch (Exception e) {

            EventLogger.LogEvent("An error occured while stopping activity monitoring " + e.toString(), EventType.ERROR);
            throw e;
        }
    }

    /**
     * Publishes the observed client activity into a file.
     */
    @TargetMethodAttribute(privateMethod = MethodName.PublishActivity, privateOverload = 1)
    public final void PublishActivity() throws CloneNotSupportedException, Exception {
//        Logger logger = new Logger();
//        try
//        {
//            logger.Initialize("ActivityLog", "ActivityLogs");
//            logger.WriteSingleLine("Monitoring start_time :" + ServerMonitor.getStartTime().ToString(Logger.TIME_FORMAT) + " end_time :"
//                    + ServerMonitor.getEndTime().ToString(Logger.TIME_FORMAT));
//
//            java.util.HashMap activityTable = ServerMonitor.GetCompletedClientActivity();
//            if (activityTable != null)
//            {
//                logger.WriteClientActivities(activityTable, true);
//            }
//
//            activityTable = ServerMonitor.GetCurrentClientActivity();
//            if (activityTable != null)
//            {
//                logger.WriteClientActivities(activityTable, false);
//            }
//            ServerMonitor.Reset();
//        }
//        catch (Exception e)
//        {
//
//            //AppUtil.LogEvent("An error occured while logging client activity " + e.toString(), EventLogEntryType.Error);
//            throw e;
//        }
//        finally
//        {
//            logger.Close();
//        }
    }

    ///#region IMonitorServer Members
    /// <summary>
    /// Get All configured partition of replica caches
    /// </summary>
    /// <returns></returns>
    @TargetMethodAttribute(privateMethod = MethodName.GetConfiguredPartitionedReplicaCaches, privateOverload = 1)
    @Override
    public ConfiguredCacheInfo[] GetConfiguredPartitionedReplicaCaches() {
        ConfiguredCacheInfo[] configuredCaches = new ConfiguredCacheInfo[s_partitionedCaches.size()];

        _rwLock.AcquireReaderLock();
        try {
            Iterator en = s_partitionedCaches.entrySet().iterator();
            int i = 0;
            while (en.hasNext()) {
                Map.Entry current = (Map.Entry) en.next();
                String cacheId = (String) Common.readAs(current.getKey(), String.class);
                //Muneeb: HashTable changed to HashMap keep an eye for future issues.
                HashMap partitionedCaches = (HashMap) Common.readAs(current.getValue(), HashMap.class);
                if (partitionedCaches != null) {
                    for (Iterator it = partitionedCaches.entrySet().iterator(); it.hasNext(); ) {
                        Map.Entry de = (Map.Entry) it.next();
                        String partId = (String) Common.readAs(de.getKey(), String.class);
                        CacheInfo cacheInfo = (CacheInfo) de.getValue();
                        ConfiguredCacheInfo configuredCache = new ConfiguredCacheInfo();
                        configuredCache.setCacheId(cacheInfo.getCacheProps().getName());
                        configuredCache.setIsRunning(cacheInfo.getCache().getIsRunning());
                        configuredCache.setDataCapacity(cacheInfo.getCacheProps().getStorage().getSize());
                        configuredCache.setCachePropString(GetProps(cacheInfo.getCacheProps()));
                        configuredCache.setPartId(partId);
                        if (cacheInfo.getCacheProps().getCacheType() == "clustered-cache") {
                            if (cacheInfo.getCacheProps().getCluster() != null) {
                                String topology = cacheInfo.getCacheProps().getCluster().getTopology();
                                if (topology.equals("replicated-server")) {
                                    configuredCache.setTopology(CacheTopology.Replicated);
                                } else if (topology.equals("partitioned-server")) {
                                    configuredCache.setTopology(CacheTopology.Partitioned);
                                } else if (topology.equals("partitioned-replicas-server")) {
                                    configuredCache.setTopology(CacheTopology.PartitionedOfReplica);
                                } else if (topology.equals("mirror-server")) {
                                    configuredCache.setTopology(CacheTopology.Mirror);
                                }
                            }
                        } else if (cacheInfo.getCacheProps().getCacheType() == "local-cache") {
                            configuredCache.setTopology(CacheTopology.Local);
                        }
                        configuredCaches[i] = configuredCache;
                        i++;
                    }
                }
            }
            return configuredCaches;
        } finally {
            _rwLock.ReleaseReaderLock();
        }
    }

    //public void ListenForEventViewerEvents(List<string> sources)
    //{
    //    throw new Exception("The method or operation is not implemented.");
    //}
    //public Dictionary<string, EventViewerEvent> GetLatestEvents()
    //{
    //    throw new Exception("The method or operation is not implemented.");
    //}
    //public Dictionary<string, EventViewerEvent> GetLatestEvents(List<string> sources)
    //{
    //    throw new Exception("The method or operation is not implemented.");
    //}

    @TargetMethodAttribute(privateMethod = MethodName.GetCacheStatistics, privateOverload = 1)
    public final CacheNodeStatistics[] GetCacheStatistics(String cacheId) throws CacheException {
        Cache cache = GetCacheInstance(cacheId, null);
        java.util.ArrayList<CacheNodeStatistics> statistics = null;
        if (cache != null) {
            statistics = cache.GetCacheNodeStatistics();
            return statistics.toArray(new CacheNodeStatistics[statistics.size()]);
        }
        return null;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetCacheStatistics2, privateOverload = 1)
    public CacheStatistics GetCacheStatistics2(String cacheId) throws IllegalArgumentException {

        if (cacheId == null) {
            throw new IllegalArgumentException(cacheId);
        }
        try {
            _rwLock.AcquireReaderLock();
            if (s_caches.containsKey((cacheId.toLowerCase()))) {
                CacheInfo cacheInfo = (CacheInfo) Common.readAs(s_caches.get(cacheId.toLowerCase()), CacheInfo.class);
                return cacheInfo == null ? null : cacheInfo.getCache().getStatistics();
            }
        } finally {
            _rwLock.ReleaseReaderLock();
        }
        return null;
    }

    /**
     * Gets the list of all the configured cache servers in a clustered cache
     * irrespective of running or stopped.
     *
     * @param cacheId
     * @return
     */
    @TargetMethodAttribute(privateMethod = MethodName.GetCacheServers, privateOverload = 1)
    public final Node[] GetCacheServers(String cacheId) throws UnknownHostException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }

        java.util.ArrayList<Node> serverNodes = new java.util.ArrayList<Node>();
        try {
            _rwLock.AcquireReaderLock();

            if (s_caches.containsKey(cacheId.toLowerCase())) {
                CacheInfo cacheInfo = (CacheInfo) ((s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo) ? s_caches.get(cacheId.toLowerCase()) : null);
                if (cacheInfo.getCacheProps().getCacheType().equals("clustered-cache")) {
                    java.util.ArrayList<Address> nodeAddresses = cacheInfo.getCacheProps().getCluster().GetAllConfiguredNodes();
                    //List<CacheNodeStatistics> lstStats = GetCacheStatistics(cacheId);
                    ServerNode server = null;
                    for (Address node : nodeAddresses) {
                        server = new ServerNode();
                        server.setAddress(node);
                        ////HACK: Verify
                        //if (lstStats != null)
                        //{
                        //    foreach (CacheNodeStatistics cacheStatistics in lstStats)
                        //    {
                        //        if (cacheStatistics.Node == null)
                        //        {
                        //            continue;
                        //        }
                        //        if (cacheStatistics.Node.Address.ToString() == server.Address.ToString())
                        //        {
                        //            server.Status = cacheStatistics.Status;
                        //            server.ClientCount = cacheStatistics.ClientCount;
                        //        }
                        //    }
                        //}
                        ////-HACK
                        serverNodes.add((Node) server);
                    }
                }
            }
        } finally {
            _rwLock.ReleaseReaderLock();
        }
        return serverNodes.toArray(new Node[serverNodes.size()]);
    }

    /**
     * Gets the list of servers which are up and are part of a clustered cache.
     *
     * @param cacheId
     * @return
     */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetRunningCacheServers, 1)]
    @TargetMethodAttribute(privateMethod = "GetRunningCacheServers", privateOverload = 1)
    public final java.util.ArrayList<ServerNode> GetRunningCacheServers(String cacheId) {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }

        java.util.ArrayList<ServerNode> serverNodes = new java.util.ArrayList<ServerNode>();

        try {
            _rwLock.AcquireReaderLock();

            if (s_caches.containsKey(cacheId.toLowerCase())) {
                CacheInfo cacheInfo = (CacheInfo) ((s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo) ? s_caches.get(cacheId.toLowerCase()) : null);

                if (cacheInfo.getCache().getIsRunning() && cacheInfo.getCacheProps().getCacheType().equals("clustered-cache")) {
                    Alachisoft.NCache.Caching.Statistics.CacheStatistics tempVar = cacheInfo.getCache().getStatistics();
                    ClusterCacheStatistics stats = (ClusterCacheStatistics) ((tempVar instanceof ClusterCacheStatistics) ? tempVar : null);

                    //List<CacheNodeStatistics> lstStats = GetCacheStatistics(cacheId);

                    if (stats != null) {
                        for (Iterator it = stats.getNodes().iterator(); it.hasNext(); ) {
                            NodeInfo node = (NodeInfo) it.next();
                            ServerNode serverNode = new ServerNode();
                            serverNode.setAddress(node.getAddress());
                            serverNode.setIsReplica(node.getIsStartedAsMirror());
                            serverNode.setInProcInstance(node.getIsInproc());
                            if (node.getRendererAddress() != null) {
                                serverNode.setClientPort(node.getRendererAddress().getPort());
                            }
                            if (node.getIsStartedAsMirror() && stats.getNodes().size() > 2) {
                                for (Iterator its = stats.getNodes().iterator(); it.hasNext(); ) {
                                    NodeInfo node2 = (NodeInfo) its.next();
                                    if (node2.getSubgroupName().equals(node.getSubgroupName())
                                            && !node2.getAddress().getIpAddress().toString().equals(node.getAddress().getIpAddress().toString())) {
                                        serverNode.setNodeAt(node2.getAddress().getIpAddress().toString());
                                        break;
                                    }
                                }
                            } else {
                                serverNode.setNodeAt(node.getAddress().getIpAddress().toString());
                            }
                            serverNodes.add(serverNode);
                        }
                    }

                }
            }
        } finally {
            _rwLock.ReleaseReaderLock();
        }
        return serverNodes;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheClients, 1)]
    @TargetMethodAttribute(privateMethod = "GetCacheClients", privateOverload = 1)
    public final java.util.ArrayList<Alachisoft.NCache.Common.Monitoring.ClientNode> GetCacheClients(String cacheId) throws UnknownHostException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }

        java.util.ArrayList<Alachisoft.NCache.Common.Monitoring.ClientNode> clients = _renderer.GetClientList(cacheId);
        return clients;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetClientProcessStats, 1)]
    @TargetMethodAttribute(privateMethod = "GetClientProcessStats", privateOverload = 1)
    public final java.util.ArrayList<Alachisoft.NCache.Common.Monitoring.ClientProcessStats> GetClientProcessStats(String cacheId) throws UnknownHostException {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }

        java.util.ArrayList<Alachisoft.NCache.Common.Monitoring.ClientProcessStats> clients = _renderer.GetClientProcessStats(cacheId);
        return clients;
    }

    @Override
    public void PublishCustomClientCounters(String cacheId, ClientCustomCounters customCounters) {

    }

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#region ICacheServer Members
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetClusterIP, 1)]

    /**
     * Gets the list of all configured caches on this server.
     *
     * @return
     */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetAllConfiguredCaches, 1)]
    @TargetMethodAttribute(privateMethod = "GetAllConfiguredCaches", privateOverload = 1)
    public final ConfiguredCacheInfo[] GetAllConfiguredCaches() {
        ConfiguredCacheInfo[] configuredCaches = new ConfiguredCacheInfo[s_caches.size()];

        try {
            _rwLock.AcquireReaderLock();
            Iterator ide = s_caches.entrySet().iterator();
            int tmp = 0;
            while (ide.hasNext()) {
                Map.Entry current = (Map.Entry) ide.next();
                CacheInfo cacheInfo = (CacheInfo) ((current.getValue() instanceof CacheInfo) ? current.getValue() : null);
                ConfiguredCacheInfo configuredCache = new ConfiguredCacheInfo();
                configuredCache.setCacheId(cacheInfo.getCacheProps().getName());
                configuredCache.setIsRunning(cacheInfo.getCache().getIsRunning());
                configuredCache.setDataCapacity(cacheInfo.getCacheProps().getStorage().getSize());
                configuredCache.setCachePropString(_clusterIp);
                if (cacheInfo.getCacheProps().getCacheType().equals("clustered-cache")) {
                    if (cacheInfo.getCacheProps().getCluster() != null) {
//C# TO JAVA CONVERTER NOTE: The following 'switch' operated on a string member and was converted to Java 'if-else' logic:
//						switch (cacheInfo.CacheProps.Cluster.Topology)
                        String tempVar = cacheInfo.getCacheProps().getCluster().getTopology();
//ORIGINAL LINE: case "replicated-server":
                        if (tempVar.equals("replicated-server")) {
                            configuredCache.setTopology(CacheTopology.Replicated);

                        } //ORIGINAL LINE: case "partitioned-server":
                        else if (tempVar.equals("partitioned-server")) {
                            configuredCache.setTopology(CacheTopology.Partitioned);

                        } //ORIGINAL LINE: case "partitioned-replicas-server":
                        else if (tempVar.equals("partitioned-replicas-server")) {
                            configuredCache.setTopology(CacheTopology.PartitionedOfReplica);

                        } //ORIGINAL LINE: case "mirror-server":
                        else if (tempVar.equals("mirror-server")) {
                            configuredCache.setTopology(CacheTopology.Mirror);

                        }
                    }
                } else if (cacheInfo.getCacheProps().getCacheType().equals("local-cache")) {
                    configuredCache.setTopology(CacheTopology.Local);
                }
                configuredCaches[tmp++] = configuredCache;
            }
        } finally {
            _rwLock.ReleaseReaderLock();
        }
        return configuredCaches;
    }

    /**
     * Gets the basic cache related information for given cache id.
     *
     * @param cacheId Name of the cache.
     * @return
     */
//C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[TargetMethod(ManagementUtil.MethodName.GetCacheConfigurationInfo, 1)]
    @TargetMethodAttribute(privateMethod = "GetCacheConfigurationInfo", privateOverload = 1)
    public final ConfiguredCacheInfo GetCacheConfigurationInfo(String cacheId) {
        if (cacheId == null) {
            throw new java.lang.IllegalArgumentException("Value cannot be null.\nParameter name: cacheId");
        }

        ConfiguredCacheInfo configuredCache = null;
        try {
            _rwLock.AcquireReaderLock();

            if (s_caches.containsKey(cacheId.toLowerCase())) {

                CacheInfo cacheInfo = (CacheInfo) ((s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo) ? s_caches.get(cacheId.toLowerCase()) : null);
                configuredCache = new ConfiguredCacheInfo();
                configuredCache.setCacheId(cacheInfo.getCacheProps().getName());
                configuredCache.setIsRunning(cacheInfo.getCache().getIsRunning());
                configuredCache.setDataCapacity(cacheInfo.getCacheProps().getStorage().getSize());

                if (cacheInfo.getCacheProps().getCacheType().equals("clustered-cache")) {
                    if (cacheInfo.getCacheProps().getCluster() != null) {
//C# TO JAVA CONVERTER NOTE: The following 'switch' operated on a string member and was converted to Java 'if-else' logic:
//						switch (cacheInfo.CacheProps.Cluster.Topology)
                        String tempVar = cacheInfo.getCacheProps().getCluster().getTopology();
//ORIGINAL LINE: case "replicated-server":
                        if (tempVar.equals("replicated-server")) {
                            configuredCache.setTopology(CacheTopology.Replicated);

                        } //ORIGINAL LINE: case "partitioned-server":
                        else if (tempVar.equals("partitioned-server")) {
                            configuredCache.setTopology(CacheTopology.Partitioned);

                        } //ORIGINAL LINE: case "partitioned-replicas-server":
                        else if (tempVar.equals("partitioned-replicas-server")) {
                            configuredCache.setTopology(CacheTopology.PartitionedOfReplica);

                        } //ORIGINAL LINE: case "mirror-server":
                        else if (tempVar.equals("mirror-server")) {
                            configuredCache.setTopology(CacheTopology.Mirror);

                        }
                    }
                } else if (cacheInfo.getCacheProps().getCacheType().equals("local-cache")) {
                    configuredCache.setTopology(CacheTopology.Local);
                }
            }
        } finally {
            _rwLock.ReleaseReaderLock();
        }
        return configuredCache;
    }

    /**
     * @return
     */
    @TargetMethodAttribute(privateMethod = "GetClusterIP", privateOverload = 1)
    @Override
    public final String GetClusterIP() {
        return getClusterIP();
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetLocalCacheIP, privateOverload = 1)
    @Override
    public final String GetLocalCacheIP() {
        return getLocalCacheIP();
    }

    @TargetMethodAttribute(privateMethod = MethodName.CacheProps, privateOverload = 1)
    @Override
    public java.util.Map CacheProps() {
        throw new UnsupportedOperationException();
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetSocketServerPort, privateOverload = 1)
    @Override
    public final int GetSocketServerPort() {
        return _socketServerPort;
    }

    @TargetMethodAttribute(privateMethod = MethodName.MakeCacheActive, privateOverload = 1)
    @Override
    public final void MakeCacheActive(String cacheId, boolean active) {
        Cache cache = GetCacheInstance(cacheId, null);

        if (cache != null && cache.getIsRunning()) {
            cache.MakeCacheActiveNCManager(active);
        }
    }

    @TargetMethodAttribute(privateMethod = MethodName.IsBridgeTargetCache, privateOverload = 1)
    @Override
    public final boolean IsBridgeTargetCache(String cacheId) {
        Cache cache = GetCacheInstance(cacheId, null);

        if (cache != null) {
            return cache.getIsBridgeTargetCache();
        }

        return false;
    }

    @TargetMethodAttribute(privateMethod = MethodName.ClearCacheContent, privateOverload = 1)
    @Override
    public final void ClearCacheContent(String cacheId) throws OperationFailedException {
        Cache cache = GetCacheInstance(cacheId, null);

        if (cache != null) {
            cache.Clear();
        }
    }

    @TargetMethodAttribute(privateMethod = MethodName.IsRunning, privateOverload = 1)
    @Override
    public final boolean IsRunning(String cacheId) {
        Cache cache = GetCacheInstance(cacheId, null);

        if (cache != null) {
            return cache.getIsRunning();
        }

        return false;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetStatistics, privateOverload = 1)
    @Override
    public final CacheStatistics GetStatistics(String cacheId) {
        Cache cache = GetCacheInstance(cacheId, null);

        if (cache != null && cache.getIsRunning()) {
            return cache.getStatistics();
        }

        return null;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetCacheCount, privateOverload = 1)
    @Override
    public final long GetCacheCount(String cacheId) throws GeneralFailureException, OperationFailedException, CacheException {
        Cache cache = GetCacheInstance(cacheId, null);
        if (cache != null) {
            return cache.getCount();
        }
        return 0;
    }

    @TargetMethodAttribute(privateMethod = MethodName.SetLocalCacheIP, privateOverload = 1)
    @Override
    public final void SetLocalCacheIP(String ip) {
        setLocalCacheIP(ip);
    }

    @TargetMethodAttribute(privateMethod = MethodName.BalanceDataloadOnCache, privateOverload = 1)
    @Override
    public void BalanceDataloadOnCache(String cacheId) throws SuspectedException, TimeoutException, GeneralFailureException {
        Cache cache = GetCacheInstance(cacheId, null);

        if (cache != null) {
            cache.BalanceDataLoad();
        }
    }

    @TargetMethodAttribute(privateMethod = MethodName.IsCacheRegistered, privateOverload = 1)
    @Override
    public boolean IsCacheRegistered(String cacheId) {
        if (cacheId != null) {
            if (s_caches.get(cacheId.toLowerCase()) != null) {
                return true;
            }
        }
        return false;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetSnmpPorts, privateOverload = 1)
    @Override
    public java.util.HashMap GetSnmpPorts() {
        HashMap snmpPorts = new HashMap();
        Map temp = PortPool.getInstance().getSNMPMap();
        for (Object entryObject : temp.entrySet()) {
            Map.Entry entry = (Map.Entry) entryObject;
            snmpPorts.put(entry.getKey(), entry.getValue());
        }
//        for (Iterator it = s_caches.entrySet().iterator(); it.hasNext();)
//        {
//            Map.Entry current = (Map.Entry) it.next();
//            String cache = (String) current.getKey();
//            CacheInfo cacheInfo = (CacheInfo) current.getValue();
//            int snmpPort = cacheInfo.getCacheProps().getPerfCounters().getSnmpPort(cacheInfo.getCache().getName());
//            snmpPorts.put(cache, snmpPort);
//        }
        return snmpPorts;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetServerLicenseInfo, privateOverload = 1)
    @Override
    public ServerLicenseInfo GetServerLicenseInfo() throws Exception {
//        try {
        return new ServerLicenseInfo();
//        } catch (Throwable ex) {
//            return new ServerLicenseInfo(ex.getMessage());
//        }
    }

    @TargetMethodAttribute(privateMethod = MethodName.StopServer, privateOverload = 1)
    @Override
    public void StopServer() {
        ReleaseServiceObject();
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetServerPlatform, privateOverload = 1)
    @Override
    public String GetServerPlatform() {
        return ServerPlatform.isJava;
    }

    @TargetMethodAttribute(privateMethod = MethodName.GetClientCacheStatus, privateOverload = 1)
    @Override
    public ClientCacheStatus GetClientCahceStatus(String clientCacheID) throws ManagementException, ParserConfigurationException, ParserConfigurationException, InstantiationException, SAXException, IOException, IllegalAccessException {

        ClientCacheStatus clientCachestatus = new ClientCacheStatus();
        try {
            Alachisoft.NCache.Config.NewDom.CacheServerConfig existConfig = Alachisoft.NCache.Config.NewDom.DomHelper.convertToNewDom(GetCacheConfiguration(clientCacheID));

            if (existConfig == null) {
                clientCachestatus.setStatus(ClientCacheStatus.NOT_REGISTERED);
                return clientCachestatus;
            }

            if (!existConfig.getCacheSettings().getCacheType().equals("client-cache")) {
                clientCachestatus.setStatus(ClientCacheStatus.NOT_CLIENT_CACHE);
                return clientCachestatus;
            }

            clientCachestatus.setStatus(ClientCacheStatus.REGISTERED);


            ClientConfiguration clientConfig = ClientConfigManager.GetClientConfiguration(clientCacheID);

            for (int i = 0; i < clientConfig.getCacheConfigurations().length; i++) {
                if (clientConfig.getCacheConfigurations()[i].getClientCacheId() != null && clientCacheID.toLowerCase().equals(clientConfig.getCacheConfigurations()[i].getClientCacheId().toLowerCase())) {
                    clientCachestatus.setClusteredCacheId(clientConfig.getCacheConfigurations()[i].getCacheId());
                    return clientCachestatus;
                }

            }
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception ex) {
            Logger.getLogger(CacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }


        return clientCachestatus;


    }

    @Override
    public boolean getIsConnected() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void PublishMetadata(String sessionId, String version, ClientMetaData clientMeta) throws Exception {

    }

    @Override
    public void PublishMetadata(String sessionId, CounterMetadataCollection counterMeta) throws Exception {

    }

    @Override
    public int PublishData(String session, CounterDataCollection data)  throws Exception{
        return 0;
    }

    private enum CacheStopReason {
        Expired,
        Stoped,
        ForcedStoped
    }

    /**
     * Enumeration specifying type of channle
     */
    public enum Channel {

        /**
         * Bind cluster channel
         */
        Cluster(0),
        /**
         * Bind client server channel
         */
        SocketServer(1);
        private static java.util.HashMap<Integer, Channel> mappings;
        private int intValue;

        private Channel(int value) {
            intValue = value;
            Channel.getMappings().put(value, this);
        }

        private static java.util.HashMap<Integer, Channel> getMappings() {
            if (mappings == null) {
                synchronized (Channel.class) {
                    if (mappings == null) {
                        mappings = new java.util.HashMap<Integer, Channel>();
                    }
                }
            }
            return mappings;
        }

        public static Channel forValue(int value) {
            return getMappings().get(value);
        }

        public int getValue() {
            return intValue;
        }
    }
}