package Alachisoft.NCache.Management;

import Alachisoft.NCache.Caching.*;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Config.ConfigReader;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.Dom.ConfigConverter;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;

public class CacheInfo implements InternalCompactSerializable {
    //private string _cacheProps;

    private LeasedCache _cache;

    public final CacheServerConfig getCacheProps() {
        if (this._cache != null) {
            return this._cache.getConfiguration();
        }
        return null;
    }

    public final void setCacheProps(CacheServerConfig value) {
        if (this._cache != null) {
            this._cache.setConfiguration(value);
        }
    }

    public final LeasedCache getCache() {
        return _cache;
    }

    public final void setCache(LeasedCache value) {
        _cache = value;
    }

    public final void SyncConfiguration() {
        //_cache.Configuration = _cacheProps;
        if (this._cache != null) {
            java.util.HashMap config = ConfigConverter.ToHashMap(this.getCacheProps());
            this._cache.setConfigString(ConfigReader.ToPropertiesString(config));
        }
    }
//#else

    /**
     * returns the collection of cache objects.
     */
    public final java.util.Collection getCaches() {
        return null;
    }

    /**
     * Start a cache
     *
     * @param cahcheID
     * @param propertyString
     * @return
     * @throws ArgumentNullException cacheId is a null reference (Nothing in Visual Basic).
     */
    public final void StartCache(String cacheId) {
        StartCache(cacheId, null, null, null, null, null, null);
    }
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public void StartCache(string cacheId, byte[] userId, byte[] password)

    public final void StartCache(String cacheId, byte[] userId, byte[] password) {
        StartCache(cacheId, null, null, null, null, null, null);
    }

    /**
     * Start a cache and provide call backs
     *
     * @param cahcheID
     * @param propertyString
     * @param itemAdded
     * @param itemRemoved
     * @param itemUpdated
     * @param cacheCleared
     * @return
     * @throws ArgumentNullException cacheId is a null reference (Nothing in Visual Basic).
     */
    public final void StartCache(String cacheId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate) {
    }

    /**
     * Stop a cache
     *
     * @param cacheId
     * @throws ArgumentNullException cacheId is a null reference (Nothing in Visual Basic).
     */
    public final void StopCache(String cacheId) {
    }
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: public void StopCache(string cacheId, byte[] userId, byte[] password)

    public final void StopCache(String cacheId, byte[] userId, byte[] password) {
    }

    public final void dispose() {
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._cache.setConfiguration((CacheServerConfig) Common.readAs(reader.ReadObject(), CacheServerConfig.class));
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject(this._cache.getConfiguration());
    }
}