package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.Util.SecurityUtil;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.XmlConfigReader;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;

import java.io.*;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Helps locate the configuration information file.
 */
public class CacheConfigManager {

    /**
     * Default tcp channel port.
     */
    public static final int DEF_TCP_PORT = Integer.parseInt(ServicePropValues.CACHE_MANAGEMENT_PORT);
    /**
     * Default http channel port.
     */
    public static final int DEF_HTTP_PORT = 8251;
    /**
     * Default IPC channel port.
     */
    public static final String DEF_IPC_PORT_NAME = "jvcCacheHost";
    /**
     * Configuration file folder name
     */
    private static final String DIRNAME = "config";
    /**
     * Configuration file name
     */
    private static final String FILENAME = "config.ncconf";
    /**
     * Default tcp channel port.
     */
    protected static int s_tcpPort = DEF_TCP_PORT;
    /**
     * Default http channel port.
     */
    protected static int s_httpPort = DEF_HTTP_PORT;
    /**
     * Default IPC channel port.
     */
    protected static String s_ipcPortName = DEF_IPC_PORT_NAME;
    /**
     * Path of the configuration file.
     */
    private static String s_configFileName = "";
    /**
     * Path of the configuration folder.
     */
    private static String s_configDir = "";

    /**
     * static constructor
     */
    static {
        //ConfigurationBuilder.RegisterRootConfigurationObject(typeof(CacheServerConfig));
        try {
            CacheConfigManager.ScanConfiguration();
        } catch (ManagementException managementException) {
            //Muneeb: IN-1012	:	System Event logger needed
        } catch (Exception e) {
            //Muneeb: IN-1012	:	System Event logger needed
        }

    }

    protected CacheConfigManager() {
    }

    /**
     * Configuration files folder.
     */
    public static String getDirName() {
        return s_configDir;
    }

    /**
     * Configuration file name.
     */
    public static String getFileName() {
        return s_configFileName;
    }

    /**
     * Configuration file name.
     */
    public static int getTcpPort() {
        return s_tcpPort;
    }

    /**
     * Configuration file name.
     */
    public static int getHttpPort() {
        return s_httpPort;
    }

    // <summary>

    /**
     * Configuration file name.
     */
    public static String getIPCPortName() {
        return s_ipcPortName;
    }

    /**
     * Scans the registry and locates the configuration file.
     */
    public static void ScanConfiguration() throws ManagementException, Exception {

        try {
            s_configDir = AppUtil.getInstallDir();
            if (s_configDir == null || s_configDir.length() == 0) {
                throw new ManagementException("Missing installation folder information");
            }
            s_configDir = Common.combinePath(s_configDir, DIRNAME);
            if (!(new java.io.File(s_configDir)).isDirectory()) {
                (new java.io.File(s_configDir)).mkdir();
            }
            s_configFileName = Common.combinePath(s_configDir, FILENAME);

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !THINCLIENT
            if (!(new java.io.File(s_configFileName)).isFile() || (new java.io.File(s_configFileName)).length() == 0) {
                /**
                 * Save a dummy configuration.
                 */
                SaveConfiguration(null);
            }
//#endif
        } catch (ManagementException e) {
            s_configFileName = "";
            throw e;
        } catch (Exception e) {
            s_configFileName = "";
            throw new ManagementException(e.getMessage(), e);
        }

        try {
            //Muneeb: Registry call changed to System.getProperty
            //Object v = RegHelper.GetRegValue(REGKEY, "Tcp.Port", 0);
            String v = ServicePropValues.CACHE_MANAGEMENT_PORT;
            if (v != null) {
                int port = Integer.parseInt(v);
//                if (port >= IPEndpoint.MinPort && port <= System.Net.IPEndPoint.MaxPort)
//                {
                s_tcpPort = port;
//                }
            }
        } catch (Exception e) {
            throw e;
        }
        try {
            //Muneeb: Registry call changed to System.getProperty
            //Object v = RegHelper.GetRegValue(REGKEY, "Tcp.Port", 0);
            String v = ServicePropValues.HTTP_PORT;
            if (v != null) {
                int port = Integer.parseInt(v);
//                if (port >= IPEndPoint.MinPort && port <= System.Net.IPEndPoint.MaxPort)
//                {
                s_httpPort = port;
//                }
            }
        } catch (Exception e) {
            throw e;
        }
        try {
            //Muneeb: Registry call changed to System.getProperty
            //Object v = RegHelper.GetRegValue(REGKEY, "Tcp.Port", 0);
            String v = ServicePropValues.IPC_PortName;
            if (v != null) {
                String portName = String.valueOf(v);
                if (portName != null) {
                    s_ipcPortName = portName;
                }
            }
        } catch (Exception e) {
            throw e;
        }
//#endif
    }

    /**
     * Initialize a registered cache given by the ID.
     *
     * @param cacheId A string identifier of configuration.
     */
    public static java.util.ArrayList GetCacheConfig(String cacheId, String userId, String password, boolean inProc) throws ManagementException {
        if (getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt");
        }
        try {
            XmlConfigReader configReader = new XmlConfigReader(getFileName(), cacheId);
            java.util.ArrayList propsList = configReader.getPropertiesList();
            java.util.ArrayList configsList = CacheConfig.GetConfigs(propsList);
            for (Iterator it = configsList.iterator(); it.hasNext(); ) {
                CacheConfig config = (CacheConfig) it.next();
                if (!inProc) {
                    inProc = config.getUseInProc();
                }
                break;
            }

            if (inProc) {
                boolean isAuthorize = false;
                java.util.HashMap ht = (java.util.HashMap) propsList.get(0);
                java.util.HashMap cache = (java.util.HashMap) ht.get("cache");
                java.util.HashMap security = (java.util.HashMap) cache.get("security");
                java.util.HashMap user = (java.util.HashMap) security.get("user");
                String userName = ThinClientConfigManager.ExtractUserName(userId);
                isAuthorize = user.containsKey(userName);
                String domainController = (String) security.get("domain-controller");
                String port = (String) security.get("port");
                //Security
                //if (isAuthorize)
                //    isAuthorize = ApiSecurityProvider.AuthorizeUserNamePassword(domainController, userName, password);

                //if (!isAuthorize)
                //{
                //    throw new SecurityException("You do not have permissions to perform this operation");
                //}

                //Security:New Code
                if (isAuthorize) {
                    isAuthorize = SecurityUtil.AuthorizeUserNamePassword(domainController, userName, password, port);
                }

                if (!isAuthorize) {
                    throw new SecurityException("You do not have permissions to perform this operation");
                }
                return configsList;
            }
            return null;
            //return CacheConfig.FromProperties(configReader.Properties);
        } catch (SecurityException e) {
            throw e;
        } catch (ManagementException e2) {
            throw e2;
        } catch (Exception e) {
            throw new ManagementException(e.getMessage(), e);
        }
    }

    /**
     * Initialize a registered cache given by the ID.
     *
     * @param cacheId A string identifier of configuration.
     */
    public static CacheConfig GetCacheConfig(String cacheId) throws ManagementException {
        if (getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt");
        }
        try {
            XmlConfigReader configReader = new XmlConfigReader(getFileName(), cacheId);
            return CacheConfig.FromProperties(configReader.getProperties());
        } catch (Exception e) {
            throw new ManagementException(e.getMessage(), e);
        }
    }

    public static CacheServerConfig GetUpdatedCacheConfig(String cacheId, String partId, String newNode, tangible.RefObject<java.util.ArrayList> affectedNodes, boolean isJoining) throws ManagementException {
        if (getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt");
        }

        try {
            XmlConfigReader configReader = new XmlConfigReader(getFileName(), cacheId);
            CacheServerConfig config = configReader.GetConfigDom();

            String list = config.getCluster().getChannel().getInitialHosts().toLowerCase();
            String[] nodes = list.split("[,]", -1);

            if (isJoining) {
                for (String node : nodes) {
                    String[] nodename = node.split("[\\[]", -1);
                    affectedNodes.argvalue.add(nodename[0]);
                }

                if (list.indexOf(newNode) == -1) {
                    list = list + "," + newNode + "[" + config.getCluster().getChannel().getTcpPort() + "]";
                }
            } else {
                for (String node : nodes) {
                    String[] nodename = node.split("[\\[]", -1);
                    if (!newNode.equals(nodename[0])) {
                        affectedNodes.argvalue.add(nodename[0]);
                    }
                }

                list = "";
                for (Iterator it = affectedNodes.argvalue.iterator(); it.hasNext(); ) {
                    String node = (String) it.next();
                    if (list.length() == 0) {
                        list = node + "[" + config.getCluster().getChannel().getTcpPort() + "]";
                    } else {
                        list = list + "," + node + "[" + config.getCluster().getChannel().getTcpPort() + "]";
                    }
                }
            }

            config.getCluster().getChannel().setInitialHosts(list);

            return config;
        } catch (Exception e) {
            throw new ManagementException(e.getMessage(), e);
        }
    }

    /**
     * Loads and returns all cache configurations from the configuration file.
     */
    public static CacheServerConfig[] GetConfiguredCaches() throws ManagementException {
        if (FILENAME.length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        try {
            ConfigurationBuilder builder = new ConfigurationBuilder(getFileName());
            builder.RegisterRootConfigurationObject(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class);
            builder.ReadConfiguration();
            Alachisoft.NCache.Config.NewDom.CacheServerConfig[] caches = new Alachisoft.NCache.Config.NewDom.CacheServerConfig[builder.getConfiguration().length];
            System.arraycopy(builder.getConfiguration(), 0, caches, 0, builder.getConfiguration().length);

            return convertToOldDom(caches);
        } catch (Exception e) {
            throw new ManagementException(e.getMessage(), e);
        }
    }

    //Method for converting New Dom into Old Dom for Passing to back to LoadConfig Method .. .. .. [Numan Hanif]
    private static Alachisoft.NCache.Config.Dom.CacheServerConfig[] convertToOldDom(Alachisoft.NCache.Config.NewDom.CacheServerConfig[] newCacheConfigsList) throws Exception {
        //Alachisoft.NCache.Config.Dom.CacheServerConfig[] oldCacheConfigsList = new CacheServerConfig[newCacheConfigsList.length];
        List<Alachisoft.NCache.Config.Dom.CacheServerConfig> oldCacheConfigsList = new ArrayList<Alachisoft.NCache.Config.Dom.CacheServerConfig>();
        for (int index = 0; index < newCacheConfigsList.length; index++) {
            try {
                oldCacheConfigsList.add(Alachisoft.NCache.Config.NewDom.DomHelper.convertToOldDom(newCacheConfigsList[index]));
            } catch (Exception e) {

            }
        }
        Alachisoft.NCache.Config.Dom.CacheServerConfig[] oldCacheConfigsArray = new CacheServerConfig[oldCacheConfigsList.size()];
        return oldCacheConfigsList.toArray(oldCacheConfigsArray);
    }

    /**
     * Loads and returns all cache configurations from the configuration file.
     */
    //static public CacheConfig[] GetConfiguredCaches()
    //{
    //    if (FileName.Length == 0)
    //    {
    //        throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
    //    }
    //    try
    //    {
    //        XmlConfigReader xcr = new XmlConfigReader("", "");
    //        IDictionary propMap = null;
    //        propMap = xcr.GetProperties(CacheConfigManager.FileName);
    //        ArrayList configList = new ArrayList();
    //        IDictionaryEnumerator ide = propMap.GetEnumerator();
    //        while (ide.MoveNext())
    //        {
    //            IDictionary properties = (IDictionary)ide.Value;
    //            if (properties.Contains("Partitioned-Replica"))
    //            {
    //                properties.Remove("Partitioned-Replica");
    //                IDictionaryEnumerator ie = properties.GetEnumerator();
    //                while (ie.MoveNext())
    //                {
    //                    IDictionary partitionedProps = ie.Value as IDictionary;
    //                    configList.Add(CacheConfig.FromProperties(partitionedProps));
    //                }
    //            }
    //            else
    //            {
    //                configList.Add(CacheConfig.FromProperties(properties));
    //            }
    //        }
    //        CacheConfig[] configs = new CacheConfig[configList.Count];
    //        for (int i = 0; i < configList.Count; i++)
    //        {
    //            configs[i] = configList[i] as CacheConfig;
    //        }
    //        return configs;
    //    }
    //    catch (ManagementException)
    //    {
    //        throw;
    //    }
    //    catch (Exception e)
    //    {
    //        throw new ManagementException(e.Message, e);
    //    }
    //}
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if EXPRESS

    /**
     * Loads and returns all cache configurations from the configuration file.
     */
    public static CacheConfig[] GetConfiguredCaches2() throws ManagementException, ConfigurationException, UnknownHostException {
        if (getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        try {
            XmlConfigReader xcr = new XmlConfigReader("", "");
            java.util.Map propMap = null;

            propMap = xcr.GetProperties2(CacheConfigManager.getFileName());

            java.util.ArrayList configList = new java.util.ArrayList();

            Iterator ide = propMap.entrySet().iterator();
            while (ide.hasNext()) {
                Map.Entry current = (Map.Entry) ide.next();
                java.util.Map properties = (java.util.Map) current.getValue();
                configList.add(CacheConfig.FromProperties2(properties));
            }

            CacheConfig[] configs = new CacheConfig[configList.size()];
            for (int i = 0; i < configList.size(); i++) {
                configs[i] = (CacheConfig) ((configList.get(i) instanceof CacheConfig) ? configList.get(i) : null);
            }

            return configs;
        } catch (ManagementException e) {
            throw e;
        } catch (RuntimeException e) {
            throw new ManagementException(e.getMessage(), e);
        }
    }
//#endif

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !THINCLIENT
    //static public void SaveConfiguration(HashMap caches)
    //{
    //    SaveConfiguration(caches, null);
    //}
    //static public void SaveConfiguration(HashMap caches, HashMap partitionedCaches, Alachisoft.NCache.Config.Dom.CacheServerConfig config)
    //{
    //    if (FileName.Length == 0)
    //    {
    //        throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
    //    }
    //    CacheServerConfig[] configurations = null;
    //    if (caches != null)
    //    {
    //        configurations = new CacheServerConfig[caches.Count];
    //        IDictionaryEnumerator ide = caches.GetEnumerator();
    //        int count = 0;
    //        while (ide.MoveNext())
    //        {
    //            try
    //            {
    //                CacheInfo cacheInfo = (CacheInfo)ide.Value;
    //                configurations[count++] = cacheInfo.CacheProps;
    //            }
    //            catch (Exception)
    //            {
    //            }
    //        }
    //    }
    //    FileStream fs = null;
    //    StreamWriter sw = null;
    //    try
    //    {
    //        fs = new FileStream(CacheConfigManager.FileName, FileMode.Create);
    //        sw = new StreamWriter(fs);
    //        SaveConfiguration(configurations);
    //        sw.Flush();
    //    }
    //    catch (Exception e)
    //    {
    //        throw new ManagementException(e.Message, e);
    //    }
    //    finally
    //    {
    //        if (sw != null) sw.Close();
    //        fs.Close();
    //    }
    //}

    /**
     * Save caches to configuration
     */
    public static void SaveConfiguration(java.util.HashMap caches, java.util.HashMap partitionedCaches) throws ManagementException, IllegalArgumentException, IllegalAccessException, FileNotFoundException, UnsupportedEncodingException, IOException, Exception {
        if (getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }

        java.util.ArrayList<CacheServerConfig> configurations = new java.util.ArrayList<CacheServerConfig>();
        if (caches != null) {
            Iterator ide = caches.entrySet().iterator();
            while (ide.hasNext()) {
                Map.Entry current = (Map.Entry) ide.next();
                try {
                    CacheInfo cacheInfo = (CacheInfo) current.getValue();
                    configurations.add(cacheInfo.getCacheProps());
                } catch (RuntimeException e) {
                }
            }
        }

        if (partitionedCaches != null) {
            Iterator ide = partitionedCaches.entrySet().iterator();
            while (ide.hasNext()) {
                Map.Entry curr = (Map.Entry) ide.next();
                java.util.HashMap partitionedTable = (java.util.HashMap) ((curr.getValue() instanceof java.util.HashMap) ? curr.getValue() : null);
                if (partitionedTable != null) {
                    Iterator ie = partitionedTable.entrySet().iterator();
                    while (ie.hasNext()) {
                        Map.Entry current = (Map.Entry) ie.next();
                        try {
                            CacheInfo cacheInfo = (CacheInfo) current.getValue();
                            configurations.add(cacheInfo.getCacheProps());
                        } catch (Exception ex) {
                            Exception e = ex;
                        }
                    }
                }
            }
        }
        //SaveConfiguration(configurations.toArray(new CacheServerConfig[0]));

        //Change for New Dom Convert Old Dom Config to New Dom Config before Saving it on File ncconf[Numan Hanif]
        SaveConfiguration(convertToNewDom(configurations).toArray(new Alachisoft.NCache.Config.NewDom.CacheServerConfig[0]));

    }

    //Method for converting Old Dom into New Dom for Saving it on the nconf File .. .. .. [Numan Hanif]
    private static java.util.ArrayList<Alachisoft.NCache.Config.NewDom.CacheServerConfig> convertToNewDom(java.util.ArrayList<CacheServerConfig> oldCacheConfigsList) throws Exception {
        java.util.ArrayList<Alachisoft.NCache.Config.NewDom.CacheServerConfig> newCacheConfigsList = new ArrayList<Alachisoft.NCache.Config.NewDom.CacheServerConfig>();

        Iterator itr = oldCacheConfigsList.listIterator();
        while (itr.hasNext()) {
            Alachisoft.NCache.Config.Dom.CacheServerConfig tempOldCacheConfig = (Alachisoft.NCache.Config.Dom.CacheServerConfig) itr.next();
            try {
                Alachisoft.NCache.Config.NewDom.CacheServerConfig tempNewCacheConfig = Alachisoft.NCache.Config.NewDom.DomHelper.convertToNewDom(tempOldCacheConfig);
                newCacheConfigsList.add(tempNewCacheConfig);
            } catch (Exception e) {

            }
        }
        return newCacheConfigsList;


    }

    //static public void SaveConfiguration(HashMap caches, HashMap partitionedCaches, Alachisoft.NCache.Config.Dom.CacheServerConfig config)
    //{
    //    if (FileName.Length == 0)
    //    {
    //        throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
    //    }
    //    HashMap configuration = new HashMap();
    //    if (caches != null)
    //    {
    //        IDictionaryEnumerator ide = caches.GetEnumerator();
    //        while (ide.MoveNext())
    //        {
    //            try
    //            {
    //                CacheInfo cacheInfo = (CacheInfo)ide.Value;
    //                PropsConfigReader pcr = new PropsConfigReader(cacheInfo.CacheProps);
    //                IDictionary cacheConfig = pcr.Properties;
    //                cacheConfig.Add("type", "cache-configuration");
    //                cacheConfig.Add("id", ide.Key);
    //                configuration.Add(ide.Key, cacheConfig);
    //            }
    //            catch (Exception)
    //            {
    //            }
    //        }
    //    }
    //    IDictionary properties = new HashMap();
    //    properties.Add("configuration", configuration);
    //    FileStream fs = null;
    //    StreamWriter sw = null;
    //    try
    //    {
    //        fs = new FileStream(CacheConfigManager.FileName, FileMode.Create);
    //        sw = new StreamWriter(fs);
    //        SaveAsXml(configuration, config, sw);
    //        sw.Flush();
    //    }
    //    catch (Exception e)
    //    {
    //        throw new ManagementException(e.Message, e);
    //    }
    //    finally
    //    {
    //        if (sw != null) sw.Close();
    //        fs.Close();
    //    }
    //}
    /**
     * Save caches to configuration
     */
    //static public void SaveConfiguration(HashMap caches, HashMap partitionedCaches)
    //{
    //    if (FileName.Length == 0)
    //    {
    //        throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
    //    }
    //    HashMap configuration = new HashMap();
    //    if (caches != null)
    //    {
    //        IDictionaryEnumerator ide = caches.GetEnumerator();
    //        while (ide.MoveNext())
    //        {
    //            try
    //            {
    //                CacheInfo cacheInfo = (CacheInfo)ide.Value;
    //                //Cache cache = (Cache) ide.Value;
    //                PropsConfigReader pcr = new PropsConfigReader(cacheInfo.CacheProps);
    //                IDictionary cacheConfig = pcr.Properties;
    //                //#if !EXPRESS
    //                cacheConfig.Add("type", "cache-configuration");
    //                cacheConfig.Add("id", ide.Key);
    //                configuration.Add(ide.Key, cacheConfig);
    //                //#else
    //                //                        HashMap tmp = new HashMap();
    //                //                        string name = cacheConfig["name"] as string;
    //                //                        string inproc = cacheConfig["inproc"] as string;
    //                //                        cacheConfig.Remove("name");
    //                //                        cacheConfig.Remove("inproc");
    //                //                        tmp.Add(name, cacheConfig);
    //                //                        tmp.Add("type", "cache-config");
    //                //                        tmp.Add("name", name);
    //                //                        tmp.Add("inproc", inproc);
    //                //                        configuration.Add(name, tmp);
    //                //#endif
    //            }
    //            catch (Exception)
    //            {
    //            }
    //        }
    //    }
    //    if (partitionedCaches != null)
    //    {
    //        IDictionaryEnumerator ide = partitionedCaches.GetEnumerator();
    //        while (ide.MoveNext())
    //        {
    //            HashMap partitionedTable = ide.Value as HashMap;
    //            if (partitionedTable != null)
    //            {
    //                IDictionaryEnumerator ie = partitionedTable.GetEnumerator();
    //                while (ie.MoveNext())
    //                {
    //                    try
    //                    {
    //                        CacheInfo cacheInfo = (CacheInfo)ie.Value;
    //                        //Cache cache = (Cache) ide.Value;
    //                        PropsConfigReader pcr = new PropsConfigReader(cacheInfo.CacheProps);
    //                        IDictionary cacheConfig = pcr.Properties;
    //                        cacheConfig.Add("type", "cache-configuration");
    //                        cacheConfig.Add("id", ide.Key);
    //                        cacheConfig.Add("partitionId", ie.Key);
    //                        string keyName = (string)ide.Key + "-" + (string)ie.Key;
    //                        configuration.Add(keyName, cacheConfig);
    //                        //								if (configuration.Contains(ide.Key))
    //                        //								{
    //                        //									HashMap partitionConfig = configuration[ide.Key] as HashMap;
    //                        //									partitionConfig[ie.Key] = cacheConfig;
    //                        //								}
    //                        //								else
    //                        //								{
    //                        //									HashMap partitionConfig = new HashMap();
    //                        //									partitionConfig[ie.Key] = cacheConfig;
    //                        //									configuration.Add(ide.Key, cacheConfig);
    //                        //								}
    //                    }
    //                    catch (Exception ex)
    //                    {
    //                        Exception e = ex;
    //                    }
    //                }
    //            }
    //        }
    //    }
    //    IDictionary properties = new HashMap();
    //    properties.Add("configuration", configuration);
    //    FileStream fs = null;
    //    StreamWriter sw = null;
    //    try
    //    {
    //        fs = new FileStream(CacheConfigManager.FileName, FileMode.Create);
    //        sw = new StreamWriter(fs);
    //        //#if !EXPRESS
    //        SaveAsXml(configuration, sw);
    //        //#else
    //        //                sw.Write(ConfigReader.ToPropertiesXml2(properties, true));
    //        //#endif
    //        sw.Flush();
    //    }
    //    catch (Exception e)
    //    {
    //        throw new ManagementException(e.Message, e);
    //    }
    //    finally
    //    {
    //        if (sw != null) sw.Close();
    //        fs.Close();
    //    }
    //}

    /**
     * Save the configuration
     *
     * @param configuration
     */
    public static void SaveConfiguration(Object[] configuration) throws IllegalArgumentException, IllegalAccessException, ManagementException, FileNotFoundException, Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<configuration>\r\n");
        if (configuration != null && configuration.length > 0) {
            ConfigurationBuilder builder = new ConfigurationBuilder(configuration);
            builder.RegisterRootConfigurationObject(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class);
            xml.append(builder.GetXmlString());
        }
        xml.append("\r\n</configuration>");
        WriteXmlToFile(xml.toString());
    }

    /**
     * Write the xml configuration string to c
     *
     * @param xml
     */
    private static void WriteXmlToFile(String xml) throws ManagementException, FileNotFoundException, UnsupportedEncodingException, IOException {
        if (getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        //Muneeb:   NR-1020	:	StreamWriter to changed to Writer/OutputStream/FileOutputStream
        OutputStream os = null;
        Writer writer = null;
        try {
            os = new FileOutputStream(getFileName());
            writer = new OutputStreamWriter(os);
            writer.write(xml);
            writer.flush();
        } catch (RuntimeException e) {
            throw new ManagementException(e.getMessage(), e);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (RuntimeException e) {
                }
                writer = null;
            }
            if (os != null) {
                try {
                    os.close();
                } catch (RuntimeException e2) {
                }
                os = null;
            }
        }
    }
//#endif
}