package Alachisoft.NCache.Management;
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS || (EXPRESS && PROFESSIONAL)

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheFactory;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.ServiceControl.NCacheService;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.util.TimeSpan;

import java.net.UnknownHostException;

//#else
//#endif

/**
 * Manages client side connection to caches.
 */
public final class CacheClient {

    private CacheClient() {
    }

    /**
     * Initialize a registered cache given by the ID.
     *
     * @param cacheId
     * @param timeout
     * @return A reference to <see cref="Cache"/> object.
     * @throws ArgumentNullException cacheId is a null reference (Nothing in Visual Basic).
     */
    public static Cache GetCacheInstance(String cacheId) throws ConfigurationException, ManagementException, UnknownHostException {
        return GetCacheInstance(cacheId, new TimeSpan(30000));
    }

    /**
     * Initialize a registered cache given by the ID.
     *
     * @param cacheId
     * @param timeout
     * @return A reference to <see cref="Cache"/> object.
     * @throws ArgumentNullException cacheId is a null reference (Nothing in Visual Basic).
     */
    public static Cache GetCacheInstance(String cacheId, TimeSpan timeout) throws ConfigurationException, ManagementException, UnknownHostException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: cacheId");
        }
        try {
            CacheConfig data = CacheConfigManager.GetCacheConfig(cacheId);
            return GetCacheInstance(data, timeout, false);
        } catch (RuntimeException e) {
            throw e;
        }
    }

    /**
     * Initialize a registered cache given by the ID.
     *
     * @param data
     * @param timeout
     * @return A reference to <see cref="Cache"/> object.
     * @throws ArgumentNullException data is a null reference (Nothing in Visual Basic).
     */
    public static Cache GetCacheInstance(CacheConfig data, TimeSpan timeout, boolean autoStart) throws ConfigurationException, UnknownHostException {
        if (data == null) {
            throw new IllegalArgumentException("Value cannot be null."+System.lineSeparator()+"Parameter name: data");
        }
        try {
            if (data == null) {
                return null;
            }
            if (data.getUseInProc()) {
                return CacheFactory.CreateFromPropertyString(data.getPropertyString());
            }

            Cache cache = ConnectCacheInstance(data, timeout, autoStart);
            return cache;
        } catch (RuntimeException e) {
            throw e;
        }
    }

    /**
     * Creates and returns an instance of NCache.
     *
     * @param data
     * @param timeout
     * @return A reference to <see cref="Cache"/> object.
     */
    private static Cache ConnectCacheInstance(CacheConfig data, TimeSpan timeout, boolean autoStart) throws UnknownHostException {
        NCacheService ncache = new NCacheService();
        try {
            ncache.setUseTcp(data.getUseTcp());
            ncache.setServerName(data.getServerName());
            ncache.setPort(data.getPort());
            if (ncache.getServerName() == null || ncache.getServerName().length() < 1 || ncache.getServerName().compareTo(".") == 0 || ncache.getServerName().compareTo("localhost") == 0) {
                //Muneeb: Changed Enviorment.MachineName to java.net.InetAddress.getLocalHost().getHostName()
                ncache.setServerName(java.net.InetAddress.getLocalHost().getHostName());
                //ncache.setServerName(Environment.MachineName);
            }

            //ICacheServer manager =  ncache.GetCacheServer(timeout);
            //if(manager != null)
            //{
            //    Cache cache =  manager[data.CacheId];
            //    if(autoStart)
            //    {
            //        manager.StartCache(data.CacheId);
            //    }
            //    if (cache.IsRunning)
            //        return cache;
            //    Alachisoft.NCache.Common.AppUtil.LogEvent("Initialize Cache", "Cache " + data.CacheId + " is not running. Possibly your license has expired the evaluation period.", System.Diagnostics.EventLogEntryType.Information, EventCategories.Error, EventID.LicensingError);
            //    throw new OperationFailedException("Cache is not running. For more information see Application Log.");
            //}
            return null;
        } catch (RuntimeException e) {
            throw e;
        } finally {
            ncache.dispose();
        }
    }
}