/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.customview.view.AbsSavedState;
import com.akexorcist.roundcornerprogressbar.R;

@Keep
public abstract class BaseRoundCornerProgressBar
extends LinearLayout {
    protected static final int DEFAULT_MAX_PROGRESS = 100;
    protected static final int DEFAULT_PROGRESS = 0;
    protected static final int DEFAULT_SECONDARY_PROGRESS = 0;
    protected static final int DEFAULT_PROGRESS_RADIUS = 30;
    protected static final int DEFAULT_BACKGROUND_PADDING = 0;
    protected LinearLayout layoutBackground;
    protected LinearLayout layoutProgress;
    protected LinearLayout layoutSecondaryProgress;
    protected GradientDrawable progressDrawable;
    protected GradientDrawable secondaryProgressDrawable;
    protected int radius;
    protected int padding;
    protected int totalWidth;
    protected float max;
    protected float progress;
    protected float secondaryProgress;
    protected int backgroundColor;
    private int progressColor;
    protected int secondaryProgressColor;
    protected int[] progressColors;
    protected int[] secondaryProgressColors;
    protected boolean isReverse;
    protected OnProgressChangedListener progressChangedListener;

    public BaseRoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    public BaseRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    @RequiresApi(value=21)
    public BaseRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    protected abstract int initLayout();

    protected abstract void initStyleable(@NonNull Context var1, @NonNull AttributeSet var2);

    protected abstract void initView();

    protected abstract void drawProgress(@NonNull LinearLayout var1, @NonNull GradientDrawable var2, float var3, float var4, float var5, int var6, int var7, boolean var8);

    protected abstract void onViewDraw();

    public void setup(@NonNull Context context, @NonNull AttributeSet attrs) {
        this.setupStyleable(context, attrs);
        this.removeAllViews();
        LayoutInflater.from((Context)context).inflate(this.initLayout(), (ViewGroup)this);
        this.layoutBackground = (LinearLayout)this.findViewById(R.id.layout_background);
        this.layoutProgress = (LinearLayout)this.findViewById(R.id.layout_progress);
        this.layoutSecondaryProgress = (LinearLayout)this.findViewById(R.id.layout_secondary_progress);
        this.initView();
    }

    public void setupStyleable(@NonNull Context context, @NonNull AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BaseRoundCornerProgressBar);
        this.radius = (int)typedArray.getDimension(R.styleable.BaseRoundCornerProgressBar_rcRadius, this.dp2px(30.0f));
        this.padding = (int)typedArray.getDimension(R.styleable.BaseRoundCornerProgressBar_rcBackgroundPadding, this.dp2px(0.0f));
        this.isReverse = typedArray.getBoolean(R.styleable.BaseRoundCornerProgressBar_rcReverse, false);
        this.max = typedArray.getFloat(R.styleable.BaseRoundCornerProgressBar_rcMax, 100.0f);
        this.progress = typedArray.getFloat(R.styleable.BaseRoundCornerProgressBar_rcProgress, 0.0f);
        this.secondaryProgress = typedArray.getFloat(R.styleable.BaseRoundCornerProgressBar_rcSecondaryProgress, 0.0f);
        int defaultBackgroundColor = context.getResources().getColor(R.color.round_corner_progress_bar_background_default);
        this.backgroundColor = typedArray.getColor(R.styleable.BaseRoundCornerProgressBar_rcBackgroundColor, defaultBackgroundColor);
        this.progressColor = typedArray.getColor(R.styleable.BaseRoundCornerProgressBar_rcProgressColor, -1);
        int progressColorResourceId = typedArray.getResourceId(R.styleable.BaseRoundCornerProgressBar_rcProgressColors, 0);
        this.progressColors = (int[])(progressColorResourceId != 0 ? this.getResources().getIntArray(progressColorResourceId) : null);
        this.secondaryProgressColor = typedArray.getColor(R.styleable.BaseRoundCornerProgressBar_rcSecondaryProgressColor, -1);
        int secondaryProgressColorResourceId = typedArray.getResourceId(R.styleable.BaseRoundCornerProgressBar_rcSecondaryProgressColors, 0);
        this.secondaryProgressColors = (int[])(secondaryProgressColorResourceId != 0 ? this.getResources().getIntArray(secondaryProgressColorResourceId) : null);
        typedArray.recycle();
        this.updateProgressDrawable();
        this.updateSecondaryProgressDrawable();
        this.initStyleable(context, attrs);
    }

    protected void onSizeChanged(int newWidth, int newHeight, int oldWidth, int oldHeight) {
        super.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
        this.totalWidth = newWidth;
        this.drawBackgroundProgress();
        this.drawPadding();
        this.drawProgressReverse();
        this.post(new Runnable(){

            @Override
            public void run() {
                BaseRoundCornerProgressBar.this.drawPrimaryProgress();
                BaseRoundCornerProgressBar.this.drawSecondaryProgress();
            }
        });
        this.onViewDraw();
    }

    protected void drawAll() {
        this.drawBackgroundProgress();
        this.drawPadding();
        this.drawProgressReverse();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
        this.onViewDraw();
    }

    private void drawBackgroundProgress() {
        GradientDrawable backgroundDrawable = this.createGradientDrawable(this.backgroundColor);
        int newRadius = this.radius - this.padding / 2;
        backgroundDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        this.layoutBackground.setBackground((Drawable)backgroundDrawable);
    }

    protected GradientDrawable createGradientDrawable(@ColorInt int color2) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setColor(color2);
        return gradientDrawable;
    }

    protected GradientDrawable createGradientDrawable(int[] colors) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setOrientation(!this.isReverse() ? GradientDrawable.Orientation.LEFT_RIGHT : GradientDrawable.Orientation.RIGHT_LEFT);
        gradientDrawable.setColors(colors);
        return gradientDrawable;
    }

    private void updateProgressDrawable() {
        if (this.progressColor != -1) {
            this.progressDrawable = this.createGradientDrawable(this.progressColor);
        } else if (this.progressColors != null && this.progressColors.length > 0) {
            this.progressDrawable = this.createGradientDrawable(this.progressColors);
        } else {
            int defaultColor = this.getResources().getColor(R.color.round_corner_progress_bar_progress_default);
            this.progressDrawable = this.createGradientDrawable(defaultColor);
        }
    }

    private void updateSecondaryProgressDrawable() {
        if (this.secondaryProgressColor != -1) {
            this.secondaryProgressDrawable = this.createGradientDrawable(this.secondaryProgressColor);
        } else if (this.secondaryProgressColors != null && this.secondaryProgressColors.length > 0) {
            this.secondaryProgressDrawable = this.createGradientDrawable(this.secondaryProgressColors);
        } else {
            int defaultColor = this.getResources().getColor(R.color.round_corner_progress_bar_secondary_progress_default);
            this.secondaryProgressDrawable = this.createGradientDrawable(defaultColor);
        }
    }

    private void drawPrimaryProgress() {
        int possibleRadius = Math.min(this.radius, this.layoutBackground.getMeasuredHeight() / 2);
        this.drawProgress(this.layoutProgress, this.progressDrawable, this.max, this.progress, this.totalWidth, possibleRadius, this.padding, this.isReverse);
    }

    private void drawSecondaryProgress() {
        int possibleRadius = Math.min(this.radius, this.layoutBackground.getMeasuredHeight() / 2);
        this.drawProgress(this.layoutSecondaryProgress, this.secondaryProgressDrawable, this.max, this.secondaryProgress, this.totalWidth, possibleRadius, this.padding, this.isReverse);
    }

    private void drawProgressReverse() {
        this.setupProgressReversing(this.layoutProgress, this.isReverse);
        this.setupProgressReversing(this.layoutSecondaryProgress, this.isReverse);
    }

    private void setupProgressReversing(@NonNull LinearLayout layoutProgress, boolean isReverse) {
        RelativeLayout.LayoutParams progressParams = (RelativeLayout.LayoutParams)layoutProgress.getLayoutParams();
        this.removeLayoutParamsRule(progressParams);
        if (isReverse) {
            progressParams.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                progressParams.addRule(21);
            }
        } else {
            progressParams.addRule(9);
            if (Build.VERSION.SDK_INT >= 17) {
                progressParams.addRule(20);
            }
        }
        layoutProgress.setLayoutParams((ViewGroup.LayoutParams)progressParams);
    }

    private void drawPadding() {
        this.layoutBackground.setPadding(this.padding, this.padding, this.padding, this.padding);
    }

    private void removeLayoutParamsRule(@NonNull RelativeLayout.LayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.removeRule(11);
            layoutParams.removeRule(21);
            layoutParams.removeRule(9);
            layoutParams.removeRule(20);
        } else {
            layoutParams.addRule(11, 0);
            layoutParams.addRule(9, 0);
        }
    }

    @SuppressLint(value={"NewApi"})
    protected float dp2px(float dp) {
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public void setReverse(boolean isReverse) {
        this.isReverse = isReverse;
        this.drawProgressReverse();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(@Px int radius) {
        if (radius >= 0) {
            this.radius = radius;
        }
        this.drawBackgroundProgress();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(@Px int padding) {
        if (padding >= 0) {
            this.padding = padding;
        }
        this.drawPadding();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        if (max >= 0.0f) {
            this.max = max;
        }
        if (this.progress > max) {
            this.progress = max;
        }
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public float getLayoutWidth() {
        return this.totalWidth;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.setProgress((float)progress);
    }

    public void setProgress(float progress) {
        this.progress = progress < 0.0f ? 0.0f : Math.min(progress, this.max);
        this.drawPrimaryProgress();
        if (this.progressChangedListener != null) {
            this.progressChangedListener.onProgressChanged((View)this, this.progress, true, false);
        }
    }

    public float getSecondaryProgressWidth() {
        if (this.layoutSecondaryProgress != null) {
            return this.layoutSecondaryProgress.getWidth();
        }
        return 0.0f;
    }

    public float getSecondaryProgress() {
        return this.secondaryProgress;
    }

    public void setSecondaryProgress(int progress) {
        this.setSecondaryProgress((float)progress);
    }

    public void setSecondaryProgress(float progress) {
        this.secondaryProgress = progress < 0.0f ? 0.0f : Math.min(progress, this.max);
        this.drawSecondaryProgress();
        if (this.progressChangedListener != null) {
            this.progressChangedListener.onProgressChanged((View)this, this.secondaryProgress, false, true);
        }
    }

    public int getProgressBackgroundColor() {
        return this.backgroundColor;
    }

    public void setProgressBackgroundColor(@ColorInt int color2) {
        this.backgroundColor = color2;
        this.drawBackgroundProgress();
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(@ColorInt int color2) {
        this.progressColor = color2;
        this.progressColors = null;
        this.updateProgressDrawable();
        this.drawPrimaryProgress();
    }

    @Nullable
    public int[] getProgressColors() {
        return this.progressColors;
    }

    public void setProgressColors(int[] colors) {
        this.progressColor = -1;
        this.progressColors = colors;
        this.updateProgressDrawable();
        this.drawPrimaryProgress();
    }

    public int getSecondaryProgressColor() {
        return this.secondaryProgressColor;
    }

    public void setSecondaryProgressColor(@ColorInt int color2) {
        this.secondaryProgressColor = color2;
        this.secondaryProgressColors = null;
        this.updateSecondaryProgressDrawable();
        this.drawSecondaryProgress();
    }

    @Nullable
    public int[] getSecondaryProgressColors() {
        return this.secondaryProgressColors;
    }

    public void setSecondaryProgressColors(int[] colors) {
        this.secondaryProgressColor = -1;
        this.secondaryProgressColors = colors;
        this.updateSecondaryProgressDrawable();
        this.drawSecondaryProgress();
    }

    public void setOnProgressChangedListener(@Nullable OnProgressChangedListener listener) {
        this.progressChangedListener = listener;
    }

    public void invalidate() {
        super.invalidate();
        this.drawAll();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.max = this.max;
        ss.progress = this.progress;
        ss.secondaryProgress = this.secondaryProgress;
        ss.radius = this.radius;
        ss.padding = this.padding;
        ss.colorBackground = this.backgroundColor;
        ss.colorProgress = this.progressColor;
        ss.colorSecondaryProgress = this.secondaryProgressColor;
        ss.colorProgressArray = this.progressColors;
        ss.colorSecondaryProgressArray = this.secondaryProgressColors;
        ss.isReverse = this.isReverse;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.max = ss.max;
        this.progress = ss.progress;
        this.secondaryProgress = ss.secondaryProgress;
        this.radius = ss.radius;
        this.padding = ss.padding;
        this.backgroundColor = ss.colorBackground;
        this.progressColor = ss.colorProgress;
        this.secondaryProgressColor = ss.colorSecondaryProgress;
        this.progressColors = ss.colorProgressArray;
        this.secondaryProgressColors = ss.colorSecondaryProgressArray;
        this.isReverse = ss.isReverse;
        this.updateProgressDrawable();
        this.updateSecondaryProgressDrawable();
    }

    protected static class SavedState
    extends AbsSavedState {
        float max;
        float progress;
        float secondaryProgress;
        int radius;
        int padding;
        int colorBackground;
        int colorProgress;
        int colorSecondaryProgress;
        int[] colorProgressArray;
        int[] colorSecondaryProgressArray;
        boolean isReverse;
        public static final Parcelable.ClassLoaderCreator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel in) {
            this(in, null);
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.max = in.readFloat();
            this.progress = in.readFloat();
            this.secondaryProgress = in.readFloat();
            this.radius = in.readInt();
            this.padding = in.readInt();
            this.colorBackground = in.readInt();
            this.colorProgress = in.readInt();
            this.colorSecondaryProgress = in.readInt();
            this.colorProgressArray = new int[in.readInt()];
            in.readIntArray(this.colorProgressArray);
            this.colorSecondaryProgressArray = new int[in.readInt()];
            in.readIntArray(this.colorSecondaryProgressArray);
            this.isReverse = in.readByte() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.max);
            out.writeFloat(this.progress);
            out.writeFloat(this.secondaryProgress);
            out.writeInt(this.radius);
            out.writeInt(this.padding);
            out.writeInt(this.colorBackground);
            out.writeInt(this.colorProgress);
            out.writeInt(this.colorSecondaryProgress);
            out.writeInt(this.colorProgressArray != null ? this.colorProgressArray.length : 0);
            out.writeIntArray(this.colorProgressArray != null ? this.colorProgressArray : new int[]{});
            out.writeInt(this.colorSecondaryProgressArray != null ? this.colorSecondaryProgressArray.length : 0);
            out.writeIntArray(this.colorSecondaryProgressArray != null ? this.colorSecondaryProgressArray : new int[]{});
            out.writeByte((byte)(this.isReverse ? 1 : 0));
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(View var1, float var2, boolean var3, boolean var4);
    }
}

