/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.customview.view.AbsSavedState;
import com.akexorcist.roundcornerprogressbar.R;
import com.akexorcist.roundcornerprogressbar.common.AnimatedRoundCornerProgressBar;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Keep
public class TextRoundCornerProgressBar
extends AnimatedRoundCornerProgressBar
implements ViewTreeObserver.OnGlobalLayoutListener {
    protected static final int DEFAULT_TEXT_SIZE = 16;
    protected static final int DEFAULT_TEXT_MARGIN = 10;
    public static final int GRAVITY_START = 0;
    public static final int GRAVITY_END = 1;
    public static final int PRIORITY_INSIDE = 0;
    public static final int PRIORITY_OUTSIDE = 1;
    private TextView tvProgress;
    private int colorTextProgress;
    private int textProgressSize;
    private int textProgressMargin;
    private String textProgress;
    private int textInsideGravity;
    private int textOutsideGravity;
    private int textPositionPriority;

    public TextRoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TextRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int initLayout() {
        return R.layout.layout_text_round_corner_progress_bar;
    }

    @Override
    protected void initStyleable(@NonNull Context context, @NonNull AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TextRoundCornerProgressBar);
        this.colorTextProgress = typedArray.getColor(R.styleable.TextRoundCornerProgressBar_rcTextProgressColor, -1);
        this.textProgressSize = (int)typedArray.getDimension(R.styleable.TextRoundCornerProgressBar_rcTextProgressSize, this.dp2px(16.0f));
        this.textProgressMargin = (int)typedArray.getDimension(R.styleable.TextRoundCornerProgressBar_rcTextProgressMargin, this.dp2px(10.0f));
        this.textProgress = typedArray.getString(R.styleable.TextRoundCornerProgressBar_rcTextProgress);
        this.textInsideGravity = typedArray.getInt(R.styleable.TextRoundCornerProgressBar_rcTextInsideGravity, 0);
        this.textOutsideGravity = typedArray.getInt(R.styleable.TextRoundCornerProgressBar_rcTextOutsideGravity, 0);
        this.textPositionPriority = typedArray.getInt(R.styleable.TextRoundCornerProgressBar_rcTextPositionPriority, 0);
        typedArray.recycle();
    }

    @Override
    protected void initView() {
        this.tvProgress = (TextView)this.findViewById(R.id.tv_progress);
        this.tvProgress.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    @Override
    protected void drawProgress(@NonNull LinearLayout layoutProgress, @NonNull GradientDrawable progressDrawable, float max, float progress, float totalWidth, int radius, int padding, boolean isReverse) {
        int newRadius = radius - padding / 2;
        progressDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        layoutProgress.setBackground((Drawable)progressDrawable);
        float ratio = max / progress;
        int progressWidth = (int)((totalWidth - (float)(padding * 2)) / ratio);
        ViewGroup.MarginLayoutParams progressParams = (ViewGroup.MarginLayoutParams)layoutProgress.getLayoutParams();
        if (padding + progressWidth / 2 < radius) {
            int margin;
            progressParams.topMargin = margin = Math.max(radius - padding, 0) - progressWidth / 2;
            progressParams.bottomMargin = margin;
        } else {
            progressParams.topMargin = 0;
            progressParams.bottomMargin = 0;
        }
        progressParams.width = progressWidth;
        layoutProgress.setLayoutParams((ViewGroup.LayoutParams)progressParams);
    }

    @Override
    protected void onViewDraw() {
        this.drawTextProgress();
        this.drawTextProgressSize();
        this.drawTextProgressMargin();
        this.post(new Runnable(){

            @Override
            public void run() {
                TextRoundCornerProgressBar.this.drawTextProgressPosition();
            }
        });
        this.drawTextProgressColor();
    }

    private void drawTextProgress() {
        this.tvProgress.setText((CharSequence)this.textProgress);
    }

    private void drawTextProgressColor() {
        this.tvProgress.setTextColor(this.colorTextProgress);
    }

    private void drawTextProgressSize() {
        this.tvProgress.setTextSize(0, (float)this.textProgressSize);
    }

    private void drawTextProgressMargin() {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.tvProgress.getLayoutParams();
        params.setMargins(this.textProgressMargin, 0, this.textProgressMargin, 0);
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void drawTextProgressPosition() {
        this.clearTextProgressAlign();
        int textProgressWidth = this.tvProgress.getMeasuredWidth() + this.getTextProgressMargin() * 2;
        float ratio = this.getMax() / this.getProgress();
        int progressWidth = (int)((this.getLayoutWidth() - (float)(this.getPadding() * 2)) / ratio);
        if (this.textPositionPriority == 1) {
            if (this.getLayoutWidth() - (float)progressWidth > (float)textProgressWidth) {
                this.alignTextProgressOutsideProgress();
            } else {
                this.alignTextProgressInsideProgress();
            }
        } else if (textProgressWidth + this.textProgressMargin > progressWidth) {
            this.alignTextProgressOutsideProgress();
        } else {
            this.alignTextProgressInsideProgress();
        }
    }

    private void clearTextProgressAlign() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.tvProgress.getLayoutParams();
        params.removeRule(0);
        params.removeRule(1);
        params.removeRule(5);
        params.removeRule(7);
        params.removeRule(9);
        params.removeRule(11);
        if (Build.VERSION.SDK_INT >= 17) {
            params.removeRule(16);
            params.removeRule(17);
            params.removeRule(18);
            params.removeRule(19);
            params.removeRule(20);
            params.removeRule(21);
        }
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void alignTextProgressInsideProgress() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.tvProgress.getLayoutParams();
        if (this.isReverse()) {
            if (this.textInsideGravity == 1) {
                params.addRule(7, R.id.layout_progress);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(19, R.id.layout_progress);
                }
            } else {
                params.addRule(5, R.id.layout_progress);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(18, R.id.layout_progress);
                }
            }
        } else if (this.textInsideGravity == 1) {
            params.addRule(5, R.id.layout_progress);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(18, R.id.layout_progress);
            }
        } else {
            params.addRule(7, R.id.layout_progress);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(19, R.id.layout_progress);
            }
        }
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void alignTextProgressOutsideProgress() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.tvProgress.getLayoutParams();
        if (this.isReverse()) {
            if (this.textOutsideGravity == 1) {
                params.addRule(9);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20);
                }
            } else {
                params.addRule(0, R.id.layout_progress);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(16, R.id.layout_progress);
                }
            }
        } else if (this.textOutsideGravity == 1) {
            params.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(21);
            }
        } else {
            params.addRule(1, R.id.layout_progress);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(17, R.id.layout_progress);
            }
        }
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public String getProgressText() {
        return this.textProgress;
    }

    public void setProgressText(String text) {
        this.textProgress = text;
        this.drawTextProgress();
        this.drawTextProgressPosition();
    }

    @Override
    public void setProgress(int progress) {
        this.setProgress((float)progress);
    }

    @Override
    public void setProgress(float progress) {
        super.setProgress(progress);
        this.drawTextProgressPosition();
    }

    public int getTextProgressColor() {
        return this.colorTextProgress;
    }

    public void setTextProgressColor(@ColorInt int color2) {
        this.colorTextProgress = color2;
        this.drawTextProgressColor();
    }

    public int getTextProgressSize() {
        return this.textProgressSize;
    }

    public void setTextProgressSize(@Px int size) {
        this.textProgressSize = size;
        this.drawTextProgressSize();
        this.drawTextProgressPosition();
    }

    public int getTextProgressMargin() {
        return this.textProgressMargin;
    }

    public void setTextProgressMargin(@Px int margin) {
        this.textProgressMargin = margin;
        this.drawTextProgressMargin();
        this.drawTextProgressPosition();
    }

    public int getTextPositionPriority() {
        return this.textPositionPriority;
    }

    public void setTextPositionPriority(int priority) {
        this.textPositionPriority = priority;
        this.drawTextProgressPosition();
    }

    public int getTextInsideGravity() {
        return this.textInsideGravity;
    }

    public void setTextInsideGravity(int gravity) {
        this.textInsideGravity = gravity;
        this.drawTextProgressPosition();
    }

    public int getTextOutsideGravity() {
        return this.textOutsideGravity;
    }

    public void setTextOutsideGravity(int gravity) {
        this.textOutsideGravity = gravity;
        this.drawTextProgressPosition();
    }

    public void onGlobalLayout() {
        this.tvProgress.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.drawTextProgressPosition();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.colorTextProgress = this.colorTextProgress;
        ss.textProgressSize = this.textProgressSize;
        ss.textProgressMargin = this.textProgressMargin;
        ss.textProgress = this.textProgress;
        ss.textInsideGravity = this.textInsideGravity;
        ss.textOutsideGravity = this.textOutsideGravity;
        ss.textPositionPriority = this.textPositionPriority;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.colorTextProgress = ss.colorTextProgress;
        this.textProgressSize = ss.textProgressSize;
        this.textProgressMargin = ss.textProgressMargin;
        this.textProgress = ss.textProgress;
        this.textInsideGravity = ss.textInsideGravity;
        this.textOutsideGravity = ss.textOutsideGravity;
        this.textPositionPriority = ss.textPositionPriority;
    }

    protected static class SavedState
    extends AbsSavedState {
        int colorTextProgress;
        int textProgressSize;
        int textProgressMargin;
        String textProgress;
        int textInsideGravity;
        int textOutsideGravity;
        int textPositionPriority;
        public static final Parcelable.ClassLoaderCreator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            this(in, (ClassLoader)null);
        }

        protected SavedState(@NonNull Parcel in, @Nullable ClassLoader loader) {
            super(in, loader);
            this.colorTextProgress = in.readInt();
            this.textProgressSize = in.readInt();
            this.textProgressMargin = in.readInt();
            this.textProgress = in.readString();
            this.textInsideGravity = in.readInt();
            this.textOutsideGravity = in.readInt();
            this.textPositionPriority = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.colorTextProgress);
            out.writeInt(this.textProgressSize);
            out.writeInt(this.textProgressMargin);
            out.writeString(this.textProgress);
            out.writeInt(this.textInsideGravity);
            out.writeInt(this.textOutsideGravity);
            out.writeInt(this.textPositionPriority);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TEXT_POSITION_PRIORITY {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TEXT_PROGRESS_GRAVITY {
    }
}

